from WebMonitoring.API.resources.last_seven_entries_metrics import (
    get_last_seven_entries_size, )


def get_results_resource_get_size(mysql, resource_name):
    result_args_get_size = []
    result_args_old_get_size = []
    list_sample = []

    try:
        conn = mysql.connect()
        cursor = conn.cursor()
        """
        Compatibility warning: PEP-249 specifies that any modified
        parameters must be returned. This is currently impossible
        as they are only available by storing them in a server
        variable and then retrieved by a query. Since stored
        procedures return zero or more result sets, there is no
        reliable way to get at OUT or INOUT parameters via callproc.
        The server variables are named @_procname_n, where procname
        is the parameter above and n is the position of the parameter
        (from zero). Once all result sets generated by the procedure
        have been fetched, you can issue a SELECT @_procname_0, ...
        query using .execute() to get any OUT or INOUT values.
        """
        args = [resource_name, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]

        cursor.callproc("resource_get_size", args)
        cursor.execute("SELECT @_resource_get_size_0, "
                       "@_resource_get_size_1, "
                       "@_resource_get_size_2, "
                       "@_resource_get_size_3, "
                       "@_resource_get_size_4, "
                       "@_resource_get_size_5, "
                       "@_resource_get_size_6, "
                       "@_resource_get_size_7, "
                       "@_resource_get_size_8, "
                       "@_resource_get_size_9, "
                       "@_resource_get_size_10, "
                       "@_resource_get_size_11, "
                       "@_resource_get_size_12 ")
        result_args_get_size = cursor.fetchone()

        cursor.callproc("resource_get_old_size", args)
        cursor.execute("SELECT @_resource_get_old_size_0, "
                       "@_resource_get_old_size_1, "
                       "@_resource_get_old_size_2, "
                       "@_resource_get_old_size_3, "
                       "@_resource_get_old_size_4, "
                       "@_resource_get_old_size_5, "
                       "@_resource_get_old_size_6, "
                       "@_resource_get_old_size_7, "
                       "@_resource_get_old_size_8, "
                       "@_resource_get_old_size_9, "
                       "@_resource_get_old_size_10, "
                       "@_resource_get_old_size_11, "
                       "@_resource_get_old_size_12 ")
        result_args_old_get_size = cursor.fetchone()

        list_sample = []
        samples = get_last_seven_entries_size(mysql, resource_name)
        for sample in samples:
            list_sample.append(sample["ResponseSize"])
    except Exception as e:
        print(e)
    finally:
        try:
            cursor.close()
            conn.close()
        except NameError:
            return (None, None, None)
        return (result_args_get_size, result_args_old_get_size, list_sample)
