"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
require("@aws-cdk/assert/jest");
const core = require("@aws-cdk/core");
const inc = require("../lib");
const futils = require("../lib/file-utils");
/* eslint-disable quote-props */
/* eslint-disable quotes */
describe('CDK Include for templates with SAM transform', () => {
    let stack;
    beforeEach(() => {
        stack = new core.Stack();
    });
    test('can ingest a template with only a minimal SAM function using S3Location for CodeUri, and output it unchanged', () => {
        includeTestTemplate(stack, 'only-minimal-sam-function-codeuri-as-s3location.yaml');
        expect(stack).toMatchTemplate(loadTestFileToJsObject('only-minimal-sam-function-codeuri-as-s3location.yaml'));
    });
    test('can ingest a template with only a SAM function using an array with DDB CRUD for Policies, and output it unchanged', () => {
        includeTestTemplate(stack, 'only-sam-function-policies-array-ddb-crud.yaml');
        expect(stack).toMatchTemplate(loadTestFileToJsObject('only-sam-function-policies-array-ddb-crud.yaml'));
    });
    test('can ingest a template with only a minimal SAM function using a parameter for CodeUri, and output it unchanged', () => {
        includeTestTemplate(stack, 'only-minimal-sam-function-codeuri-as-param.yaml');
        expect(stack).toMatchTemplate(loadTestFileToJsObject('only-minimal-sam-function-codeuri-as-param.yaml'));
    });
    test('can ingest a template with only a minimal SAM function using a parameter for CodeUri Bucket property, and output it unchanged', () => {
        includeTestTemplate(stack, 'only-minimal-sam-function-codeuri-bucket-as-param.yaml');
        expect(stack).toMatchTemplate(loadTestFileToJsObject('only-minimal-sam-function-codeuri-bucket-as-param.yaml'));
    });
    test('can ingest a template with only a SAM function using an array with DDB CRUD for Policies with an Fn::If expression, and output it unchanged', () => {
        includeTestTemplate(stack, 'only-sam-function-policies-array-ddb-crud-if.yaml');
        expect(stack).toMatchTemplate(loadTestFileToJsObject('only-sam-function-policies-array-ddb-crud-if.yaml'));
    });
});
function includeTestTemplate(scope, testTemplate) {
    return new inc.CfnInclude(scope, 'MyScope', {
        templateFile: _testTemplateFilePath(testTemplate),
    });
}
function loadTestFileToJsObject(testTemplate) {
    return futils.readYamlSync(_testTemplateFilePath(testTemplate));
}
function _testTemplateFilePath(testTemplate) {
    return path.join(__dirname, 'test-templates', 'sam', testTemplate);
}
//# sourceMappingURL=data:application/json;base64,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