from django.contrib.auth.backends import ModelBackend
from django.contrib.auth.backends import UserModel
from .ad_auth import ldap_auth

class UserBackend(ModelBackend):
    def authenticate(self, request, username=None, password=None, **kwargs):
        if username is None:
            username = kwargs.get(UserModel.USERNAME_FIELD)
        if username is None or password is None:
            return
        try:
            user = UserModel._default_manager.get_by_natural_key(username)
        except UserModel.DoesNotExist:
            # Run the default password hasher once to reduce the timing
            # difference between an existing and a nonexistent user (#20760).
            UserModel().set_password(password)
        else:
            if user.is_ad_account:
                if ldap_auth(user.username,password) and self.user_can_authenticate(user):
                    # print("域用户登陆成功",user.username)
                    return user
            else: 
                if user.check_password(password) and self.user_can_authenticate(user):
                    # print("网站账号登陆成功",user.username)
                    return user
