# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['hypertag']

package_data = \
{'': ['*']}

install_requires = \
['Pillow>=8.1.0,<9.0.0',
 'PyPDF2>=1.26.0,<2.0.0',
 'cairocffi>=1.2.0,<2.0.0',
 'filetype>=1.0.7,<2.0.0',
 'fire>=0.3.1,<0.4.0',
 'ftfy>=5.8,<6.0',
 'fuzzywuzzy[speedup]>=0.18.0,<0.19.0',
 'hnswlib>=0.4.0,<0.5.0',
 'python-igraph>=0.8.3,<0.9.0',
 'pywebcopy>=6.3.0,<7.0.0',
 'rpyc>=5.0.0,<6.0.0',
 'sentence-transformers>=0.4.1,<0.5.0',
 'textract>=1.6.3,<2.0.0',
 'torchvision>=0.8.2,<0.9.0',
 'tqdm>=4.55.0,<5.0.0',
 'watchdog>=1.0.2,<2.0.0',
 'wordninja>=2.0.0,<3.0.0']

setup_kwargs = {
    'name': 'hypertag',
    'version': '0.6.2.9',
    'description': 'File organization made for humans',
    'long_description': '# HyperTag\n\nHyperTag helps humans intuitively express how they think about their files using tags and machine learning. Represent how you think using tags. Find what you look for using semantic search for your text documents (yes, even PDF\'s) and images. Instead of introducing proprietary file formats like other existing file organization tools, HyperTag just smoothly layers on top of your existing files without any fuss.\n\n**Objective Function**: Minimize time between a thought and access to all relevant files.\n\nAccompanying blog post: https://blog.neotree.uber.space/posts/hypertag-file-organization-made-for-humans\n\n<!-- START doctoc generated TOC please keep comment here to allow auto update -->\n<!-- DON\'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->\n**Table of Contents**\n- [HyperTag](#hypertag)\n  - [Install](#install)\n  - [Community](#community)\n  - [Overview](#overview)\n  - [CLI Functions](#cli-functions)\n    - [Import existing directory recursively](#import-existing-directory-recursively)\n    - [Add file/s or URL/s manually](#add-files-or-urls-manually)\n    - [Tag file/s  (with values)](#tag-files--with-values)\n    - [Untag file/s](#untag-files)\n    - [Tag a tag](#tag-a-tag)\n    - [Merge tags](#merge-tags)\n    - [Query using Set Theory](#query-using-set-theory)\n    - [Index supported image and text files](#index-supported-image-and-text-files)\n    - [Semantic search for text files](#semantic-search-for-text-files)\n    - [Semantic search for image files](#semantic-search-for-image-files)\n    - [Start HyperTag Daemon](#start-hypertag-daemon)\n    - [Print all tags of file/s](#print-all-tags-of-files)\n    - [Print all metatags of tag/s](#print-all-metatags-of-tags)\n    - [Print all tags](#print-all-tags)\n    - [Print all files](#print-all-files)\n    - [Visualize HyperTag Graph](#visualize-hypertag-graph)\n    - [Generate HyperTagFS](#generate-hypertagfs)\n    - [Add directory to auto import list](#add-directory-to-auto-import-list)\n    - [Set HyperTagFS directory path](#set-hypertagfs-directory-path)\n  - [Architecture](#architecture)\n  - [Development](#development)\n  - [Inspiration](#inspiration)\n\n<!-- END doctoc generated TOC please keep comment here to allow auto update -->\n## Install\nAvailable on [PyPI](https://pypi.org/project/hypertag/)\n\n`$ pip install hypertag` (supports both CPU only & CUDA accelerated execution!)\n\n## Community\nJoin the HyperTag [matrix chat room](https://matrix.to/#/#hypertag:matrix.neotree.uber.space?via=matrix.neotree.uber.space) to stay up to date on the latest developments or to ask for help.\n\n## Overview\nHyperTag offers a slick CLI but more importantly it creates a directory called ```HyperTagFS``` which is a file system based representation of your files and tags using symbolic links and directories.\n\n**Directory Import**: Import your existing directory hierarchies using ```$ hypertag import path/to/directory```. HyperTag converts it automatically into a tag hierarchy using metatagging.\n\n**Semantic Text & Image Search  (Experimental)**: Search for **images** (jpg, png) and **text documents** (yes, even PDF\'s) content with a simple text query. Text search is powered by the awesome [Sentence Transformers](https://github.com/UKPLab/sentence-transformers) library. Text to image search is powered by OpenAI\'s [CLIP model](https://openai.com/blog/clip/). Currently only English queries are supported.\n\n**HyperTag Daemon  (Experimental)**: Monitors `HyperTagFS` and directories added to the auto import list for user changes (see section "Start HyperTag Daemon" below). Also spawns the DaemonService which speeds up semantic search significantly.\n\n**Fuzzy Matching Queries**: HyperTag uses fuzzy matching to minimize friction in the unlikely case of a typo.\n\n**File Type Groups**: HyperTag automatically creates folders containing common files (e.g. Images: jpg, png, etc., Documents: txt, pdf, etc., Source Code: py, js, etc.), which can be found in ```HyperTagFS```.\n\n**HyperTag Graph**: Quickly get an overview of your HyperTag Graph! HyperTag visualizes the metatag graph on every change and saves it at `HyperTagFS/hypertag-graph.pdf`.\n\n![HyperTag Graph Example](https://raw.githubusercontent.com/SeanPedersen/HyperTag/master/images/hypertag-graph.jpg)\n\n## CLI Functions\n\n### Import existing directory recursively\nImport files with tags inferred from the existing directory hierarchy.\n\n```$ hypertag import path/to/directory```\n\n### Add file/s or URL/s manually\n\n```$ hypertag add path/to/file https://github.com/SeanPedersen/HyperTag```\n\n### Tag file/s  (with values)\nManually tag files. Shortcut: `$ hypertag t`\n\n```$ hypertag tag humans/*.txt with human "Homo Sapiens"```\n\nAdd a value to a file\'s tag:\n\n```$ hypertag tag sean.txt with name="Sean Pedersen"```\n\n### Untag file/s\nManually remove tag/s from file/s.\n\n```$ hypertag untag humans/*.txt with human "Homo Sapiens"```\n\n### Tag a tag\nMetatag tag/s to create tag hierarchies. Shortcut: `$ hypertag tt`\n\n```$ hypertag metatag human with animal```\n\n### Merge tags\nMerge all associations (files & tags) of tag A into tag B.\n\n```$ hypertag merge human into "Homo Sapiens"```\n\n### Query using Set Theory\nPrint file names of the resulting set matching the query. Queries are composed of tags (with values) and operands. Tags are fuzzy matched for convenience. Nesting is currently not supported, queries are evaluated from left to right.\n<br>Shortcut: `$ hypertag q`\n\nQuery with a value using a wildcard: ```$ hypertag query name="Sean*"```<br>\nPrint paths: ```$ hypertag query human --path```<br>\nPrint fuzzy matched tag: ```$ hypertag query man --verbose``` <br>\nDisable fuzzy matching: ```$ hypertag query human --fuzzy=0```\n\nDefault operand is AND (intersection): <br>\n```$ hypertag query human name="Sean*"``` is equivalent to ```$ hypertag query human and name="Sean*"```\n\nOR (union): <br>\n```$ hypertag query human or "Homo Sapiens"```\n\nMINUS (difference): <br>\n```$ hypertag query human minus "Homo Sapiens"```\n\n### Index supported image and text files\nOnly indexed files can be searched.\n\n```$ hypertag index```\n\nTo parse even unparseable PDF\'s, install tesseract: `# pacman -S tesseract tesseract-data-eng`\n\nIndex only image files: ```$ hypertag index --image```<br>\nIndex only text files: ```$ hypertag index --text```\n\n### Semantic search for text files\nPrint text file names sorted by matching score.\nPerformance benefits greatly from running the HyperTag daemon.\n<br>Shortcut: `$ hypertag s`\n\n```$ hypertag search "your important text query" --path --score --top_k=10```\n\n### Semantic search for image files\nPrint image file names sorted by matching score.\nPerformance benefits greatly from running the HyperTag daemon.\n<br>Shortcut: `$ hypertag si`\n\nText to image:\n```$ hypertag search_image "your image content description" --path --score --top_k=10```\n\nImage to image:\n```$ hypertag search_image "path/to/image.jpg" --path --score --top_k=10```\n\n### Start HyperTag Daemon\nStart daemon process with triple functionality:\n- Watches `HyperTagFS` directory for user changes\n  - Maps file (symlink) and directory deletions into tag / metatag removal/s\n  - On directory creation: Interprets name as set theory tag query and automatically populates it with results\n  - On directory creation in `Search Images` or `Search Texts`: Interprets name as semantic search query (add top_k=42 to limit result size) and automatically populates it with results\n- Watches directories on the auto import list for user changes:\n  - Maps file changes (moves & renames) to DB\n  - On file creation: Adds new file/s with inferred tag/s\n- Spawns DaemonService to load and expose models used for semantic search, speeding it up significantly\n\n```$ hypertag daemon```\n\n### Print all tags of file/s\n\n```$ hypertag tags filename1 filename2```\n\n### Print all metatags of tag/s\n\n```$ hypertag metatags tag1 tag2```\n\n### Print all tags\n\n```$ hypertag show```\n\n### Print all files\n\nPrint names:\n```$ hypertag show files```\n\nPrint paths:\n```$ hypertag show files --path```\n\n### Visualize HyperTag Graph\nVisualize the metatag graph hierarchy (saved at HyperTagFS root).\n\n```$ hypertag graph```\n\nSpecify [layout algorithm](https://igraph.org/python/doc/tutorial/tutorial.html#layout-algorithms) (default: fruchterman_reingold):\n\n```$ hypertag graph --layout=kamada_kawai```\n\n### Generate HyperTagFS\nGenerate file system based representation of your files and tags using symbolic links and directories.\n\n```$ hypertag mount```\n\n### Add directory to auto import list\nDirectories added to the auto import list will be monitored by the daemon for new files or changes.\n\n```$ hypertag add_auto_import_dir path/to/directory```\n\n### Set HyperTagFS directory path\nDefault is the user\'s home directory.\n\n```$ hypertag set_hypertagfs_dir path/to/directory```\n\n## Architecture\n- Python and it\'s vibrant open-source community power HyperTag\n- Many other awesome open-source projects make HyperTag possible (listed in `pyproject.toml`)\n- SQLite3 serves as the meta data storage engine (located at `~/.config/hypertag/hypertag.db`)\n- Added URLs are saved in `~/.config/hypertag/web_pages` for websites, others in `~/.config/hypertag/downloads`\n- Symbolic links are used to create the HyperTagFS directory structure\n- Semantic Search: boosted using [hnswlib](https://github.com/nmslib/hnswlib/)\n  - Text to text search is powered by the awesome [DistilBERT](https://arxiv.org/abs/1910.01108)\n  - Text to image & image to image search is powered by OpenAI\'s impressive [CLIP model](https://openai.com/blog/clip/)\n\n## Development\n- Find prioritized issues here: [TODO List](https://github.com/SeanPedersen/HyperTag/projects/1)\n- Pick an issue and comment how you plan to tackle it before starting out, to make sure no dev time is wasted.\n- Clone repo: ```$ git clone https://github.com/SeanPedersen/HyperTag.git```\n- `$ cd HyperTag/`\n- Install [Poetry](https://python-poetry.org/docs/#installation)\n- Install dependencies: `$ poetry install`\n- Activate virtual environment: `$ poetry shell`\n- Run all tests: ```$ pytest -v```\n- Run formatter: ```$ black hypertag/```\n- Run linter: ```$ flake8```\n- Run type checking: ```$ mypy **/*.py```\n- Run security checking: ```$ bandit --exclude tests/ -r .```\n- Run HyperTag: ```$ python -m hypertag```\n\n## Inspiration\n\n**What is the point of HyperTag\'s existence?**<br/>\nHyperTag offers many unique features such as the import, semantic search for images and texts, graphing and fuzzy matching functions that make it very convenient to use. All while HyperTag\'s code base staying tiny at <2000 LOC in comparison to TMSU (>10,000 LOC) and SuperTag (>25,000 LOC), making it easy to hack on.\n\nThis project is partially inspired by these open-source projects:\n- [TMSU](https://github.com/oniony/TMSU): Written in Go\n- [SuperTag](https://github.com/amoffat/supertag): Written in Rust\n',
    'author': 'Sean',
    'author_email': 'sean-p-96@hotmail.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/SeanPedersen/HyperTag',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.2,<4.0.0',
}


setup(**setup_kwargs)
