import * as iam from '@aws-cdk/aws-iam';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface DataBrewCodePipelineProps {
    /**
     * The ARN of the IAM role in the pre-production account.
     *
     * @stability stable
     */
    readonly preproductionIamRoleArn: string;
    /**
     * The ARN of the IAM role in the production account.
     *
     * @stability stable
     */
    readonly productionIamRoleArn: string;
    /**
     * The name of the S3 bucket for the CodePipeline DataBrew CICD pipeline.
     *
     * @default 'databrew-cicd-codepipelineartifactstorebucket'
     * @stability stable
     */
    readonly bucketName?: string;
    /**
     * The name of the CodeCommit repositroy for the DataBrew CICD pipeline.
     *
     * @default 'DataBrew-Recipes-Repo'
     * @stability stable
     */
    readonly repoName?: string;
    /**
     * The name of the branch that will trigger the DataBrew CICD pipeline.
     *
     * @default 'main'
     * @stability stable
     */
    readonly branchName?: string;
    /**
     * The name of the CodePipeline Databrew CICD pipeline.
     *
     * @default 'DataBrew-Recipe-Application'
     * @stability stable
     */
    readonly pipelineName?: string;
    /**
     * the (required) name of the Artifact at the first stage.
     *
     * @default 'SourceOutput'
     * @stability stable
     */
    readonly firstStageArtifactName?: string;
}
/**
 * @stability stable
 */
export declare class DataBrewCodePipeline extends cdk.Construct {
    /**
     * The ARN of the S3 bucket for the CodePipeline DataBrew CICD pipeline.
     *
     * @stability stable
     */
    readonly bucketArn: string;
    /**
     * The name of the CodeCommit repositroy for the DataBrew CICD pipeline.
     *
     * @stability stable
     */
    readonly repoName: string;
    /**
     * The name of the branch that will trigger the DataBrew CICD pipeline.
     *
     * @stability stable
     */
    readonly branchName: string;
    /**
     * the (required) name of the Artifact at the first stage.
     *
     * @stability stable
     */
    readonly firstStageArtifactName: string;
    /**
     * The ARN of the Lambda function for the pre-production account.
     *
     * @stability stable
     */
    readonly preproductionFunctionArn: string;
    /**
     * The ARN of the Lambda function for the production account.
     *
     * @stability stable
     */
    readonly productionFunctionArn: string;
    /**
     * The ARN of the CodeCommit repository.
     *
     * @stability stable
     */
    readonly codeCommitRepoArn: string;
    /**
     * The ARN of the DataBrew CICD pipeline.
     *
     * @stability stable
     */
    readonly codePipelineArn: string;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, name: string, props: DataBrewCodePipelineProps);
    /**
         * Creates a source action.
         *
         * @param codeCommitRepo the CodeCommit repository used in the DataBrew CICD pipeline.
         * @param role the IAM role used by the CodePipeline pipeline.
         * @returns the CodeCOmmit source action.
         */
    private createSourceAction;
}
/**
 * @stability stable
 */
export interface InfraIamRoleProps {
    /**
     * The role name for the infrastructure account.
     *
     * @default 'CrossAccountRepositoryContributorRole'
     * @stability stable
     */
    readonly roleName?: string;
}
/**
 * @stability stable
 */
export declare class InfraIamRole extends cdk.Construct {
    /**
     * The ARN of the IAM role for the infrastructure account.
     *
     * @stability stable
     */
    readonly roleArn: string;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, name: string, props: InfraIamRoleProps);
}
/**
 * @stability stable
 */
export interface CodePipelineIamRoleProps {
    /**
     * The ARN of the S3 bucket where you store your artifacts.
     *
     * @stability stable
     */
    readonly bucketArn: string;
    /**
     * The ARN of the Lambda function for the pre-production account.
     *
     * @stability stable
     */
    readonly preproductionLambdaArn: string;
    /**
     * The ARN of the Lambda function for the production account.
     *
     * @stability stable
     */
    readonly productionLambdaArn: string;
    /**
     * The role name for the CodePipeline CICD pipeline.
     *
     * @default 'DataBrew-Recipe-Pipeline-Role'
     * @stability stable
     */
    readonly roleName?: string;
}
/**
 * @stability stable
 */
export declare class CodePipelineIamRole extends cdk.Construct {
    /**
     * The ARN of the IAM role for the CodePipeline CICD pipeline.
     *
     * @stability stable
     */
    readonly roleArn: string;
    /**
     * The representative of the IAM role for the CodePipeline CICD pipeline.
     *
     * @stability stable
     */
    readonly role: iam.Role;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, name: string, props: CodePipelineIamRoleProps);
}
