import * as lambda from '@aws-cdk/aws-lambda';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface PreProductionLambdaProps {
    /**
     * The ARN of the S3 bucket for the DataBrew CICD pipeline.
     *
     * @stability stable
     */
    readonly bucketArn: string;
    /**
     * The ARN of the IAM role in the pre-production account.
     *
     * @stability stable
     */
    readonly preproductionIamRoleArn: string;
    /**
     * The name of the IAM role for the pre-produciton Lambda function.
     *
     * @default 'PreProd-DataBrew-Recipe-Deployer-role'
     * @stability stable
     */
    readonly roleName?: string;
    /**
     * The Lambda funciton name for the pre-production account.
     *
     * @default 'PreProd-DataBrew-Recipe-Deployer'
     * @stability stable
     */
    readonly functionName?: string;
}
/**
 * @stability stable
 */
export declare class PreProductionLambda extends cdk.Construct {
    /**
     * The name of the IAM role for the pre-produciton Lambda function.
     *
     * @stability stable
     */
    readonly roleName: string;
    /**
     * The Lambda funciton name for the pre-production account.
     *
     * @stability stable
     */
    readonly functionName: string;
    /**
     * The representative of Lambda function for the pre-production account.
     *
     * @stability stable
     */
    readonly function: lambda.IFunction;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, name: string, props: PreProductionLambdaProps);
}
/**
 * @stability stable
 */
export interface ProductionLambdaProps {
    /**
     * The ARN of the S3 bucket for the DataBrew CICD pipeline.
     *
     * @stability stable
     */
    readonly bucketArn: string;
    /**
     * The ARN of the IAM role in the production account.
     *
     * @stability stable
     */
    readonly productionIamRoleArn: string;
    /**
     * The name of the IAM role for the produciton Lambda function.
     *
     * @default 'Prod-DataBrew-Recipe-Deployer-role'
     * @stability stable
     */
    readonly roleName?: string;
    /**
     * The Lambda funciton name for the production account.
     *
     * @default 'Prod-DataBrew-Recipe-Deployer'
     * @stability stable
     */
    readonly functionName?: string;
}
/**
 * @stability stable
 */
export declare class ProductionLambda extends cdk.Construct {
    /**
     * The name of the IAM role for the produciton Lambda function.
     *
     * @stability stable
     */
    readonly roleName: string;
    /**
     * The Lambda funciton name for the production account.
     *
     * @stability stable
     */
    readonly functionName: string;
    /**
     * The representative of Lambda function for the production account.
     *
     * @stability stable
     */
    readonly function: lambda.IFunction;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, name: string, props: ProductionLambdaProps);
}
/**
 * @stability stable
 */
export interface FirstCommitHandlerProps {
    /**
     * The ARN of the CodeCommit repository.
     *
     * @stability stable
     */
    readonly codeCommitRepoArn: string;
    /**
     * The name of the CodeCommit repo.
     *
     * @stability stable
     */
    readonly repoName: string;
    /**
     * The branch name used in the CodeCommit repo.
     *
     * @stability stable
     */
    readonly branchName: string;
    /**
     * The name of the IAM role for the Lambda function which deals with first commit via AWS CodeCommit.
     *
     * @default 'LambdaForInitialCommitRole'
     * @stability stable
     */
    readonly roleName?: string;
    /**
     * The name of the Lambda function which deals with first commit via AWS CodeCommit.
     *
     * @default 'FirstCommitHandler'
     * @stability stable
     */
    readonly functionName?: string;
}
/**
 * @stability stable
 */
export declare class FirstCommitHandler extends cdk.Construct {
    /**
     * The name of the IAM role for the Lambda function which deals with first commit via AWS CodeCommit.
     *
     * @stability stable
     */
    readonly roleName: string;
    /**
     * The name of the Lambda function which deals with first commit via AWS CodeCommit.
     *
     * @stability stable
     */
    readonly functionName: string;
    /**
     * The representative of Lambda function which deals with first commit via AWS CodeCommit.
     *
     * @stability stable
     */
    readonly function: lambda.IFunction;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, name: string, props: FirstCommitHandlerProps);
}
