"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirstCommitHandler = exports.ProductionLambda = exports.PreProductionLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const cdk = require("@aws-cdk/core");
const functionScript = 'import os\r\nimport json\r\nimport zipfile\r\nimport boto3\r\nimport gzip\r\nfrom io import BytesIO\r\n\r\ndef get_clients():\r\n    s3_client = boto3.resource(\'s3\')\r\n    sts_connection = boto3.client(\'sts\')\r\n    cross_account = sts_connection.assume_role(RoleArn=os.environ[\'role\'],RoleSessionName=\"session\")\r\n    access_key = cross_account[\'Credentials\'][\'AccessKeyId\']\r\n    secrect_key = cross_account[\'Credentials\'][\'SecretAccessKey\']\r\n    session_token = cross_account[\'Credentials\'][\'SessionToken\']\r\n    databrew_client = boto3.client(\r\n        \'databrew\',\r\n        aws_access_key_id=access_key,\r\n        aws_secret_access_key=secrect_key,\r\n        aws_session_token=session_token,\r\n    )\r\n    return s3_client, databrew_client\r\n\r\ndef get_name_contents(event, s3_client):\r\n    s3_location = event[\'CodePipeline.job\'][\'data\'][\'inputArtifacts\'][0][\'location\'][\'s3Location\']\r\n    s3_bucket = s3_location[\'bucketName\']\r\n    s3_file = s3_location[\'objectKey\']\r\n    zip_obj = s3_client.Object(bucket_name=s3_bucket, key=s3_file)\r\n    # extracting compressed files\r\n    buffer = BytesIO(zip_obj.get()[\"Body\"].read())\r\n    file_name = \'\'\r\n    z = zipfile.ZipFile(buffer)\r\n    json_content = \'\'\r\n    for filename in z.namelist():\r\n        if filename.endswith(\'.json\'):\r\n            file_name = filename\r\n            with z.open(file_name) as content:\r\n                json_content = json.load(content)\r\n    return file_name.replace(\'.json\', \'\'), json_content\r\n\r\ndef lambda_handler(event, context):\r\n    codepipeline_client = boto3.client(\'codepipeline\')\r\n    job_id = event[\'CodePipeline.job\'][\'id\']\r\n    try:\r\n        # client creation\r\n        clients = get_clients()\r\n        s3_client = clients[0]\r\n        databrew_client = clients[1]\r\n        # getting file name and contents\r\n        name_contents = get_name_contents(event, s3_client)\r\n        recipe_lists = databrew_client.list_recipes(MaxResults=99)\r\n        if name_contents[0] not in (x[\'Name\'] for x in recipe_lists[\'Recipes\']):\r\n            databrew_client.create_recipe(Name=name_contents[0], Steps=name_contents[1])\r\n        # updating recipe\r\n        databrew_client.update_recipe(Description=\'updating recipe\',Name=name_contents[0],Steps= name_contents[1])\r\n        # publishing a recipe\r\n        databrew_client.publish_recipe(Description=\'publishing recipe\', Name=name_contents[0])\r\n        # Notify AWS CodePipeline of a successful job\r\n        codepipeline_client.put_job_success_result(jobId=job_id)\r\n    except Exception as e:\r\n        # Notifying pipeline of a failure\r\n        codepipeline_client.put_job_failure_result(jobId=job_id,failureDetails={\'type\': \'JobFailed\',\'message\': str(e)})';
/**
 * @stability stable
 */
class PreProductionLambda extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, name, props) {
        var _d, _e;
        super(scope, name);
        this.roleName = (_d = props.roleName) !== null && _d !== void 0 ? _d : 'PreProd-DataBrew-Recipe-Deployer-role';
        this.functionName = (_e = props.functionName) !== null && _e !== void 0 ? _e : 'PreProd-DataBrew-Recipe-Deployer';
        const lambdaRole = new iam.Role(this, 'PreproductionFunctionRole', {
            assumedBy: new iam.ServicePrincipal('lambda.amazonaws.com'),
            description: 'An execution role for the pre-production Lambda funciton.',
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('AWSXRayDaemonWriteAccess'),
                new iam.ManagedPolicy(this, 'PreProductionManagedPolicy', {
                    managedPolicyName: 'PreProd-DataBrew-Recipe-Deployer-Policy',
                    statements: [
                        new iam.PolicyStatement({
                            sid: 'CodePipelinePermissions',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                'codepipeline:PutJobFailureResult',
                                'codepipeline:PutJobSuccessResult',
                            ],
                            resources: ['*'],
                        }),
                        new iam.PolicyStatement({
                            sid: 'S3BucketPermissions',
                            effect: iam.Effect.ALLOW,
                            actions: ['s3:GetObject'],
                            resources: [`${props.bucketArn}/*`],
                        }),
                        new iam.PolicyStatement({
                            sid: 'AssumeRolePermission',
                            effect: iam.Effect.ALLOW,
                            actions: ['sts:AssumeRole'],
                            resources: [props.preproductionIamRoleArn],
                        }),
                    ],
                }),
            ],
            roleName: this.roleName,
        });
        const preproductionFunction = new lambda.Function(this, 'PreProductionFunction', {
            functionName: this.functionName,
            description: 'Read from latest commit and publish AWS Glue DataBrew recipe to pre-prod account',
            logRetention: logs.RetentionDays.THREE_MONTHS,
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromInline(functionScript),
            handler: 'index.lambda_handler',
            environment: { role: props.preproductionIamRoleArn },
            memorySize: 128,
            role: lambdaRole,
            timeout: cdk.Duration.seconds(20),
            tracing: lambda.Tracing.ACTIVE,
        });
        this.function = preproductionFunction;
    }
}
exports.PreProductionLambda = PreProductionLambda;
_a = JSII_RTTI_SYMBOL_1;
PreProductionLambda[_a] = { fqn: "cdk-databrew-cicd.PreProductionLambda", version: "0.1.10" };
/**
 * @stability stable
 */
class ProductionLambda extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, name, props) {
        var _d, _e;
        super(scope, name);
        this.roleName = (_d = props.roleName) !== null && _d !== void 0 ? _d : 'Prod-DataBrew-Recipe-Deployer-role';
        this.functionName = (_e = props.functionName) !== null && _e !== void 0 ? _e : 'Prod-DataBrew-Recipe-Deployer';
        const lambdaRole = new iam.Role(this, 'ProductionFunctionRole', {
            assumedBy: new iam.ServicePrincipal('lambda.amazonaws.com'),
            description: 'An execution role for the production Lambda funciton.',
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('AWSXRayDaemonWriteAccess'),
                new iam.ManagedPolicy(this, 'ProductionLambdaMangedPolicuy', {
                    managedPolicyName: 'Prod-DataBrew-Recipe-Deployer-Policy',
                    statements: [
                        new iam.PolicyStatement({
                            sid: 'CodePipelinePermissions',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                'codepipeline:PutJobFailureResult',
                                'codepipeline:PutJobSuccessResult',
                            ],
                            resources: ['*'],
                        }),
                        new iam.PolicyStatement({
                            sid: 'S3BucketPermissions',
                            effect: iam.Effect.ALLOW,
                            actions: ['s3:GetObject'],
                            resources: [`${props.bucketArn}/*`],
                        }),
                        new iam.PolicyStatement({
                            sid: 'AssumeRolePermission',
                            effect: iam.Effect.ALLOW,
                            actions: ['sts:AssumeRole'],
                            resources: [props.productionIamRoleArn],
                        }),
                    ],
                }),
            ],
            roleName: this.roleName,
        });
        const productionFunction = new lambda.Function(this, 'ProductionFunction', {
            functionName: this.functionName,
            description: 'Read from latest commit and publish AWS Glue DataBrew recipe to production account',
            logRetention: logs.RetentionDays.THREE_MONTHS,
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromInline(functionScript),
            handler: 'index.lambda_handler',
            environment: { role: props.productionIamRoleArn },
            memorySize: 128,
            role: lambdaRole,
            timeout: cdk.Duration.seconds(20),
            tracing: lambda.Tracing.ACTIVE,
        });
        this.function = productionFunction;
    }
}
exports.ProductionLambda = ProductionLambda;
_b = JSII_RTTI_SYMBOL_1;
ProductionLambda[_b] = { fqn: "cdk-databrew-cicd.ProductionLambda", version: "0.1.10" };
/**
 * @stability stable
 */
class FirstCommitHandler extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, name, props) {
        var _d, _e;
        super(scope, name);
        this.roleName = (_d = props.roleName) !== null && _d !== void 0 ? _d : 'LambdaForInitialCommitRole';
        this.functionName = (_e = props.functionName) !== null && _e !== void 0 ? _e : 'FirstCommitHandler';
        const lambdaRole = new iam.Role(this, 'FirstCommitFunctionRole', {
            assumedBy: new iam.ServicePrincipal('lambda.amazonaws.com'),
            description: 'An execution role for the Lambda function which deals with first commit via AWS CodeCommit.',
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('AWSXRayDaemonWriteAccess'),
            ],
            roleName: this.roleName,
            inlinePolicies: {
                LambdaForBranchPolicy: new iam.PolicyDocument({
                    assignSids: true,
                    statements: [new iam.PolicyStatement({
                            effect: iam.Effect.ALLOW,
                            actions: ['codecommit:CreateCommit'],
                            resources: [props.codeCommitRepoArn],
                        })],
                }),
            },
        });
        const commitHandlerFunction = new lambda.Function(this, 'CommitHandlerFunction', {
            functionName: this.functionName,
            description: 'Read from latest commit and publish AWS Glue DataBrew recipe to production account',
            logRetention: logs.RetentionDays.THREE_MONTHS,
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromInline('import os\r\nimport json\r\nimport boto3\r\nimport cfnresponse\r\n\r\ndef lambda_handler(event, context):\r\n    if(event[\'RequestType\'] == \'Create\'):\r\n        code_commit_client = boto3.client(\'codecommit\')\r\n        code_commit_client.create_commit(repositoryName=os.environ[\'repo_name\'],branchName=os.environ[\'branch_name\'],commitMessage=\'Initial Commit\',putFiles=[{\'filePath\': \'README.md\',\'fileMode\': \'NORMAL\',\'fileContent\': os.environ[\'readme_contents\']}])\r\n    responseValue = 120\r\n    responseData = {}\r\n    responseData[\'Data\'] = responseValue\r\n    cfnresponse.send(event, context, cfnresponse.SUCCESS, responseData)'),
            handler: 'index.lambda_handler',
            memorySize: 128,
            role: lambdaRole,
            environment: {
                repo_name: props.repoName,
                branch_name: props.branchName,
                readme_contents: 'CONTENTS OF THIS FILE\r\n------------\r\n * Introduction\r\n * How to set up local access\r\nINTRODUCTION\r\n------------\r\nThis repository is used for storing recipes for AWSGlue DataBrew. DataBrew is a visual data preparation tool that makes it easy to profile and prepare data for analytics and machine learning (ML). \r\nHOW TO SET UP LOCAL ACCESS\r\n------------\r\nTo set up local developer access:\r\n1. Open a terminal window, and configure the AWS CLI.\r\n   ```\r\n   aws configure\r\n   ```\r\n2. When prompted, provide the following information.\r\n   ```\r\n   > AWS Access Key ID [None]: User-Access-Key\r\n   > AWS Secret Access Key ID [None]: User-Secret-Access-Key\r\n   > Default region name ID [None]: us-east-1\r\n   > Default output format [None]: json\r\n   ```\r\n3. In a plain-text editor, open the config file, also known as the AWS CLI configuration file. Depending on your operating system, this file might be located at `~/.aws/config` on Linux, macOS, or Unix, or at `drive:\\Users\\USERNAME\\.aws\\config` on Windows.\r\n4. Update the file to include two entries, default for your account, and a second for cross account access. The resulting file should look as follows: \r\n   ```\r\n   [default]\r\n   account = <user-account-id>\r\n   region = us-east-1\r\n   output = json\r\n    \r\n   [profile CrossAccountAccessProfile]\r\n   account = <infra-account-id>\r\n   region = us-east-1\r\n   output = json\r\n   role_arn = arn:aws:iam::<infra-account-id>:role/CrossAccountRepositoryContributorRole\r\n   source_profile = default\r\n   ```\r\n6. Save your changes, and close the plain-text editor.\r\n7. Run *git clone* to clone the shared repository.\r\n   ```\r\n   > git clone codecommit://CrossAccountAccessProfile@DataBrew-Recipes-Repo \r\n   ```',
            },
            timeout: cdk.Duration.seconds(20),
            tracing: lambda.Tracing.ACTIVE,
        });
        this.function = commitHandlerFunction;
    }
}
exports.FirstCommitHandler = FirstCommitHandler;
_c = JSII_RTTI_SYMBOL_1;
FirstCommitHandler[_c] = { fqn: "cdk-databrew-cicd.FirstCommitHandler", version: "0.1.10" };
//# sourceMappingURL=data:application/json;base64,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