import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface IamRoleProps {
    /**
     * 'preproduction' or 'production'.
     *
     * @stability stable
     */
    readonly environment: string;
    /**
     * The ID of your infrastructure account.
     *
     * @stability stable
     */
    readonly accountID: string;
    /**
     * The role name.
     *
     * @default '{environment}-Databrew-Cicd-Role'
     * @stability stable
     */
    readonly roleName?: string;
}
/**
 * IAM Role.
 *
 * Defines an IAM role for pre-production and production AWS accounts.
 *
 * @stability stable
 */
export declare class IamRole extends cdk.Construct {
    /**
     * The ARN of the IAM role for pre-production or production.
     *
     * @stability stable
     */
    readonly roleArn: string;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, name: string, props: IamRoleProps);
}
