#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const cdk_databrew_cicd_1 = require("../../cdk-databrew-cicd");
class TypescriptStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const preproductionAccountId = 'PREPRODUCTION_ACCOUNT_ID';
        const productionAccountId = 'PRODUCTION_ACCOUNT_ID';
        const dataBrewPipeline = new cdk_databrew_cicd_1.DataBrewCodePipeline(this, 'DataBrewCicdPipeline', {
            preproductionIamRoleArn: `arn:${cdk.Aws.PARTITION}:iam::${preproductionAccountId}:role/preproduction-Databrew-Cicd-Role`,
            productionIamRoleArn: `arn:${cdk.Aws.PARTITION}:iam::${productionAccountId}:role/production-Databrew-Cicd-Role`,
        });
        new cdk.CfnOutput(this, 'OPreproductionLambdaArn', { value: dataBrewPipeline.preproductionFunctionArn });
        new cdk.CfnOutput(this, 'OProductionLambdaArn', { value: dataBrewPipeline.productionFunctionArn });
        new cdk.CfnOutput(this, 'OCodeCommitRepoArn', { value: dataBrewPipeline.codeCommitRepoArn });
        new cdk.CfnOutput(this, 'OCodePipelineArn', { value: dataBrewPipeline.codePipelineArn });
    }
}
const app = new cdk.App();
new TypescriptStack(app, 'TypescriptStack', {
    stackName: 'DataBrew-CICD',
});
//# sourceMappingURL=data:application/json;base64,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