import numpy as np
from pandas.util._decorators import Appender as Appender
from typing import Any, Optional, Tuple

get_window_bounds_doc: str

class BaseIndexer:
    index_array: Any = ...
    window_size: Any = ...
    def __init__(self, index_array: Optional[np.ndarray]=..., window_size: int=..., **kwargs: Any) -> None: ...
    def get_window_bounds(self, num_values: int=..., min_periods: Optional[int]=..., center: Optional[bool]=..., closed: Optional[str]=...) -> Tuple[np.ndarray, np.ndarray]: ...

class FixedWindowIndexer(BaseIndexer):
    def get_window_bounds(self, num_values: int=..., min_periods: Optional[int]=..., center: Optional[bool]=..., closed: Optional[str]=...) -> Tuple[np.ndarray, np.ndarray]: ...

class VariableWindowIndexer(BaseIndexer):
    def get_window_bounds(self, num_values: int=..., min_periods: Optional[int]=..., center: Optional[bool]=..., closed: Optional[str]=...) -> Tuple[np.ndarray, np.ndarray]: ...

class ExpandingIndexer(BaseIndexer):
    def get_window_bounds(self, num_values: int=..., min_periods: Optional[int]=..., center: Optional[bool]=..., closed: Optional[str]=...) -> Tuple[np.ndarray, np.ndarray]: ...
