# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AccessLevelBasic',
    'AccessLevelBasicCondition',
    'AccessLevelBasicConditionDevicePolicy',
    'AccessLevelBasicConditionDevicePolicyOsConstraint',
    'AccessLevelConditionDevicePolicy',
    'AccessLevelConditionDevicePolicyOsConstraint',
    'AccessLevelCustom',
    'AccessLevelCustomExpr',
    'AccessLevelsAccessLevel',
    'AccessLevelsAccessLevelBasic',
    'AccessLevelsAccessLevelBasicCondition',
    'AccessLevelsAccessLevelBasicConditionDevicePolicy',
    'AccessLevelsAccessLevelBasicConditionDevicePolicyOsConstraint',
    'AccessLevelsAccessLevelCustom',
    'AccessLevelsAccessLevelCustomExpr',
    'AccessPolicyIamBindingCondition',
    'AccessPolicyIamMemberCondition',
    'ServicePerimeterSpec',
    'ServicePerimeterSpecEgressPolicy',
    'ServicePerimeterSpecEgressPolicyEgressFrom',
    'ServicePerimeterSpecEgressPolicyEgressTo',
    'ServicePerimeterSpecEgressPolicyEgressToOperation',
    'ServicePerimeterSpecEgressPolicyEgressToOperationMethodSelector',
    'ServicePerimeterSpecIngressPolicy',
    'ServicePerimeterSpecIngressPolicyIngressFrom',
    'ServicePerimeterSpecIngressPolicyIngressFromSource',
    'ServicePerimeterSpecIngressPolicyIngressTo',
    'ServicePerimeterSpecIngressPolicyIngressToOperation',
    'ServicePerimeterSpecIngressPolicyIngressToOperationMethodSelector',
    'ServicePerimeterSpecVpcAccessibleServices',
    'ServicePerimeterStatus',
    'ServicePerimeterStatusEgressPolicy',
    'ServicePerimeterStatusEgressPolicyEgressFrom',
    'ServicePerimeterStatusEgressPolicyEgressTo',
    'ServicePerimeterStatusEgressPolicyEgressToOperation',
    'ServicePerimeterStatusEgressPolicyEgressToOperationMethodSelector',
    'ServicePerimeterStatusIngressPolicy',
    'ServicePerimeterStatusIngressPolicyIngressFrom',
    'ServicePerimeterStatusIngressPolicyIngressFromSource',
    'ServicePerimeterStatusIngressPolicyIngressTo',
    'ServicePerimeterStatusIngressPolicyIngressToOperation',
    'ServicePerimeterStatusIngressPolicyIngressToOperationMethodSelector',
    'ServicePerimeterStatusVpcAccessibleServices',
    'ServicePerimetersServicePerimeter',
    'ServicePerimetersServicePerimeterSpec',
    'ServicePerimetersServicePerimeterSpecEgressPolicy',
    'ServicePerimetersServicePerimeterSpecEgressPolicyEgressFrom',
    'ServicePerimetersServicePerimeterSpecEgressPolicyEgressTo',
    'ServicePerimetersServicePerimeterSpecEgressPolicyEgressToOperation',
    'ServicePerimetersServicePerimeterSpecEgressPolicyEgressToOperationMethodSelector',
    'ServicePerimetersServicePerimeterSpecIngressPolicy',
    'ServicePerimetersServicePerimeterSpecIngressPolicyIngressFrom',
    'ServicePerimetersServicePerimeterSpecIngressPolicyIngressFromSource',
    'ServicePerimetersServicePerimeterSpecIngressPolicyIngressTo',
    'ServicePerimetersServicePerimeterSpecIngressPolicyIngressToOperation',
    'ServicePerimetersServicePerimeterSpecIngressPolicyIngressToOperationMethodSelector',
    'ServicePerimetersServicePerimeterSpecVpcAccessibleServices',
    'ServicePerimetersServicePerimeterStatus',
    'ServicePerimetersServicePerimeterStatusEgressPolicy',
    'ServicePerimetersServicePerimeterStatusEgressPolicyEgressFrom',
    'ServicePerimetersServicePerimeterStatusEgressPolicyEgressTo',
    'ServicePerimetersServicePerimeterStatusEgressPolicyEgressToOperation',
    'ServicePerimetersServicePerimeterStatusEgressPolicyEgressToOperationMethodSelector',
    'ServicePerimetersServicePerimeterStatusIngressPolicy',
    'ServicePerimetersServicePerimeterStatusIngressPolicyIngressFrom',
    'ServicePerimetersServicePerimeterStatusIngressPolicyIngressFromSource',
    'ServicePerimetersServicePerimeterStatusIngressPolicyIngressTo',
    'ServicePerimetersServicePerimeterStatusIngressPolicyIngressToOperation',
    'ServicePerimetersServicePerimeterStatusIngressPolicyIngressToOperationMethodSelector',
    'ServicePerimetersServicePerimeterStatusVpcAccessibleServices',
]

@pulumi.output_type
class AccessLevelBasic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "combiningFunction":
            suggest = "combining_function"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessLevelBasic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessLevelBasic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessLevelBasic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Sequence['outputs.AccessLevelBasicCondition'],
                 combining_function: Optional[str] = None):
        """
        :param Sequence['AccessLevelBasicConditionArgs'] conditions: A set of requirements for the AccessLevel to be granted.
               Structure is documented below.
        :param str combining_function: How the conditions list should be combined to determine if a request
               is granted this AccessLevel. If AND is used, each Condition in
               conditions must be satisfied for the AccessLevel to be applied. If
               OR is used, at least one Condition in conditions must be satisfied
               for the AccessLevel to be applied.
               Default value is `AND`.
               Possible values are `AND` and `OR`.
        """
        pulumi.set(__self__, "conditions", conditions)
        if combining_function is not None:
            pulumi.set(__self__, "combining_function", combining_function)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.AccessLevelBasicCondition']:
        """
        A set of requirements for the AccessLevel to be granted.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="combiningFunction")
    def combining_function(self) -> Optional[str]:
        """
        How the conditions list should be combined to determine if a request
        is granted this AccessLevel. If AND is used, each Condition in
        conditions must be satisfied for the AccessLevel to be applied. If
        OR is used, at least one Condition in conditions must be satisfied
        for the AccessLevel to be applied.
        Default value is `AND`.
        Possible values are `AND` and `OR`.
        """
        return pulumi.get(self, "combining_function")


@pulumi.output_type
class AccessLevelBasicCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "devicePolicy":
            suggest = "device_policy"
        elif key == "ipSubnetworks":
            suggest = "ip_subnetworks"
        elif key == "requiredAccessLevels":
            suggest = "required_access_levels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessLevelBasicCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessLevelBasicCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessLevelBasicCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_policy: Optional['outputs.AccessLevelBasicConditionDevicePolicy'] = None,
                 ip_subnetworks: Optional[Sequence[str]] = None,
                 members: Optional[Sequence[str]] = None,
                 negate: Optional[bool] = None,
                 regions: Optional[Sequence[str]] = None,
                 required_access_levels: Optional[Sequence[str]] = None):
        """
        :param 'AccessLevelBasicConditionDevicePolicyArgs' device_policy: Device specific restrictions, all restrictions must hold for
               the Condition to be true. If not specified, all devices are
               allowed.
               Structure is documented below.
        :param Sequence[str] ip_subnetworks: A list of CIDR block IP subnetwork specification. May be IPv4
               or IPv6.
               Note that for a CIDR IP address block, the specified IP address
               portion must be properly truncated (i.e. all the host bits must
               be zero) or the input is considered malformed. For example,
               "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
               for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
               is not. The originating IP of a request must be in one of the
               listed subnets in order for this Condition to be true.
               If empty, all IP addresses are allowed.
        :param Sequence[str] members: An allowed list of members (users, service accounts).
               Using groups is not supported yet.
               The signed-in user originating the request must be a part of one
               of the provided members. If not specified, a request may come
               from any user (logged in/not logged in, not present in any
               groups, etc.).
               Formats: `user:{emailid}`, `serviceAccount:{emailid}`
        :param bool negate: Whether to negate the Condition. If true, the Condition becomes
               a NAND over its non-empty fields, each field must be false for
               the Condition overall to be satisfied. Defaults to false.
        :param Sequence[str] regions: The request must originate from one of the provided
               countries/regions.
               Format: A valid ISO 3166-1 alpha-2 code.
        :param Sequence[str] required_access_levels: A list of other access levels defined in the same Policy,
               referenced by resource name. Referencing an AccessLevel which
               does not exist is an error. All access levels listed must be
               granted for the Condition to be true.
               Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        """
        if device_policy is not None:
            pulumi.set(__self__, "device_policy", device_policy)
        if ip_subnetworks is not None:
            pulumi.set(__self__, "ip_subnetworks", ip_subnetworks)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if required_access_levels is not None:
            pulumi.set(__self__, "required_access_levels", required_access_levels)

    @property
    @pulumi.getter(name="devicePolicy")
    def device_policy(self) -> Optional['outputs.AccessLevelBasicConditionDevicePolicy']:
        """
        Device specific restrictions, all restrictions must hold for
        the Condition to be true. If not specified, all devices are
        allowed.
        Structure is documented below.
        """
        return pulumi.get(self, "device_policy")

    @property
    @pulumi.getter(name="ipSubnetworks")
    def ip_subnetworks(self) -> Optional[Sequence[str]]:
        """
        A list of CIDR block IP subnetwork specification. May be IPv4
        or IPv6.
        Note that for a CIDR IP address block, the specified IP address
        portion must be properly truncated (i.e. all the host bits must
        be zero) or the input is considered malformed. For example,
        "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
        for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
        is not. The originating IP of a request must be in one of the
        listed subnets in order for this Condition to be true.
        If empty, all IP addresses are allowed.
        """
        return pulumi.get(self, "ip_subnetworks")

    @property
    @pulumi.getter
    def members(self) -> Optional[Sequence[str]]:
        """
        An allowed list of members (users, service accounts).
        Using groups is not supported yet.
        The signed-in user originating the request must be a part of one
        of the provided members. If not specified, a request may come
        from any user (logged in/not logged in, not present in any
        groups, etc.).
        Formats: `user:{emailid}`, `serviceAccount:{emailid}`
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def negate(self) -> Optional[bool]:
        """
        Whether to negate the Condition. If true, the Condition becomes
        a NAND over its non-empty fields, each field must be false for
        the Condition overall to be satisfied. Defaults to false.
        """
        return pulumi.get(self, "negate")

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[str]]:
        """
        The request must originate from one of the provided
        countries/regions.
        Format: A valid ISO 3166-1 alpha-2 code.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="requiredAccessLevels")
    def required_access_levels(self) -> Optional[Sequence[str]]:
        """
        A list of other access levels defined in the same Policy,
        referenced by resource name. Referencing an AccessLevel which
        does not exist is an error. All access levels listed must be
        granted for the Condition to be true.
        Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        """
        return pulumi.get(self, "required_access_levels")


@pulumi.output_type
class AccessLevelBasicConditionDevicePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedDeviceManagementLevels":
            suggest = "allowed_device_management_levels"
        elif key == "allowedEncryptionStatuses":
            suggest = "allowed_encryption_statuses"
        elif key == "osConstraints":
            suggest = "os_constraints"
        elif key == "requireAdminApproval":
            suggest = "require_admin_approval"
        elif key == "requireCorpOwned":
            suggest = "require_corp_owned"
        elif key == "requireScreenLock":
            suggest = "require_screen_lock"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessLevelBasicConditionDevicePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessLevelBasicConditionDevicePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessLevelBasicConditionDevicePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_device_management_levels: Optional[Sequence[str]] = None,
                 allowed_encryption_statuses: Optional[Sequence[str]] = None,
                 os_constraints: Optional[Sequence['outputs.AccessLevelBasicConditionDevicePolicyOsConstraint']] = None,
                 require_admin_approval: Optional[bool] = None,
                 require_corp_owned: Optional[bool] = None,
                 require_screen_lock: Optional[bool] = None):
        """
        :param Sequence[str] allowed_device_management_levels: A list of allowed device management levels.
               An empty list allows all management levels.
               Each value may be one of `MANAGEMENT_UNSPECIFIED`, `NONE`, `BASIC`, and `COMPLETE`.
        :param Sequence[str] allowed_encryption_statuses: A list of allowed encryptions statuses.
               An empty list allows all statuses.
               Each value may be one of `ENCRYPTION_UNSPECIFIED`, `ENCRYPTION_UNSUPPORTED`, `UNENCRYPTED`, and `ENCRYPTED`.
        :param Sequence['AccessLevelBasicConditionDevicePolicyOsConstraintArgs'] os_constraints: A list of allowed OS versions.
               An empty list allows all types and all versions.
               Structure is documented below.
        :param bool require_admin_approval: Whether the device needs to be approved by the customer admin.
        :param bool require_corp_owned: Whether the device needs to be corp owned.
        :param bool require_screen_lock: Whether or not screenlock is required for the DevicePolicy
               to be true. Defaults to false.
        """
        if allowed_device_management_levels is not None:
            pulumi.set(__self__, "allowed_device_management_levels", allowed_device_management_levels)
        if allowed_encryption_statuses is not None:
            pulumi.set(__self__, "allowed_encryption_statuses", allowed_encryption_statuses)
        if os_constraints is not None:
            pulumi.set(__self__, "os_constraints", os_constraints)
        if require_admin_approval is not None:
            pulumi.set(__self__, "require_admin_approval", require_admin_approval)
        if require_corp_owned is not None:
            pulumi.set(__self__, "require_corp_owned", require_corp_owned)
        if require_screen_lock is not None:
            pulumi.set(__self__, "require_screen_lock", require_screen_lock)

    @property
    @pulumi.getter(name="allowedDeviceManagementLevels")
    def allowed_device_management_levels(self) -> Optional[Sequence[str]]:
        """
        A list of allowed device management levels.
        An empty list allows all management levels.
        Each value may be one of `MANAGEMENT_UNSPECIFIED`, `NONE`, `BASIC`, and `COMPLETE`.
        """
        return pulumi.get(self, "allowed_device_management_levels")

    @property
    @pulumi.getter(name="allowedEncryptionStatuses")
    def allowed_encryption_statuses(self) -> Optional[Sequence[str]]:
        """
        A list of allowed encryptions statuses.
        An empty list allows all statuses.
        Each value may be one of `ENCRYPTION_UNSPECIFIED`, `ENCRYPTION_UNSUPPORTED`, `UNENCRYPTED`, and `ENCRYPTED`.
        """
        return pulumi.get(self, "allowed_encryption_statuses")

    @property
    @pulumi.getter(name="osConstraints")
    def os_constraints(self) -> Optional[Sequence['outputs.AccessLevelBasicConditionDevicePolicyOsConstraint']]:
        """
        A list of allowed OS versions.
        An empty list allows all types and all versions.
        Structure is documented below.
        """
        return pulumi.get(self, "os_constraints")

    @property
    @pulumi.getter(name="requireAdminApproval")
    def require_admin_approval(self) -> Optional[bool]:
        """
        Whether the device needs to be approved by the customer admin.
        """
        return pulumi.get(self, "require_admin_approval")

    @property
    @pulumi.getter(name="requireCorpOwned")
    def require_corp_owned(self) -> Optional[bool]:
        """
        Whether the device needs to be corp owned.
        """
        return pulumi.get(self, "require_corp_owned")

    @property
    @pulumi.getter(name="requireScreenLock")
    def require_screen_lock(self) -> Optional[bool]:
        """
        Whether or not screenlock is required for the DevicePolicy
        to be true. Defaults to false.
        """
        return pulumi.get(self, "require_screen_lock")


@pulumi.output_type
class AccessLevelBasicConditionDevicePolicyOsConstraint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osType":
            suggest = "os_type"
        elif key == "minimumVersion":
            suggest = "minimum_version"
        elif key == "requireVerifiedChromeOs":
            suggest = "require_verified_chrome_os"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessLevelBasicConditionDevicePolicyOsConstraint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessLevelBasicConditionDevicePolicyOsConstraint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessLevelBasicConditionDevicePolicyOsConstraint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_type: str,
                 minimum_version: Optional[str] = None,
                 require_verified_chrome_os: Optional[bool] = None):
        """
        :param str os_type: The operating system type of the device.
               Possible values are `OS_UNSPECIFIED`, `DESKTOP_MAC`, `DESKTOP_WINDOWS`, `DESKTOP_LINUX`, `DESKTOP_CHROME_OS`, `ANDROID`, and `IOS`.
        :param str minimum_version: The minimum allowed OS version. If not set, any version
               of this OS satisfies the constraint.
               Format: "major.minor.patch" such as "10.5.301", "9.2.1".
        :param bool require_verified_chrome_os: If you specify DESKTOP_CHROME_OS for osType, you can optionally include requireVerifiedChromeOs to require Chrome Verified Access.
        """
        pulumi.set(__self__, "os_type", os_type)
        if minimum_version is not None:
            pulumi.set(__self__, "minimum_version", minimum_version)
        if require_verified_chrome_os is not None:
            pulumi.set(__self__, "require_verified_chrome_os", require_verified_chrome_os)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The operating system type of the device.
        Possible values are `OS_UNSPECIFIED`, `DESKTOP_MAC`, `DESKTOP_WINDOWS`, `DESKTOP_LINUX`, `DESKTOP_CHROME_OS`, `ANDROID`, and `IOS`.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="minimumVersion")
    def minimum_version(self) -> Optional[str]:
        """
        The minimum allowed OS version. If not set, any version
        of this OS satisfies the constraint.
        Format: "major.minor.patch" such as "10.5.301", "9.2.1".
        """
        return pulumi.get(self, "minimum_version")

    @property
    @pulumi.getter(name="requireVerifiedChromeOs")
    def require_verified_chrome_os(self) -> Optional[bool]:
        """
        If you specify DESKTOP_CHROME_OS for osType, you can optionally include requireVerifiedChromeOs to require Chrome Verified Access.
        """
        return pulumi.get(self, "require_verified_chrome_os")


@pulumi.output_type
class AccessLevelConditionDevicePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedDeviceManagementLevels":
            suggest = "allowed_device_management_levels"
        elif key == "allowedEncryptionStatuses":
            suggest = "allowed_encryption_statuses"
        elif key == "osConstraints":
            suggest = "os_constraints"
        elif key == "requireAdminApproval":
            suggest = "require_admin_approval"
        elif key == "requireCorpOwned":
            suggest = "require_corp_owned"
        elif key == "requireScreenLock":
            suggest = "require_screen_lock"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessLevelConditionDevicePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessLevelConditionDevicePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessLevelConditionDevicePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_device_management_levels: Optional[Sequence[str]] = None,
                 allowed_encryption_statuses: Optional[Sequence[str]] = None,
                 os_constraints: Optional[Sequence['outputs.AccessLevelConditionDevicePolicyOsConstraint']] = None,
                 require_admin_approval: Optional[bool] = None,
                 require_corp_owned: Optional[bool] = None,
                 require_screen_lock: Optional[bool] = None):
        """
        :param Sequence[str] allowed_device_management_levels: A list of allowed device management levels.
               An empty list allows all management levels.
               Each value may be one of `MANAGEMENT_UNSPECIFIED`, `NONE`, `BASIC`, and `COMPLETE`.
        :param Sequence[str] allowed_encryption_statuses: A list of allowed encryptions statuses.
               An empty list allows all statuses.
               Each value may be one of `ENCRYPTION_UNSPECIFIED`, `ENCRYPTION_UNSUPPORTED`, `UNENCRYPTED`, and `ENCRYPTED`.
        :param Sequence['AccessLevelConditionDevicePolicyOsConstraintArgs'] os_constraints: A list of allowed OS versions.
               An empty list allows all types and all versions.
               Structure is documented below.
        :param bool require_admin_approval: Whether the device needs to be approved by the customer admin.
        :param bool require_corp_owned: Whether the device needs to be corp owned.
        :param bool require_screen_lock: Whether or not screenlock is required for the DevicePolicy
               to be true. Defaults to false.
        """
        if allowed_device_management_levels is not None:
            pulumi.set(__self__, "allowed_device_management_levels", allowed_device_management_levels)
        if allowed_encryption_statuses is not None:
            pulumi.set(__self__, "allowed_encryption_statuses", allowed_encryption_statuses)
        if os_constraints is not None:
            pulumi.set(__self__, "os_constraints", os_constraints)
        if require_admin_approval is not None:
            pulumi.set(__self__, "require_admin_approval", require_admin_approval)
        if require_corp_owned is not None:
            pulumi.set(__self__, "require_corp_owned", require_corp_owned)
        if require_screen_lock is not None:
            pulumi.set(__self__, "require_screen_lock", require_screen_lock)

    @property
    @pulumi.getter(name="allowedDeviceManagementLevels")
    def allowed_device_management_levels(self) -> Optional[Sequence[str]]:
        """
        A list of allowed device management levels.
        An empty list allows all management levels.
        Each value may be one of `MANAGEMENT_UNSPECIFIED`, `NONE`, `BASIC`, and `COMPLETE`.
        """
        return pulumi.get(self, "allowed_device_management_levels")

    @property
    @pulumi.getter(name="allowedEncryptionStatuses")
    def allowed_encryption_statuses(self) -> Optional[Sequence[str]]:
        """
        A list of allowed encryptions statuses.
        An empty list allows all statuses.
        Each value may be one of `ENCRYPTION_UNSPECIFIED`, `ENCRYPTION_UNSUPPORTED`, `UNENCRYPTED`, and `ENCRYPTED`.
        """
        return pulumi.get(self, "allowed_encryption_statuses")

    @property
    @pulumi.getter(name="osConstraints")
    def os_constraints(self) -> Optional[Sequence['outputs.AccessLevelConditionDevicePolicyOsConstraint']]:
        """
        A list of allowed OS versions.
        An empty list allows all types and all versions.
        Structure is documented below.
        """
        return pulumi.get(self, "os_constraints")

    @property
    @pulumi.getter(name="requireAdminApproval")
    def require_admin_approval(self) -> Optional[bool]:
        """
        Whether the device needs to be approved by the customer admin.
        """
        return pulumi.get(self, "require_admin_approval")

    @property
    @pulumi.getter(name="requireCorpOwned")
    def require_corp_owned(self) -> Optional[bool]:
        """
        Whether the device needs to be corp owned.
        """
        return pulumi.get(self, "require_corp_owned")

    @property
    @pulumi.getter(name="requireScreenLock")
    def require_screen_lock(self) -> Optional[bool]:
        """
        Whether or not screenlock is required for the DevicePolicy
        to be true. Defaults to false.
        """
        return pulumi.get(self, "require_screen_lock")


@pulumi.output_type
class AccessLevelConditionDevicePolicyOsConstraint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osType":
            suggest = "os_type"
        elif key == "minimumVersion":
            suggest = "minimum_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessLevelConditionDevicePolicyOsConstraint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessLevelConditionDevicePolicyOsConstraint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessLevelConditionDevicePolicyOsConstraint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_type: str,
                 minimum_version: Optional[str] = None):
        """
        :param str os_type: The operating system type of the device.
               Possible values are `OS_UNSPECIFIED`, `DESKTOP_MAC`, `DESKTOP_WINDOWS`, `DESKTOP_LINUX`, `DESKTOP_CHROME_OS`, `ANDROID`, and `IOS`.
        :param str minimum_version: The minimum allowed OS version. If not set, any version
               of this OS satisfies the constraint.
               Format: "major.minor.patch" such as "10.5.301", "9.2.1".
        """
        pulumi.set(__self__, "os_type", os_type)
        if minimum_version is not None:
            pulumi.set(__self__, "minimum_version", minimum_version)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The operating system type of the device.
        Possible values are `OS_UNSPECIFIED`, `DESKTOP_MAC`, `DESKTOP_WINDOWS`, `DESKTOP_LINUX`, `DESKTOP_CHROME_OS`, `ANDROID`, and `IOS`.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="minimumVersion")
    def minimum_version(self) -> Optional[str]:
        """
        The minimum allowed OS version. If not set, any version
        of this OS satisfies the constraint.
        Format: "major.minor.patch" such as "10.5.301", "9.2.1".
        """
        return pulumi.get(self, "minimum_version")


@pulumi.output_type
class AccessLevelCustom(dict):
    def __init__(__self__, *,
                 expr: 'outputs.AccessLevelCustomExpr'):
        """
        :param 'AccessLevelCustomExprArgs' expr: Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language.
               This page details the objects and attributes that are used to the build the CEL expressions for
               custom access levels - https://cloud.google.com/access-context-manager/docs/custom-access-level-spec.
               Structure is documented below.
        """
        pulumi.set(__self__, "expr", expr)

    @property
    @pulumi.getter
    def expr(self) -> 'outputs.AccessLevelCustomExpr':
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language.
        This page details the objects and attributes that are used to the build the CEL expressions for
        custom access levels - https://cloud.google.com/access-context-manager/docs/custom-access-level-spec.
        Structure is documented below.
        """
        return pulumi.get(self, "expr")


@pulumi.output_type
class AccessLevelCustomExpr(dict):
    def __init__(__self__, *,
                 expression: str,
                 description: Optional[str] = None,
                 location: Optional[str] = None,
                 title: Optional[str] = None):
        """
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str description: Description of the expression
        :param str location: String indicating the location of the expression for error reporting, e.g. a file name and a position in the file
        :param str title: Title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the expression
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        String indicating the location of the expression for error reporting, e.g. a file name and a position in the file
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        """
        Title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class AccessLevelsAccessLevel(dict):
    def __init__(__self__, *,
                 name: str,
                 title: str,
                 basic: Optional['outputs.AccessLevelsAccessLevelBasic'] = None,
                 custom: Optional['outputs.AccessLevelsAccessLevelCustom'] = None,
                 description: Optional[str] = None):
        """
        :param str name: Resource name for the Access Level. The short_name component must begin
               with a letter and only include alphanumeric and '_'.
               Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        :param str title: Human readable title. Must be unique within the Policy.
        :param 'AccessLevelsAccessLevelBasicArgs' basic: A set of predefined conditions for the access level and a combining function.
               Structure is documented below.
        :param 'AccessLevelsAccessLevelCustomArgs' custom: Custom access level conditions are set using the Cloud Common Expression Language to represent the necessary conditions for the level to apply to a request.
               See CEL spec at: https://github.com/google/cel-spec.
               Structure is documented below.
        :param str description: Description of the AccessLevel and its use. Does not affect behavior.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "title", title)
        if basic is not None:
            pulumi.set(__self__, "basic", basic)
        if custom is not None:
            pulumi.set(__self__, "custom", custom)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name for the Access Level. The short_name component must begin
        with a letter and only include alphanumeric and '_'.
        Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Human readable title. Must be unique within the Policy.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def basic(self) -> Optional['outputs.AccessLevelsAccessLevelBasic']:
        """
        A set of predefined conditions for the access level and a combining function.
        Structure is documented below.
        """
        return pulumi.get(self, "basic")

    @property
    @pulumi.getter
    def custom(self) -> Optional['outputs.AccessLevelsAccessLevelCustom']:
        """
        Custom access level conditions are set using the Cloud Common Expression Language to represent the necessary conditions for the level to apply to a request.
        See CEL spec at: https://github.com/google/cel-spec.
        Structure is documented below.
        """
        return pulumi.get(self, "custom")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the AccessLevel and its use. Does not affect behavior.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class AccessLevelsAccessLevelBasic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "combiningFunction":
            suggest = "combining_function"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessLevelsAccessLevelBasic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessLevelsAccessLevelBasic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessLevelsAccessLevelBasic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Sequence['outputs.AccessLevelsAccessLevelBasicCondition'],
                 combining_function: Optional[str] = None):
        """
        :param Sequence['AccessLevelsAccessLevelBasicConditionArgs'] conditions: A set of requirements for the AccessLevel to be granted.
               Structure is documented below.
        :param str combining_function: How the conditions list should be combined to determine if a request
               is granted this AccessLevel. If AND is used, each Condition in
               conditions must be satisfied for the AccessLevel to be applied. If
               OR is used, at least one Condition in conditions must be satisfied
               for the AccessLevel to be applied.
               Default value is `AND`.
               Possible values are `AND` and `OR`.
        """
        pulumi.set(__self__, "conditions", conditions)
        if combining_function is not None:
            pulumi.set(__self__, "combining_function", combining_function)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.AccessLevelsAccessLevelBasicCondition']:
        """
        A set of requirements for the AccessLevel to be granted.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="combiningFunction")
    def combining_function(self) -> Optional[str]:
        """
        How the conditions list should be combined to determine if a request
        is granted this AccessLevel. If AND is used, each Condition in
        conditions must be satisfied for the AccessLevel to be applied. If
        OR is used, at least one Condition in conditions must be satisfied
        for the AccessLevel to be applied.
        Default value is `AND`.
        Possible values are `AND` and `OR`.
        """
        return pulumi.get(self, "combining_function")


@pulumi.output_type
class AccessLevelsAccessLevelBasicCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "devicePolicy":
            suggest = "device_policy"
        elif key == "ipSubnetworks":
            suggest = "ip_subnetworks"
        elif key == "requiredAccessLevels":
            suggest = "required_access_levels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessLevelsAccessLevelBasicCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessLevelsAccessLevelBasicCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessLevelsAccessLevelBasicCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_policy: Optional['outputs.AccessLevelsAccessLevelBasicConditionDevicePolicy'] = None,
                 ip_subnetworks: Optional[Sequence[str]] = None,
                 members: Optional[Sequence[str]] = None,
                 negate: Optional[bool] = None,
                 regions: Optional[Sequence[str]] = None,
                 required_access_levels: Optional[Sequence[str]] = None):
        """
        :param 'AccessLevelsAccessLevelBasicConditionDevicePolicyArgs' device_policy: Device specific restrictions, all restrictions must hold for
               the Condition to be true. If not specified, all devices are
               allowed.
               Structure is documented below.
        :param Sequence[str] ip_subnetworks: A list of CIDR block IP subnetwork specification. May be IPv4
               or IPv6.
               Note that for a CIDR IP address block, the specified IP address
               portion must be properly truncated (i.e. all the host bits must
               be zero) or the input is considered malformed. For example,
               "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
               for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
               is not. The originating IP of a request must be in one of the
               listed subnets in order for this Condition to be true.
               If empty, all IP addresses are allowed.
        :param Sequence[str] members: An allowed list of members (users, service accounts).
               Using groups is not supported yet.
               The signed-in user originating the request must be a part of one
               of the provided members. If not specified, a request may come
               from any user (logged in/not logged in, not present in any
               groups, etc.).
               Formats: `user:{emailid}`, `serviceAccount:{emailid}`
        :param bool negate: Whether to negate the Condition. If true, the Condition becomes
               a NAND over its non-empty fields, each field must be false for
               the Condition overall to be satisfied. Defaults to false.
        :param Sequence[str] regions: The request must originate from one of the provided
               countries/regions.
               Format: A valid ISO 3166-1 alpha-2 code.
        :param Sequence[str] required_access_levels: A list of other access levels defined in the same Policy,
               referenced by resource name. Referencing an AccessLevel which
               does not exist is an error. All access levels listed must be
               granted for the Condition to be true.
               Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        """
        if device_policy is not None:
            pulumi.set(__self__, "device_policy", device_policy)
        if ip_subnetworks is not None:
            pulumi.set(__self__, "ip_subnetworks", ip_subnetworks)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if required_access_levels is not None:
            pulumi.set(__self__, "required_access_levels", required_access_levels)

    @property
    @pulumi.getter(name="devicePolicy")
    def device_policy(self) -> Optional['outputs.AccessLevelsAccessLevelBasicConditionDevicePolicy']:
        """
        Device specific restrictions, all restrictions must hold for
        the Condition to be true. If not specified, all devices are
        allowed.
        Structure is documented below.
        """
        return pulumi.get(self, "device_policy")

    @property
    @pulumi.getter(name="ipSubnetworks")
    def ip_subnetworks(self) -> Optional[Sequence[str]]:
        """
        A list of CIDR block IP subnetwork specification. May be IPv4
        or IPv6.
        Note that for a CIDR IP address block, the specified IP address
        portion must be properly truncated (i.e. all the host bits must
        be zero) or the input is considered malformed. For example,
        "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
        for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
        is not. The originating IP of a request must be in one of the
        listed subnets in order for this Condition to be true.
        If empty, all IP addresses are allowed.
        """
        return pulumi.get(self, "ip_subnetworks")

    @property
    @pulumi.getter
    def members(self) -> Optional[Sequence[str]]:
        """
        An allowed list of members (users, service accounts).
        Using groups is not supported yet.
        The signed-in user originating the request must be a part of one
        of the provided members. If not specified, a request may come
        from any user (logged in/not logged in, not present in any
        groups, etc.).
        Formats: `user:{emailid}`, `serviceAccount:{emailid}`
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def negate(self) -> Optional[bool]:
        """
        Whether to negate the Condition. If true, the Condition becomes
        a NAND over its non-empty fields, each field must be false for
        the Condition overall to be satisfied. Defaults to false.
        """
        return pulumi.get(self, "negate")

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[str]]:
        """
        The request must originate from one of the provided
        countries/regions.
        Format: A valid ISO 3166-1 alpha-2 code.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="requiredAccessLevels")
    def required_access_levels(self) -> Optional[Sequence[str]]:
        """
        A list of other access levels defined in the same Policy,
        referenced by resource name. Referencing an AccessLevel which
        does not exist is an error. All access levels listed must be
        granted for the Condition to be true.
        Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        """
        return pulumi.get(self, "required_access_levels")


@pulumi.output_type
class AccessLevelsAccessLevelBasicConditionDevicePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedDeviceManagementLevels":
            suggest = "allowed_device_management_levels"
        elif key == "allowedEncryptionStatuses":
            suggest = "allowed_encryption_statuses"
        elif key == "osConstraints":
            suggest = "os_constraints"
        elif key == "requireAdminApproval":
            suggest = "require_admin_approval"
        elif key == "requireCorpOwned":
            suggest = "require_corp_owned"
        elif key == "requireScreenLock":
            suggest = "require_screen_lock"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessLevelsAccessLevelBasicConditionDevicePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessLevelsAccessLevelBasicConditionDevicePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessLevelsAccessLevelBasicConditionDevicePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_device_management_levels: Optional[Sequence[str]] = None,
                 allowed_encryption_statuses: Optional[Sequence[str]] = None,
                 os_constraints: Optional[Sequence['outputs.AccessLevelsAccessLevelBasicConditionDevicePolicyOsConstraint']] = None,
                 require_admin_approval: Optional[bool] = None,
                 require_corp_owned: Optional[bool] = None,
                 require_screen_lock: Optional[bool] = None):
        """
        :param Sequence[str] allowed_device_management_levels: A list of allowed device management levels.
               An empty list allows all management levels.
               Each value may be one of `MANAGEMENT_UNSPECIFIED`, `NONE`, `BASIC`, and `COMPLETE`.
        :param Sequence[str] allowed_encryption_statuses: A list of allowed encryptions statuses.
               An empty list allows all statuses.
               Each value may be one of `ENCRYPTION_UNSPECIFIED`, `ENCRYPTION_UNSUPPORTED`, `UNENCRYPTED`, and `ENCRYPTED`.
        :param Sequence['AccessLevelsAccessLevelBasicConditionDevicePolicyOsConstraintArgs'] os_constraints: A list of allowed OS versions.
               An empty list allows all types and all versions.
               Structure is documented below.
        :param bool require_admin_approval: Whether the device needs to be approved by the customer admin.
        :param bool require_corp_owned: Whether the device needs to be corp owned.
        :param bool require_screen_lock: Whether or not screenlock is required for the DevicePolicy
               to be true. Defaults to false.
        """
        if allowed_device_management_levels is not None:
            pulumi.set(__self__, "allowed_device_management_levels", allowed_device_management_levels)
        if allowed_encryption_statuses is not None:
            pulumi.set(__self__, "allowed_encryption_statuses", allowed_encryption_statuses)
        if os_constraints is not None:
            pulumi.set(__self__, "os_constraints", os_constraints)
        if require_admin_approval is not None:
            pulumi.set(__self__, "require_admin_approval", require_admin_approval)
        if require_corp_owned is not None:
            pulumi.set(__self__, "require_corp_owned", require_corp_owned)
        if require_screen_lock is not None:
            pulumi.set(__self__, "require_screen_lock", require_screen_lock)

    @property
    @pulumi.getter(name="allowedDeviceManagementLevels")
    def allowed_device_management_levels(self) -> Optional[Sequence[str]]:
        """
        A list of allowed device management levels.
        An empty list allows all management levels.
        Each value may be one of `MANAGEMENT_UNSPECIFIED`, `NONE`, `BASIC`, and `COMPLETE`.
        """
        return pulumi.get(self, "allowed_device_management_levels")

    @property
    @pulumi.getter(name="allowedEncryptionStatuses")
    def allowed_encryption_statuses(self) -> Optional[Sequence[str]]:
        """
        A list of allowed encryptions statuses.
        An empty list allows all statuses.
        Each value may be one of `ENCRYPTION_UNSPECIFIED`, `ENCRYPTION_UNSUPPORTED`, `UNENCRYPTED`, and `ENCRYPTED`.
        """
        return pulumi.get(self, "allowed_encryption_statuses")

    @property
    @pulumi.getter(name="osConstraints")
    def os_constraints(self) -> Optional[Sequence['outputs.AccessLevelsAccessLevelBasicConditionDevicePolicyOsConstraint']]:
        """
        A list of allowed OS versions.
        An empty list allows all types and all versions.
        Structure is documented below.
        """
        return pulumi.get(self, "os_constraints")

    @property
    @pulumi.getter(name="requireAdminApproval")
    def require_admin_approval(self) -> Optional[bool]:
        """
        Whether the device needs to be approved by the customer admin.
        """
        return pulumi.get(self, "require_admin_approval")

    @property
    @pulumi.getter(name="requireCorpOwned")
    def require_corp_owned(self) -> Optional[bool]:
        """
        Whether the device needs to be corp owned.
        """
        return pulumi.get(self, "require_corp_owned")

    @property
    @pulumi.getter(name="requireScreenLock")
    def require_screen_lock(self) -> Optional[bool]:
        """
        Whether or not screenlock is required for the DevicePolicy
        to be true. Defaults to false.
        """
        return pulumi.get(self, "require_screen_lock")


@pulumi.output_type
class AccessLevelsAccessLevelBasicConditionDevicePolicyOsConstraint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osType":
            suggest = "os_type"
        elif key == "minimumVersion":
            suggest = "minimum_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessLevelsAccessLevelBasicConditionDevicePolicyOsConstraint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessLevelsAccessLevelBasicConditionDevicePolicyOsConstraint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessLevelsAccessLevelBasicConditionDevicePolicyOsConstraint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_type: str,
                 minimum_version: Optional[str] = None):
        """
        :param str os_type: The operating system type of the device.
               Possible values are `OS_UNSPECIFIED`, `DESKTOP_MAC`, `DESKTOP_WINDOWS`, `DESKTOP_LINUX`, `DESKTOP_CHROME_OS`, `ANDROID`, and `IOS`.
        :param str minimum_version: The minimum allowed OS version. If not set, any version
               of this OS satisfies the constraint.
               Format: "major.minor.patch" such as "10.5.301", "9.2.1".
        """
        pulumi.set(__self__, "os_type", os_type)
        if minimum_version is not None:
            pulumi.set(__self__, "minimum_version", minimum_version)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The operating system type of the device.
        Possible values are `OS_UNSPECIFIED`, `DESKTOP_MAC`, `DESKTOP_WINDOWS`, `DESKTOP_LINUX`, `DESKTOP_CHROME_OS`, `ANDROID`, and `IOS`.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="minimumVersion")
    def minimum_version(self) -> Optional[str]:
        """
        The minimum allowed OS version. If not set, any version
        of this OS satisfies the constraint.
        Format: "major.minor.patch" such as "10.5.301", "9.2.1".
        """
        return pulumi.get(self, "minimum_version")


@pulumi.output_type
class AccessLevelsAccessLevelCustom(dict):
    def __init__(__self__, *,
                 expr: 'outputs.AccessLevelsAccessLevelCustomExpr'):
        """
        :param 'AccessLevelsAccessLevelCustomExprArgs' expr: Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language.
               This page details the objects and attributes that are used to the build the CEL expressions for
               custom access levels - https://cloud.google.com/access-context-manager/docs/custom-access-level-spec.
               Structure is documented below.
        """
        pulumi.set(__self__, "expr", expr)

    @property
    @pulumi.getter
    def expr(self) -> 'outputs.AccessLevelsAccessLevelCustomExpr':
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language.
        This page details the objects and attributes that are used to the build the CEL expressions for
        custom access levels - https://cloud.google.com/access-context-manager/docs/custom-access-level-spec.
        Structure is documented below.
        """
        return pulumi.get(self, "expr")


@pulumi.output_type
class AccessLevelsAccessLevelCustomExpr(dict):
    def __init__(__self__, *,
                 expression: str,
                 description: Optional[str] = None,
                 location: Optional[str] = None,
                 title: Optional[str] = None):
        """
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str description: Description of the expression
        :param str location: String indicating the location of the expression for error reporting, e.g. a file name and a position in the file
        :param str title: Title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the expression
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        String indicating the location of the expression for error reporting, e.g. a file name and a position in the file
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        """
        Title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class AccessPolicyIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AccessPolicyIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class ServicePerimeterSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessLevels":
            suggest = "access_levels"
        elif key == "egressPolicies":
            suggest = "egress_policies"
        elif key == "ingressPolicies":
            suggest = "ingress_policies"
        elif key == "restrictedServices":
            suggest = "restricted_services"
        elif key == "vpcAccessibleServices":
            suggest = "vpc_accessible_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_levels: Optional[Sequence[str]] = None,
                 egress_policies: Optional[Sequence['outputs.ServicePerimeterSpecEgressPolicy']] = None,
                 ingress_policies: Optional[Sequence['outputs.ServicePerimeterSpecIngressPolicy']] = None,
                 resources: Optional[Sequence[str]] = None,
                 restricted_services: Optional[Sequence[str]] = None,
                 vpc_accessible_services: Optional['outputs.ServicePerimeterSpecVpcAccessibleServices'] = None):
        """
        :param Sequence[str] access_levels: A list of AccessLevel resource names that allow resources within
               the ServicePerimeter to be accessed from the internet.
               AccessLevels listed must be in the same policy as this
               ServicePerimeter. Referencing a nonexistent AccessLevel is a
               syntax error. If no AccessLevel names are listed, resources within
               the perimeter can only be accessed via GCP calls with request
               origins within the perimeter. For Service Perimeter Bridge, must
               be empty.
               Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        :param Sequence['ServicePerimeterSpecEgressPolicyArgs'] egress_policies: List of EgressPolicies to apply to the perimeter. A perimeter may
               have multiple EgressPolicies, each of which is evaluated separately.
               Access is granted if any EgressPolicy grants it. Must be empty for
               a perimeter bridge.
               Structure is documented below.
        :param Sequence['ServicePerimeterSpecIngressPolicyArgs'] ingress_policies: List of `IngressPolicies` to apply to the perimeter. A perimeter may
               have multiple `IngressPolicies`, each of which is evaluated
               separately. Access is granted if any `Ingress Policy` grants it.
               Must be empty for a perimeter bridge.
               Structure is documented below.
        :param Sequence[str] resources: A list of GCP resources that are inside of the service perimeter.
               Currently only projects are allowed.
               Format: projects/{project_number}
        :param Sequence[str] restricted_services: GCP services that are subject to the Service Perimeter
               restrictions. Must contain a list of services. For example, if
               `storage.googleapis.com` is specified, access to the storage
               buckets inside the perimeter must meet the perimeter's access
               restrictions.
        :param 'ServicePerimeterSpecVpcAccessibleServicesArgs' vpc_accessible_services: Specifies how APIs are allowed to communicate within the Service
               Perimeter.
               Structure is documented below.
        """
        if access_levels is not None:
            pulumi.set(__self__, "access_levels", access_levels)
        if egress_policies is not None:
            pulumi.set(__self__, "egress_policies", egress_policies)
        if ingress_policies is not None:
            pulumi.set(__self__, "ingress_policies", ingress_policies)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if restricted_services is not None:
            pulumi.set(__self__, "restricted_services", restricted_services)
        if vpc_accessible_services is not None:
            pulumi.set(__self__, "vpc_accessible_services", vpc_accessible_services)

    @property
    @pulumi.getter(name="accessLevels")
    def access_levels(self) -> Optional[Sequence[str]]:
        """
        A list of AccessLevel resource names that allow resources within
        the ServicePerimeter to be accessed from the internet.
        AccessLevels listed must be in the same policy as this
        ServicePerimeter. Referencing a nonexistent AccessLevel is a
        syntax error. If no AccessLevel names are listed, resources within
        the perimeter can only be accessed via GCP calls with request
        origins within the perimeter. For Service Perimeter Bridge, must
        be empty.
        Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        """
        return pulumi.get(self, "access_levels")

    @property
    @pulumi.getter(name="egressPolicies")
    def egress_policies(self) -> Optional[Sequence['outputs.ServicePerimeterSpecEgressPolicy']]:
        """
        List of EgressPolicies to apply to the perimeter. A perimeter may
        have multiple EgressPolicies, each of which is evaluated separately.
        Access is granted if any EgressPolicy grants it. Must be empty for
        a perimeter bridge.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_policies")

    @property
    @pulumi.getter(name="ingressPolicies")
    def ingress_policies(self) -> Optional[Sequence['outputs.ServicePerimeterSpecIngressPolicy']]:
        """
        List of `IngressPolicies` to apply to the perimeter. A perimeter may
        have multiple `IngressPolicies`, each of which is evaluated
        separately. Access is granted if any `Ingress Policy` grants it.
        Must be empty for a perimeter bridge.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_policies")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        A list of GCP resources that are inside of the service perimeter.
        Currently only projects are allowed.
        Format: projects/{project_number}
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="restrictedServices")
    def restricted_services(self) -> Optional[Sequence[str]]:
        """
        GCP services that are subject to the Service Perimeter
        restrictions. Must contain a list of services. For example, if
        `storage.googleapis.com` is specified, access to the storage
        buckets inside the perimeter must meet the perimeter's access
        restrictions.
        """
        return pulumi.get(self, "restricted_services")

    @property
    @pulumi.getter(name="vpcAccessibleServices")
    def vpc_accessible_services(self) -> Optional['outputs.ServicePerimeterSpecVpcAccessibleServices']:
        """
        Specifies how APIs are allowed to communicate within the Service
        Perimeter.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_accessible_services")


@pulumi.output_type
class ServicePerimeterSpecEgressPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "egressFrom":
            suggest = "egress_from"
        elif key == "egressTo":
            suggest = "egress_to"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterSpecEgressPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterSpecEgressPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterSpecEgressPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 egress_from: Optional['outputs.ServicePerimeterSpecEgressPolicyEgressFrom'] = None,
                 egress_to: Optional['outputs.ServicePerimeterSpecEgressPolicyEgressTo'] = None):
        """
        :param 'ServicePerimeterSpecEgressPolicyEgressFromArgs' egress_from: Defines conditions on the source of a request causing this `EgressPolicy` to apply.
               Structure is documented below.
        :param 'ServicePerimeterSpecEgressPolicyEgressToArgs' egress_to: Defines the conditions on the `ApiOperation` and destination resources that
               cause this `EgressPolicy` to apply.
               Structure is documented below.
        """
        if egress_from is not None:
            pulumi.set(__self__, "egress_from", egress_from)
        if egress_to is not None:
            pulumi.set(__self__, "egress_to", egress_to)

    @property
    @pulumi.getter(name="egressFrom")
    def egress_from(self) -> Optional['outputs.ServicePerimeterSpecEgressPolicyEgressFrom']:
        """
        Defines conditions on the source of a request causing this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_from")

    @property
    @pulumi.getter(name="egressTo")
    def egress_to(self) -> Optional['outputs.ServicePerimeterSpecEgressPolicyEgressTo']:
        """
        Defines the conditions on the `ApiOperation` and destination resources that
        cause this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_to")


@pulumi.output_type
class ServicePerimeterSpecEgressPolicyEgressFrom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityType":
            suggest = "identity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterSpecEgressPolicyEgressFrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterSpecEgressPolicyEgressFrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterSpecEgressPolicyEgressFrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identities: Optional[Sequence[str]] = None,
                 identity_type: Optional[str] = None):
        """
        :param Sequence[str] identities: A list of identities that are allowed access through this `EgressPolicy`.
               Should be in the format of email address. The email address should
               represent individual user or service account only.
        :param str identity_type: Specifies the type of identities that are allowed access to outside the
               perimeter. If left unspecified, then members of `identities` field will
               be allowed access.
               Possible values are `IDENTITY_TYPE_UNSPECIFIED`, `ANY_IDENTITY`, `ANY_USER_ACCOUNT`, and `ANY_SERVICE_ACCOUNT`.
        """
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if identity_type is not None:
            pulumi.set(__self__, "identity_type", identity_type)

    @property
    @pulumi.getter
    def identities(self) -> Optional[Sequence[str]]:
        """
        A list of identities that are allowed access through this `EgressPolicy`.
        Should be in the format of email address. The email address should
        represent individual user or service account only.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> Optional[str]:
        """
        Specifies the type of identities that are allowed access to outside the
        perimeter. If left unspecified, then members of `identities` field will
        be allowed access.
        Possible values are `IDENTITY_TYPE_UNSPECIFIED`, `ANY_IDENTITY`, `ANY_USER_ACCOUNT`, and `ANY_SERVICE_ACCOUNT`.
        """
        return pulumi.get(self, "identity_type")


@pulumi.output_type
class ServicePerimeterSpecEgressPolicyEgressTo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalResources":
            suggest = "external_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterSpecEgressPolicyEgressTo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterSpecEgressPolicyEgressTo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterSpecEgressPolicyEgressTo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_resources: Optional[Sequence[str]] = None,
                 operations: Optional[Sequence['outputs.ServicePerimeterSpecEgressPolicyEgressToOperation']] = None,
                 resources: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] external_resources: A list of external resources that are allowed to be accessed. A request
               matches if it contains an external resource in this list (Example:
               s3://bucket/path). Currently '*' is not allowed.
        :param Sequence['ServicePerimeterSpecEgressPolicyEgressToOperationArgs'] operations: A list of `ApiOperations` that this egress rule applies to. A request matches
               if it contains an operation/service in this list.
               Structure is documented below.
        :param Sequence[str] resources: A list of resources, currently only projects in the form
               `projects/<projectnumber>`, that match this to stanza. A request matches
               if it contains a resource in this list. If * is specified for resources,
               then this `EgressTo` rule will authorize access to all resources outside
               the perimeter.
        """
        if external_resources is not None:
            pulumi.set(__self__, "external_resources", external_resources)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter(name="externalResources")
    def external_resources(self) -> Optional[Sequence[str]]:
        """
        A list of external resources that are allowed to be accessed. A request
        matches if it contains an external resource in this list (Example:
        s3://bucket/path). Currently '*' is not allowed.
        """
        return pulumi.get(self, "external_resources")

    @property
    @pulumi.getter
    def operations(self) -> Optional[Sequence['outputs.ServicePerimeterSpecEgressPolicyEgressToOperation']]:
        """
        A list of `ApiOperations` that this egress rule applies to. A request matches
        if it contains an operation/service in this list.
        Structure is documented below.
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        A list of resources, currently only projects in the form
        `projects/<projectnumber>`, that match this to stanza. A request matches
        if it contains a resource in this list. If * is specified for resources,
        then this `EgressTo` rule will authorize access to all resources outside
        the perimeter.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class ServicePerimeterSpecEgressPolicyEgressToOperation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "methodSelectors":
            suggest = "method_selectors"
        elif key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterSpecEgressPolicyEgressToOperation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterSpecEgressPolicyEgressToOperation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterSpecEgressPolicyEgressToOperation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method_selectors: Optional[Sequence['outputs.ServicePerimeterSpecEgressPolicyEgressToOperationMethodSelector']] = None,
                 service_name: Optional[str] = None):
        """
        :param Sequence['ServicePerimeterSpecEgressPolicyEgressToOperationMethodSelectorArgs'] method_selectors: API methods or permissions to allow. Method or permission must belong
               to the service specified by `serviceName` field. A single MethodSelector
               entry with `*` specified for the `method` field will allow all methods
               AND permissions for the service specified in `serviceName`.
               Structure is documented below.
        :param str service_name: The name of the API whose methods or permissions the `IngressPolicy` or
               `EgressPolicy` want to allow. A single `ApiOperation` with serviceName
               field set to `*` will allow all methods AND permissions for all services.
        """
        if method_selectors is not None:
            pulumi.set(__self__, "method_selectors", method_selectors)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="methodSelectors")
    def method_selectors(self) -> Optional[Sequence['outputs.ServicePerimeterSpecEgressPolicyEgressToOperationMethodSelector']]:
        """
        API methods or permissions to allow. Method or permission must belong
        to the service specified by `serviceName` field. A single MethodSelector
        entry with `*` specified for the `method` field will allow all methods
        AND permissions for the service specified in `serviceName`.
        Structure is documented below.
        """
        return pulumi.get(self, "method_selectors")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        """
        The name of the API whose methods or permissions the `IngressPolicy` or
        `EgressPolicy` want to allow. A single `ApiOperation` with serviceName
        field set to `*` will allow all methods AND permissions for all services.
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class ServicePerimeterSpecEgressPolicyEgressToOperationMethodSelector(dict):
    def __init__(__self__, *,
                 method: Optional[str] = None,
                 permission: Optional[str] = None):
        """
        :param str method: Value for `method` should be a valid method name for the corresponding
               `serviceName` in `ApiOperation`. If `*` used as value for method,
               then ALL methods and permissions are allowed.
        :param str permission: Value for permission should be a valid Cloud IAM permission for the
               corresponding `serviceName` in `ApiOperation`.
        """
        if method is not None:
            pulumi.set(__self__, "method", method)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        Value for `method` should be a valid method name for the corresponding
        `serviceName` in `ApiOperation`. If `*` used as value for method,
        then ALL methods and permissions are allowed.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def permission(self) -> Optional[str]:
        """
        Value for permission should be a valid Cloud IAM permission for the
        corresponding `serviceName` in `ApiOperation`.
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class ServicePerimeterSpecIngressPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ingressFrom":
            suggest = "ingress_from"
        elif key == "ingressTo":
            suggest = "ingress_to"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterSpecIngressPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterSpecIngressPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterSpecIngressPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ingress_from: Optional['outputs.ServicePerimeterSpecIngressPolicyIngressFrom'] = None,
                 ingress_to: Optional['outputs.ServicePerimeterSpecIngressPolicyIngressTo'] = None):
        """
        :param 'ServicePerimeterSpecIngressPolicyIngressFromArgs' ingress_from: Defines the conditions on the source of a request causing this `IngressPolicy`
               to apply.
               Structure is documented below.
        :param 'ServicePerimeterSpecIngressPolicyIngressToArgs' ingress_to: Defines the conditions on the `ApiOperation` and request destination that cause
               this `IngressPolicy` to apply.
               Structure is documented below.
        """
        if ingress_from is not None:
            pulumi.set(__self__, "ingress_from", ingress_from)
        if ingress_to is not None:
            pulumi.set(__self__, "ingress_to", ingress_to)

    @property
    @pulumi.getter(name="ingressFrom")
    def ingress_from(self) -> Optional['outputs.ServicePerimeterSpecIngressPolicyIngressFrom']:
        """
        Defines the conditions on the source of a request causing this `IngressPolicy`
        to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_from")

    @property
    @pulumi.getter(name="ingressTo")
    def ingress_to(self) -> Optional['outputs.ServicePerimeterSpecIngressPolicyIngressTo']:
        """
        Defines the conditions on the `ApiOperation` and request destination that cause
        this `IngressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_to")


@pulumi.output_type
class ServicePerimeterSpecIngressPolicyIngressFrom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityType":
            suggest = "identity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterSpecIngressPolicyIngressFrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterSpecIngressPolicyIngressFrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterSpecIngressPolicyIngressFrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identities: Optional[Sequence[str]] = None,
                 identity_type: Optional[str] = None,
                 sources: Optional[Sequence['outputs.ServicePerimeterSpecIngressPolicyIngressFromSource']] = None):
        """
        :param Sequence[str] identities: A list of identities that are allowed access through this ingress policy.
               Should be in the format of email address. The email address should represent
               individual user or service account only.
        :param str identity_type: Specifies the type of identities that are allowed access from outside the
               perimeter. If left unspecified, then members of `identities` field will be
               allowed access.
               Possible values are `IDENTITY_TYPE_UNSPECIFIED`, `ANY_IDENTITY`, `ANY_USER_ACCOUNT`, and `ANY_SERVICE_ACCOUNT`.
        :param Sequence['ServicePerimeterSpecIngressPolicyIngressFromSourceArgs'] sources: Sources that this `IngressPolicy` authorizes access from.
               Structure is documented below.
        """
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if identity_type is not None:
            pulumi.set(__self__, "identity_type", identity_type)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def identities(self) -> Optional[Sequence[str]]:
        """
        A list of identities that are allowed access through this ingress policy.
        Should be in the format of email address. The email address should represent
        individual user or service account only.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> Optional[str]:
        """
        Specifies the type of identities that are allowed access from outside the
        perimeter. If left unspecified, then members of `identities` field will be
        allowed access.
        Possible values are `IDENTITY_TYPE_UNSPECIFIED`, `ANY_IDENTITY`, `ANY_USER_ACCOUNT`, and `ANY_SERVICE_ACCOUNT`.
        """
        return pulumi.get(self, "identity_type")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.ServicePerimeterSpecIngressPolicyIngressFromSource']]:
        """
        Sources that this `IngressPolicy` authorizes access from.
        Structure is documented below.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class ServicePerimeterSpecIngressPolicyIngressFromSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessLevel":
            suggest = "access_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterSpecIngressPolicyIngressFromSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterSpecIngressPolicyIngressFromSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterSpecIngressPolicyIngressFromSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_level: Optional[str] = None,
                 resource: Optional[str] = None):
        """
        :param str access_level: An `AccessLevel` resource name that allow resources within the
               `ServicePerimeters` to be accessed from the internet. `AccessLevels` listed
               must be in the same policy as this `ServicePerimeter`. Referencing a nonexistent
               `AccessLevel` will cause an error. If no `AccessLevel` names are listed,
               resources within the perimeter can only be accessed via Google Cloud calls
               with request origins within the perimeter.
               Example `accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.`
               If * is specified, then all IngressSources will be allowed.
        :param str resource: A Google Cloud resource that is allowed to ingress the perimeter.
               Requests from these resources will be allowed to access perimeter data.
               Currently only projects are allowed. Format `projects/{project_number}`
               The project may be in any Google Cloud organization, not just the
               organization that the perimeter is defined in. `*` is not allowed, the case
               of allowing all Google Cloud resources only is not supported.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        """
        An `AccessLevel` resource name that allow resources within the
        `ServicePerimeters` to be accessed from the internet. `AccessLevels` listed
        must be in the same policy as this `ServicePerimeter`. Referencing a nonexistent
        `AccessLevel` will cause an error. If no `AccessLevel` names are listed,
        resources within the perimeter can only be accessed via Google Cloud calls
        with request origins within the perimeter.
        Example `accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.`
        If * is specified, then all IngressSources will be allowed.
        """
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter
    def resource(self) -> Optional[str]:
        """
        A Google Cloud resource that is allowed to ingress the perimeter.
        Requests from these resources will be allowed to access perimeter data.
        Currently only projects are allowed. Format `projects/{project_number}`
        The project may be in any Google Cloud organization, not just the
        organization that the perimeter is defined in. `*` is not allowed, the case
        of allowing all Google Cloud resources only is not supported.
        """
        return pulumi.get(self, "resource")


@pulumi.output_type
class ServicePerimeterSpecIngressPolicyIngressTo(dict):
    def __init__(__self__, *,
                 operations: Optional[Sequence['outputs.ServicePerimeterSpecIngressPolicyIngressToOperation']] = None,
                 resources: Optional[Sequence[str]] = None):
        """
        :param Sequence['ServicePerimeterSpecIngressPolicyIngressToOperationArgs'] operations: A list of `ApiOperations` the sources specified in corresponding `IngressFrom`
               are allowed to perform in this `ServicePerimeter`.
               Structure is documented below.
        :param Sequence[str] resources: A list of resources, currently only projects in the form
               `projects/<projectnumber>`, protected by this `ServicePerimeter`
               that are allowed to be accessed by sources defined in the
               corresponding `IngressFrom`. A request matches if it contains
               a resource in this list. If `*` is specified for resources,
               then this `IngressTo` rule will authorize access to all
               resources inside the perimeter, provided that the request
               also matches the `operations` field.
        """
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def operations(self) -> Optional[Sequence['outputs.ServicePerimeterSpecIngressPolicyIngressToOperation']]:
        """
        A list of `ApiOperations` the sources specified in corresponding `IngressFrom`
        are allowed to perform in this `ServicePerimeter`.
        Structure is documented below.
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        A list of resources, currently only projects in the form
        `projects/<projectnumber>`, protected by this `ServicePerimeter`
        that are allowed to be accessed by sources defined in the
        corresponding `IngressFrom`. A request matches if it contains
        a resource in this list. If `*` is specified for resources,
        then this `IngressTo` rule will authorize access to all
        resources inside the perimeter, provided that the request
        also matches the `operations` field.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class ServicePerimeterSpecIngressPolicyIngressToOperation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "methodSelectors":
            suggest = "method_selectors"
        elif key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterSpecIngressPolicyIngressToOperation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterSpecIngressPolicyIngressToOperation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterSpecIngressPolicyIngressToOperation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method_selectors: Optional[Sequence['outputs.ServicePerimeterSpecIngressPolicyIngressToOperationMethodSelector']] = None,
                 service_name: Optional[str] = None):
        """
        :param Sequence['ServicePerimeterSpecIngressPolicyIngressToOperationMethodSelectorArgs'] method_selectors: API methods or permissions to allow. Method or permission must belong
               to the service specified by `serviceName` field. A single MethodSelector
               entry with `*` specified for the `method` field will allow all methods
               AND permissions for the service specified in `serviceName`.
               Structure is documented below.
        :param str service_name: The name of the API whose methods or permissions the `IngressPolicy` or
               `EgressPolicy` want to allow. A single `ApiOperation` with serviceName
               field set to `*` will allow all methods AND permissions for all services.
        """
        if method_selectors is not None:
            pulumi.set(__self__, "method_selectors", method_selectors)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="methodSelectors")
    def method_selectors(self) -> Optional[Sequence['outputs.ServicePerimeterSpecIngressPolicyIngressToOperationMethodSelector']]:
        """
        API methods or permissions to allow. Method or permission must belong
        to the service specified by `serviceName` field. A single MethodSelector
        entry with `*` specified for the `method` field will allow all methods
        AND permissions for the service specified in `serviceName`.
        Structure is documented below.
        """
        return pulumi.get(self, "method_selectors")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        """
        The name of the API whose methods or permissions the `IngressPolicy` or
        `EgressPolicy` want to allow. A single `ApiOperation` with serviceName
        field set to `*` will allow all methods AND permissions for all services.
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class ServicePerimeterSpecIngressPolicyIngressToOperationMethodSelector(dict):
    def __init__(__self__, *,
                 method: Optional[str] = None,
                 permission: Optional[str] = None):
        """
        :param str method: Value for `method` should be a valid method name for the corresponding
               `serviceName` in `ApiOperation`. If `*` used as value for method,
               then ALL methods and permissions are allowed.
        :param str permission: Value for permission should be a valid Cloud IAM permission for the
               corresponding `serviceName` in `ApiOperation`.
        """
        if method is not None:
            pulumi.set(__self__, "method", method)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        Value for `method` should be a valid method name for the corresponding
        `serviceName` in `ApiOperation`. If `*` used as value for method,
        then ALL methods and permissions are allowed.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def permission(self) -> Optional[str]:
        """
        Value for permission should be a valid Cloud IAM permission for the
        corresponding `serviceName` in `ApiOperation`.
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class ServicePerimeterSpecVpcAccessibleServices(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedServices":
            suggest = "allowed_services"
        elif key == "enableRestriction":
            suggest = "enable_restriction"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterSpecVpcAccessibleServices. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterSpecVpcAccessibleServices.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterSpecVpcAccessibleServices.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_services: Optional[Sequence[str]] = None,
                 enable_restriction: Optional[bool] = None):
        """
        :param Sequence[str] allowed_services: The list of APIs usable within the Service Perimeter.
               Must be empty unless `enableRestriction` is True.
        :param bool enable_restriction: Whether to restrict API calls within the Service Perimeter to the
               list of APIs specified in 'allowedServices'.
        """
        if allowed_services is not None:
            pulumi.set(__self__, "allowed_services", allowed_services)
        if enable_restriction is not None:
            pulumi.set(__self__, "enable_restriction", enable_restriction)

    @property
    @pulumi.getter(name="allowedServices")
    def allowed_services(self) -> Optional[Sequence[str]]:
        """
        The list of APIs usable within the Service Perimeter.
        Must be empty unless `enableRestriction` is True.
        """
        return pulumi.get(self, "allowed_services")

    @property
    @pulumi.getter(name="enableRestriction")
    def enable_restriction(self) -> Optional[bool]:
        """
        Whether to restrict API calls within the Service Perimeter to the
        list of APIs specified in 'allowedServices'.
        """
        return pulumi.get(self, "enable_restriction")


@pulumi.output_type
class ServicePerimeterStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessLevels":
            suggest = "access_levels"
        elif key == "egressPolicies":
            suggest = "egress_policies"
        elif key == "ingressPolicies":
            suggest = "ingress_policies"
        elif key == "restrictedServices":
            suggest = "restricted_services"
        elif key == "vpcAccessibleServices":
            suggest = "vpc_accessible_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_levels: Optional[Sequence[str]] = None,
                 egress_policies: Optional[Sequence['outputs.ServicePerimeterStatusEgressPolicy']] = None,
                 ingress_policies: Optional[Sequence['outputs.ServicePerimeterStatusIngressPolicy']] = None,
                 resources: Optional[Sequence[str]] = None,
                 restricted_services: Optional[Sequence[str]] = None,
                 vpc_accessible_services: Optional['outputs.ServicePerimeterStatusVpcAccessibleServices'] = None):
        """
        :param Sequence[str] access_levels: A list of AccessLevel resource names that allow resources within
               the ServicePerimeter to be accessed from the internet.
               AccessLevels listed must be in the same policy as this
               ServicePerimeter. Referencing a nonexistent AccessLevel is a
               syntax error. If no AccessLevel names are listed, resources within
               the perimeter can only be accessed via GCP calls with request
               origins within the perimeter. For Service Perimeter Bridge, must
               be empty.
               Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        :param Sequence['ServicePerimeterStatusEgressPolicyArgs'] egress_policies: List of EgressPolicies to apply to the perimeter. A perimeter may
               have multiple EgressPolicies, each of which is evaluated separately.
               Access is granted if any EgressPolicy grants it. Must be empty for
               a perimeter bridge.
               Structure is documented below.
        :param Sequence['ServicePerimeterStatusIngressPolicyArgs'] ingress_policies: List of `IngressPolicies` to apply to the perimeter. A perimeter may
               have multiple `IngressPolicies`, each of which is evaluated
               separately. Access is granted if any `Ingress Policy` grants it.
               Must be empty for a perimeter bridge.
               Structure is documented below.
        :param Sequence[str] resources: A list of GCP resources that are inside of the service perimeter.
               Currently only projects are allowed.
               Format: projects/{project_number}
        :param Sequence[str] restricted_services: GCP services that are subject to the Service Perimeter
               restrictions. Must contain a list of services. For example, if
               `storage.googleapis.com` is specified, access to the storage
               buckets inside the perimeter must meet the perimeter's access
               restrictions.
        :param 'ServicePerimeterStatusVpcAccessibleServicesArgs' vpc_accessible_services: Specifies how APIs are allowed to communicate within the Service
               Perimeter.
               Structure is documented below.
        """
        if access_levels is not None:
            pulumi.set(__self__, "access_levels", access_levels)
        if egress_policies is not None:
            pulumi.set(__self__, "egress_policies", egress_policies)
        if ingress_policies is not None:
            pulumi.set(__self__, "ingress_policies", ingress_policies)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if restricted_services is not None:
            pulumi.set(__self__, "restricted_services", restricted_services)
        if vpc_accessible_services is not None:
            pulumi.set(__self__, "vpc_accessible_services", vpc_accessible_services)

    @property
    @pulumi.getter(name="accessLevels")
    def access_levels(self) -> Optional[Sequence[str]]:
        """
        A list of AccessLevel resource names that allow resources within
        the ServicePerimeter to be accessed from the internet.
        AccessLevels listed must be in the same policy as this
        ServicePerimeter. Referencing a nonexistent AccessLevel is a
        syntax error. If no AccessLevel names are listed, resources within
        the perimeter can only be accessed via GCP calls with request
        origins within the perimeter. For Service Perimeter Bridge, must
        be empty.
        Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        """
        return pulumi.get(self, "access_levels")

    @property
    @pulumi.getter(name="egressPolicies")
    def egress_policies(self) -> Optional[Sequence['outputs.ServicePerimeterStatusEgressPolicy']]:
        """
        List of EgressPolicies to apply to the perimeter. A perimeter may
        have multiple EgressPolicies, each of which is evaluated separately.
        Access is granted if any EgressPolicy grants it. Must be empty for
        a perimeter bridge.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_policies")

    @property
    @pulumi.getter(name="ingressPolicies")
    def ingress_policies(self) -> Optional[Sequence['outputs.ServicePerimeterStatusIngressPolicy']]:
        """
        List of `IngressPolicies` to apply to the perimeter. A perimeter may
        have multiple `IngressPolicies`, each of which is evaluated
        separately. Access is granted if any `Ingress Policy` grants it.
        Must be empty for a perimeter bridge.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_policies")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        A list of GCP resources that are inside of the service perimeter.
        Currently only projects are allowed.
        Format: projects/{project_number}
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="restrictedServices")
    def restricted_services(self) -> Optional[Sequence[str]]:
        """
        GCP services that are subject to the Service Perimeter
        restrictions. Must contain a list of services. For example, if
        `storage.googleapis.com` is specified, access to the storage
        buckets inside the perimeter must meet the perimeter's access
        restrictions.
        """
        return pulumi.get(self, "restricted_services")

    @property
    @pulumi.getter(name="vpcAccessibleServices")
    def vpc_accessible_services(self) -> Optional['outputs.ServicePerimeterStatusVpcAccessibleServices']:
        """
        Specifies how APIs are allowed to communicate within the Service
        Perimeter.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_accessible_services")


@pulumi.output_type
class ServicePerimeterStatusEgressPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "egressFrom":
            suggest = "egress_from"
        elif key == "egressTo":
            suggest = "egress_to"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterStatusEgressPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterStatusEgressPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterStatusEgressPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 egress_from: Optional['outputs.ServicePerimeterStatusEgressPolicyEgressFrom'] = None,
                 egress_to: Optional['outputs.ServicePerimeterStatusEgressPolicyEgressTo'] = None):
        """
        :param 'ServicePerimeterStatusEgressPolicyEgressFromArgs' egress_from: Defines conditions on the source of a request causing this `EgressPolicy` to apply.
               Structure is documented below.
        :param 'ServicePerimeterStatusEgressPolicyEgressToArgs' egress_to: Defines the conditions on the `ApiOperation` and destination resources that
               cause this `EgressPolicy` to apply.
               Structure is documented below.
        """
        if egress_from is not None:
            pulumi.set(__self__, "egress_from", egress_from)
        if egress_to is not None:
            pulumi.set(__self__, "egress_to", egress_to)

    @property
    @pulumi.getter(name="egressFrom")
    def egress_from(self) -> Optional['outputs.ServicePerimeterStatusEgressPolicyEgressFrom']:
        """
        Defines conditions on the source of a request causing this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_from")

    @property
    @pulumi.getter(name="egressTo")
    def egress_to(self) -> Optional['outputs.ServicePerimeterStatusEgressPolicyEgressTo']:
        """
        Defines the conditions on the `ApiOperation` and destination resources that
        cause this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_to")


@pulumi.output_type
class ServicePerimeterStatusEgressPolicyEgressFrom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityType":
            suggest = "identity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterStatusEgressPolicyEgressFrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterStatusEgressPolicyEgressFrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterStatusEgressPolicyEgressFrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identities: Optional[Sequence[str]] = None,
                 identity_type: Optional[str] = None):
        """
        :param Sequence[str] identities: A list of identities that are allowed access through this `EgressPolicy`.
               Should be in the format of email address. The email address should
               represent individual user or service account only.
        :param str identity_type: Specifies the type of identities that are allowed access to outside the
               perimeter. If left unspecified, then members of `identities` field will
               be allowed access.
               Possible values are `IDENTITY_TYPE_UNSPECIFIED`, `ANY_IDENTITY`, `ANY_USER_ACCOUNT`, and `ANY_SERVICE_ACCOUNT`.
        """
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if identity_type is not None:
            pulumi.set(__self__, "identity_type", identity_type)

    @property
    @pulumi.getter
    def identities(self) -> Optional[Sequence[str]]:
        """
        A list of identities that are allowed access through this `EgressPolicy`.
        Should be in the format of email address. The email address should
        represent individual user or service account only.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> Optional[str]:
        """
        Specifies the type of identities that are allowed access to outside the
        perimeter. If left unspecified, then members of `identities` field will
        be allowed access.
        Possible values are `IDENTITY_TYPE_UNSPECIFIED`, `ANY_IDENTITY`, `ANY_USER_ACCOUNT`, and `ANY_SERVICE_ACCOUNT`.
        """
        return pulumi.get(self, "identity_type")


@pulumi.output_type
class ServicePerimeterStatusEgressPolicyEgressTo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalResources":
            suggest = "external_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterStatusEgressPolicyEgressTo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterStatusEgressPolicyEgressTo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterStatusEgressPolicyEgressTo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_resources: Optional[Sequence[str]] = None,
                 operations: Optional[Sequence['outputs.ServicePerimeterStatusEgressPolicyEgressToOperation']] = None,
                 resources: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] external_resources: A list of external resources that are allowed to be accessed. A request
               matches if it contains an external resource in this list (Example:
               s3://bucket/path). Currently '*' is not allowed.
        :param Sequence['ServicePerimeterStatusEgressPolicyEgressToOperationArgs'] operations: A list of `ApiOperations` that this egress rule applies to. A request matches
               if it contains an operation/service in this list.
               Structure is documented below.
        :param Sequence[str] resources: A list of resources, currently only projects in the form
               `projects/<projectnumber>`, that match this to stanza. A request matches
               if it contains a resource in this list. If * is specified for resources,
               then this `EgressTo` rule will authorize access to all resources outside
               the perimeter.
        """
        if external_resources is not None:
            pulumi.set(__self__, "external_resources", external_resources)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter(name="externalResources")
    def external_resources(self) -> Optional[Sequence[str]]:
        """
        A list of external resources that are allowed to be accessed. A request
        matches if it contains an external resource in this list (Example:
        s3://bucket/path). Currently '*' is not allowed.
        """
        return pulumi.get(self, "external_resources")

    @property
    @pulumi.getter
    def operations(self) -> Optional[Sequence['outputs.ServicePerimeterStatusEgressPolicyEgressToOperation']]:
        """
        A list of `ApiOperations` that this egress rule applies to. A request matches
        if it contains an operation/service in this list.
        Structure is documented below.
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        A list of resources, currently only projects in the form
        `projects/<projectnumber>`, that match this to stanza. A request matches
        if it contains a resource in this list. If * is specified for resources,
        then this `EgressTo` rule will authorize access to all resources outside
        the perimeter.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class ServicePerimeterStatusEgressPolicyEgressToOperation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "methodSelectors":
            suggest = "method_selectors"
        elif key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterStatusEgressPolicyEgressToOperation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterStatusEgressPolicyEgressToOperation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterStatusEgressPolicyEgressToOperation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method_selectors: Optional[Sequence['outputs.ServicePerimeterStatusEgressPolicyEgressToOperationMethodSelector']] = None,
                 service_name: Optional[str] = None):
        """
        :param Sequence['ServicePerimeterStatusEgressPolicyEgressToOperationMethodSelectorArgs'] method_selectors: API methods or permissions to allow. Method or permission must belong
               to the service specified by `serviceName` field. A single MethodSelector
               entry with `*` specified for the `method` field will allow all methods
               AND permissions for the service specified in `serviceName`.
               Structure is documented below.
        :param str service_name: The name of the API whose methods or permissions the `IngressPolicy` or
               `EgressPolicy` want to allow. A single `ApiOperation` with serviceName
               field set to `*` will allow all methods AND permissions for all services.
        """
        if method_selectors is not None:
            pulumi.set(__self__, "method_selectors", method_selectors)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="methodSelectors")
    def method_selectors(self) -> Optional[Sequence['outputs.ServicePerimeterStatusEgressPolicyEgressToOperationMethodSelector']]:
        """
        API methods or permissions to allow. Method or permission must belong
        to the service specified by `serviceName` field. A single MethodSelector
        entry with `*` specified for the `method` field will allow all methods
        AND permissions for the service specified in `serviceName`.
        Structure is documented below.
        """
        return pulumi.get(self, "method_selectors")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        """
        The name of the API whose methods or permissions the `IngressPolicy` or
        `EgressPolicy` want to allow. A single `ApiOperation` with serviceName
        field set to `*` will allow all methods AND permissions for all services.
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class ServicePerimeterStatusEgressPolicyEgressToOperationMethodSelector(dict):
    def __init__(__self__, *,
                 method: Optional[str] = None,
                 permission: Optional[str] = None):
        """
        :param str method: Value for `method` should be a valid method name for the corresponding
               `serviceName` in `ApiOperation`. If `*` used as value for method,
               then ALL methods and permissions are allowed.
        :param str permission: Value for permission should be a valid Cloud IAM permission for the
               corresponding `serviceName` in `ApiOperation`.
        """
        if method is not None:
            pulumi.set(__self__, "method", method)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        Value for `method` should be a valid method name for the corresponding
        `serviceName` in `ApiOperation`. If `*` used as value for method,
        then ALL methods and permissions are allowed.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def permission(self) -> Optional[str]:
        """
        Value for permission should be a valid Cloud IAM permission for the
        corresponding `serviceName` in `ApiOperation`.
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class ServicePerimeterStatusIngressPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ingressFrom":
            suggest = "ingress_from"
        elif key == "ingressTo":
            suggest = "ingress_to"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterStatusIngressPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterStatusIngressPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterStatusIngressPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ingress_from: Optional['outputs.ServicePerimeterStatusIngressPolicyIngressFrom'] = None,
                 ingress_to: Optional['outputs.ServicePerimeterStatusIngressPolicyIngressTo'] = None):
        """
        :param 'ServicePerimeterStatusIngressPolicyIngressFromArgs' ingress_from: Defines the conditions on the source of a request causing this `IngressPolicy`
               to apply.
               Structure is documented below.
        :param 'ServicePerimeterStatusIngressPolicyIngressToArgs' ingress_to: Defines the conditions on the `ApiOperation` and request destination that cause
               this `IngressPolicy` to apply.
               Structure is documented below.
        """
        if ingress_from is not None:
            pulumi.set(__self__, "ingress_from", ingress_from)
        if ingress_to is not None:
            pulumi.set(__self__, "ingress_to", ingress_to)

    @property
    @pulumi.getter(name="ingressFrom")
    def ingress_from(self) -> Optional['outputs.ServicePerimeterStatusIngressPolicyIngressFrom']:
        """
        Defines the conditions on the source of a request causing this `IngressPolicy`
        to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_from")

    @property
    @pulumi.getter(name="ingressTo")
    def ingress_to(self) -> Optional['outputs.ServicePerimeterStatusIngressPolicyIngressTo']:
        """
        Defines the conditions on the `ApiOperation` and request destination that cause
        this `IngressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_to")


@pulumi.output_type
class ServicePerimeterStatusIngressPolicyIngressFrom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityType":
            suggest = "identity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterStatusIngressPolicyIngressFrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterStatusIngressPolicyIngressFrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterStatusIngressPolicyIngressFrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identities: Optional[Sequence[str]] = None,
                 identity_type: Optional[str] = None,
                 sources: Optional[Sequence['outputs.ServicePerimeterStatusIngressPolicyIngressFromSource']] = None):
        """
        :param Sequence[str] identities: A list of identities that are allowed access through this ingress policy.
               Should be in the format of email address. The email address should represent
               individual user or service account only.
        :param str identity_type: Specifies the type of identities that are allowed access from outside the
               perimeter. If left unspecified, then members of `identities` field will be
               allowed access.
               Possible values are `IDENTITY_TYPE_UNSPECIFIED`, `ANY_IDENTITY`, `ANY_USER_ACCOUNT`, and `ANY_SERVICE_ACCOUNT`.
        :param Sequence['ServicePerimeterStatusIngressPolicyIngressFromSourceArgs'] sources: Sources that this `IngressPolicy` authorizes access from.
               Structure is documented below.
        """
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if identity_type is not None:
            pulumi.set(__self__, "identity_type", identity_type)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def identities(self) -> Optional[Sequence[str]]:
        """
        A list of identities that are allowed access through this ingress policy.
        Should be in the format of email address. The email address should represent
        individual user or service account only.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> Optional[str]:
        """
        Specifies the type of identities that are allowed access from outside the
        perimeter. If left unspecified, then members of `identities` field will be
        allowed access.
        Possible values are `IDENTITY_TYPE_UNSPECIFIED`, `ANY_IDENTITY`, `ANY_USER_ACCOUNT`, and `ANY_SERVICE_ACCOUNT`.
        """
        return pulumi.get(self, "identity_type")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.ServicePerimeterStatusIngressPolicyIngressFromSource']]:
        """
        Sources that this `IngressPolicy` authorizes access from.
        Structure is documented below.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class ServicePerimeterStatusIngressPolicyIngressFromSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessLevel":
            suggest = "access_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterStatusIngressPolicyIngressFromSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterStatusIngressPolicyIngressFromSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterStatusIngressPolicyIngressFromSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_level: Optional[str] = None,
                 resource: Optional[str] = None):
        """
        :param str access_level: An `AccessLevel` resource name that allow resources within the
               `ServicePerimeters` to be accessed from the internet. `AccessLevels` listed
               must be in the same policy as this `ServicePerimeter`. Referencing a nonexistent
               `AccessLevel` will cause an error. If no `AccessLevel` names are listed,
               resources within the perimeter can only be accessed via Google Cloud calls
               with request origins within the perimeter.
               Example `accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.`
               If * is specified, then all IngressSources will be allowed.
        :param str resource: A Google Cloud resource that is allowed to ingress the perimeter.
               Requests from these resources will be allowed to access perimeter data.
               Currently only projects are allowed. Format `projects/{project_number}`
               The project may be in any Google Cloud organization, not just the
               organization that the perimeter is defined in. `*` is not allowed, the case
               of allowing all Google Cloud resources only is not supported.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        """
        An `AccessLevel` resource name that allow resources within the
        `ServicePerimeters` to be accessed from the internet. `AccessLevels` listed
        must be in the same policy as this `ServicePerimeter`. Referencing a nonexistent
        `AccessLevel` will cause an error. If no `AccessLevel` names are listed,
        resources within the perimeter can only be accessed via Google Cloud calls
        with request origins within the perimeter.
        Example `accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.`
        If * is specified, then all IngressSources will be allowed.
        """
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter
    def resource(self) -> Optional[str]:
        """
        A Google Cloud resource that is allowed to ingress the perimeter.
        Requests from these resources will be allowed to access perimeter data.
        Currently only projects are allowed. Format `projects/{project_number}`
        The project may be in any Google Cloud organization, not just the
        organization that the perimeter is defined in. `*` is not allowed, the case
        of allowing all Google Cloud resources only is not supported.
        """
        return pulumi.get(self, "resource")


@pulumi.output_type
class ServicePerimeterStatusIngressPolicyIngressTo(dict):
    def __init__(__self__, *,
                 operations: Optional[Sequence['outputs.ServicePerimeterStatusIngressPolicyIngressToOperation']] = None,
                 resources: Optional[Sequence[str]] = None):
        """
        :param Sequence['ServicePerimeterStatusIngressPolicyIngressToOperationArgs'] operations: A list of `ApiOperations` the sources specified in corresponding `IngressFrom`
               are allowed to perform in this `ServicePerimeter`.
               Structure is documented below.
        :param Sequence[str] resources: A list of resources, currently only projects in the form
               `projects/<projectnumber>`, protected by this `ServicePerimeter`
               that are allowed to be accessed by sources defined in the
               corresponding `IngressFrom`. A request matches if it contains
               a resource in this list. If `*` is specified for resources,
               then this `IngressTo` rule will authorize access to all
               resources inside the perimeter, provided that the request
               also matches the `operations` field.
        """
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def operations(self) -> Optional[Sequence['outputs.ServicePerimeterStatusIngressPolicyIngressToOperation']]:
        """
        A list of `ApiOperations` the sources specified in corresponding `IngressFrom`
        are allowed to perform in this `ServicePerimeter`.
        Structure is documented below.
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        A list of resources, currently only projects in the form
        `projects/<projectnumber>`, protected by this `ServicePerimeter`
        that are allowed to be accessed by sources defined in the
        corresponding `IngressFrom`. A request matches if it contains
        a resource in this list. If `*` is specified for resources,
        then this `IngressTo` rule will authorize access to all
        resources inside the perimeter, provided that the request
        also matches the `operations` field.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class ServicePerimeterStatusIngressPolicyIngressToOperation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "methodSelectors":
            suggest = "method_selectors"
        elif key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterStatusIngressPolicyIngressToOperation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterStatusIngressPolicyIngressToOperation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterStatusIngressPolicyIngressToOperation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method_selectors: Optional[Sequence['outputs.ServicePerimeterStatusIngressPolicyIngressToOperationMethodSelector']] = None,
                 service_name: Optional[str] = None):
        """
        :param Sequence['ServicePerimeterStatusIngressPolicyIngressToOperationMethodSelectorArgs'] method_selectors: API methods or permissions to allow. Method or permission must belong
               to the service specified by `serviceName` field. A single MethodSelector
               entry with `*` specified for the `method` field will allow all methods
               AND permissions for the service specified in `serviceName`.
               Structure is documented below.
        :param str service_name: The name of the API whose methods or permissions the `IngressPolicy` or
               `EgressPolicy` want to allow. A single `ApiOperation` with serviceName
               field set to `*` will allow all methods AND permissions for all services.
        """
        if method_selectors is not None:
            pulumi.set(__self__, "method_selectors", method_selectors)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="methodSelectors")
    def method_selectors(self) -> Optional[Sequence['outputs.ServicePerimeterStatusIngressPolicyIngressToOperationMethodSelector']]:
        """
        API methods or permissions to allow. Method or permission must belong
        to the service specified by `serviceName` field. A single MethodSelector
        entry with `*` specified for the `method` field will allow all methods
        AND permissions for the service specified in `serviceName`.
        Structure is documented below.
        """
        return pulumi.get(self, "method_selectors")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        """
        The name of the API whose methods or permissions the `IngressPolicy` or
        `EgressPolicy` want to allow. A single `ApiOperation` with serviceName
        field set to `*` will allow all methods AND permissions for all services.
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class ServicePerimeterStatusIngressPolicyIngressToOperationMethodSelector(dict):
    def __init__(__self__, *,
                 method: Optional[str] = None,
                 permission: Optional[str] = None):
        """
        :param str method: Value for `method` should be a valid method name for the corresponding
               `serviceName` in `ApiOperation`. If `*` used as value for method,
               then ALL methods and permissions are allowed.
        :param str permission: Value for permission should be a valid Cloud IAM permission for the
               corresponding `serviceName` in `ApiOperation`.
        """
        if method is not None:
            pulumi.set(__self__, "method", method)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        Value for `method` should be a valid method name for the corresponding
        `serviceName` in `ApiOperation`. If `*` used as value for method,
        then ALL methods and permissions are allowed.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def permission(self) -> Optional[str]:
        """
        Value for permission should be a valid Cloud IAM permission for the
        corresponding `serviceName` in `ApiOperation`.
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class ServicePerimeterStatusVpcAccessibleServices(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedServices":
            suggest = "allowed_services"
        elif key == "enableRestriction":
            suggest = "enable_restriction"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimeterStatusVpcAccessibleServices. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimeterStatusVpcAccessibleServices.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimeterStatusVpcAccessibleServices.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_services: Optional[Sequence[str]] = None,
                 enable_restriction: Optional[bool] = None):
        """
        :param Sequence[str] allowed_services: The list of APIs usable within the Service Perimeter.
               Must be empty unless `enableRestriction` is True.
        :param bool enable_restriction: Whether to restrict API calls within the Service Perimeter to the
               list of APIs specified in 'allowedServices'.
        """
        if allowed_services is not None:
            pulumi.set(__self__, "allowed_services", allowed_services)
        if enable_restriction is not None:
            pulumi.set(__self__, "enable_restriction", enable_restriction)

    @property
    @pulumi.getter(name="allowedServices")
    def allowed_services(self) -> Optional[Sequence[str]]:
        """
        The list of APIs usable within the Service Perimeter.
        Must be empty unless `enableRestriction` is True.
        """
        return pulumi.get(self, "allowed_services")

    @property
    @pulumi.getter(name="enableRestriction")
    def enable_restriction(self) -> Optional[bool]:
        """
        Whether to restrict API calls within the Service Perimeter to the
        list of APIs specified in 'allowedServices'.
        """
        return pulumi.get(self, "enable_restriction")


@pulumi.output_type
class ServicePerimetersServicePerimeter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"
        elif key == "perimeterType":
            suggest = "perimeter_type"
        elif key == "updateTime":
            suggest = "update_time"
        elif key == "useExplicitDryRunSpec":
            suggest = "use_explicit_dry_run_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 title: str,
                 create_time: Optional[str] = None,
                 description: Optional[str] = None,
                 perimeter_type: Optional[str] = None,
                 spec: Optional['outputs.ServicePerimetersServicePerimeterSpec'] = None,
                 status: Optional['outputs.ServicePerimetersServicePerimeterStatus'] = None,
                 update_time: Optional[str] = None,
                 use_explicit_dry_run_spec: Optional[bool] = None):
        """
        :param str name: Resource name for the ServicePerimeter. The short_name component must
               begin with a letter and only include alphanumeric and '_'.
               Format: accessPolicies/{policy_id}/servicePerimeters/{short_name}
        :param str title: Human readable title. Must be unique within the Policy.
        :param str create_time: Time the AccessPolicy was created in UTC.
        :param str description: Description of the ServicePerimeter and its use. Does not affect
               behavior.
        :param str perimeter_type: Specifies the type of the Perimeter. There are two types: regular and
               bridge. Regular Service Perimeter contains resources, access levels,
               and restricted services. Every resource can be in at most
               ONE regular Service Perimeter.
               In addition to being in a regular service perimeter, a resource can also
               be in zero or more perimeter bridges. A perimeter bridge only contains
               resources. Cross project operations are permitted if all effected
               resources share some perimeter (whether bridge or regular). Perimeter
               Bridge does not contain access levels or services: those are governed
               entirely by the regular perimeter that resource is in.
               Perimeter Bridges are typically useful when building more complex
               topologies with many independent perimeters that need to share some data
               with a common perimeter, but should not be able to share data among
               themselves.
               Default value is `PERIMETER_TYPE_REGULAR`.
               Possible values are `PERIMETER_TYPE_REGULAR` and `PERIMETER_TYPE_BRIDGE`.
        :param 'ServicePerimetersServicePerimeterSpecArgs' spec: Proposed (or dry run) ServicePerimeter configuration.
               This configuration allows to specify and test ServicePerimeter configuration
               without enforcing actual access restrictions. Only allowed to be set when
               the `useExplicitDryRunSpec` flag is set.
               Structure is documented below.
        :param 'ServicePerimetersServicePerimeterStatusArgs' status: ServicePerimeter configuration. Specifies sets of resources,
               restricted services and access levels that determine
               perimeter content and boundaries.
               Structure is documented below.
        :param str update_time: Time the AccessPolicy was updated in UTC.
        :param bool use_explicit_dry_run_spec: Use explicit dry run spec flag. Ordinarily, a dry-run spec implicitly exists
               for all Service Perimeters, and that spec is identical to the status for those
               Service Perimeters. When this flag is set, it inhibits the generation of the
               implicit spec, thereby allowing the user to explicitly provide a
               configuration ("spec") to use in a dry-run version of the Service Perimeter.
               This allows the user to test changes to the enforced config ("status") without
               actually enforcing them. This testing is done through analyzing the differences
               between currently enforced and suggested restrictions. useExplicitDryRunSpec must
               bet set to True if any of the fields in the spec are set to non-default values.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "title", title)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if perimeter_type is not None:
            pulumi.set(__self__, "perimeter_type", perimeter_type)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if use_explicit_dry_run_spec is not None:
            pulumi.set(__self__, "use_explicit_dry_run_spec", use_explicit_dry_run_spec)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name for the ServicePerimeter. The short_name component must
        begin with a letter and only include alphanumeric and '_'.
        Format: accessPolicies/{policy_id}/servicePerimeters/{short_name}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Human readable title. Must be unique within the Policy.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[str]:
        """
        Time the AccessPolicy was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the ServicePerimeter and its use. Does not affect
        behavior.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="perimeterType")
    def perimeter_type(self) -> Optional[str]:
        """
        Specifies the type of the Perimeter. There are two types: regular and
        bridge. Regular Service Perimeter contains resources, access levels,
        and restricted services. Every resource can be in at most
        ONE regular Service Perimeter.
        In addition to being in a regular service perimeter, a resource can also
        be in zero or more perimeter bridges. A perimeter bridge only contains
        resources. Cross project operations are permitted if all effected
        resources share some perimeter (whether bridge or regular). Perimeter
        Bridge does not contain access levels or services: those are governed
        entirely by the regular perimeter that resource is in.
        Perimeter Bridges are typically useful when building more complex
        topologies with many independent perimeters that need to share some data
        with a common perimeter, but should not be able to share data among
        themselves.
        Default value is `PERIMETER_TYPE_REGULAR`.
        Possible values are `PERIMETER_TYPE_REGULAR` and `PERIMETER_TYPE_BRIDGE`.
        """
        return pulumi.get(self, "perimeter_type")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.ServicePerimetersServicePerimeterSpec']:
        """
        Proposed (or dry run) ServicePerimeter configuration.
        This configuration allows to specify and test ServicePerimeter configuration
        without enforcing actual access restrictions. Only allowed to be set when
        the `useExplicitDryRunSpec` flag is set.
        Structure is documented below.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.ServicePerimetersServicePerimeterStatus']:
        """
        ServicePerimeter configuration. Specifies sets of resources,
        restricted services and access levels that determine
        perimeter content and boundaries.
        Structure is documented below.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[str]:
        """
        Time the AccessPolicy was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="useExplicitDryRunSpec")
    def use_explicit_dry_run_spec(self) -> Optional[bool]:
        """
        Use explicit dry run spec flag. Ordinarily, a dry-run spec implicitly exists
        for all Service Perimeters, and that spec is identical to the status for those
        Service Perimeters. When this flag is set, it inhibits the generation of the
        implicit spec, thereby allowing the user to explicitly provide a
        configuration ("spec") to use in a dry-run version of the Service Perimeter.
        This allows the user to test changes to the enforced config ("status") without
        actually enforcing them. This testing is done through analyzing the differences
        between currently enforced and suggested restrictions. useExplicitDryRunSpec must
        bet set to True if any of the fields in the spec are set to non-default values.
        """
        return pulumi.get(self, "use_explicit_dry_run_spec")


@pulumi.output_type
class ServicePerimetersServicePerimeterSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessLevels":
            suggest = "access_levels"
        elif key == "egressPolicies":
            suggest = "egress_policies"
        elif key == "ingressPolicies":
            suggest = "ingress_policies"
        elif key == "restrictedServices":
            suggest = "restricted_services"
        elif key == "vpcAccessibleServices":
            suggest = "vpc_accessible_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_levels: Optional[Sequence[str]] = None,
                 egress_policies: Optional[Sequence['outputs.ServicePerimetersServicePerimeterSpecEgressPolicy']] = None,
                 ingress_policies: Optional[Sequence['outputs.ServicePerimetersServicePerimeterSpecIngressPolicy']] = None,
                 resources: Optional[Sequence[str]] = None,
                 restricted_services: Optional[Sequence[str]] = None,
                 vpc_accessible_services: Optional['outputs.ServicePerimetersServicePerimeterSpecVpcAccessibleServices'] = None):
        """
        :param Sequence[str] access_levels: A list of AccessLevel resource names that allow resources within
               the ServicePerimeter to be accessed from the internet.
               AccessLevels listed must be in the same policy as this
               ServicePerimeter. Referencing a nonexistent AccessLevel is a
               syntax error. If no AccessLevel names are listed, resources within
               the perimeter can only be accessed via GCP calls with request
               origins within the perimeter. For Service Perimeter Bridge, must
               be empty.
               Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        :param Sequence['ServicePerimetersServicePerimeterSpecEgressPolicyArgs'] egress_policies: List of EgressPolicies to apply to the perimeter. A perimeter may
               have multiple EgressPolicies, each of which is evaluated separately.
               Access is granted if any EgressPolicy grants it. Must be empty for
               a perimeter bridge.
               Structure is documented below.
        :param Sequence['ServicePerimetersServicePerimeterSpecIngressPolicyArgs'] ingress_policies: List of `IngressPolicies` to apply to the perimeter. A perimeter may
               have multiple `IngressPolicies`, each of which is evaluated
               separately. Access is granted if any `Ingress Policy` grants it.
               Must be empty for a perimeter bridge.
               Structure is documented below.
        :param Sequence[str] resources: A list of GCP resources that are inside of the service perimeter.
               Currently only projects are allowed.
               Format: projects/{project_number}
        :param Sequence[str] restricted_services: GCP services that are subject to the Service Perimeter
               restrictions. Must contain a list of services. For example, if
               `storage.googleapis.com` is specified, access to the storage
               buckets inside the perimeter must meet the perimeter's access
               restrictions.
        :param 'ServicePerimetersServicePerimeterSpecVpcAccessibleServicesArgs' vpc_accessible_services: Specifies how APIs are allowed to communicate within the Service
               Perimeter.
               Structure is documented below.
        """
        if access_levels is not None:
            pulumi.set(__self__, "access_levels", access_levels)
        if egress_policies is not None:
            pulumi.set(__self__, "egress_policies", egress_policies)
        if ingress_policies is not None:
            pulumi.set(__self__, "ingress_policies", ingress_policies)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if restricted_services is not None:
            pulumi.set(__self__, "restricted_services", restricted_services)
        if vpc_accessible_services is not None:
            pulumi.set(__self__, "vpc_accessible_services", vpc_accessible_services)

    @property
    @pulumi.getter(name="accessLevels")
    def access_levels(self) -> Optional[Sequence[str]]:
        """
        A list of AccessLevel resource names that allow resources within
        the ServicePerimeter to be accessed from the internet.
        AccessLevels listed must be in the same policy as this
        ServicePerimeter. Referencing a nonexistent AccessLevel is a
        syntax error. If no AccessLevel names are listed, resources within
        the perimeter can only be accessed via GCP calls with request
        origins within the perimeter. For Service Perimeter Bridge, must
        be empty.
        Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        """
        return pulumi.get(self, "access_levels")

    @property
    @pulumi.getter(name="egressPolicies")
    def egress_policies(self) -> Optional[Sequence['outputs.ServicePerimetersServicePerimeterSpecEgressPolicy']]:
        """
        List of EgressPolicies to apply to the perimeter. A perimeter may
        have multiple EgressPolicies, each of which is evaluated separately.
        Access is granted if any EgressPolicy grants it. Must be empty for
        a perimeter bridge.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_policies")

    @property
    @pulumi.getter(name="ingressPolicies")
    def ingress_policies(self) -> Optional[Sequence['outputs.ServicePerimetersServicePerimeterSpecIngressPolicy']]:
        """
        List of `IngressPolicies` to apply to the perimeter. A perimeter may
        have multiple `IngressPolicies`, each of which is evaluated
        separately. Access is granted if any `Ingress Policy` grants it.
        Must be empty for a perimeter bridge.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_policies")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        A list of GCP resources that are inside of the service perimeter.
        Currently only projects are allowed.
        Format: projects/{project_number}
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="restrictedServices")
    def restricted_services(self) -> Optional[Sequence[str]]:
        """
        GCP services that are subject to the Service Perimeter
        restrictions. Must contain a list of services. For example, if
        `storage.googleapis.com` is specified, access to the storage
        buckets inside the perimeter must meet the perimeter's access
        restrictions.
        """
        return pulumi.get(self, "restricted_services")

    @property
    @pulumi.getter(name="vpcAccessibleServices")
    def vpc_accessible_services(self) -> Optional['outputs.ServicePerimetersServicePerimeterSpecVpcAccessibleServices']:
        """
        Specifies how APIs are allowed to communicate within the Service
        Perimeter.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_accessible_services")


@pulumi.output_type
class ServicePerimetersServicePerimeterSpecEgressPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "egressFrom":
            suggest = "egress_from"
        elif key == "egressTo":
            suggest = "egress_to"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterSpecEgressPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterSpecEgressPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterSpecEgressPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 egress_from: Optional['outputs.ServicePerimetersServicePerimeterSpecEgressPolicyEgressFrom'] = None,
                 egress_to: Optional['outputs.ServicePerimetersServicePerimeterSpecEgressPolicyEgressTo'] = None):
        """
        :param 'ServicePerimetersServicePerimeterSpecEgressPolicyEgressFromArgs' egress_from: Defines conditions on the source of a request causing this `EgressPolicy` to apply.
               Structure is documented below.
        :param 'ServicePerimetersServicePerimeterSpecEgressPolicyEgressToArgs' egress_to: Defines the conditions on the `ApiOperation` and destination resources that
               cause this `EgressPolicy` to apply.
               Structure is documented below.
        """
        if egress_from is not None:
            pulumi.set(__self__, "egress_from", egress_from)
        if egress_to is not None:
            pulumi.set(__self__, "egress_to", egress_to)

    @property
    @pulumi.getter(name="egressFrom")
    def egress_from(self) -> Optional['outputs.ServicePerimetersServicePerimeterSpecEgressPolicyEgressFrom']:
        """
        Defines conditions on the source of a request causing this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_from")

    @property
    @pulumi.getter(name="egressTo")
    def egress_to(self) -> Optional['outputs.ServicePerimetersServicePerimeterSpecEgressPolicyEgressTo']:
        """
        Defines the conditions on the `ApiOperation` and destination resources that
        cause this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_to")


@pulumi.output_type
class ServicePerimetersServicePerimeterSpecEgressPolicyEgressFrom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityType":
            suggest = "identity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterSpecEgressPolicyEgressFrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterSpecEgressPolicyEgressFrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterSpecEgressPolicyEgressFrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identities: Optional[Sequence[str]] = None,
                 identity_type: Optional[str] = None):
        """
        :param Sequence[str] identities: A list of identities that are allowed access through this `EgressPolicy`.
               Should be in the format of email address. The email address should
               represent individual user or service account only.
        :param str identity_type: Specifies the type of identities that are allowed access to outside the
               perimeter. If left unspecified, then members of `identities` field will
               be allowed access.
               Possible values are `IDENTITY_TYPE_UNSPECIFIED`, `ANY_IDENTITY`, `ANY_USER_ACCOUNT`, and `ANY_SERVICE_ACCOUNT`.
        """
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if identity_type is not None:
            pulumi.set(__self__, "identity_type", identity_type)

    @property
    @pulumi.getter
    def identities(self) -> Optional[Sequence[str]]:
        """
        A list of identities that are allowed access through this `EgressPolicy`.
        Should be in the format of email address. The email address should
        represent individual user or service account only.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> Optional[str]:
        """
        Specifies the type of identities that are allowed access to outside the
        perimeter. If left unspecified, then members of `identities` field will
        be allowed access.
        Possible values are `IDENTITY_TYPE_UNSPECIFIED`, `ANY_IDENTITY`, `ANY_USER_ACCOUNT`, and `ANY_SERVICE_ACCOUNT`.
        """
        return pulumi.get(self, "identity_type")


@pulumi.output_type
class ServicePerimetersServicePerimeterSpecEgressPolicyEgressTo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalResources":
            suggest = "external_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterSpecEgressPolicyEgressTo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterSpecEgressPolicyEgressTo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterSpecEgressPolicyEgressTo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_resources: Optional[Sequence[str]] = None,
                 operations: Optional[Sequence['outputs.ServicePerimetersServicePerimeterSpecEgressPolicyEgressToOperation']] = None,
                 resources: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] external_resources: A list of external resources that are allowed to be accessed. A request
               matches if it contains an external resource in this list (Example:
               s3://bucket/path). Currently '*' is not allowed.
        :param Sequence['ServicePerimetersServicePerimeterSpecEgressPolicyEgressToOperationArgs'] operations: A list of `ApiOperations` that this egress rule applies to. A request matches
               if it contains an operation/service in this list.
               Structure is documented below.
        :param Sequence[str] resources: A list of resources, currently only projects in the form
               `projects/<projectnumber>`, that match this to stanza. A request matches
               if it contains a resource in this list. If * is specified for resources,
               then this `EgressTo` rule will authorize access to all resources outside
               the perimeter.
        """
        if external_resources is not None:
            pulumi.set(__self__, "external_resources", external_resources)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter(name="externalResources")
    def external_resources(self) -> Optional[Sequence[str]]:
        """
        A list of external resources that are allowed to be accessed. A request
        matches if it contains an external resource in this list (Example:
        s3://bucket/path). Currently '*' is not allowed.
        """
        return pulumi.get(self, "external_resources")

    @property
    @pulumi.getter
    def operations(self) -> Optional[Sequence['outputs.ServicePerimetersServicePerimeterSpecEgressPolicyEgressToOperation']]:
        """
        A list of `ApiOperations` that this egress rule applies to. A request matches
        if it contains an operation/service in this list.
        Structure is documented below.
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        A list of resources, currently only projects in the form
        `projects/<projectnumber>`, that match this to stanza. A request matches
        if it contains a resource in this list. If * is specified for resources,
        then this `EgressTo` rule will authorize access to all resources outside
        the perimeter.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class ServicePerimetersServicePerimeterSpecEgressPolicyEgressToOperation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "methodSelectors":
            suggest = "method_selectors"
        elif key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterSpecEgressPolicyEgressToOperation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterSpecEgressPolicyEgressToOperation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterSpecEgressPolicyEgressToOperation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method_selectors: Optional[Sequence['outputs.ServicePerimetersServicePerimeterSpecEgressPolicyEgressToOperationMethodSelector']] = None,
                 service_name: Optional[str] = None):
        """
        :param Sequence['ServicePerimetersServicePerimeterSpecEgressPolicyEgressToOperationMethodSelectorArgs'] method_selectors: API methods or permissions to allow. Method or permission must belong
               to the service specified by `serviceName` field. A single MethodSelector
               entry with `*` specified for the `method` field will allow all methods
               AND permissions for the service specified in `serviceName`.
               Structure is documented below.
        :param str service_name: The name of the API whose methods or permissions the `IngressPolicy` or
               `EgressPolicy` want to allow. A single `ApiOperation` with serviceName
               field set to `*` will allow all methods AND permissions for all services.
        """
        if method_selectors is not None:
            pulumi.set(__self__, "method_selectors", method_selectors)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="methodSelectors")
    def method_selectors(self) -> Optional[Sequence['outputs.ServicePerimetersServicePerimeterSpecEgressPolicyEgressToOperationMethodSelector']]:
        """
        API methods or permissions to allow. Method or permission must belong
        to the service specified by `serviceName` field. A single MethodSelector
        entry with `*` specified for the `method` field will allow all methods
        AND permissions for the service specified in `serviceName`.
        Structure is documented below.
        """
        return pulumi.get(self, "method_selectors")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        """
        The name of the API whose methods or permissions the `IngressPolicy` or
        `EgressPolicy` want to allow. A single `ApiOperation` with serviceName
        field set to `*` will allow all methods AND permissions for all services.
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class ServicePerimetersServicePerimeterSpecEgressPolicyEgressToOperationMethodSelector(dict):
    def __init__(__self__, *,
                 method: Optional[str] = None,
                 permission: Optional[str] = None):
        """
        :param str method: Value for `method` should be a valid method name for the corresponding
               `serviceName` in `ApiOperation`. If `*` used as value for method,
               then ALL methods and permissions are allowed.
        :param str permission: Value for permission should be a valid Cloud IAM permission for the
               corresponding `serviceName` in `ApiOperation`.
        """
        if method is not None:
            pulumi.set(__self__, "method", method)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        Value for `method` should be a valid method name for the corresponding
        `serviceName` in `ApiOperation`. If `*` used as value for method,
        then ALL methods and permissions are allowed.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def permission(self) -> Optional[str]:
        """
        Value for permission should be a valid Cloud IAM permission for the
        corresponding `serviceName` in `ApiOperation`.
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class ServicePerimetersServicePerimeterSpecIngressPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ingressFrom":
            suggest = "ingress_from"
        elif key == "ingressTo":
            suggest = "ingress_to"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterSpecIngressPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterSpecIngressPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterSpecIngressPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ingress_from: Optional['outputs.ServicePerimetersServicePerimeterSpecIngressPolicyIngressFrom'] = None,
                 ingress_to: Optional['outputs.ServicePerimetersServicePerimeterSpecIngressPolicyIngressTo'] = None):
        """
        :param 'ServicePerimetersServicePerimeterSpecIngressPolicyIngressFromArgs' ingress_from: Defines the conditions on the source of a request causing this `IngressPolicy`
               to apply.
               Structure is documented below.
        :param 'ServicePerimetersServicePerimeterSpecIngressPolicyIngressToArgs' ingress_to: Defines the conditions on the `ApiOperation` and request destination that cause
               this `IngressPolicy` to apply.
               Structure is documented below.
        """
        if ingress_from is not None:
            pulumi.set(__self__, "ingress_from", ingress_from)
        if ingress_to is not None:
            pulumi.set(__self__, "ingress_to", ingress_to)

    @property
    @pulumi.getter(name="ingressFrom")
    def ingress_from(self) -> Optional['outputs.ServicePerimetersServicePerimeterSpecIngressPolicyIngressFrom']:
        """
        Defines the conditions on the source of a request causing this `IngressPolicy`
        to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_from")

    @property
    @pulumi.getter(name="ingressTo")
    def ingress_to(self) -> Optional['outputs.ServicePerimetersServicePerimeterSpecIngressPolicyIngressTo']:
        """
        Defines the conditions on the `ApiOperation` and request destination that cause
        this `IngressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_to")


@pulumi.output_type
class ServicePerimetersServicePerimeterSpecIngressPolicyIngressFrom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityType":
            suggest = "identity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterSpecIngressPolicyIngressFrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterSpecIngressPolicyIngressFrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterSpecIngressPolicyIngressFrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identities: Optional[Sequence[str]] = None,
                 identity_type: Optional[str] = None,
                 sources: Optional[Sequence['outputs.ServicePerimetersServicePerimeterSpecIngressPolicyIngressFromSource']] = None):
        """
        :param Sequence[str] identities: A list of identities that are allowed access through this ingress policy.
               Should be in the format of email address. The email address should represent
               individual user or service account only.
        :param str identity_type: Specifies the type of identities that are allowed access from outside the
               perimeter. If left unspecified, then members of `identities` field will be
               allowed access.
               Possible values are `IDENTITY_TYPE_UNSPECIFIED`, `ANY_IDENTITY`, `ANY_USER_ACCOUNT`, and `ANY_SERVICE_ACCOUNT`.
        :param Sequence['ServicePerimetersServicePerimeterSpecIngressPolicyIngressFromSourceArgs'] sources: Sources that this `IngressPolicy` authorizes access from.
               Structure is documented below.
        """
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if identity_type is not None:
            pulumi.set(__self__, "identity_type", identity_type)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def identities(self) -> Optional[Sequence[str]]:
        """
        A list of identities that are allowed access through this ingress policy.
        Should be in the format of email address. The email address should represent
        individual user or service account only.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> Optional[str]:
        """
        Specifies the type of identities that are allowed access from outside the
        perimeter. If left unspecified, then members of `identities` field will be
        allowed access.
        Possible values are `IDENTITY_TYPE_UNSPECIFIED`, `ANY_IDENTITY`, `ANY_USER_ACCOUNT`, and `ANY_SERVICE_ACCOUNT`.
        """
        return pulumi.get(self, "identity_type")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.ServicePerimetersServicePerimeterSpecIngressPolicyIngressFromSource']]:
        """
        Sources that this `IngressPolicy` authorizes access from.
        Structure is documented below.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class ServicePerimetersServicePerimeterSpecIngressPolicyIngressFromSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessLevel":
            suggest = "access_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterSpecIngressPolicyIngressFromSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterSpecIngressPolicyIngressFromSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterSpecIngressPolicyIngressFromSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_level: Optional[str] = None,
                 resource: Optional[str] = None):
        """
        :param str access_level: An `AccessLevel` resource name that allow resources within the
               `ServicePerimeters` to be accessed from the internet. `AccessLevels` listed
               must be in the same policy as this `ServicePerimeter`. Referencing a nonexistent
               `AccessLevel` will cause an error. If no `AccessLevel` names are listed,
               resources within the perimeter can only be accessed via Google Cloud calls
               with request origins within the perimeter.
               Example `accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.`
               If * is specified, then all IngressSources will be allowed.
        :param str resource: A Google Cloud resource that is allowed to ingress the perimeter.
               Requests from these resources will be allowed to access perimeter data.
               Currently only projects are allowed. Format `projects/{project_number}`
               The project may be in any Google Cloud organization, not just the
               organization that the perimeter is defined in. `*` is not allowed, the case
               of allowing all Google Cloud resources only is not supported.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        """
        An `AccessLevel` resource name that allow resources within the
        `ServicePerimeters` to be accessed from the internet. `AccessLevels` listed
        must be in the same policy as this `ServicePerimeter`. Referencing a nonexistent
        `AccessLevel` will cause an error. If no `AccessLevel` names are listed,
        resources within the perimeter can only be accessed via Google Cloud calls
        with request origins within the perimeter.
        Example `accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.`
        If * is specified, then all IngressSources will be allowed.
        """
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter
    def resource(self) -> Optional[str]:
        """
        A Google Cloud resource that is allowed to ingress the perimeter.
        Requests from these resources will be allowed to access perimeter data.
        Currently only projects are allowed. Format `projects/{project_number}`
        The project may be in any Google Cloud organization, not just the
        organization that the perimeter is defined in. `*` is not allowed, the case
        of allowing all Google Cloud resources only is not supported.
        """
        return pulumi.get(self, "resource")


@pulumi.output_type
class ServicePerimetersServicePerimeterSpecIngressPolicyIngressTo(dict):
    def __init__(__self__, *,
                 operations: Optional[Sequence['outputs.ServicePerimetersServicePerimeterSpecIngressPolicyIngressToOperation']] = None,
                 resources: Optional[Sequence[str]] = None):
        """
        :param Sequence['ServicePerimetersServicePerimeterSpecIngressPolicyIngressToOperationArgs'] operations: A list of `ApiOperations` the sources specified in corresponding `IngressFrom`
               are allowed to perform in this `ServicePerimeter`.
               Structure is documented below.
        :param Sequence[str] resources: A list of resources, currently only projects in the form
               `projects/<projectnumber>`, protected by this `ServicePerimeter`
               that are allowed to be accessed by sources defined in the
               corresponding `IngressFrom`. A request matches if it contains
               a resource in this list. If `*` is specified for resources,
               then this `IngressTo` rule will authorize access to all
               resources inside the perimeter, provided that the request
               also matches the `operations` field.
        """
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def operations(self) -> Optional[Sequence['outputs.ServicePerimetersServicePerimeterSpecIngressPolicyIngressToOperation']]:
        """
        A list of `ApiOperations` the sources specified in corresponding `IngressFrom`
        are allowed to perform in this `ServicePerimeter`.
        Structure is documented below.
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        A list of resources, currently only projects in the form
        `projects/<projectnumber>`, protected by this `ServicePerimeter`
        that are allowed to be accessed by sources defined in the
        corresponding `IngressFrom`. A request matches if it contains
        a resource in this list. If `*` is specified for resources,
        then this `IngressTo` rule will authorize access to all
        resources inside the perimeter, provided that the request
        also matches the `operations` field.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class ServicePerimetersServicePerimeterSpecIngressPolicyIngressToOperation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "methodSelectors":
            suggest = "method_selectors"
        elif key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterSpecIngressPolicyIngressToOperation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterSpecIngressPolicyIngressToOperation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterSpecIngressPolicyIngressToOperation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method_selectors: Optional[Sequence['outputs.ServicePerimetersServicePerimeterSpecIngressPolicyIngressToOperationMethodSelector']] = None,
                 service_name: Optional[str] = None):
        """
        :param Sequence['ServicePerimetersServicePerimeterSpecIngressPolicyIngressToOperationMethodSelectorArgs'] method_selectors: API methods or permissions to allow. Method or permission must belong
               to the service specified by `serviceName` field. A single MethodSelector
               entry with `*` specified for the `method` field will allow all methods
               AND permissions for the service specified in `serviceName`.
               Structure is documented below.
        :param str service_name: The name of the API whose methods or permissions the `IngressPolicy` or
               `EgressPolicy` want to allow. A single `ApiOperation` with serviceName
               field set to `*` will allow all methods AND permissions for all services.
        """
        if method_selectors is not None:
            pulumi.set(__self__, "method_selectors", method_selectors)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="methodSelectors")
    def method_selectors(self) -> Optional[Sequence['outputs.ServicePerimetersServicePerimeterSpecIngressPolicyIngressToOperationMethodSelector']]:
        """
        API methods or permissions to allow. Method or permission must belong
        to the service specified by `serviceName` field. A single MethodSelector
        entry with `*` specified for the `method` field will allow all methods
        AND permissions for the service specified in `serviceName`.
        Structure is documented below.
        """
        return pulumi.get(self, "method_selectors")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        """
        The name of the API whose methods or permissions the `IngressPolicy` or
        `EgressPolicy` want to allow. A single `ApiOperation` with serviceName
        field set to `*` will allow all methods AND permissions for all services.
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class ServicePerimetersServicePerimeterSpecIngressPolicyIngressToOperationMethodSelector(dict):
    def __init__(__self__, *,
                 method: Optional[str] = None,
                 permission: Optional[str] = None):
        """
        :param str method: Value for `method` should be a valid method name for the corresponding
               `serviceName` in `ApiOperation`. If `*` used as value for method,
               then ALL methods and permissions are allowed.
        :param str permission: Value for permission should be a valid Cloud IAM permission for the
               corresponding `serviceName` in `ApiOperation`.
        """
        if method is not None:
            pulumi.set(__self__, "method", method)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        Value for `method` should be a valid method name for the corresponding
        `serviceName` in `ApiOperation`. If `*` used as value for method,
        then ALL methods and permissions are allowed.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def permission(self) -> Optional[str]:
        """
        Value for permission should be a valid Cloud IAM permission for the
        corresponding `serviceName` in `ApiOperation`.
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class ServicePerimetersServicePerimeterSpecVpcAccessibleServices(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedServices":
            suggest = "allowed_services"
        elif key == "enableRestriction":
            suggest = "enable_restriction"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterSpecVpcAccessibleServices. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterSpecVpcAccessibleServices.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterSpecVpcAccessibleServices.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_services: Optional[Sequence[str]] = None,
                 enable_restriction: Optional[bool] = None):
        """
        :param Sequence[str] allowed_services: The list of APIs usable within the Service Perimeter.
               Must be empty unless `enableRestriction` is True.
        :param bool enable_restriction: Whether to restrict API calls within the Service Perimeter to the
               list of APIs specified in 'allowedServices'.
        """
        if allowed_services is not None:
            pulumi.set(__self__, "allowed_services", allowed_services)
        if enable_restriction is not None:
            pulumi.set(__self__, "enable_restriction", enable_restriction)

    @property
    @pulumi.getter(name="allowedServices")
    def allowed_services(self) -> Optional[Sequence[str]]:
        """
        The list of APIs usable within the Service Perimeter.
        Must be empty unless `enableRestriction` is True.
        """
        return pulumi.get(self, "allowed_services")

    @property
    @pulumi.getter(name="enableRestriction")
    def enable_restriction(self) -> Optional[bool]:
        """
        Whether to restrict API calls within the Service Perimeter to the
        list of APIs specified in 'allowedServices'.
        """
        return pulumi.get(self, "enable_restriction")


@pulumi.output_type
class ServicePerimetersServicePerimeterStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessLevels":
            suggest = "access_levels"
        elif key == "egressPolicies":
            suggest = "egress_policies"
        elif key == "ingressPolicies":
            suggest = "ingress_policies"
        elif key == "restrictedServices":
            suggest = "restricted_services"
        elif key == "vpcAccessibleServices":
            suggest = "vpc_accessible_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_levels: Optional[Sequence[str]] = None,
                 egress_policies: Optional[Sequence['outputs.ServicePerimetersServicePerimeterStatusEgressPolicy']] = None,
                 ingress_policies: Optional[Sequence['outputs.ServicePerimetersServicePerimeterStatusIngressPolicy']] = None,
                 resources: Optional[Sequence[str]] = None,
                 restricted_services: Optional[Sequence[str]] = None,
                 vpc_accessible_services: Optional['outputs.ServicePerimetersServicePerimeterStatusVpcAccessibleServices'] = None):
        """
        :param Sequence[str] access_levels: A list of AccessLevel resource names that allow resources within
               the ServicePerimeter to be accessed from the internet.
               AccessLevels listed must be in the same policy as this
               ServicePerimeter. Referencing a nonexistent AccessLevel is a
               syntax error. If no AccessLevel names are listed, resources within
               the perimeter can only be accessed via GCP calls with request
               origins within the perimeter. For Service Perimeter Bridge, must
               be empty.
               Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        :param Sequence['ServicePerimetersServicePerimeterStatusEgressPolicyArgs'] egress_policies: List of EgressPolicies to apply to the perimeter. A perimeter may
               have multiple EgressPolicies, each of which is evaluated separately.
               Access is granted if any EgressPolicy grants it. Must be empty for
               a perimeter bridge.
               Structure is documented below.
        :param Sequence['ServicePerimetersServicePerimeterStatusIngressPolicyArgs'] ingress_policies: List of `IngressPolicies` to apply to the perimeter. A perimeter may
               have multiple `IngressPolicies`, each of which is evaluated
               separately. Access is granted if any `Ingress Policy` grants it.
               Must be empty for a perimeter bridge.
               Structure is documented below.
        :param Sequence[str] resources: A list of GCP resources that are inside of the service perimeter.
               Currently only projects are allowed.
               Format: projects/{project_number}
        :param Sequence[str] restricted_services: GCP services that are subject to the Service Perimeter
               restrictions. Must contain a list of services. For example, if
               `storage.googleapis.com` is specified, access to the storage
               buckets inside the perimeter must meet the perimeter's access
               restrictions.
        :param 'ServicePerimetersServicePerimeterStatusVpcAccessibleServicesArgs' vpc_accessible_services: Specifies how APIs are allowed to communicate within the Service
               Perimeter.
               Structure is documented below.
        """
        if access_levels is not None:
            pulumi.set(__self__, "access_levels", access_levels)
        if egress_policies is not None:
            pulumi.set(__self__, "egress_policies", egress_policies)
        if ingress_policies is not None:
            pulumi.set(__self__, "ingress_policies", ingress_policies)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if restricted_services is not None:
            pulumi.set(__self__, "restricted_services", restricted_services)
        if vpc_accessible_services is not None:
            pulumi.set(__self__, "vpc_accessible_services", vpc_accessible_services)

    @property
    @pulumi.getter(name="accessLevels")
    def access_levels(self) -> Optional[Sequence[str]]:
        """
        A list of AccessLevel resource names that allow resources within
        the ServicePerimeter to be accessed from the internet.
        AccessLevels listed must be in the same policy as this
        ServicePerimeter. Referencing a nonexistent AccessLevel is a
        syntax error. If no AccessLevel names are listed, resources within
        the perimeter can only be accessed via GCP calls with request
        origins within the perimeter. For Service Perimeter Bridge, must
        be empty.
        Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        """
        return pulumi.get(self, "access_levels")

    @property
    @pulumi.getter(name="egressPolicies")
    def egress_policies(self) -> Optional[Sequence['outputs.ServicePerimetersServicePerimeterStatusEgressPolicy']]:
        """
        List of EgressPolicies to apply to the perimeter. A perimeter may
        have multiple EgressPolicies, each of which is evaluated separately.
        Access is granted if any EgressPolicy grants it. Must be empty for
        a perimeter bridge.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_policies")

    @property
    @pulumi.getter(name="ingressPolicies")
    def ingress_policies(self) -> Optional[Sequence['outputs.ServicePerimetersServicePerimeterStatusIngressPolicy']]:
        """
        List of `IngressPolicies` to apply to the perimeter. A perimeter may
        have multiple `IngressPolicies`, each of which is evaluated
        separately. Access is granted if any `Ingress Policy` grants it.
        Must be empty for a perimeter bridge.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_policies")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        A list of GCP resources that are inside of the service perimeter.
        Currently only projects are allowed.
        Format: projects/{project_number}
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="restrictedServices")
    def restricted_services(self) -> Optional[Sequence[str]]:
        """
        GCP services that are subject to the Service Perimeter
        restrictions. Must contain a list of services. For example, if
        `storage.googleapis.com` is specified, access to the storage
        buckets inside the perimeter must meet the perimeter's access
        restrictions.
        """
        return pulumi.get(self, "restricted_services")

    @property
    @pulumi.getter(name="vpcAccessibleServices")
    def vpc_accessible_services(self) -> Optional['outputs.ServicePerimetersServicePerimeterStatusVpcAccessibleServices']:
        """
        Specifies how APIs are allowed to communicate within the Service
        Perimeter.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_accessible_services")


@pulumi.output_type
class ServicePerimetersServicePerimeterStatusEgressPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "egressFrom":
            suggest = "egress_from"
        elif key == "egressTo":
            suggest = "egress_to"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterStatusEgressPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterStatusEgressPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterStatusEgressPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 egress_from: Optional['outputs.ServicePerimetersServicePerimeterStatusEgressPolicyEgressFrom'] = None,
                 egress_to: Optional['outputs.ServicePerimetersServicePerimeterStatusEgressPolicyEgressTo'] = None):
        """
        :param 'ServicePerimetersServicePerimeterStatusEgressPolicyEgressFromArgs' egress_from: Defines conditions on the source of a request causing this `EgressPolicy` to apply.
               Structure is documented below.
        :param 'ServicePerimetersServicePerimeterStatusEgressPolicyEgressToArgs' egress_to: Defines the conditions on the `ApiOperation` and destination resources that
               cause this `EgressPolicy` to apply.
               Structure is documented below.
        """
        if egress_from is not None:
            pulumi.set(__self__, "egress_from", egress_from)
        if egress_to is not None:
            pulumi.set(__self__, "egress_to", egress_to)

    @property
    @pulumi.getter(name="egressFrom")
    def egress_from(self) -> Optional['outputs.ServicePerimetersServicePerimeterStatusEgressPolicyEgressFrom']:
        """
        Defines conditions on the source of a request causing this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_from")

    @property
    @pulumi.getter(name="egressTo")
    def egress_to(self) -> Optional['outputs.ServicePerimetersServicePerimeterStatusEgressPolicyEgressTo']:
        """
        Defines the conditions on the `ApiOperation` and destination resources that
        cause this `EgressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_to")


@pulumi.output_type
class ServicePerimetersServicePerimeterStatusEgressPolicyEgressFrom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityType":
            suggest = "identity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterStatusEgressPolicyEgressFrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterStatusEgressPolicyEgressFrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterStatusEgressPolicyEgressFrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identities: Optional[Sequence[str]] = None,
                 identity_type: Optional[str] = None):
        """
        :param Sequence[str] identities: A list of identities that are allowed access through this `EgressPolicy`.
               Should be in the format of email address. The email address should
               represent individual user or service account only.
        :param str identity_type: Specifies the type of identities that are allowed access to outside the
               perimeter. If left unspecified, then members of `identities` field will
               be allowed access.
               Possible values are `IDENTITY_TYPE_UNSPECIFIED`, `ANY_IDENTITY`, `ANY_USER_ACCOUNT`, and `ANY_SERVICE_ACCOUNT`.
        """
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if identity_type is not None:
            pulumi.set(__self__, "identity_type", identity_type)

    @property
    @pulumi.getter
    def identities(self) -> Optional[Sequence[str]]:
        """
        A list of identities that are allowed access through this `EgressPolicy`.
        Should be in the format of email address. The email address should
        represent individual user or service account only.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> Optional[str]:
        """
        Specifies the type of identities that are allowed access to outside the
        perimeter. If left unspecified, then members of `identities` field will
        be allowed access.
        Possible values are `IDENTITY_TYPE_UNSPECIFIED`, `ANY_IDENTITY`, `ANY_USER_ACCOUNT`, and `ANY_SERVICE_ACCOUNT`.
        """
        return pulumi.get(self, "identity_type")


@pulumi.output_type
class ServicePerimetersServicePerimeterStatusEgressPolicyEgressTo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalResources":
            suggest = "external_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterStatusEgressPolicyEgressTo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterStatusEgressPolicyEgressTo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterStatusEgressPolicyEgressTo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_resources: Optional[Sequence[str]] = None,
                 operations: Optional[Sequence['outputs.ServicePerimetersServicePerimeterStatusEgressPolicyEgressToOperation']] = None,
                 resources: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] external_resources: A list of external resources that are allowed to be accessed. A request
               matches if it contains an external resource in this list (Example:
               s3://bucket/path). Currently '*' is not allowed.
        :param Sequence['ServicePerimetersServicePerimeterStatusEgressPolicyEgressToOperationArgs'] operations: A list of `ApiOperations` that this egress rule applies to. A request matches
               if it contains an operation/service in this list.
               Structure is documented below.
        :param Sequence[str] resources: A list of resources, currently only projects in the form
               `projects/<projectnumber>`, that match this to stanza. A request matches
               if it contains a resource in this list. If * is specified for resources,
               then this `EgressTo` rule will authorize access to all resources outside
               the perimeter.
        """
        if external_resources is not None:
            pulumi.set(__self__, "external_resources", external_resources)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter(name="externalResources")
    def external_resources(self) -> Optional[Sequence[str]]:
        """
        A list of external resources that are allowed to be accessed. A request
        matches if it contains an external resource in this list (Example:
        s3://bucket/path). Currently '*' is not allowed.
        """
        return pulumi.get(self, "external_resources")

    @property
    @pulumi.getter
    def operations(self) -> Optional[Sequence['outputs.ServicePerimetersServicePerimeterStatusEgressPolicyEgressToOperation']]:
        """
        A list of `ApiOperations` that this egress rule applies to. A request matches
        if it contains an operation/service in this list.
        Structure is documented below.
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        A list of resources, currently only projects in the form
        `projects/<projectnumber>`, that match this to stanza. A request matches
        if it contains a resource in this list. If * is specified for resources,
        then this `EgressTo` rule will authorize access to all resources outside
        the perimeter.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class ServicePerimetersServicePerimeterStatusEgressPolicyEgressToOperation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "methodSelectors":
            suggest = "method_selectors"
        elif key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterStatusEgressPolicyEgressToOperation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterStatusEgressPolicyEgressToOperation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterStatusEgressPolicyEgressToOperation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method_selectors: Optional[Sequence['outputs.ServicePerimetersServicePerimeterStatusEgressPolicyEgressToOperationMethodSelector']] = None,
                 service_name: Optional[str] = None):
        """
        :param Sequence['ServicePerimetersServicePerimeterStatusEgressPolicyEgressToOperationMethodSelectorArgs'] method_selectors: API methods or permissions to allow. Method or permission must belong
               to the service specified by `serviceName` field. A single MethodSelector
               entry with `*` specified for the `method` field will allow all methods
               AND permissions for the service specified in `serviceName`.
               Structure is documented below.
        :param str service_name: The name of the API whose methods or permissions the `IngressPolicy` or
               `EgressPolicy` want to allow. A single `ApiOperation` with serviceName
               field set to `*` will allow all methods AND permissions for all services.
        """
        if method_selectors is not None:
            pulumi.set(__self__, "method_selectors", method_selectors)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="methodSelectors")
    def method_selectors(self) -> Optional[Sequence['outputs.ServicePerimetersServicePerimeterStatusEgressPolicyEgressToOperationMethodSelector']]:
        """
        API methods or permissions to allow. Method or permission must belong
        to the service specified by `serviceName` field. A single MethodSelector
        entry with `*` specified for the `method` field will allow all methods
        AND permissions for the service specified in `serviceName`.
        Structure is documented below.
        """
        return pulumi.get(self, "method_selectors")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        """
        The name of the API whose methods or permissions the `IngressPolicy` or
        `EgressPolicy` want to allow. A single `ApiOperation` with serviceName
        field set to `*` will allow all methods AND permissions for all services.
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class ServicePerimetersServicePerimeterStatusEgressPolicyEgressToOperationMethodSelector(dict):
    def __init__(__self__, *,
                 method: Optional[str] = None,
                 permission: Optional[str] = None):
        """
        :param str method: Value for `method` should be a valid method name for the corresponding
               `serviceName` in `ApiOperation`. If `*` used as value for method,
               then ALL methods and permissions are allowed.
        :param str permission: Value for permission should be a valid Cloud IAM permission for the
               corresponding `serviceName` in `ApiOperation`.
        """
        if method is not None:
            pulumi.set(__self__, "method", method)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        Value for `method` should be a valid method name for the corresponding
        `serviceName` in `ApiOperation`. If `*` used as value for method,
        then ALL methods and permissions are allowed.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def permission(self) -> Optional[str]:
        """
        Value for permission should be a valid Cloud IAM permission for the
        corresponding `serviceName` in `ApiOperation`.
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class ServicePerimetersServicePerimeterStatusIngressPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ingressFrom":
            suggest = "ingress_from"
        elif key == "ingressTo":
            suggest = "ingress_to"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterStatusIngressPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterStatusIngressPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterStatusIngressPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ingress_from: Optional['outputs.ServicePerimetersServicePerimeterStatusIngressPolicyIngressFrom'] = None,
                 ingress_to: Optional['outputs.ServicePerimetersServicePerimeterStatusIngressPolicyIngressTo'] = None):
        """
        :param 'ServicePerimetersServicePerimeterStatusIngressPolicyIngressFromArgs' ingress_from: Defines the conditions on the source of a request causing this `IngressPolicy`
               to apply.
               Structure is documented below.
        :param 'ServicePerimetersServicePerimeterStatusIngressPolicyIngressToArgs' ingress_to: Defines the conditions on the `ApiOperation` and request destination that cause
               this `IngressPolicy` to apply.
               Structure is documented below.
        """
        if ingress_from is not None:
            pulumi.set(__self__, "ingress_from", ingress_from)
        if ingress_to is not None:
            pulumi.set(__self__, "ingress_to", ingress_to)

    @property
    @pulumi.getter(name="ingressFrom")
    def ingress_from(self) -> Optional['outputs.ServicePerimetersServicePerimeterStatusIngressPolicyIngressFrom']:
        """
        Defines the conditions on the source of a request causing this `IngressPolicy`
        to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_from")

    @property
    @pulumi.getter(name="ingressTo")
    def ingress_to(self) -> Optional['outputs.ServicePerimetersServicePerimeterStatusIngressPolicyIngressTo']:
        """
        Defines the conditions on the `ApiOperation` and request destination that cause
        this `IngressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_to")


@pulumi.output_type
class ServicePerimetersServicePerimeterStatusIngressPolicyIngressFrom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityType":
            suggest = "identity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterStatusIngressPolicyIngressFrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterStatusIngressPolicyIngressFrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterStatusIngressPolicyIngressFrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identities: Optional[Sequence[str]] = None,
                 identity_type: Optional[str] = None,
                 sources: Optional[Sequence['outputs.ServicePerimetersServicePerimeterStatusIngressPolicyIngressFromSource']] = None):
        """
        :param Sequence[str] identities: A list of identities that are allowed access through this ingress policy.
               Should be in the format of email address. The email address should represent
               individual user or service account only.
        :param str identity_type: Specifies the type of identities that are allowed access from outside the
               perimeter. If left unspecified, then members of `identities` field will be
               allowed access.
               Possible values are `IDENTITY_TYPE_UNSPECIFIED`, `ANY_IDENTITY`, `ANY_USER_ACCOUNT`, and `ANY_SERVICE_ACCOUNT`.
        :param Sequence['ServicePerimetersServicePerimeterStatusIngressPolicyIngressFromSourceArgs'] sources: Sources that this `IngressPolicy` authorizes access from.
               Structure is documented below.
        """
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if identity_type is not None:
            pulumi.set(__self__, "identity_type", identity_type)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def identities(self) -> Optional[Sequence[str]]:
        """
        A list of identities that are allowed access through this ingress policy.
        Should be in the format of email address. The email address should represent
        individual user or service account only.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> Optional[str]:
        """
        Specifies the type of identities that are allowed access from outside the
        perimeter. If left unspecified, then members of `identities` field will be
        allowed access.
        Possible values are `IDENTITY_TYPE_UNSPECIFIED`, `ANY_IDENTITY`, `ANY_USER_ACCOUNT`, and `ANY_SERVICE_ACCOUNT`.
        """
        return pulumi.get(self, "identity_type")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.ServicePerimetersServicePerimeterStatusIngressPolicyIngressFromSource']]:
        """
        Sources that this `IngressPolicy` authorizes access from.
        Structure is documented below.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class ServicePerimetersServicePerimeterStatusIngressPolicyIngressFromSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessLevel":
            suggest = "access_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterStatusIngressPolicyIngressFromSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterStatusIngressPolicyIngressFromSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterStatusIngressPolicyIngressFromSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_level: Optional[str] = None,
                 resource: Optional[str] = None):
        """
        :param str access_level: An `AccessLevel` resource name that allow resources within the
               `ServicePerimeters` to be accessed from the internet. `AccessLevels` listed
               must be in the same policy as this `ServicePerimeter`. Referencing a nonexistent
               `AccessLevel` will cause an error. If no `AccessLevel` names are listed,
               resources within the perimeter can only be accessed via Google Cloud calls
               with request origins within the perimeter.
               Example `accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.`
               If * is specified, then all IngressSources will be allowed.
        :param str resource: A Google Cloud resource that is allowed to ingress the perimeter.
               Requests from these resources will be allowed to access perimeter data.
               Currently only projects are allowed. Format `projects/{project_number}`
               The project may be in any Google Cloud organization, not just the
               organization that the perimeter is defined in. `*` is not allowed, the case
               of allowing all Google Cloud resources only is not supported.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        """
        An `AccessLevel` resource name that allow resources within the
        `ServicePerimeters` to be accessed from the internet. `AccessLevels` listed
        must be in the same policy as this `ServicePerimeter`. Referencing a nonexistent
        `AccessLevel` will cause an error. If no `AccessLevel` names are listed,
        resources within the perimeter can only be accessed via Google Cloud calls
        with request origins within the perimeter.
        Example `accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.`
        If * is specified, then all IngressSources will be allowed.
        """
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter
    def resource(self) -> Optional[str]:
        """
        A Google Cloud resource that is allowed to ingress the perimeter.
        Requests from these resources will be allowed to access perimeter data.
        Currently only projects are allowed. Format `projects/{project_number}`
        The project may be in any Google Cloud organization, not just the
        organization that the perimeter is defined in. `*` is not allowed, the case
        of allowing all Google Cloud resources only is not supported.
        """
        return pulumi.get(self, "resource")


@pulumi.output_type
class ServicePerimetersServicePerimeterStatusIngressPolicyIngressTo(dict):
    def __init__(__self__, *,
                 operations: Optional[Sequence['outputs.ServicePerimetersServicePerimeterStatusIngressPolicyIngressToOperation']] = None,
                 resources: Optional[Sequence[str]] = None):
        """
        :param Sequence['ServicePerimetersServicePerimeterStatusIngressPolicyIngressToOperationArgs'] operations: A list of `ApiOperations` the sources specified in corresponding `IngressFrom`
               are allowed to perform in this `ServicePerimeter`.
               Structure is documented below.
        :param Sequence[str] resources: A list of resources, currently only projects in the form
               `projects/<projectnumber>`, protected by this `ServicePerimeter`
               that are allowed to be accessed by sources defined in the
               corresponding `IngressFrom`. A request matches if it contains
               a resource in this list. If `*` is specified for resources,
               then this `IngressTo` rule will authorize access to all
               resources inside the perimeter, provided that the request
               also matches the `operations` field.
        """
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def operations(self) -> Optional[Sequence['outputs.ServicePerimetersServicePerimeterStatusIngressPolicyIngressToOperation']]:
        """
        A list of `ApiOperations` the sources specified in corresponding `IngressFrom`
        are allowed to perform in this `ServicePerimeter`.
        Structure is documented below.
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        A list of resources, currently only projects in the form
        `projects/<projectnumber>`, protected by this `ServicePerimeter`
        that are allowed to be accessed by sources defined in the
        corresponding `IngressFrom`. A request matches if it contains
        a resource in this list. If `*` is specified for resources,
        then this `IngressTo` rule will authorize access to all
        resources inside the perimeter, provided that the request
        also matches the `operations` field.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class ServicePerimetersServicePerimeterStatusIngressPolicyIngressToOperation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "methodSelectors":
            suggest = "method_selectors"
        elif key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterStatusIngressPolicyIngressToOperation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterStatusIngressPolicyIngressToOperation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterStatusIngressPolicyIngressToOperation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method_selectors: Optional[Sequence['outputs.ServicePerimetersServicePerimeterStatusIngressPolicyIngressToOperationMethodSelector']] = None,
                 service_name: Optional[str] = None):
        """
        :param Sequence['ServicePerimetersServicePerimeterStatusIngressPolicyIngressToOperationMethodSelectorArgs'] method_selectors: API methods or permissions to allow. Method or permission must belong
               to the service specified by `serviceName` field. A single MethodSelector
               entry with `*` specified for the `method` field will allow all methods
               AND permissions for the service specified in `serviceName`.
               Structure is documented below.
        :param str service_name: The name of the API whose methods or permissions the `IngressPolicy` or
               `EgressPolicy` want to allow. A single `ApiOperation` with serviceName
               field set to `*` will allow all methods AND permissions for all services.
        """
        if method_selectors is not None:
            pulumi.set(__self__, "method_selectors", method_selectors)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="methodSelectors")
    def method_selectors(self) -> Optional[Sequence['outputs.ServicePerimetersServicePerimeterStatusIngressPolicyIngressToOperationMethodSelector']]:
        """
        API methods or permissions to allow. Method or permission must belong
        to the service specified by `serviceName` field. A single MethodSelector
        entry with `*` specified for the `method` field will allow all methods
        AND permissions for the service specified in `serviceName`.
        Structure is documented below.
        """
        return pulumi.get(self, "method_selectors")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        """
        The name of the API whose methods or permissions the `IngressPolicy` or
        `EgressPolicy` want to allow. A single `ApiOperation` with serviceName
        field set to `*` will allow all methods AND permissions for all services.
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class ServicePerimetersServicePerimeterStatusIngressPolicyIngressToOperationMethodSelector(dict):
    def __init__(__self__, *,
                 method: Optional[str] = None,
                 permission: Optional[str] = None):
        """
        :param str method: Value for `method` should be a valid method name for the corresponding
               `serviceName` in `ApiOperation`. If `*` used as value for method,
               then ALL methods and permissions are allowed.
        :param str permission: Value for permission should be a valid Cloud IAM permission for the
               corresponding `serviceName` in `ApiOperation`.
        """
        if method is not None:
            pulumi.set(__self__, "method", method)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        Value for `method` should be a valid method name for the corresponding
        `serviceName` in `ApiOperation`. If `*` used as value for method,
        then ALL methods and permissions are allowed.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def permission(self) -> Optional[str]:
        """
        Value for permission should be a valid Cloud IAM permission for the
        corresponding `serviceName` in `ApiOperation`.
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class ServicePerimetersServicePerimeterStatusVpcAccessibleServices(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedServices":
            suggest = "allowed_services"
        elif key == "enableRestriction":
            suggest = "enable_restriction"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePerimetersServicePerimeterStatusVpcAccessibleServices. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePerimetersServicePerimeterStatusVpcAccessibleServices.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePerimetersServicePerimeterStatusVpcAccessibleServices.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_services: Optional[Sequence[str]] = None,
                 enable_restriction: Optional[bool] = None):
        """
        :param Sequence[str] allowed_services: The list of APIs usable within the Service Perimeter.
               Must be empty unless `enableRestriction` is True.
        :param bool enable_restriction: Whether to restrict API calls within the Service Perimeter to the
               list of APIs specified in 'allowedServices'.
        """
        if allowed_services is not None:
            pulumi.set(__self__, "allowed_services", allowed_services)
        if enable_restriction is not None:
            pulumi.set(__self__, "enable_restriction", enable_restriction)

    @property
    @pulumi.getter(name="allowedServices")
    def allowed_services(self) -> Optional[Sequence[str]]:
        """
        The list of APIs usable within the Service Perimeter.
        Must be empty unless `enableRestriction` is True.
        """
        return pulumi.get(self, "allowed_services")

    @property
    @pulumi.getter(name="enableRestriction")
    def enable_restriction(self) -> Optional[bool]:
        """
        Whether to restrict API calls within the Service Perimeter to the
        list of APIs specified in 'allowedServices'.
        """
        return pulumi.get(self, "enable_restriction")


