# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterAutomatedBackupPolicy',
    'ClusterAutomatedBackupPolicyQuantityBasedRetention',
    'ClusterAutomatedBackupPolicyTimeBasedRetention',
    'ClusterAutomatedBackupPolicyWeeklySchedule',
    'ClusterAutomatedBackupPolicyWeeklyScheduleStartTime',
    'ClusterBackupSource',
    'ClusterInitialUser',
    'ClusterMigrationSource',
    'InstanceMachineConfig',
    'InstanceReadPoolConfig',
]

@pulumi.output_type
class ClusterAutomatedBackupPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "weeklySchedule":
            suggest = "weekly_schedule"
        elif key == "backupWindow":
            suggest = "backup_window"
        elif key == "quantityBasedRetention":
            suggest = "quantity_based_retention"
        elif key == "timeBasedRetention":
            suggest = "time_based_retention"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutomatedBackupPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutomatedBackupPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutomatedBackupPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 weekly_schedule: 'outputs.ClusterAutomatedBackupPolicyWeeklySchedule',
                 backup_window: Optional[str] = None,
                 enabled: Optional[bool] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 location: Optional[str] = None,
                 quantity_based_retention: Optional['outputs.ClusterAutomatedBackupPolicyQuantityBasedRetention'] = None,
                 time_based_retention: Optional['outputs.ClusterAutomatedBackupPolicyTimeBasedRetention'] = None):
        """
        :param 'ClusterAutomatedBackupPolicyWeeklyScheduleArgs' weekly_schedule: Weekly schedule for the Backup.
               Structure is documented below.
        :param str backup_window: The length of the time window during which a backup can be taken. If a backup does not succeed within this time window, it will be canceled and considered failed.
               The backup window must be at least 5 minutes long. There is no upper bound on the window. If not set, it will default to 1 hour.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param bool enabled: Whether automated automated backups are enabled.
        :param Mapping[str, str] labels: Labels to apply to backups created using this configuration.
        :param str location: The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
        :param 'ClusterAutomatedBackupPolicyQuantityBasedRetentionArgs' quantity_based_retention: Quantity-based Backup retention policy to retain recent backups.
               Structure is documented below.
        :param 'ClusterAutomatedBackupPolicyTimeBasedRetentionArgs' time_based_retention: Time-based Backup retention policy.
               Structure is documented below.
        """
        pulumi.set(__self__, "weekly_schedule", weekly_schedule)
        if backup_window is not None:
            pulumi.set(__self__, "backup_window", backup_window)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if quantity_based_retention is not None:
            pulumi.set(__self__, "quantity_based_retention", quantity_based_retention)
        if time_based_retention is not None:
            pulumi.set(__self__, "time_based_retention", time_based_retention)

    @property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> 'outputs.ClusterAutomatedBackupPolicyWeeklySchedule':
        """
        Weekly schedule for the Backup.
        Structure is documented below.
        """
        return pulumi.get(self, "weekly_schedule")

    @property
    @pulumi.getter(name="backupWindow")
    def backup_window(self) -> Optional[str]:
        """
        The length of the time window during which a backup can be taken. If a backup does not succeed within this time window, it will be canceled and considered failed.
        The backup window must be at least 5 minutes long. There is no upper bound on the window. If not set, it will default to 1 hour.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "backup_window")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether automated automated backups are enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        Labels to apply to backups created using this configuration.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="quantityBasedRetention")
    def quantity_based_retention(self) -> Optional['outputs.ClusterAutomatedBackupPolicyQuantityBasedRetention']:
        """
        Quantity-based Backup retention policy to retain recent backups.
        Structure is documented below.
        """
        return pulumi.get(self, "quantity_based_retention")

    @property
    @pulumi.getter(name="timeBasedRetention")
    def time_based_retention(self) -> Optional['outputs.ClusterAutomatedBackupPolicyTimeBasedRetention']:
        """
        Time-based Backup retention policy.
        Structure is documented below.
        """
        return pulumi.get(self, "time_based_retention")


@pulumi.output_type
class ClusterAutomatedBackupPolicyQuantityBasedRetention(dict):
    def __init__(__self__, *,
                 count: Optional[int] = None):
        """
        :param int count: The number of backups to retain.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        The number of backups to retain.
        """
        return pulumi.get(self, "count")


@pulumi.output_type
class ClusterAutomatedBackupPolicyTimeBasedRetention(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPeriod":
            suggest = "retention_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutomatedBackupPolicyTimeBasedRetention. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutomatedBackupPolicyTimeBasedRetention.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutomatedBackupPolicyTimeBasedRetention.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_period: Optional[str] = None):
        """
        :param str retention_period: The retention period.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[str]:
        """
        The retention period.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "retention_period")


@pulumi.output_type
class ClusterAutomatedBackupPolicyWeeklySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTimes":
            suggest = "start_times"
        elif key == "daysOfWeeks":
            suggest = "days_of_weeks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutomatedBackupPolicyWeeklySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutomatedBackupPolicyWeeklySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutomatedBackupPolicyWeeklySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_times: Sequence['outputs.ClusterAutomatedBackupPolicyWeeklyScheduleStartTime'],
                 days_of_weeks: Optional[Sequence[str]] = None):
        """
        :param Sequence['ClusterAutomatedBackupPolicyWeeklyScheduleStartTimeArgs'] start_times: The times during the day to start a backup. At least one start time must be provided. The start times are assumed to be in UTC and to be an exact hour (e.g., 04:00:00).
               Structure is documented below.
        :param Sequence[str] days_of_weeks: The days of the week to perform a backup. At least one day of the week must be provided.
               Each value may be one of `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, and `SUNDAY`.
        """
        pulumi.set(__self__, "start_times", start_times)
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)

    @property
    @pulumi.getter(name="startTimes")
    def start_times(self) -> Sequence['outputs.ClusterAutomatedBackupPolicyWeeklyScheduleStartTime']:
        """
        The times during the day to start a backup. At least one start time must be provided. The start times are assumed to be in UTC and to be an exact hour (e.g., 04:00:00).
        Structure is documented below.
        """
        return pulumi.get(self, "start_times")

    @property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[Sequence[str]]:
        """
        The days of the week to perform a backup. At least one day of the week must be provided.
        Each value may be one of `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, and `SUNDAY`.
        """
        return pulumi.get(self, "days_of_weeks")


@pulumi.output_type
class ClusterAutomatedBackupPolicyWeeklyScheduleStartTime(dict):
    def __init__(__self__, *,
                 hours: Optional[int] = None,
                 minutes: Optional[int] = None,
                 nanos: Optional[int] = None,
                 seconds: Optional[int] = None):
        """
        :param int hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param int seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> Optional[int]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Optional[int]:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> Optional[int]:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> Optional[int]:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class ClusterBackupSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupName":
            suggest = "backup_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBackupSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBackupSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBackupSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_name: Optional[str] = None):
        """
        :param str backup_name: The name of the backup resource.
        """
        if backup_name is not None:
            pulumi.set(__self__, "backup_name", backup_name)

    @property
    @pulumi.getter(name="backupName")
    def backup_name(self) -> Optional[str]:
        """
        The name of the backup resource.
        """
        return pulumi.get(self, "backup_name")


@pulumi.output_type
class ClusterInitialUser(dict):
    def __init__(__self__, *,
                 password: str,
                 user: Optional[str] = None):
        """
        :param str password: The initial password for the user.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str user: The database username.
        """
        pulumi.set(__self__, "password", password)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The initial password for the user.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        The database username.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ClusterMigrationSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostPort":
            suggest = "host_port"
        elif key == "referenceId":
            suggest = "reference_id"
        elif key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMigrationSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMigrationSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMigrationSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_port: Optional[str] = None,
                 reference_id: Optional[str] = None,
                 source_type: Optional[str] = None):
        """
        :param str host_port: The host and port of the on-premises instance in host:port format
        :param str reference_id: Place holder for the external source identifier(e.g DMS job name) that created the cluster.
        :param str source_type: Type of migration source.
        """
        if host_port is not None:
            pulumi.set(__self__, "host_port", host_port)
        if reference_id is not None:
            pulumi.set(__self__, "reference_id", reference_id)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> Optional[str]:
        """
        The host and port of the on-premises instance in host:port format
        """
        return pulumi.get(self, "host_port")

    @property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> Optional[str]:
        """
        Place holder for the external source identifier(e.g DMS job name) that created the cluster.
        """
        return pulumi.get(self, "reference_id")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[str]:
        """
        Type of migration source.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class InstanceMachineConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuCount":
            suggest = "cpu_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMachineConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMachineConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMachineConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_count: Optional[int] = None):
        """
        :param int cpu_count: The number of CPU's in the VM instance.
        """
        if cpu_count is not None:
            pulumi.set(__self__, "cpu_count", cpu_count)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> Optional[int]:
        """
        The number of CPU's in the VM instance.
        """
        return pulumi.get(self, "cpu_count")


@pulumi.output_type
class InstanceReadPoolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeCount":
            suggest = "node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceReadPoolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceReadPoolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceReadPoolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_count: Optional[int] = None):
        """
        :param int node_count: Read capacity, i.e. number of nodes in a read pool instance.
        """
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[int]:
        """
        Read capacity, i.e. number of nodes in a read pool instance.
        """
        return pulumi.get(self, "node_count")


