# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAppConnectionResult',
    'AwaitableGetAppConnectionResult',
    'get_app_connection',
    'get_app_connection_output',
]

@pulumi.output_type
class GetAppConnectionResult:
    """
    A collection of values returned by getAppConnection.
    """
    def __init__(__self__, application_endpoints=None, connectors=None, display_name=None, gateways=None, id=None, labels=None, name=None, project=None, region=None, type=None):
        if application_endpoints and not isinstance(application_endpoints, list):
            raise TypeError("Expected argument 'application_endpoints' to be a list")
        pulumi.set(__self__, "application_endpoints", application_endpoints)
        if connectors and not isinstance(connectors, list):
            raise TypeError("Expected argument 'connectors' to be a list")
        pulumi.set(__self__, "connectors", connectors)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if gateways and not isinstance(gateways, list):
            raise TypeError("Expected argument 'gateways' to be a list")
        pulumi.set(__self__, "gateways", gateways)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="applicationEndpoints")
    def application_endpoints(self) -> Sequence['outputs.GetAppConnectionApplicationEndpointResult']:
        return pulumi.get(self, "application_endpoints")

    @property
    @pulumi.getter
    def connectors(self) -> Sequence[str]:
        return pulumi.get(self, "connectors")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def gateways(self) -> Sequence['outputs.GetAppConnectionGatewayResult']:
        return pulumi.get(self, "gateways")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


class AwaitableGetAppConnectionResult(GetAppConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppConnectionResult(
            application_endpoints=self.application_endpoints,
            connectors=self.connectors,
            display_name=self.display_name,
            gateways=self.gateways,
            id=self.id,
            labels=self.labels,
            name=self.name,
            project=self.project,
            region=self.region,
            type=self.type)


def get_app_connection(name: Optional[str] = None,
                       project: Optional[str] = None,
                       region: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppConnectionResult:
    """
    Get information about a Google BeyondCorp App Connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_beyondcorp_app_connection = gcp.beyondcorp.get_app_connection(name="my-beyondcorp-app-connection")
    ```


    :param str name: The name of the App Connection.
    :param str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param str region: The region in which the resource belongs. If it
           is not provided, the provider region is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:beyondcorp/getAppConnection:getAppConnection', __args__, opts=opts, typ=GetAppConnectionResult).value

    return AwaitableGetAppConnectionResult(
        application_endpoints=__ret__.application_endpoints,
        connectors=__ret__.connectors,
        display_name=__ret__.display_name,
        gateways=__ret__.gateways,
        id=__ret__.id,
        labels=__ret__.labels,
        name=__ret__.name,
        project=__ret__.project,
        region=__ret__.region,
        type=__ret__.type)


@_utilities.lift_output_func(get_app_connection)
def get_app_connection_output(name: Optional[pulumi.Input[str]] = None,
                              project: Optional[pulumi.Input[Optional[str]]] = None,
                              region: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAppConnectionResult]:
    """
    Get information about a Google BeyondCorp App Connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_beyondcorp_app_connection = gcp.beyondcorp.get_app_connection(name="my-beyondcorp-app-connection")
    ```


    :param str name: The name of the App Connection.
    :param str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param str region: The region in which the resource belongs. If it
           is not provided, the provider region is used.
    """
    ...
