# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAppGatewayResult',
    'AwaitableGetAppGatewayResult',
    'get_app_gateway',
    'get_app_gateway_output',
]

@pulumi.output_type
class GetAppGatewayResult:
    """
    A collection of values returned by getAppGateway.
    """
    def __init__(__self__, allocated_connections=None, display_name=None, host_type=None, id=None, labels=None, name=None, project=None, region=None, state=None, type=None, uri=None):
        if allocated_connections and not isinstance(allocated_connections, list):
            raise TypeError("Expected argument 'allocated_connections' to be a list")
        pulumi.set(__self__, "allocated_connections", allocated_connections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if host_type and not isinstance(host_type, str):
            raise TypeError("Expected argument 'host_type' to be a str")
        pulumi.set(__self__, "host_type", host_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if uri and not isinstance(uri, str):
            raise TypeError("Expected argument 'uri' to be a str")
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="allocatedConnections")
    def allocated_connections(self) -> Sequence['outputs.GetAppGatewayAllocatedConnectionResult']:
        return pulumi.get(self, "allocated_connections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="hostType")
    def host_type(self) -> str:
        return pulumi.get(self, "host_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def state(self) -> str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uri(self) -> str:
        return pulumi.get(self, "uri")


class AwaitableGetAppGatewayResult(GetAppGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppGatewayResult(
            allocated_connections=self.allocated_connections,
            display_name=self.display_name,
            host_type=self.host_type,
            id=self.id,
            labels=self.labels,
            name=self.name,
            project=self.project,
            region=self.region,
            state=self.state,
            type=self.type,
            uri=self.uri)


def get_app_gateway(name: Optional[str] = None,
                    project: Optional[str] = None,
                    region: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppGatewayResult:
    """
    Get information about a Google BeyondCorp App Gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_beyondcorp_app_gateway = gcp.beyondcorp.get_app_gateway(name="my-beyondcorp-app-gateway")
    ```


    :param str name: The name of the App Gateway.
    :param str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param str region: The region in which the resource belongs. If it
           is not provided, the provider region is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:beyondcorp/getAppGateway:getAppGateway', __args__, opts=opts, typ=GetAppGatewayResult).value

    return AwaitableGetAppGatewayResult(
        allocated_connections=__ret__.allocated_connections,
        display_name=__ret__.display_name,
        host_type=__ret__.host_type,
        id=__ret__.id,
        labels=__ret__.labels,
        name=__ret__.name,
        project=__ret__.project,
        region=__ret__.region,
        state=__ret__.state,
        type=__ret__.type,
        uri=__ret__.uri)


@_utilities.lift_output_func(get_app_gateway)
def get_app_gateway_output(name: Optional[pulumi.Input[str]] = None,
                           project: Optional[pulumi.Input[Optional[str]]] = None,
                           region: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAppGatewayResult]:
    """
    Get information about a Google BeyondCorp App Gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_beyondcorp_app_gateway = gcp.beyondcorp.get_app_gateway(name="my-beyondcorp-app-gateway")
    ```


    :param str name: The name of the App Gateway.
    :param str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param str region: The region in which the resource belongs. If it
           is not provided, the provider region is used.
    """
    ...
