# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GCPolicyMaxAge',
    'GCPolicyMaxVersion',
    'InstanceCluster',
    'InstanceClusterAutoscalingConfig',
    'InstanceIamBindingCondition',
    'InstanceIamMemberCondition',
    'TableColumnFamily',
    'TableIamBindingCondition',
    'TableIamMemberCondition',
]

@pulumi.output_type
class GCPolicyMaxAge(dict):
    def __init__(__self__, *,
                 days: Optional[int] = None,
                 duration: Optional[str] = None):
        """
        :param int days: Number of days before applying GC policy.
        :param str duration: Duration before applying GC policy (ex. "8h"). This is required when `days` isn't set
        """
        if days is not None:
            pulumi.set(__self__, "days", days)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Number of days before applying GC policy.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter
    def duration(self) -> Optional[str]:
        """
        Duration before applying GC policy (ex. "8h"). This is required when `days` isn't set
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class GCPolicyMaxVersion(dict):
    def __init__(__self__, *,
                 number: int):
        """
        :param int number: Number of version before applying the GC policy.
        """
        pulumi.set(__self__, "number", number)

    @property
    @pulumi.getter
    def number(self) -> int:
        """
        Number of version before applying the GC policy.
        """
        return pulumi.get(self, "number")


@pulumi.output_type
class InstanceCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterId":
            suggest = "cluster_id"
        elif key == "autoscalingConfig":
            suggest = "autoscaling_config"
        elif key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "numNodes":
            suggest = "num_nodes"
        elif key == "storageType":
            suggest = "storage_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_id: str,
                 autoscaling_config: Optional['outputs.InstanceClusterAutoscalingConfig'] = None,
                 kms_key_name: Optional[str] = None,
                 num_nodes: Optional[int] = None,
                 storage_type: Optional[str] = None,
                 zone: Optional[str] = None):
        """
        :param str cluster_id: The ID of the Cloud Bigtable cluster. Must be 6-30 characters and must only contain hyphens, lowercase letters and numbers.
        :param 'InstanceClusterAutoscalingConfigArgs' autoscaling_config: [Autoscaling](https://cloud.google.com/bigtable/docs/autoscaling#parameters) config for the cluster, contains the following arguments:
        :param str kms_key_name: Describes the Cloud KMS encryption key that will be used to protect the destination Bigtable cluster. The requirements for this key are: 1) The Cloud Bigtable service account associated with the project that contains this cluster must be granted the `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key. 2) Only regional keys can be used and the region of the CMEK key must match the region of the cluster.
        :param int num_nodes: The number of nodes in your Cloud Bigtable cluster.
               Required, with a minimum of `1` for each cluster in an instance.
        :param str storage_type: The storage type to use. One of `"SSD"` or
               `"HDD"`. Defaults to `"SSD"`.
        :param str zone: The zone to create the Cloud Bigtable cluster in. If it not
               specified, the provider zone is used. Each cluster must have a different zone in the same region. Zones that support
               Bigtable instances are noted on the [Cloud Bigtable locations page](https://cloud.google.com/bigtable/docs/locations).
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if autoscaling_config is not None:
            pulumi.set(__self__, "autoscaling_config", autoscaling_config)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if num_nodes is not None:
            pulumi.set(__self__, "num_nodes", num_nodes)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The ID of the Cloud Bigtable cluster. Must be 6-30 characters and must only contain hyphens, lowercase letters and numbers.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="autoscalingConfig")
    def autoscaling_config(self) -> Optional['outputs.InstanceClusterAutoscalingConfig']:
        """
        [Autoscaling](https://cloud.google.com/bigtable/docs/autoscaling#parameters) config for the cluster, contains the following arguments:
        """
        return pulumi.get(self, "autoscaling_config")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[str]:
        """
        Describes the Cloud KMS encryption key that will be used to protect the destination Bigtable cluster. The requirements for this key are: 1) The Cloud Bigtable service account associated with the project that contains this cluster must be granted the `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key. 2) Only regional keys can be used and the region of the CMEK key must match the region of the cluster.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="numNodes")
    def num_nodes(self) -> Optional[int]:
        """
        The number of nodes in your Cloud Bigtable cluster.
        Required, with a minimum of `1` for each cluster in an instance.
        """
        return pulumi.get(self, "num_nodes")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[str]:
        """
        The storage type to use. One of `"SSD"` or
        `"HDD"`. Defaults to `"SSD"`.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        The zone to create the Cloud Bigtable cluster in. If it not
        specified, the provider zone is used. Each cluster must have a different zone in the same region. Zones that support
        Bigtable instances are noted on the [Cloud Bigtable locations page](https://cloud.google.com/bigtable/docs/locations).
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class InstanceClusterAutoscalingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuTarget":
            suggest = "cpu_target"
        elif key == "maxNodes":
            suggest = "max_nodes"
        elif key == "minNodes":
            suggest = "min_nodes"
        elif key == "storageTarget":
            suggest = "storage_target"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceClusterAutoscalingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceClusterAutoscalingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceClusterAutoscalingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_target: int,
                 max_nodes: int,
                 min_nodes: int,
                 storage_target: Optional[int] = None):
        """
        :param int cpu_target: The target CPU utilization for autoscaling, in percentage. Must be between 10 and 80.
        :param int max_nodes: The maximum number of nodes for autoscaling.
        :param int min_nodes: The minimum number of nodes for autoscaling.
        :param int storage_target: The target storage utilization for autoscaling, in GB, for each node in a cluster. This number is limited between 2560 (2.5TiB) and 5120 (5TiB) for a SSD cluster and between 8192 (8TiB) and 16384 (16 TiB) for an HDD cluster. If not set, whatever is already set for the cluster will not change, or if the cluster is just being created, it will use the default value of 2560 for SSD clusters and 8192 for HDD clusters.
        """
        pulumi.set(__self__, "cpu_target", cpu_target)
        pulumi.set(__self__, "max_nodes", max_nodes)
        pulumi.set(__self__, "min_nodes", min_nodes)
        if storage_target is not None:
            pulumi.set(__self__, "storage_target", storage_target)

    @property
    @pulumi.getter(name="cpuTarget")
    def cpu_target(self) -> int:
        """
        The target CPU utilization for autoscaling, in percentage. Must be between 10 and 80.
        """
        return pulumi.get(self, "cpu_target")

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> int:
        """
        The maximum number of nodes for autoscaling.
        """
        return pulumi.get(self, "max_nodes")

    @property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> int:
        """
        The minimum number of nodes for autoscaling.
        """
        return pulumi.get(self, "min_nodes")

    @property
    @pulumi.getter(name="storageTarget")
    def storage_target(self) -> Optional[int]:
        """
        The target storage utilization for autoscaling, in GB, for each node in a cluster. This number is limited between 2560 (2.5TiB) and 5120 (5TiB) for a SSD cluster and between 8192 (8TiB) and 16384 (16 TiB) for an HDD cluster. If not set, whatever is already set for the cluster will not change, or if the cluster is just being created, it will use the default value of 2560 for SSD clusters and 8192 for HDD clusters.
        """
        return pulumi.get(self, "storage_target")


@pulumi.output_type
class InstanceIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class InstanceIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class TableColumnFamily(dict):
    def __init__(__self__, *,
                 family: str):
        """
        :param str family: The name of the column family.
        """
        pulumi.set(__self__, "family", family)

    @property
    @pulumi.getter
    def family(self) -> str:
        """
        The name of the column family.
        """
        return pulumi.get(self, "family")


@pulumi.output_type
class TableIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class TableIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


