# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SubAccountArgs', 'SubAccount']

@pulumi.input_type
class SubAccountArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 master_billing_account: pulumi.Input[str],
                 deletion_policy: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SubAccount resource.
        :param pulumi.Input[str] display_name: The display name of the billing account.
        :param pulumi.Input[str] master_billing_account: The name of the master billing account that the subaccount
               will be created under in the form `{billing_account_id}` or `billingAccounts/{billing_account_id}`.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "master_billing_account", master_billing_account)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The display name of the billing account.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="masterBillingAccount")
    def master_billing_account(self) -> pulumi.Input[str]:
        """
        The name of the master billing account that the subaccount
        will be created under in the form `{billing_account_id}` or `billingAccounts/{billing_account_id}`.
        """
        return pulumi.get(self, "master_billing_account")

    @master_billing_account.setter
    def master_billing_account(self, value: pulumi.Input[str]):
        pulumi.set(self, "master_billing_account", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_policy", value)


@pulumi.input_type
class _SubAccountState:
    def __init__(__self__, *,
                 billing_account_id: Optional[pulumi.Input[str]] = None,
                 deletion_policy: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 master_billing_account: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 open: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering SubAccount resources.
        :param pulumi.Input[str] billing_account_id: The billing account id.
        :param pulumi.Input[str] display_name: The display name of the billing account.
        :param pulumi.Input[str] master_billing_account: The name of the master billing account that the subaccount
               will be created under in the form `{billing_account_id}` or `billingAccounts/{billing_account_id}`.
        :param pulumi.Input[str] name: The resource name of the billing account in the form `billingAccounts/{billing_account_id}`.
        :param pulumi.Input[bool] open: `true` if the billing account is open, `false` if the billing account is closed.
        """
        if billing_account_id is not None:
            pulumi.set(__self__, "billing_account_id", billing_account_id)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if master_billing_account is not None:
            pulumi.set(__self__, "master_billing_account", master_billing_account)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if open is not None:
            pulumi.set(__self__, "open", open)

    @property
    @pulumi.getter(name="billingAccountId")
    def billing_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The billing account id.
        """
        return pulumi.get(self, "billing_account_id")

    @billing_account_id.setter
    def billing_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "billing_account_id", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_policy", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the billing account.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="masterBillingAccount")
    def master_billing_account(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the master billing account that the subaccount
        will be created under in the form `{billing_account_id}` or `billingAccounts/{billing_account_id}`.
        """
        return pulumi.get(self, "master_billing_account")

    @master_billing_account.setter
    def master_billing_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_billing_account", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name of the billing account in the form `billingAccounts/{billing_account_id}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def open(self) -> Optional[pulumi.Input[bool]]:
        """
        `true` if the billing account is open, `false` if the billing account is closed.
        """
        return pulumi.get(self, "open")

    @open.setter
    def open(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "open", value)


class SubAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_policy: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 master_billing_account: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        Billing Subaccounts can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:billing/subAccount:SubAccount default billingAccounts/{billing_account_id}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] display_name: The display name of the billing account.
        :param pulumi.Input[str] master_billing_account: The name of the master billing account that the subaccount
               will be created under in the form `{billing_account_id}` or `billingAccounts/{billing_account_id}`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Billing Subaccounts can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:billing/subAccount:SubAccount default billingAccounts/{billing_account_id}
        ```

        :param str resource_name: The name of the resource.
        :param SubAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_policy: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 master_billing_account: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubAccountArgs.__new__(SubAccountArgs)

            __props__.__dict__["deletion_policy"] = deletion_policy
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if master_billing_account is None and not opts.urn:
                raise TypeError("Missing required property 'master_billing_account'")
            __props__.__dict__["master_billing_account"] = master_billing_account
            __props__.__dict__["billing_account_id"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["open"] = None
        super(SubAccount, __self__).__init__(
            'gcp:billing/subAccount:SubAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            billing_account_id: Optional[pulumi.Input[str]] = None,
            deletion_policy: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            master_billing_account: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            open: Optional[pulumi.Input[bool]] = None) -> 'SubAccount':
        """
        Get an existing SubAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] billing_account_id: The billing account id.
        :param pulumi.Input[str] display_name: The display name of the billing account.
        :param pulumi.Input[str] master_billing_account: The name of the master billing account that the subaccount
               will be created under in the form `{billing_account_id}` or `billingAccounts/{billing_account_id}`.
        :param pulumi.Input[str] name: The resource name of the billing account in the form `billingAccounts/{billing_account_id}`.
        :param pulumi.Input[bool] open: `true` if the billing account is open, `false` if the billing account is closed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubAccountState.__new__(_SubAccountState)

        __props__.__dict__["billing_account_id"] = billing_account_id
        __props__.__dict__["deletion_policy"] = deletion_policy
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["master_billing_account"] = master_billing_account
        __props__.__dict__["name"] = name
        __props__.__dict__["open"] = open
        return SubAccount(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="billingAccountId")
    def billing_account_id(self) -> pulumi.Output[str]:
        """
        The billing account id.
        """
        return pulumi.get(self, "billing_account_id")

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "deletion_policy")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The display name of the billing account.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="masterBillingAccount")
    def master_billing_account(self) -> pulumi.Output[str]:
        """
        The name of the master billing account that the subaccount
        will be created under in the form `{billing_account_id}` or `billingAccounts/{billing_account_id}`.
        """
        return pulumi.get(self, "master_billing_account")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name of the billing account in the form `billingAccounts/{billing_account_id}`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def open(self) -> pulumi.Output[bool]:
        """
        `true` if the billing account is open, `false` if the billing account is closed.
        """
        return pulumi.get(self, "open")

