# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceFromMachineImageArgs', 'InstanceFromMachineImage']

@pulumi.input_type
class InstanceFromMachineImageArgs:
    def __init__(__self__, *,
                 source_machine_image: pulumi.Input[str],
                 advanced_machine_features: Optional[pulumi.Input['InstanceFromMachineImageAdvancedMachineFeaturesArgs']] = None,
                 allow_stopping_for_update: Optional[pulumi.Input[bool]] = None,
                 can_ip_forward: Optional[pulumi.Input[bool]] = None,
                 confidential_instance_config: Optional[pulumi.Input['InstanceFromMachineImageConfidentialInstanceConfigArgs']] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 desired_status: Optional[pulumi.Input[str]] = None,
                 enable_display: Optional[pulumi.Input[bool]] = None,
                 guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageGuestAcceleratorArgs']]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata_startup_script: Optional[pulumi.Input[str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageNetworkInterfaceArgs']]]] = None,
                 network_performance_config: Optional[pulumi.Input['InstanceFromMachineImageNetworkPerformanceConfigArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 reservation_affinity: Optional[pulumi.Input['InstanceFromMachineImageReservationAffinityArgs']] = None,
                 resource_policies: Optional[pulumi.Input[str]] = None,
                 scheduling: Optional[pulumi.Input['InstanceFromMachineImageSchedulingArgs']] = None,
                 service_account: Optional[pulumi.Input['InstanceFromMachineImageServiceAccountArgs']] = None,
                 shielded_instance_config: Optional[pulumi.Input['InstanceFromMachineImageShieldedInstanceConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a InstanceFromMachineImage resource.
        :param pulumi.Input[str] source_machine_image: Name or self link of a machine
               image to create the instance based on.
        :param pulumi.Input['InstanceFromMachineImageAdvancedMachineFeaturesArgs'] advanced_machine_features: Controls for advanced machine-related behavior features.
        :param pulumi.Input[bool] allow_stopping_for_update: If true, allows Terraform to stop the instance to update its properties. If you try to update a property that requires
               stopping the instance without setting this field, the update will fail.
        :param pulumi.Input[bool] can_ip_forward: Whether sending and receiving of packets with non-matching source or destination IPs is allowed.
        :param pulumi.Input['InstanceFromMachineImageConfidentialInstanceConfigArgs'] confidential_instance_config: The Confidential VM config being used by the instance. on_host_maintenance has to be set to TERMINATE or this will fail
               to create.
        :param pulumi.Input[bool] deletion_protection: Whether deletion protection is enabled on this instance.
        :param pulumi.Input[str] description: A brief description of the resource.
        :param pulumi.Input[str] desired_status: Desired status of the instance. Either "RUNNING" or "TERMINATED".
        :param pulumi.Input[bool] enable_display: Whether the instance has virtual displays enabled.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageGuestAcceleratorArgs']]] guest_accelerators: List of the type and count of accelerator cards attached to the instance.
        :param pulumi.Input[str] hostname: A custom hostname for the instance. Must be a fully qualified DNS name and RFC-1035-valid. Valid format is a series of
               labels 1-63 characters long matching the regular expression [a-z]([-a-z0-9]*[a-z0-9]), concatenated with periods. The
               entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs assigned to the instance.
        :param pulumi.Input[str] machine_type: The machine type to create.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Metadata key/value pairs made available within the instance.
        :param pulumi.Input[str] metadata_startup_script: Metadata startup scripts made available within the instance.
        :param pulumi.Input[str] min_cpu_platform: The minimum CPU platform specified for the VM instance.
        :param pulumi.Input[str] name: A unique name for the resource, required by GCE.
               Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageNetworkInterfaceArgs']]] network_interfaces: The networks attached to the instance.
        :param pulumi.Input['InstanceFromMachineImageNetworkPerformanceConfigArgs'] network_performance_config: Configures network performance settings for the instance. If not specified, the instance will be created with its
               default network performance configuration.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If self_link is provided, this value is ignored. If neither
               self_link nor project are provided, the provider project is used.
        :param pulumi.Input['InstanceFromMachineImageReservationAffinityArgs'] reservation_affinity: Specifies the reservations that this instance can consume from.
        :param pulumi.Input[str] resource_policies: A list of self_links of resource policies to attach to the instance. Currently a max of 1 resource policy is supported.
        :param pulumi.Input['InstanceFromMachineImageSchedulingArgs'] scheduling: The scheduling strategy being used by the instance.
        :param pulumi.Input['InstanceFromMachineImageServiceAccountArgs'] service_account: The service account to attach to the instance.
        :param pulumi.Input['InstanceFromMachineImageShieldedInstanceConfigArgs'] shielded_instance_config: The shielded vm config being used by the instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The list of tags attached to the instance.
        :param pulumi.Input[str] zone: The zone that the machine should be created in. If not
               set, the provider zone is used.
        """
        pulumi.set(__self__, "source_machine_image", source_machine_image)
        if advanced_machine_features is not None:
            pulumi.set(__self__, "advanced_machine_features", advanced_machine_features)
        if allow_stopping_for_update is not None:
            pulumi.set(__self__, "allow_stopping_for_update", allow_stopping_for_update)
        if can_ip_forward is not None:
            pulumi.set(__self__, "can_ip_forward", can_ip_forward)
        if confidential_instance_config is not None:
            pulumi.set(__self__, "confidential_instance_config", confidential_instance_config)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if desired_status is not None:
            pulumi.set(__self__, "desired_status", desired_status)
        if enable_display is not None:
            pulumi.set(__self__, "enable_display", enable_display)
        if guest_accelerators is not None:
            pulumi.set(__self__, "guest_accelerators", guest_accelerators)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_startup_script is not None:
            pulumi.set(__self__, "metadata_startup_script", metadata_startup_script)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if network_performance_config is not None:
            pulumi.set(__self__, "network_performance_config", network_performance_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reservation_affinity is not None:
            pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        if resource_policies is not None:
            pulumi.set(__self__, "resource_policies", resource_policies)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="sourceMachineImage")
    def source_machine_image(self) -> pulumi.Input[str]:
        """
        Name or self link of a machine
        image to create the instance based on.
        """
        return pulumi.get(self, "source_machine_image")

    @source_machine_image.setter
    def source_machine_image(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_machine_image", value)

    @property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> Optional[pulumi.Input['InstanceFromMachineImageAdvancedMachineFeaturesArgs']]:
        """
        Controls for advanced machine-related behavior features.
        """
        return pulumi.get(self, "advanced_machine_features")

    @advanced_machine_features.setter
    def advanced_machine_features(self, value: Optional[pulumi.Input['InstanceFromMachineImageAdvancedMachineFeaturesArgs']]):
        pulumi.set(self, "advanced_machine_features", value)

    @property
    @pulumi.getter(name="allowStoppingForUpdate")
    def allow_stopping_for_update(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, allows Terraform to stop the instance to update its properties. If you try to update a property that requires
        stopping the instance without setting this field, the update will fail.
        """
        return pulumi.get(self, "allow_stopping_for_update")

    @allow_stopping_for_update.setter
    def allow_stopping_for_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_stopping_for_update", value)

    @property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether sending and receiving of packets with non-matching source or destination IPs is allowed.
        """
        return pulumi.get(self, "can_ip_forward")

    @can_ip_forward.setter
    def can_ip_forward(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_ip_forward", value)

    @property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> Optional[pulumi.Input['InstanceFromMachineImageConfidentialInstanceConfigArgs']]:
        """
        The Confidential VM config being used by the instance. on_host_maintenance has to be set to TERMINATE or this will fail
        to create.
        """
        return pulumi.get(self, "confidential_instance_config")

    @confidential_instance_config.setter
    def confidential_instance_config(self, value: Optional[pulumi.Input['InstanceFromMachineImageConfidentialInstanceConfigArgs']]):
        pulumi.set(self, "confidential_instance_config", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether deletion protection is enabled on this instance.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A brief description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="desiredStatus")
    def desired_status(self) -> Optional[pulumi.Input[str]]:
        """
        Desired status of the instance. Either "RUNNING" or "TERMINATED".
        """
        return pulumi.get(self, "desired_status")

    @desired_status.setter
    def desired_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desired_status", value)

    @property
    @pulumi.getter(name="enableDisplay")
    def enable_display(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the instance has virtual displays enabled.
        """
        return pulumi.get(self, "enable_display")

    @enable_display.setter
    def enable_display(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_display", value)

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageGuestAcceleratorArgs']]]]:
        """
        List of the type and count of accelerator cards attached to the instance.
        """
        return pulumi.get(self, "guest_accelerators")

    @guest_accelerators.setter
    def guest_accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageGuestAcceleratorArgs']]]]):
        pulumi.set(self, "guest_accelerators", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        A custom hostname for the instance. Must be a fully qualified DNS name and RFC-1035-valid. Valid format is a series of
        labels 1-63 characters long matching the regular expression [a-z]([-a-z0-9]*[a-z0-9]), concatenated with periods. The
        entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs assigned to the instance.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The machine type to create.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Metadata key/value pairs made available within the instance.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="metadataStartupScript")
    def metadata_startup_script(self) -> Optional[pulumi.Input[str]]:
        """
        Metadata startup scripts made available within the instance.
        """
        return pulumi.get(self, "metadata_startup_script")

    @metadata_startup_script.setter
    def metadata_startup_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata_startup_script", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum CPU platform specified for the VM instance.
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name for the resource, required by GCE.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageNetworkInterfaceArgs']]]]:
        """
        The networks attached to the instance.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="networkPerformanceConfig")
    def network_performance_config(self) -> Optional[pulumi.Input['InstanceFromMachineImageNetworkPerformanceConfigArgs']]:
        """
        Configures network performance settings for the instance. If not specified, the instance will be created with its
        default network performance configuration.
        """
        return pulumi.get(self, "network_performance_config")

    @network_performance_config.setter
    def network_performance_config(self, value: Optional[pulumi.Input['InstanceFromMachineImageNetworkPerformanceConfigArgs']]):
        pulumi.set(self, "network_performance_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs. If self_link is provided, this value is ignored. If neither
        self_link nor project are provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> Optional[pulumi.Input['InstanceFromMachineImageReservationAffinityArgs']]:
        """
        Specifies the reservations that this instance can consume from.
        """
        return pulumi.get(self, "reservation_affinity")

    @reservation_affinity.setter
    def reservation_affinity(self, value: Optional[pulumi.Input['InstanceFromMachineImageReservationAffinityArgs']]):
        pulumi.set(self, "reservation_affinity", value)

    @property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> Optional[pulumi.Input[str]]:
        """
        A list of self_links of resource policies to attach to the instance. Currently a max of 1 resource policy is supported.
        """
        return pulumi.get(self, "resource_policies")

    @resource_policies.setter
    def resource_policies(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_policies", value)

    @property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['InstanceFromMachineImageSchedulingArgs']]:
        """
        The scheduling strategy being used by the instance.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['InstanceFromMachineImageSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input['InstanceFromMachineImageServiceAccountArgs']]:
        """
        The service account to attach to the instance.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input['InstanceFromMachineImageServiceAccountArgs']]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['InstanceFromMachineImageShieldedInstanceConfigArgs']]:
        """
        The shielded vm config being used by the instance.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['InstanceFromMachineImageShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of tags attached to the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The zone that the machine should be created in. If not
        set, the provider zone is used.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _InstanceFromMachineImageState:
    def __init__(__self__, *,
                 advanced_machine_features: Optional[pulumi.Input['InstanceFromMachineImageAdvancedMachineFeaturesArgs']] = None,
                 allow_stopping_for_update: Optional[pulumi.Input[bool]] = None,
                 attached_disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageAttachedDiskArgs']]]] = None,
                 boot_disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageBootDiskArgs']]]] = None,
                 can_ip_forward: Optional[pulumi.Input[bool]] = None,
                 confidential_instance_config: Optional[pulumi.Input['InstanceFromMachineImageConfidentialInstanceConfigArgs']] = None,
                 cpu_platform: Optional[pulumi.Input[str]] = None,
                 current_status: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 desired_status: Optional[pulumi.Input[str]] = None,
                 enable_display: Optional[pulumi.Input[bool]] = None,
                 guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageGuestAcceleratorArgs']]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 label_fingerprint: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata_fingerprint: Optional[pulumi.Input[str]] = None,
                 metadata_startup_script: Optional[pulumi.Input[str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageNetworkInterfaceArgs']]]] = None,
                 network_performance_config: Optional[pulumi.Input['InstanceFromMachineImageNetworkPerformanceConfigArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 reservation_affinity: Optional[pulumi.Input['InstanceFromMachineImageReservationAffinityArgs']] = None,
                 resource_policies: Optional[pulumi.Input[str]] = None,
                 scheduling: Optional[pulumi.Input['InstanceFromMachineImageSchedulingArgs']] = None,
                 scratch_disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageScratchDiskArgs']]]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 service_account: Optional[pulumi.Input['InstanceFromMachineImageServiceAccountArgs']] = None,
                 shielded_instance_config: Optional[pulumi.Input['InstanceFromMachineImageShieldedInstanceConfigArgs']] = None,
                 source_machine_image: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags_fingerprint: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering InstanceFromMachineImage resources.
        :param pulumi.Input['InstanceFromMachineImageAdvancedMachineFeaturesArgs'] advanced_machine_features: Controls for advanced machine-related behavior features.
        :param pulumi.Input[bool] allow_stopping_for_update: If true, allows Terraform to stop the instance to update its properties. If you try to update a property that requires
               stopping the instance without setting this field, the update will fail.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageAttachedDiskArgs']]] attached_disks: List of disks attached to the instance
        :param pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageBootDiskArgs']]] boot_disks: The boot disk for the instance.
        :param pulumi.Input[bool] can_ip_forward: Whether sending and receiving of packets with non-matching source or destination IPs is allowed.
        :param pulumi.Input['InstanceFromMachineImageConfidentialInstanceConfigArgs'] confidential_instance_config: The Confidential VM config being used by the instance. on_host_maintenance has to be set to TERMINATE or this will fail
               to create.
        :param pulumi.Input[str] cpu_platform: The CPU platform used by this instance.
        :param pulumi.Input[str] current_status: Current status of the instance.
        :param pulumi.Input[bool] deletion_protection: Whether deletion protection is enabled on this instance.
        :param pulumi.Input[str] description: A brief description of the resource.
        :param pulumi.Input[str] desired_status: Desired status of the instance. Either "RUNNING" or "TERMINATED".
        :param pulumi.Input[bool] enable_display: Whether the instance has virtual displays enabled.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageGuestAcceleratorArgs']]] guest_accelerators: List of the type and count of accelerator cards attached to the instance.
        :param pulumi.Input[str] hostname: A custom hostname for the instance. Must be a fully qualified DNS name and RFC-1035-valid. Valid format is a series of
               labels 1-63 characters long matching the regular expression [a-z]([-a-z0-9]*[a-z0-9]), concatenated with periods. The
               entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
        :param pulumi.Input[str] instance_id: The server-assigned unique identifier of this instance.
        :param pulumi.Input[str] label_fingerprint: The unique fingerprint of the labels.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs assigned to the instance.
        :param pulumi.Input[str] machine_type: The machine type to create.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Metadata key/value pairs made available within the instance.
        :param pulumi.Input[str] metadata_fingerprint: The unique fingerprint of the metadata.
        :param pulumi.Input[str] metadata_startup_script: Metadata startup scripts made available within the instance.
        :param pulumi.Input[str] min_cpu_platform: The minimum CPU platform specified for the VM instance.
        :param pulumi.Input[str] name: A unique name for the resource, required by GCE.
               Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageNetworkInterfaceArgs']]] network_interfaces: The networks attached to the instance.
        :param pulumi.Input['InstanceFromMachineImageNetworkPerformanceConfigArgs'] network_performance_config: Configures network performance settings for the instance. If not specified, the instance will be created with its
               default network performance configuration.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If self_link is provided, this value is ignored. If neither
               self_link nor project are provided, the provider project is used.
        :param pulumi.Input['InstanceFromMachineImageReservationAffinityArgs'] reservation_affinity: Specifies the reservations that this instance can consume from.
        :param pulumi.Input[str] resource_policies: A list of self_links of resource policies to attach to the instance. Currently a max of 1 resource policy is supported.
        :param pulumi.Input['InstanceFromMachineImageSchedulingArgs'] scheduling: The scheduling strategy being used by the instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageScratchDiskArgs']]] scratch_disks: The scratch disks attached to the instance.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input['InstanceFromMachineImageServiceAccountArgs'] service_account: The service account to attach to the instance.
        :param pulumi.Input['InstanceFromMachineImageShieldedInstanceConfigArgs'] shielded_instance_config: The shielded vm config being used by the instance.
        :param pulumi.Input[str] source_machine_image: Name or self link of a machine
               image to create the instance based on.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The list of tags attached to the instance.
        :param pulumi.Input[str] tags_fingerprint: The unique fingerprint of the tags.
        :param pulumi.Input[str] zone: The zone that the machine should be created in. If not
               set, the provider zone is used.
        """
        if advanced_machine_features is not None:
            pulumi.set(__self__, "advanced_machine_features", advanced_machine_features)
        if allow_stopping_for_update is not None:
            pulumi.set(__self__, "allow_stopping_for_update", allow_stopping_for_update)
        if attached_disks is not None:
            pulumi.set(__self__, "attached_disks", attached_disks)
        if boot_disks is not None:
            pulumi.set(__self__, "boot_disks", boot_disks)
        if can_ip_forward is not None:
            pulumi.set(__self__, "can_ip_forward", can_ip_forward)
        if confidential_instance_config is not None:
            pulumi.set(__self__, "confidential_instance_config", confidential_instance_config)
        if cpu_platform is not None:
            pulumi.set(__self__, "cpu_platform", cpu_platform)
        if current_status is not None:
            pulumi.set(__self__, "current_status", current_status)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if desired_status is not None:
            pulumi.set(__self__, "desired_status", desired_status)
        if enable_display is not None:
            pulumi.set(__self__, "enable_display", enable_display)
        if guest_accelerators is not None:
            pulumi.set(__self__, "guest_accelerators", guest_accelerators)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if label_fingerprint is not None:
            pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_fingerprint is not None:
            pulumi.set(__self__, "metadata_fingerprint", metadata_fingerprint)
        if metadata_startup_script is not None:
            pulumi.set(__self__, "metadata_startup_script", metadata_startup_script)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if network_performance_config is not None:
            pulumi.set(__self__, "network_performance_config", network_performance_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reservation_affinity is not None:
            pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        if resource_policies is not None:
            pulumi.set(__self__, "resource_policies", resource_policies)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if scratch_disks is not None:
            pulumi.set(__self__, "scratch_disks", scratch_disks)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if source_machine_image is not None:
            pulumi.set(__self__, "source_machine_image", source_machine_image)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_fingerprint is not None:
            pulumi.set(__self__, "tags_fingerprint", tags_fingerprint)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> Optional[pulumi.Input['InstanceFromMachineImageAdvancedMachineFeaturesArgs']]:
        """
        Controls for advanced machine-related behavior features.
        """
        return pulumi.get(self, "advanced_machine_features")

    @advanced_machine_features.setter
    def advanced_machine_features(self, value: Optional[pulumi.Input['InstanceFromMachineImageAdvancedMachineFeaturesArgs']]):
        pulumi.set(self, "advanced_machine_features", value)

    @property
    @pulumi.getter(name="allowStoppingForUpdate")
    def allow_stopping_for_update(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, allows Terraform to stop the instance to update its properties. If you try to update a property that requires
        stopping the instance without setting this field, the update will fail.
        """
        return pulumi.get(self, "allow_stopping_for_update")

    @allow_stopping_for_update.setter
    def allow_stopping_for_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_stopping_for_update", value)

    @property
    @pulumi.getter(name="attachedDisks")
    def attached_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageAttachedDiskArgs']]]]:
        """
        List of disks attached to the instance
        """
        return pulumi.get(self, "attached_disks")

    @attached_disks.setter
    def attached_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageAttachedDiskArgs']]]]):
        pulumi.set(self, "attached_disks", value)

    @property
    @pulumi.getter(name="bootDisks")
    def boot_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageBootDiskArgs']]]]:
        """
        The boot disk for the instance.
        """
        return pulumi.get(self, "boot_disks")

    @boot_disks.setter
    def boot_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageBootDiskArgs']]]]):
        pulumi.set(self, "boot_disks", value)

    @property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether sending and receiving of packets with non-matching source or destination IPs is allowed.
        """
        return pulumi.get(self, "can_ip_forward")

    @can_ip_forward.setter
    def can_ip_forward(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_ip_forward", value)

    @property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> Optional[pulumi.Input['InstanceFromMachineImageConfidentialInstanceConfigArgs']]:
        """
        The Confidential VM config being used by the instance. on_host_maintenance has to be set to TERMINATE or this will fail
        to create.
        """
        return pulumi.get(self, "confidential_instance_config")

    @confidential_instance_config.setter
    def confidential_instance_config(self, value: Optional[pulumi.Input['InstanceFromMachineImageConfidentialInstanceConfigArgs']]):
        pulumi.set(self, "confidential_instance_config", value)

    @property
    @pulumi.getter(name="cpuPlatform")
    def cpu_platform(self) -> Optional[pulumi.Input[str]]:
        """
        The CPU platform used by this instance.
        """
        return pulumi.get(self, "cpu_platform")

    @cpu_platform.setter
    def cpu_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu_platform", value)

    @property
    @pulumi.getter(name="currentStatus")
    def current_status(self) -> Optional[pulumi.Input[str]]:
        """
        Current status of the instance.
        """
        return pulumi.get(self, "current_status")

    @current_status.setter
    def current_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_status", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether deletion protection is enabled on this instance.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A brief description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="desiredStatus")
    def desired_status(self) -> Optional[pulumi.Input[str]]:
        """
        Desired status of the instance. Either "RUNNING" or "TERMINATED".
        """
        return pulumi.get(self, "desired_status")

    @desired_status.setter
    def desired_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desired_status", value)

    @property
    @pulumi.getter(name="enableDisplay")
    def enable_display(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the instance has virtual displays enabled.
        """
        return pulumi.get(self, "enable_display")

    @enable_display.setter
    def enable_display(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_display", value)

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageGuestAcceleratorArgs']]]]:
        """
        List of the type and count of accelerator cards attached to the instance.
        """
        return pulumi.get(self, "guest_accelerators")

    @guest_accelerators.setter
    def guest_accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageGuestAcceleratorArgs']]]]):
        pulumi.set(self, "guest_accelerators", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        A custom hostname for the instance. Must be a fully qualified DNS name and RFC-1035-valid. Valid format is a series of
        labels 1-63 characters long matching the regular expression [a-z]([-a-z0-9]*[a-z0-9]), concatenated with periods. The
        entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The server-assigned unique identifier of this instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        The unique fingerprint of the labels.
        """
        return pulumi.get(self, "label_fingerprint")

    @label_fingerprint.setter
    def label_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label_fingerprint", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs assigned to the instance.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The machine type to create.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Metadata key/value pairs made available within the instance.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="metadataFingerprint")
    def metadata_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        The unique fingerprint of the metadata.
        """
        return pulumi.get(self, "metadata_fingerprint")

    @metadata_fingerprint.setter
    def metadata_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata_fingerprint", value)

    @property
    @pulumi.getter(name="metadataStartupScript")
    def metadata_startup_script(self) -> Optional[pulumi.Input[str]]:
        """
        Metadata startup scripts made available within the instance.
        """
        return pulumi.get(self, "metadata_startup_script")

    @metadata_startup_script.setter
    def metadata_startup_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata_startup_script", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum CPU platform specified for the VM instance.
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name for the resource, required by GCE.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageNetworkInterfaceArgs']]]]:
        """
        The networks attached to the instance.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="networkPerformanceConfig")
    def network_performance_config(self) -> Optional[pulumi.Input['InstanceFromMachineImageNetworkPerformanceConfigArgs']]:
        """
        Configures network performance settings for the instance. If not specified, the instance will be created with its
        default network performance configuration.
        """
        return pulumi.get(self, "network_performance_config")

    @network_performance_config.setter
    def network_performance_config(self, value: Optional[pulumi.Input['InstanceFromMachineImageNetworkPerformanceConfigArgs']]):
        pulumi.set(self, "network_performance_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs. If self_link is provided, this value is ignored. If neither
        self_link nor project are provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> Optional[pulumi.Input['InstanceFromMachineImageReservationAffinityArgs']]:
        """
        Specifies the reservations that this instance can consume from.
        """
        return pulumi.get(self, "reservation_affinity")

    @reservation_affinity.setter
    def reservation_affinity(self, value: Optional[pulumi.Input['InstanceFromMachineImageReservationAffinityArgs']]):
        pulumi.set(self, "reservation_affinity", value)

    @property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> Optional[pulumi.Input[str]]:
        """
        A list of self_links of resource policies to attach to the instance. Currently a max of 1 resource policy is supported.
        """
        return pulumi.get(self, "resource_policies")

    @resource_policies.setter
    def resource_policies(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_policies", value)

    @property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['InstanceFromMachineImageSchedulingArgs']]:
        """
        The scheduling strategy being used by the instance.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['InstanceFromMachineImageSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @property
    @pulumi.getter(name="scratchDisks")
    def scratch_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageScratchDiskArgs']]]]:
        """
        The scratch disks attached to the instance.
        """
        return pulumi.get(self, "scratch_disks")

    @scratch_disks.setter
    def scratch_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFromMachineImageScratchDiskArgs']]]]):
        pulumi.set(self, "scratch_disks", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input['InstanceFromMachineImageServiceAccountArgs']]:
        """
        The service account to attach to the instance.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input['InstanceFromMachineImageServiceAccountArgs']]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['InstanceFromMachineImageShieldedInstanceConfigArgs']]:
        """
        The shielded vm config being used by the instance.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['InstanceFromMachineImageShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @property
    @pulumi.getter(name="sourceMachineImage")
    def source_machine_image(self) -> Optional[pulumi.Input[str]]:
        """
        Name or self link of a machine
        image to create the instance based on.
        """
        return pulumi.get(self, "source_machine_image")

    @source_machine_image.setter
    def source_machine_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_machine_image", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of tags attached to the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsFingerprint")
    def tags_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        The unique fingerprint of the tags.
        """
        return pulumi.get(self, "tags_fingerprint")

    @tags_fingerprint.setter
    def tags_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tags_fingerprint", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The zone that the machine should be created in. If not
        set, the provider zone is used.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class InstanceFromMachineImage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_machine_features: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageAdvancedMachineFeaturesArgs']]] = None,
                 allow_stopping_for_update: Optional[pulumi.Input[bool]] = None,
                 can_ip_forward: Optional[pulumi.Input[bool]] = None,
                 confidential_instance_config: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageConfidentialInstanceConfigArgs']]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 desired_status: Optional[pulumi.Input[str]] = None,
                 enable_display: Optional[pulumi.Input[bool]] = None,
                 guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFromMachineImageGuestAcceleratorArgs']]]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata_startup_script: Optional[pulumi.Input[str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFromMachineImageNetworkInterfaceArgs']]]]] = None,
                 network_performance_config: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageNetworkPerformanceConfigArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 reservation_affinity: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageReservationAffinityArgs']]] = None,
                 resource_policies: Optional[pulumi.Input[str]] = None,
                 scheduling: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageSchedulingArgs']]] = None,
                 service_account: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageServiceAccountArgs']]] = None,
                 shielded_instance_config: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageShieldedInstanceConfigArgs']]] = None,
                 source_machine_image: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tpl = gcp.compute.InstanceFromMachineImage("tpl",
            zone="us-central1-a",
            source_machine_image="projects/PROJECT-ID/global/machineImages/NAME",
            can_ip_forward=False,
            labels={
                "my_key": "my_value",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InstanceFromMachineImageAdvancedMachineFeaturesArgs']] advanced_machine_features: Controls for advanced machine-related behavior features.
        :param pulumi.Input[bool] allow_stopping_for_update: If true, allows Terraform to stop the instance to update its properties. If you try to update a property that requires
               stopping the instance without setting this field, the update will fail.
        :param pulumi.Input[bool] can_ip_forward: Whether sending and receiving of packets with non-matching source or destination IPs is allowed.
        :param pulumi.Input[pulumi.InputType['InstanceFromMachineImageConfidentialInstanceConfigArgs']] confidential_instance_config: The Confidential VM config being used by the instance. on_host_maintenance has to be set to TERMINATE or this will fail
               to create.
        :param pulumi.Input[bool] deletion_protection: Whether deletion protection is enabled on this instance.
        :param pulumi.Input[str] description: A brief description of the resource.
        :param pulumi.Input[str] desired_status: Desired status of the instance. Either "RUNNING" or "TERMINATED".
        :param pulumi.Input[bool] enable_display: Whether the instance has virtual displays enabled.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFromMachineImageGuestAcceleratorArgs']]]] guest_accelerators: List of the type and count of accelerator cards attached to the instance.
        :param pulumi.Input[str] hostname: A custom hostname for the instance. Must be a fully qualified DNS name and RFC-1035-valid. Valid format is a series of
               labels 1-63 characters long matching the regular expression [a-z]([-a-z0-9]*[a-z0-9]), concatenated with periods. The
               entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs assigned to the instance.
        :param pulumi.Input[str] machine_type: The machine type to create.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Metadata key/value pairs made available within the instance.
        :param pulumi.Input[str] metadata_startup_script: Metadata startup scripts made available within the instance.
        :param pulumi.Input[str] min_cpu_platform: The minimum CPU platform specified for the VM instance.
        :param pulumi.Input[str] name: A unique name for the resource, required by GCE.
               Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFromMachineImageNetworkInterfaceArgs']]]] network_interfaces: The networks attached to the instance.
        :param pulumi.Input[pulumi.InputType['InstanceFromMachineImageNetworkPerformanceConfigArgs']] network_performance_config: Configures network performance settings for the instance. If not specified, the instance will be created with its
               default network performance configuration.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If self_link is provided, this value is ignored. If neither
               self_link nor project are provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['InstanceFromMachineImageReservationAffinityArgs']] reservation_affinity: Specifies the reservations that this instance can consume from.
        :param pulumi.Input[str] resource_policies: A list of self_links of resource policies to attach to the instance. Currently a max of 1 resource policy is supported.
        :param pulumi.Input[pulumi.InputType['InstanceFromMachineImageSchedulingArgs']] scheduling: The scheduling strategy being used by the instance.
        :param pulumi.Input[pulumi.InputType['InstanceFromMachineImageServiceAccountArgs']] service_account: The service account to attach to the instance.
        :param pulumi.Input[pulumi.InputType['InstanceFromMachineImageShieldedInstanceConfigArgs']] shielded_instance_config: The shielded vm config being used by the instance.
        :param pulumi.Input[str] source_machine_image: Name or self link of a machine
               image to create the instance based on.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The list of tags attached to the instance.
        :param pulumi.Input[str] zone: The zone that the machine should be created in. If not
               set, the provider zone is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceFromMachineImageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tpl = gcp.compute.InstanceFromMachineImage("tpl",
            zone="us-central1-a",
            source_machine_image="projects/PROJECT-ID/global/machineImages/NAME",
            can_ip_forward=False,
            labels={
                "my_key": "my_value",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        :param str resource_name: The name of the resource.
        :param InstanceFromMachineImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceFromMachineImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_machine_features: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageAdvancedMachineFeaturesArgs']]] = None,
                 allow_stopping_for_update: Optional[pulumi.Input[bool]] = None,
                 can_ip_forward: Optional[pulumi.Input[bool]] = None,
                 confidential_instance_config: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageConfidentialInstanceConfigArgs']]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 desired_status: Optional[pulumi.Input[str]] = None,
                 enable_display: Optional[pulumi.Input[bool]] = None,
                 guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFromMachineImageGuestAcceleratorArgs']]]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata_startup_script: Optional[pulumi.Input[str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFromMachineImageNetworkInterfaceArgs']]]]] = None,
                 network_performance_config: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageNetworkPerformanceConfigArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 reservation_affinity: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageReservationAffinityArgs']]] = None,
                 resource_policies: Optional[pulumi.Input[str]] = None,
                 scheduling: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageSchedulingArgs']]] = None,
                 service_account: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageServiceAccountArgs']]] = None,
                 shielded_instance_config: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageShieldedInstanceConfigArgs']]] = None,
                 source_machine_image: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceFromMachineImageArgs.__new__(InstanceFromMachineImageArgs)

            __props__.__dict__["advanced_machine_features"] = advanced_machine_features
            __props__.__dict__["allow_stopping_for_update"] = allow_stopping_for_update
            __props__.__dict__["can_ip_forward"] = can_ip_forward
            __props__.__dict__["confidential_instance_config"] = confidential_instance_config
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["desired_status"] = desired_status
            __props__.__dict__["enable_display"] = enable_display
            __props__.__dict__["guest_accelerators"] = guest_accelerators
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["labels"] = labels
            __props__.__dict__["machine_type"] = machine_type
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["metadata_startup_script"] = metadata_startup_script
            __props__.__dict__["min_cpu_platform"] = min_cpu_platform
            __props__.__dict__["name"] = name
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["network_performance_config"] = network_performance_config
            __props__.__dict__["project"] = project
            __props__.__dict__["reservation_affinity"] = reservation_affinity
            __props__.__dict__["resource_policies"] = resource_policies
            __props__.__dict__["scheduling"] = scheduling
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["shielded_instance_config"] = shielded_instance_config
            if source_machine_image is None and not opts.urn:
                raise TypeError("Missing required property 'source_machine_image'")
            __props__.__dict__["source_machine_image"] = source_machine_image
            __props__.__dict__["tags"] = tags
            __props__.__dict__["zone"] = zone
            __props__.__dict__["attached_disks"] = None
            __props__.__dict__["boot_disks"] = None
            __props__.__dict__["cpu_platform"] = None
            __props__.__dict__["current_status"] = None
            __props__.__dict__["instance_id"] = None
            __props__.__dict__["label_fingerprint"] = None
            __props__.__dict__["metadata_fingerprint"] = None
            __props__.__dict__["scratch_disks"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["tags_fingerprint"] = None
        super(InstanceFromMachineImage, __self__).__init__(
            'gcp:compute/instanceFromMachineImage:InstanceFromMachineImage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_machine_features: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageAdvancedMachineFeaturesArgs']]] = None,
            allow_stopping_for_update: Optional[pulumi.Input[bool]] = None,
            attached_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFromMachineImageAttachedDiskArgs']]]]] = None,
            boot_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFromMachineImageBootDiskArgs']]]]] = None,
            can_ip_forward: Optional[pulumi.Input[bool]] = None,
            confidential_instance_config: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageConfidentialInstanceConfigArgs']]] = None,
            cpu_platform: Optional[pulumi.Input[str]] = None,
            current_status: Optional[pulumi.Input[str]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            desired_status: Optional[pulumi.Input[str]] = None,
            enable_display: Optional[pulumi.Input[bool]] = None,
            guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFromMachineImageGuestAcceleratorArgs']]]]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            label_fingerprint: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            machine_type: Optional[pulumi.Input[str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            metadata_fingerprint: Optional[pulumi.Input[str]] = None,
            metadata_startup_script: Optional[pulumi.Input[str]] = None,
            min_cpu_platform: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFromMachineImageNetworkInterfaceArgs']]]]] = None,
            network_performance_config: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageNetworkPerformanceConfigArgs']]] = None,
            project: Optional[pulumi.Input[str]] = None,
            reservation_affinity: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageReservationAffinityArgs']]] = None,
            resource_policies: Optional[pulumi.Input[str]] = None,
            scheduling: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageSchedulingArgs']]] = None,
            scratch_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFromMachineImageScratchDiskArgs']]]]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            service_account: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageServiceAccountArgs']]] = None,
            shielded_instance_config: Optional[pulumi.Input[pulumi.InputType['InstanceFromMachineImageShieldedInstanceConfigArgs']]] = None,
            source_machine_image: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags_fingerprint: Optional[pulumi.Input[str]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'InstanceFromMachineImage':
        """
        Get an existing InstanceFromMachineImage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InstanceFromMachineImageAdvancedMachineFeaturesArgs']] advanced_machine_features: Controls for advanced machine-related behavior features.
        :param pulumi.Input[bool] allow_stopping_for_update: If true, allows Terraform to stop the instance to update its properties. If you try to update a property that requires
               stopping the instance without setting this field, the update will fail.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFromMachineImageAttachedDiskArgs']]]] attached_disks: List of disks attached to the instance
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFromMachineImageBootDiskArgs']]]] boot_disks: The boot disk for the instance.
        :param pulumi.Input[bool] can_ip_forward: Whether sending and receiving of packets with non-matching source or destination IPs is allowed.
        :param pulumi.Input[pulumi.InputType['InstanceFromMachineImageConfidentialInstanceConfigArgs']] confidential_instance_config: The Confidential VM config being used by the instance. on_host_maintenance has to be set to TERMINATE or this will fail
               to create.
        :param pulumi.Input[str] cpu_platform: The CPU platform used by this instance.
        :param pulumi.Input[str] current_status: Current status of the instance.
        :param pulumi.Input[bool] deletion_protection: Whether deletion protection is enabled on this instance.
        :param pulumi.Input[str] description: A brief description of the resource.
        :param pulumi.Input[str] desired_status: Desired status of the instance. Either "RUNNING" or "TERMINATED".
        :param pulumi.Input[bool] enable_display: Whether the instance has virtual displays enabled.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFromMachineImageGuestAcceleratorArgs']]]] guest_accelerators: List of the type and count of accelerator cards attached to the instance.
        :param pulumi.Input[str] hostname: A custom hostname for the instance. Must be a fully qualified DNS name and RFC-1035-valid. Valid format is a series of
               labels 1-63 characters long matching the regular expression [a-z]([-a-z0-9]*[a-z0-9]), concatenated with periods. The
               entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
        :param pulumi.Input[str] instance_id: The server-assigned unique identifier of this instance.
        :param pulumi.Input[str] label_fingerprint: The unique fingerprint of the labels.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs assigned to the instance.
        :param pulumi.Input[str] machine_type: The machine type to create.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Metadata key/value pairs made available within the instance.
        :param pulumi.Input[str] metadata_fingerprint: The unique fingerprint of the metadata.
        :param pulumi.Input[str] metadata_startup_script: Metadata startup scripts made available within the instance.
        :param pulumi.Input[str] min_cpu_platform: The minimum CPU platform specified for the VM instance.
        :param pulumi.Input[str] name: A unique name for the resource, required by GCE.
               Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFromMachineImageNetworkInterfaceArgs']]]] network_interfaces: The networks attached to the instance.
        :param pulumi.Input[pulumi.InputType['InstanceFromMachineImageNetworkPerformanceConfigArgs']] network_performance_config: Configures network performance settings for the instance. If not specified, the instance will be created with its
               default network performance configuration.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If self_link is provided, this value is ignored. If neither
               self_link nor project are provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['InstanceFromMachineImageReservationAffinityArgs']] reservation_affinity: Specifies the reservations that this instance can consume from.
        :param pulumi.Input[str] resource_policies: A list of self_links of resource policies to attach to the instance. Currently a max of 1 resource policy is supported.
        :param pulumi.Input[pulumi.InputType['InstanceFromMachineImageSchedulingArgs']] scheduling: The scheduling strategy being used by the instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFromMachineImageScratchDiskArgs']]]] scratch_disks: The scratch disks attached to the instance.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[pulumi.InputType['InstanceFromMachineImageServiceAccountArgs']] service_account: The service account to attach to the instance.
        :param pulumi.Input[pulumi.InputType['InstanceFromMachineImageShieldedInstanceConfigArgs']] shielded_instance_config: The shielded vm config being used by the instance.
        :param pulumi.Input[str] source_machine_image: Name or self link of a machine
               image to create the instance based on.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The list of tags attached to the instance.
        :param pulumi.Input[str] tags_fingerprint: The unique fingerprint of the tags.
        :param pulumi.Input[str] zone: The zone that the machine should be created in. If not
               set, the provider zone is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceFromMachineImageState.__new__(_InstanceFromMachineImageState)

        __props__.__dict__["advanced_machine_features"] = advanced_machine_features
        __props__.__dict__["allow_stopping_for_update"] = allow_stopping_for_update
        __props__.__dict__["attached_disks"] = attached_disks
        __props__.__dict__["boot_disks"] = boot_disks
        __props__.__dict__["can_ip_forward"] = can_ip_forward
        __props__.__dict__["confidential_instance_config"] = confidential_instance_config
        __props__.__dict__["cpu_platform"] = cpu_platform
        __props__.__dict__["current_status"] = current_status
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["desired_status"] = desired_status
        __props__.__dict__["enable_display"] = enable_display
        __props__.__dict__["guest_accelerators"] = guest_accelerators
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["label_fingerprint"] = label_fingerprint
        __props__.__dict__["labels"] = labels
        __props__.__dict__["machine_type"] = machine_type
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["metadata_fingerprint"] = metadata_fingerprint
        __props__.__dict__["metadata_startup_script"] = metadata_startup_script
        __props__.__dict__["min_cpu_platform"] = min_cpu_platform
        __props__.__dict__["name"] = name
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["network_performance_config"] = network_performance_config
        __props__.__dict__["project"] = project
        __props__.__dict__["reservation_affinity"] = reservation_affinity
        __props__.__dict__["resource_policies"] = resource_policies
        __props__.__dict__["scheduling"] = scheduling
        __props__.__dict__["scratch_disks"] = scratch_disks
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["shielded_instance_config"] = shielded_instance_config
        __props__.__dict__["source_machine_image"] = source_machine_image
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_fingerprint"] = tags_fingerprint
        __props__.__dict__["zone"] = zone
        return InstanceFromMachineImage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> pulumi.Output['outputs.InstanceFromMachineImageAdvancedMachineFeatures']:
        """
        Controls for advanced machine-related behavior features.
        """
        return pulumi.get(self, "advanced_machine_features")

    @property
    @pulumi.getter(name="allowStoppingForUpdate")
    def allow_stopping_for_update(self) -> pulumi.Output[bool]:
        """
        If true, allows Terraform to stop the instance to update its properties. If you try to update a property that requires
        stopping the instance without setting this field, the update will fail.
        """
        return pulumi.get(self, "allow_stopping_for_update")

    @property
    @pulumi.getter(name="attachedDisks")
    def attached_disks(self) -> pulumi.Output[Sequence['outputs.InstanceFromMachineImageAttachedDisk']]:
        """
        List of disks attached to the instance
        """
        return pulumi.get(self, "attached_disks")

    @property
    @pulumi.getter(name="bootDisks")
    def boot_disks(self) -> pulumi.Output[Sequence['outputs.InstanceFromMachineImageBootDisk']]:
        """
        The boot disk for the instance.
        """
        return pulumi.get(self, "boot_disks")

    @property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> pulumi.Output[bool]:
        """
        Whether sending and receiving of packets with non-matching source or destination IPs is allowed.
        """
        return pulumi.get(self, "can_ip_forward")

    @property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> pulumi.Output['outputs.InstanceFromMachineImageConfidentialInstanceConfig']:
        """
        The Confidential VM config being used by the instance. on_host_maintenance has to be set to TERMINATE or this will fail
        to create.
        """
        return pulumi.get(self, "confidential_instance_config")

    @property
    @pulumi.getter(name="cpuPlatform")
    def cpu_platform(self) -> pulumi.Output[str]:
        """
        The CPU platform used by this instance.
        """
        return pulumi.get(self, "cpu_platform")

    @property
    @pulumi.getter(name="currentStatus")
    def current_status(self) -> pulumi.Output[str]:
        """
        Current status of the instance.
        """
        return pulumi.get(self, "current_status")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[bool]:
        """
        Whether deletion protection is enabled on this instance.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        A brief description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="desiredStatus")
    def desired_status(self) -> pulumi.Output[str]:
        """
        Desired status of the instance. Either "RUNNING" or "TERMINATED".
        """
        return pulumi.get(self, "desired_status")

    @property
    @pulumi.getter(name="enableDisplay")
    def enable_display(self) -> pulumi.Output[bool]:
        """
        Whether the instance has virtual displays enabled.
        """
        return pulumi.get(self, "enable_display")

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> pulumi.Output[Sequence['outputs.InstanceFromMachineImageGuestAccelerator']]:
        """
        List of the type and count of accelerator cards attached to the instance.
        """
        return pulumi.get(self, "guest_accelerators")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        A custom hostname for the instance. Must be a fully qualified DNS name and RFC-1035-valid. Valid format is a series of
        labels 1-63 characters long matching the regular expression [a-z]([-a-z0-9]*[a-z0-9]), concatenated with periods. The
        entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The server-assigned unique identifier of this instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[str]:
        """
        The unique fingerprint of the labels.
        """
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A set of key/value label pairs assigned to the instance.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Output[str]:
        """
        The machine type to create.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Metadata key/value pairs made available within the instance.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="metadataFingerprint")
    def metadata_fingerprint(self) -> pulumi.Output[str]:
        """
        The unique fingerprint of the metadata.
        """
        return pulumi.get(self, "metadata_fingerprint")

    @property
    @pulumi.getter(name="metadataStartupScript")
    def metadata_startup_script(self) -> pulumi.Output[str]:
        """
        Metadata startup scripts made available within the instance.
        """
        return pulumi.get(self, "metadata_startup_script")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> pulumi.Output[str]:
        """
        The minimum CPU platform specified for the VM instance.
        """
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique name for the resource, required by GCE.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Sequence['outputs.InstanceFromMachineImageNetworkInterface']]:
        """
        The networks attached to the instance.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="networkPerformanceConfig")
    def network_performance_config(self) -> pulumi.Output['outputs.InstanceFromMachineImageNetworkPerformanceConfig']:
        """
        Configures network performance settings for the instance. If not specified, the instance will be created with its
        default network performance configuration.
        """
        return pulumi.get(self, "network_performance_config")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs. If self_link is provided, this value is ignored. If neither
        self_link nor project are provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> pulumi.Output['outputs.InstanceFromMachineImageReservationAffinity']:
        """
        Specifies the reservations that this instance can consume from.
        """
        return pulumi.get(self, "reservation_affinity")

    @property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> pulumi.Output[str]:
        """
        A list of self_links of resource policies to attach to the instance. Currently a max of 1 resource policy is supported.
        """
        return pulumi.get(self, "resource_policies")

    @property
    @pulumi.getter
    def scheduling(self) -> pulumi.Output['outputs.InstanceFromMachineImageScheduling']:
        """
        The scheduling strategy being used by the instance.
        """
        return pulumi.get(self, "scheduling")

    @property
    @pulumi.getter(name="scratchDisks")
    def scratch_disks(self) -> pulumi.Output[Sequence['outputs.InstanceFromMachineImageScratchDisk']]:
        """
        The scratch disks attached to the instance.
        """
        return pulumi.get(self, "scratch_disks")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output['outputs.InstanceFromMachineImageServiceAccount']:
        """
        The service account to attach to the instance.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> pulumi.Output['outputs.InstanceFromMachineImageShieldedInstanceConfig']:
        """
        The shielded vm config being used by the instance.
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter(name="sourceMachineImage")
    def source_machine_image(self) -> pulumi.Output[str]:
        """
        Name or self link of a machine
        image to create the instance based on.
        """
        return pulumi.get(self, "source_machine_image")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of tags attached to the instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsFingerprint")
    def tags_fingerprint(self) -> pulumi.Output[str]:
        """
        The unique fingerprint of the tags.
        """
        return pulumi.get(self, "tags_fingerprint")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        The zone that the machine should be created in. If not
        set, the provider zone is used.
        """
        return pulumi.get(self, "zone")

