# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RegionDiskResourcePolicyAttachmentArgs', 'RegionDiskResourcePolicyAttachment']

@pulumi.input_type
class RegionDiskResourcePolicyAttachmentArgs:
    def __init__(__self__, *,
                 disk: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RegionDiskResourcePolicyAttachment resource.
        :param pulumi.Input[str] disk: The name of the regional disk in which the resource policies are attached to.
        :param pulumi.Input[str] name: The resource policy to be attached to the disk for scheduling snapshot
               creation. Do not specify the self link.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: A reference to the region where the disk resides.
        """
        pulumi.set(__self__, "disk", disk)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def disk(self) -> pulumi.Input[str]:
        """
        The name of the regional disk in which the resource policies are attached to.
        """
        return pulumi.get(self, "disk")

    @disk.setter
    def disk(self, value: pulumi.Input[str]):
        pulumi.set(self, "disk", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource policy to be attached to the disk for scheduling snapshot
        creation. Do not specify the self link.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        A reference to the region where the disk resides.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _RegionDiskResourcePolicyAttachmentState:
    def __init__(__self__, *,
                 disk: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RegionDiskResourcePolicyAttachment resources.
        :param pulumi.Input[str] disk: The name of the regional disk in which the resource policies are attached to.
        :param pulumi.Input[str] name: The resource policy to be attached to the disk for scheduling snapshot
               creation. Do not specify the self link.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: A reference to the region where the disk resides.
        """
        if disk is not None:
            pulumi.set(__self__, "disk", disk)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def disk(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the regional disk in which the resource policies are attached to.
        """
        return pulumi.get(self, "disk")

    @disk.setter
    def disk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource policy to be attached to the disk for scheduling snapshot
        creation. Do not specify the self link.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        A reference to the region where the disk resides.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


class RegionDiskResourcePolicyAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disk: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### Region Disk Resource Policy Attachment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        disk = gcp.compute.Disk("disk",
            image="debian-cloud/debian-11",
            size=50,
            type="pd-ssd",
            zone="us-central1-a")
        snapdisk = gcp.compute.Snapshot("snapdisk",
            source_disk=disk.name,
            zone="us-central1-a")
        ssd = gcp.compute.RegionDisk("ssd",
            replica_zones=[
                "us-central1-a",
                "us-central1-f",
            ],
            snapshot=snapdisk.id,
            size=50,
            type="pd-ssd",
            region="us-central1")
        attachment = gcp.compute.RegionDiskResourcePolicyAttachment("attachment",
            disk=ssd.name,
            region="us-central1")
        policy = gcp.compute.ResourcePolicy("policy",
            region="us-central1",
            snapshot_schedule_policy=gcp.compute.ResourcePolicySnapshotSchedulePolicyArgs(
                schedule=gcp.compute.ResourcePolicySnapshotSchedulePolicyScheduleArgs(
                    daily_schedule=gcp.compute.ResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleArgs(
                        days_in_cycle=1,
                        start_time="04:00",
                    ),
                ),
            ))
        my_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        ```

        ## Import

        RegionDiskResourcePolicyAttachment can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/regionDiskResourcePolicyAttachment:RegionDiskResourcePolicyAttachment default projects/{{project}}/regions/{{region}}/disks/{{disk}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/regionDiskResourcePolicyAttachment:RegionDiskResourcePolicyAttachment default {{project}}/{{region}}/{{disk}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/regionDiskResourcePolicyAttachment:RegionDiskResourcePolicyAttachment default {{region}}/{{disk}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/regionDiskResourcePolicyAttachment:RegionDiskResourcePolicyAttachment default {{disk}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] disk: The name of the regional disk in which the resource policies are attached to.
        :param pulumi.Input[str] name: The resource policy to be attached to the disk for scheduling snapshot
               creation. Do not specify the self link.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: A reference to the region where the disk resides.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionDiskResourcePolicyAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### Region Disk Resource Policy Attachment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        disk = gcp.compute.Disk("disk",
            image="debian-cloud/debian-11",
            size=50,
            type="pd-ssd",
            zone="us-central1-a")
        snapdisk = gcp.compute.Snapshot("snapdisk",
            source_disk=disk.name,
            zone="us-central1-a")
        ssd = gcp.compute.RegionDisk("ssd",
            replica_zones=[
                "us-central1-a",
                "us-central1-f",
            ],
            snapshot=snapdisk.id,
            size=50,
            type="pd-ssd",
            region="us-central1")
        attachment = gcp.compute.RegionDiskResourcePolicyAttachment("attachment",
            disk=ssd.name,
            region="us-central1")
        policy = gcp.compute.ResourcePolicy("policy",
            region="us-central1",
            snapshot_schedule_policy=gcp.compute.ResourcePolicySnapshotSchedulePolicyArgs(
                schedule=gcp.compute.ResourcePolicySnapshotSchedulePolicyScheduleArgs(
                    daily_schedule=gcp.compute.ResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleArgs(
                        days_in_cycle=1,
                        start_time="04:00",
                    ),
                ),
            ))
        my_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        ```

        ## Import

        RegionDiskResourcePolicyAttachment can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/regionDiskResourcePolicyAttachment:RegionDiskResourcePolicyAttachment default projects/{{project}}/regions/{{region}}/disks/{{disk}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/regionDiskResourcePolicyAttachment:RegionDiskResourcePolicyAttachment default {{project}}/{{region}}/{{disk}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/regionDiskResourcePolicyAttachment:RegionDiskResourcePolicyAttachment default {{region}}/{{disk}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/regionDiskResourcePolicyAttachment:RegionDiskResourcePolicyAttachment default {{disk}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RegionDiskResourcePolicyAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionDiskResourcePolicyAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disk: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionDiskResourcePolicyAttachmentArgs.__new__(RegionDiskResourcePolicyAttachmentArgs)

            if disk is None and not opts.urn:
                raise TypeError("Missing required property 'disk'")
            __props__.__dict__["disk"] = disk
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
        super(RegionDiskResourcePolicyAttachment, __self__).__init__(
            'gcp:compute/regionDiskResourcePolicyAttachment:RegionDiskResourcePolicyAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            disk: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None) -> 'RegionDiskResourcePolicyAttachment':
        """
        Get an existing RegionDiskResourcePolicyAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] disk: The name of the regional disk in which the resource policies are attached to.
        :param pulumi.Input[str] name: The resource policy to be attached to the disk for scheduling snapshot
               creation. Do not specify the self link.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: A reference to the region where the disk resides.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionDiskResourcePolicyAttachmentState.__new__(_RegionDiskResourcePolicyAttachmentState)

        __props__.__dict__["disk"] = disk
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        return RegionDiskResourcePolicyAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def disk(self) -> pulumi.Output[str]:
        """
        The name of the regional disk in which the resource policies are attached to.
        """
        return pulumi.get(self, "disk")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource policy to be attached to the disk for scheduling snapshot
        creation. Do not specify the self link.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        A reference to the region where the disk resides.
        """
        return pulumi.get(self, "region")

