# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RouterNatArgs', 'RouterNat']

@pulumi.input_type
class RouterNatArgs:
    def __init__(__self__, *,
                 nat_ip_allocate_option: pulumi.Input[str],
                 router: pulumi.Input[str],
                 source_subnetwork_ip_ranges_to_nat: pulumi.Input[str],
                 drain_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_dynamic_port_allocation: Optional[pulumi.Input[bool]] = None,
                 enable_endpoint_independent_mapping: Optional[pulumi.Input[bool]] = None,
                 icmp_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
                 log_config: Optional[pulumi.Input['RouterNatLogConfigArgs']] = None,
                 max_ports_per_vm: Optional[pulumi.Input[int]] = None,
                 min_ports_per_vm: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]]] = None,
                 subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkArgs']]]] = None,
                 tcp_established_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
                 tcp_time_wait_timeout_sec: Optional[pulumi.Input[int]] = None,
                 tcp_transitory_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
                 udp_idle_timeout_sec: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a RouterNat resource.
        :param pulumi.Input[str] nat_ip_allocate_option: How external IPs should be allocated for this NAT. Valid values are
               `AUTO_ONLY` for only allowing NAT IPs allocated by Google Cloud
               Platform, or `MANUAL_ONLY` for only user-allocated NAT IP addresses.
               Possible values are `MANUAL_ONLY` and `AUTO_ONLY`.
        :param pulumi.Input[str] router: The name of the Cloud Router in which this NAT will be configured.
        :param pulumi.Input[str] source_subnetwork_ip_ranges_to_nat: How NAT should be configured per Subnetwork.
               If `ALL_SUBNETWORKS_ALL_IP_RANGES`, all of the
               IP ranges in every Subnetwork are allowed to Nat.
               If `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, all of the primary IP
               ranges in every Subnetwork are allowed to Nat.
               `LIST_OF_SUBNETWORKS`: A list of Subnetworks are allowed to Nat
               (specified in the field subnetwork below). Note that if this field
               contains ALL_SUBNETWORKS_ALL_IP_RANGES or
               ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any
               other RouterNat section in any Router for this network in this region.
               Possible values are `ALL_SUBNETWORKS_ALL_IP_RANGES`, `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, and `LIST_OF_SUBNETWORKS`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] drain_nat_ips: A list of URLs of the IP resources to be drained. These IPs must be
               valid static external IPs that have been assigned to the NAT.
        :param pulumi.Input[bool] enable_dynamic_port_allocation: Enable Dynamic Port Allocation.
               If minPortsPerVm is set, minPortsPerVm must be set to a power of two greater than or equal to 32.
               If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
               If maxPortsPerVm is set, maxPortsPerVm must be set to a power of two greater than minPortsPerVm.
               If maxPortsPerVm is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
               Mutually exclusive with enableEndpointIndependentMapping.
        :param pulumi.Input[bool] enable_endpoint_independent_mapping: Specifies if endpoint independent mapping is enabled. This is enabled by default. For more information
               see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
        :param pulumi.Input[int] icmp_idle_timeout_sec: Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
        :param pulumi.Input['RouterNatLogConfigArgs'] log_config: Configuration for logging on NAT
               Structure is documented below.
        :param pulumi.Input[int] max_ports_per_vm: Maximum number of ports allocated to a VM from this NAT.
               This field can only be set when enableDynamicPortAllocation is enabled.
        :param pulumi.Input[int] min_ports_per_vm: Minimum number of ports allocated to a VM from this NAT.
        :param pulumi.Input[str] name: Name of the NAT service. The name must be 1-63 characters long and
               comply with RFC1035.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nat_ips: Self-links of NAT IPs. Only valid if natIpAllocateOption
               is set to MANUAL_ONLY.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region where the router and NAT reside.
        :param pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]] rules: A list of rules associated with this NAT.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkArgs']]] subnetworks: One or more subnetwork NAT configurations. Only used if
               `source_subnetwork_ip_ranges_to_nat` is set to `LIST_OF_SUBNETWORKS`
               Structure is documented below.
        :param pulumi.Input[int] tcp_established_idle_timeout_sec: Timeout (in seconds) for TCP established connections.
               Defaults to 1200s if not set.
        :param pulumi.Input[int] tcp_time_wait_timeout_sec: Timeout (in seconds) for TCP connections that are in TIME_WAIT state.
               Defaults to 120s if not set.
        :param pulumi.Input[int] tcp_transitory_idle_timeout_sec: Timeout (in seconds) for TCP transitory connections.
               Defaults to 30s if not set.
        :param pulumi.Input[int] udp_idle_timeout_sec: Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
        """
        pulumi.set(__self__, "nat_ip_allocate_option", nat_ip_allocate_option)
        pulumi.set(__self__, "router", router)
        pulumi.set(__self__, "source_subnetwork_ip_ranges_to_nat", source_subnetwork_ip_ranges_to_nat)
        if drain_nat_ips is not None:
            pulumi.set(__self__, "drain_nat_ips", drain_nat_ips)
        if enable_dynamic_port_allocation is not None:
            pulumi.set(__self__, "enable_dynamic_port_allocation", enable_dynamic_port_allocation)
        if enable_endpoint_independent_mapping is not None:
            pulumi.set(__self__, "enable_endpoint_independent_mapping", enable_endpoint_independent_mapping)
        if icmp_idle_timeout_sec is not None:
            pulumi.set(__self__, "icmp_idle_timeout_sec", icmp_idle_timeout_sec)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if max_ports_per_vm is not None:
            pulumi.set(__self__, "max_ports_per_vm", max_ports_per_vm)
        if min_ports_per_vm is not None:
            pulumi.set(__self__, "min_ports_per_vm", min_ports_per_vm)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_ips is not None:
            pulumi.set(__self__, "nat_ips", nat_ips)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if subnetworks is not None:
            pulumi.set(__self__, "subnetworks", subnetworks)
        if tcp_established_idle_timeout_sec is not None:
            pulumi.set(__self__, "tcp_established_idle_timeout_sec", tcp_established_idle_timeout_sec)
        if tcp_time_wait_timeout_sec is not None:
            pulumi.set(__self__, "tcp_time_wait_timeout_sec", tcp_time_wait_timeout_sec)
        if tcp_transitory_idle_timeout_sec is not None:
            pulumi.set(__self__, "tcp_transitory_idle_timeout_sec", tcp_transitory_idle_timeout_sec)
        if udp_idle_timeout_sec is not None:
            pulumi.set(__self__, "udp_idle_timeout_sec", udp_idle_timeout_sec)

    @property
    @pulumi.getter(name="natIpAllocateOption")
    def nat_ip_allocate_option(self) -> pulumi.Input[str]:
        """
        How external IPs should be allocated for this NAT. Valid values are
        `AUTO_ONLY` for only allowing NAT IPs allocated by Google Cloud
        Platform, or `MANUAL_ONLY` for only user-allocated NAT IP addresses.
        Possible values are `MANUAL_ONLY` and `AUTO_ONLY`.
        """
        return pulumi.get(self, "nat_ip_allocate_option")

    @nat_ip_allocate_option.setter
    def nat_ip_allocate_option(self, value: pulumi.Input[str]):
        pulumi.set(self, "nat_ip_allocate_option", value)

    @property
    @pulumi.getter
    def router(self) -> pulumi.Input[str]:
        """
        The name of the Cloud Router in which this NAT will be configured.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: pulumi.Input[str]):
        pulumi.set(self, "router", value)

    @property
    @pulumi.getter(name="sourceSubnetworkIpRangesToNat")
    def source_subnetwork_ip_ranges_to_nat(self) -> pulumi.Input[str]:
        """
        How NAT should be configured per Subnetwork.
        If `ALL_SUBNETWORKS_ALL_IP_RANGES`, all of the
        IP ranges in every Subnetwork are allowed to Nat.
        If `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, all of the primary IP
        ranges in every Subnetwork are allowed to Nat.
        `LIST_OF_SUBNETWORKS`: A list of Subnetworks are allowed to Nat
        (specified in the field subnetwork below). Note that if this field
        contains ALL_SUBNETWORKS_ALL_IP_RANGES or
        ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any
        other RouterNat section in any Router for this network in this region.
        Possible values are `ALL_SUBNETWORKS_ALL_IP_RANGES`, `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, and `LIST_OF_SUBNETWORKS`.
        """
        return pulumi.get(self, "source_subnetwork_ip_ranges_to_nat")

    @source_subnetwork_ip_ranges_to_nat.setter
    def source_subnetwork_ip_ranges_to_nat(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_subnetwork_ip_ranges_to_nat", value)

    @property
    @pulumi.getter(name="drainNatIps")
    def drain_nat_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of URLs of the IP resources to be drained. These IPs must be
        valid static external IPs that have been assigned to the NAT.
        """
        return pulumi.get(self, "drain_nat_ips")

    @drain_nat_ips.setter
    def drain_nat_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "drain_nat_ips", value)

    @property
    @pulumi.getter(name="enableDynamicPortAllocation")
    def enable_dynamic_port_allocation(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Dynamic Port Allocation.
        If minPortsPerVm is set, minPortsPerVm must be set to a power of two greater than or equal to 32.
        If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
        If maxPortsPerVm is set, maxPortsPerVm must be set to a power of two greater than minPortsPerVm.
        If maxPortsPerVm is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
        Mutually exclusive with enableEndpointIndependentMapping.
        """
        return pulumi.get(self, "enable_dynamic_port_allocation")

    @enable_dynamic_port_allocation.setter
    def enable_dynamic_port_allocation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dynamic_port_allocation", value)

    @property
    @pulumi.getter(name="enableEndpointIndependentMapping")
    def enable_endpoint_independent_mapping(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if endpoint independent mapping is enabled. This is enabled by default. For more information
        see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
        """
        return pulumi.get(self, "enable_endpoint_independent_mapping")

    @enable_endpoint_independent_mapping.setter
    def enable_endpoint_independent_mapping(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_endpoint_independent_mapping", value)

    @property
    @pulumi.getter(name="icmpIdleTimeoutSec")
    def icmp_idle_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
        """
        return pulumi.get(self, "icmp_idle_timeout_sec")

    @icmp_idle_timeout_sec.setter
    def icmp_idle_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "icmp_idle_timeout_sec", value)

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['RouterNatLogConfigArgs']]:
        """
        Configuration for logging on NAT
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['RouterNatLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @property
    @pulumi.getter(name="maxPortsPerVm")
    def max_ports_per_vm(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of ports allocated to a VM from this NAT.
        This field can only be set when enableDynamicPortAllocation is enabled.
        """
        return pulumi.get(self, "max_ports_per_vm")

    @max_ports_per_vm.setter
    def max_ports_per_vm(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_ports_per_vm", value)

    @property
    @pulumi.getter(name="minPortsPerVm")
    def min_ports_per_vm(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of ports allocated to a VM from this NAT.
        """
        return pulumi.get(self, "min_ports_per_vm")

    @min_ports_per_vm.setter
    def min_ports_per_vm(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_ports_per_vm", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the NAT service. The name must be 1-63 characters long and
        comply with RFC1035.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="natIps")
    def nat_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Self-links of NAT IPs. Only valid if natIpAllocateOption
        is set to MANUAL_ONLY.
        """
        return pulumi.get(self, "nat_ips")

    @nat_ips.setter
    def nat_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nat_ips", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region where the router and NAT reside.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]]]:
        """
        A list of rules associated with this NAT.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def subnetworks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkArgs']]]]:
        """
        One or more subnetwork NAT configurations. Only used if
        `source_subnetwork_ip_ranges_to_nat` is set to `LIST_OF_SUBNETWORKS`
        Structure is documented below.
        """
        return pulumi.get(self, "subnetworks")

    @subnetworks.setter
    def subnetworks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkArgs']]]]):
        pulumi.set(self, "subnetworks", value)

    @property
    @pulumi.getter(name="tcpEstablishedIdleTimeoutSec")
    def tcp_established_idle_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout (in seconds) for TCP established connections.
        Defaults to 1200s if not set.
        """
        return pulumi.get(self, "tcp_established_idle_timeout_sec")

    @tcp_established_idle_timeout_sec.setter
    def tcp_established_idle_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tcp_established_idle_timeout_sec", value)

    @property
    @pulumi.getter(name="tcpTimeWaitTimeoutSec")
    def tcp_time_wait_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout (in seconds) for TCP connections that are in TIME_WAIT state.
        Defaults to 120s if not set.
        """
        return pulumi.get(self, "tcp_time_wait_timeout_sec")

    @tcp_time_wait_timeout_sec.setter
    def tcp_time_wait_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tcp_time_wait_timeout_sec", value)

    @property
    @pulumi.getter(name="tcpTransitoryIdleTimeoutSec")
    def tcp_transitory_idle_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout (in seconds) for TCP transitory connections.
        Defaults to 30s if not set.
        """
        return pulumi.get(self, "tcp_transitory_idle_timeout_sec")

    @tcp_transitory_idle_timeout_sec.setter
    def tcp_transitory_idle_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tcp_transitory_idle_timeout_sec", value)

    @property
    @pulumi.getter(name="udpIdleTimeoutSec")
    def udp_idle_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
        """
        return pulumi.get(self, "udp_idle_timeout_sec")

    @udp_idle_timeout_sec.setter
    def udp_idle_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "udp_idle_timeout_sec", value)


@pulumi.input_type
class _RouterNatState:
    def __init__(__self__, *,
                 drain_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_dynamic_port_allocation: Optional[pulumi.Input[bool]] = None,
                 enable_endpoint_independent_mapping: Optional[pulumi.Input[bool]] = None,
                 icmp_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
                 log_config: Optional[pulumi.Input['RouterNatLogConfigArgs']] = None,
                 max_ports_per_vm: Optional[pulumi.Input[int]] = None,
                 min_ports_per_vm: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nat_ip_allocate_option: Optional[pulumi.Input[str]] = None,
                 nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]]] = None,
                 source_subnetwork_ip_ranges_to_nat: Optional[pulumi.Input[str]] = None,
                 subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkArgs']]]] = None,
                 tcp_established_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
                 tcp_time_wait_timeout_sec: Optional[pulumi.Input[int]] = None,
                 tcp_transitory_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
                 udp_idle_timeout_sec: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering RouterNat resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] drain_nat_ips: A list of URLs of the IP resources to be drained. These IPs must be
               valid static external IPs that have been assigned to the NAT.
        :param pulumi.Input[bool] enable_dynamic_port_allocation: Enable Dynamic Port Allocation.
               If minPortsPerVm is set, minPortsPerVm must be set to a power of two greater than or equal to 32.
               If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
               If maxPortsPerVm is set, maxPortsPerVm must be set to a power of two greater than minPortsPerVm.
               If maxPortsPerVm is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
               Mutually exclusive with enableEndpointIndependentMapping.
        :param pulumi.Input[bool] enable_endpoint_independent_mapping: Specifies if endpoint independent mapping is enabled. This is enabled by default. For more information
               see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
        :param pulumi.Input[int] icmp_idle_timeout_sec: Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
        :param pulumi.Input['RouterNatLogConfigArgs'] log_config: Configuration for logging on NAT
               Structure is documented below.
        :param pulumi.Input[int] max_ports_per_vm: Maximum number of ports allocated to a VM from this NAT.
               This field can only be set when enableDynamicPortAllocation is enabled.
        :param pulumi.Input[int] min_ports_per_vm: Minimum number of ports allocated to a VM from this NAT.
        :param pulumi.Input[str] name: Name of the NAT service. The name must be 1-63 characters long and
               comply with RFC1035.
        :param pulumi.Input[str] nat_ip_allocate_option: How external IPs should be allocated for this NAT. Valid values are
               `AUTO_ONLY` for only allowing NAT IPs allocated by Google Cloud
               Platform, or `MANUAL_ONLY` for only user-allocated NAT IP addresses.
               Possible values are `MANUAL_ONLY` and `AUTO_ONLY`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nat_ips: Self-links of NAT IPs. Only valid if natIpAllocateOption
               is set to MANUAL_ONLY.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region where the router and NAT reside.
        :param pulumi.Input[str] router: The name of the Cloud Router in which this NAT will be configured.
        :param pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]] rules: A list of rules associated with this NAT.
               Structure is documented below.
        :param pulumi.Input[str] source_subnetwork_ip_ranges_to_nat: How NAT should be configured per Subnetwork.
               If `ALL_SUBNETWORKS_ALL_IP_RANGES`, all of the
               IP ranges in every Subnetwork are allowed to Nat.
               If `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, all of the primary IP
               ranges in every Subnetwork are allowed to Nat.
               `LIST_OF_SUBNETWORKS`: A list of Subnetworks are allowed to Nat
               (specified in the field subnetwork below). Note that if this field
               contains ALL_SUBNETWORKS_ALL_IP_RANGES or
               ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any
               other RouterNat section in any Router for this network in this region.
               Possible values are `ALL_SUBNETWORKS_ALL_IP_RANGES`, `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, and `LIST_OF_SUBNETWORKS`.
        :param pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkArgs']]] subnetworks: One or more subnetwork NAT configurations. Only used if
               `source_subnetwork_ip_ranges_to_nat` is set to `LIST_OF_SUBNETWORKS`
               Structure is documented below.
        :param pulumi.Input[int] tcp_established_idle_timeout_sec: Timeout (in seconds) for TCP established connections.
               Defaults to 1200s if not set.
        :param pulumi.Input[int] tcp_time_wait_timeout_sec: Timeout (in seconds) for TCP connections that are in TIME_WAIT state.
               Defaults to 120s if not set.
        :param pulumi.Input[int] tcp_transitory_idle_timeout_sec: Timeout (in seconds) for TCP transitory connections.
               Defaults to 30s if not set.
        :param pulumi.Input[int] udp_idle_timeout_sec: Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
        """
        if drain_nat_ips is not None:
            pulumi.set(__self__, "drain_nat_ips", drain_nat_ips)
        if enable_dynamic_port_allocation is not None:
            pulumi.set(__self__, "enable_dynamic_port_allocation", enable_dynamic_port_allocation)
        if enable_endpoint_independent_mapping is not None:
            pulumi.set(__self__, "enable_endpoint_independent_mapping", enable_endpoint_independent_mapping)
        if icmp_idle_timeout_sec is not None:
            pulumi.set(__self__, "icmp_idle_timeout_sec", icmp_idle_timeout_sec)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if max_ports_per_vm is not None:
            pulumi.set(__self__, "max_ports_per_vm", max_ports_per_vm)
        if min_ports_per_vm is not None:
            pulumi.set(__self__, "min_ports_per_vm", min_ports_per_vm)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_ip_allocate_option is not None:
            pulumi.set(__self__, "nat_ip_allocate_option", nat_ip_allocate_option)
        if nat_ips is not None:
            pulumi.set(__self__, "nat_ips", nat_ips)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if router is not None:
            pulumi.set(__self__, "router", router)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if source_subnetwork_ip_ranges_to_nat is not None:
            pulumi.set(__self__, "source_subnetwork_ip_ranges_to_nat", source_subnetwork_ip_ranges_to_nat)
        if subnetworks is not None:
            pulumi.set(__self__, "subnetworks", subnetworks)
        if tcp_established_idle_timeout_sec is not None:
            pulumi.set(__self__, "tcp_established_idle_timeout_sec", tcp_established_idle_timeout_sec)
        if tcp_time_wait_timeout_sec is not None:
            pulumi.set(__self__, "tcp_time_wait_timeout_sec", tcp_time_wait_timeout_sec)
        if tcp_transitory_idle_timeout_sec is not None:
            pulumi.set(__self__, "tcp_transitory_idle_timeout_sec", tcp_transitory_idle_timeout_sec)
        if udp_idle_timeout_sec is not None:
            pulumi.set(__self__, "udp_idle_timeout_sec", udp_idle_timeout_sec)

    @property
    @pulumi.getter(name="drainNatIps")
    def drain_nat_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of URLs of the IP resources to be drained. These IPs must be
        valid static external IPs that have been assigned to the NAT.
        """
        return pulumi.get(self, "drain_nat_ips")

    @drain_nat_ips.setter
    def drain_nat_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "drain_nat_ips", value)

    @property
    @pulumi.getter(name="enableDynamicPortAllocation")
    def enable_dynamic_port_allocation(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Dynamic Port Allocation.
        If minPortsPerVm is set, minPortsPerVm must be set to a power of two greater than or equal to 32.
        If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
        If maxPortsPerVm is set, maxPortsPerVm must be set to a power of two greater than minPortsPerVm.
        If maxPortsPerVm is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
        Mutually exclusive with enableEndpointIndependentMapping.
        """
        return pulumi.get(self, "enable_dynamic_port_allocation")

    @enable_dynamic_port_allocation.setter
    def enable_dynamic_port_allocation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dynamic_port_allocation", value)

    @property
    @pulumi.getter(name="enableEndpointIndependentMapping")
    def enable_endpoint_independent_mapping(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if endpoint independent mapping is enabled. This is enabled by default. For more information
        see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
        """
        return pulumi.get(self, "enable_endpoint_independent_mapping")

    @enable_endpoint_independent_mapping.setter
    def enable_endpoint_independent_mapping(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_endpoint_independent_mapping", value)

    @property
    @pulumi.getter(name="icmpIdleTimeoutSec")
    def icmp_idle_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
        """
        return pulumi.get(self, "icmp_idle_timeout_sec")

    @icmp_idle_timeout_sec.setter
    def icmp_idle_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "icmp_idle_timeout_sec", value)

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['RouterNatLogConfigArgs']]:
        """
        Configuration for logging on NAT
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['RouterNatLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @property
    @pulumi.getter(name="maxPortsPerVm")
    def max_ports_per_vm(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of ports allocated to a VM from this NAT.
        This field can only be set when enableDynamicPortAllocation is enabled.
        """
        return pulumi.get(self, "max_ports_per_vm")

    @max_ports_per_vm.setter
    def max_ports_per_vm(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_ports_per_vm", value)

    @property
    @pulumi.getter(name="minPortsPerVm")
    def min_ports_per_vm(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of ports allocated to a VM from this NAT.
        """
        return pulumi.get(self, "min_ports_per_vm")

    @min_ports_per_vm.setter
    def min_ports_per_vm(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_ports_per_vm", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the NAT service. The name must be 1-63 characters long and
        comply with RFC1035.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="natIpAllocateOption")
    def nat_ip_allocate_option(self) -> Optional[pulumi.Input[str]]:
        """
        How external IPs should be allocated for this NAT. Valid values are
        `AUTO_ONLY` for only allowing NAT IPs allocated by Google Cloud
        Platform, or `MANUAL_ONLY` for only user-allocated NAT IP addresses.
        Possible values are `MANUAL_ONLY` and `AUTO_ONLY`.
        """
        return pulumi.get(self, "nat_ip_allocate_option")

    @nat_ip_allocate_option.setter
    def nat_ip_allocate_option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nat_ip_allocate_option", value)

    @property
    @pulumi.getter(name="natIps")
    def nat_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Self-links of NAT IPs. Only valid if natIpAllocateOption
        is set to MANUAL_ONLY.
        """
        return pulumi.get(self, "nat_ips")

    @nat_ips.setter
    def nat_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nat_ips", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region where the router and NAT reside.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def router(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Cloud Router in which this NAT will be configured.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "router", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]]]:
        """
        A list of rules associated with this NAT.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="sourceSubnetworkIpRangesToNat")
    def source_subnetwork_ip_ranges_to_nat(self) -> Optional[pulumi.Input[str]]:
        """
        How NAT should be configured per Subnetwork.
        If `ALL_SUBNETWORKS_ALL_IP_RANGES`, all of the
        IP ranges in every Subnetwork are allowed to Nat.
        If `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, all of the primary IP
        ranges in every Subnetwork are allowed to Nat.
        `LIST_OF_SUBNETWORKS`: A list of Subnetworks are allowed to Nat
        (specified in the field subnetwork below). Note that if this field
        contains ALL_SUBNETWORKS_ALL_IP_RANGES or
        ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any
        other RouterNat section in any Router for this network in this region.
        Possible values are `ALL_SUBNETWORKS_ALL_IP_RANGES`, `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, and `LIST_OF_SUBNETWORKS`.
        """
        return pulumi.get(self, "source_subnetwork_ip_ranges_to_nat")

    @source_subnetwork_ip_ranges_to_nat.setter
    def source_subnetwork_ip_ranges_to_nat(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_subnetwork_ip_ranges_to_nat", value)

    @property
    @pulumi.getter
    def subnetworks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkArgs']]]]:
        """
        One or more subnetwork NAT configurations. Only used if
        `source_subnetwork_ip_ranges_to_nat` is set to `LIST_OF_SUBNETWORKS`
        Structure is documented below.
        """
        return pulumi.get(self, "subnetworks")

    @subnetworks.setter
    def subnetworks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterNatSubnetworkArgs']]]]):
        pulumi.set(self, "subnetworks", value)

    @property
    @pulumi.getter(name="tcpEstablishedIdleTimeoutSec")
    def tcp_established_idle_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout (in seconds) for TCP established connections.
        Defaults to 1200s if not set.
        """
        return pulumi.get(self, "tcp_established_idle_timeout_sec")

    @tcp_established_idle_timeout_sec.setter
    def tcp_established_idle_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tcp_established_idle_timeout_sec", value)

    @property
    @pulumi.getter(name="tcpTimeWaitTimeoutSec")
    def tcp_time_wait_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout (in seconds) for TCP connections that are in TIME_WAIT state.
        Defaults to 120s if not set.
        """
        return pulumi.get(self, "tcp_time_wait_timeout_sec")

    @tcp_time_wait_timeout_sec.setter
    def tcp_time_wait_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tcp_time_wait_timeout_sec", value)

    @property
    @pulumi.getter(name="tcpTransitoryIdleTimeoutSec")
    def tcp_transitory_idle_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout (in seconds) for TCP transitory connections.
        Defaults to 30s if not set.
        """
        return pulumi.get(self, "tcp_transitory_idle_timeout_sec")

    @tcp_transitory_idle_timeout_sec.setter
    def tcp_transitory_idle_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tcp_transitory_idle_timeout_sec", value)

    @property
    @pulumi.getter(name="udpIdleTimeoutSec")
    def udp_idle_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
        """
        return pulumi.get(self, "udp_idle_timeout_sec")

    @udp_idle_timeout_sec.setter
    def udp_idle_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "udp_idle_timeout_sec", value)


class RouterNat(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 drain_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_dynamic_port_allocation: Optional[pulumi.Input[bool]] = None,
                 enable_endpoint_independent_mapping: Optional[pulumi.Input[bool]] = None,
                 icmp_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
                 log_config: Optional[pulumi.Input[pulumi.InputType['RouterNatLogConfigArgs']]] = None,
                 max_ports_per_vm: Optional[pulumi.Input[int]] = None,
                 min_ports_per_vm: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nat_ip_allocate_option: Optional[pulumi.Input[str]] = None,
                 nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouterNatRuleArgs']]]]] = None,
                 source_subnetwork_ip_ranges_to_nat: Optional[pulumi.Input[str]] = None,
                 subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouterNatSubnetworkArgs']]]]] = None,
                 tcp_established_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
                 tcp_time_wait_timeout_sec: Optional[pulumi.Input[int]] = None,
                 tcp_transitory_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
                 udp_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        A NAT service created in a router.

        To get more information about RouterNat, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/routers)
        * How-to Guides
            * [Google Cloud Router](https://cloud.google.com/router/docs/)

        ## Example Usage
        ### Router Nat Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net")
        subnet = gcp.compute.Subnetwork("subnet",
            network=net.id,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        router = gcp.compute.Router("router",
            region=subnet.region,
            network=net.id,
            bgp=gcp.compute.RouterBgpArgs(
                asn=64514,
            ))
        nat = gcp.compute.RouterNat("nat",
            router=router.name,
            region=router.region,
            nat_ip_allocate_option="AUTO_ONLY",
            source_subnetwork_ip_ranges_to_nat="ALL_SUBNETWORKS_ALL_IP_RANGES",
            log_config=gcp.compute.RouterNatLogConfigArgs(
                enable=True,
                filter="ERRORS_ONLY",
            ))
        ```
        ### Router Nat Manual Ips

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net")
        subnet = gcp.compute.Subnetwork("subnet",
            network=net.id,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        router = gcp.compute.Router("router",
            region=subnet.region,
            network=net.id)
        address = []
        for range in [{"value": i} for i in range(0, 2)]:
            address.append(gcp.compute.Address(f"address-{range['value']}", region=subnet.region))
        nat_manual = gcp.compute.RouterNat("natManual",
            router=router.name,
            region=router.region,
            nat_ip_allocate_option="MANUAL_ONLY",
            nat_ips=[__item.self_link for __item in address],
            source_subnetwork_ip_ranges_to_nat="LIST_OF_SUBNETWORKS",
            subnetworks=[gcp.compute.RouterNatSubnetworkArgs(
                name=subnet.id,
                source_ip_ranges_to_nats=["ALL_IP_RANGES"],
            )])
        ```
        ### Router Nat Rules

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net", auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            network=net.id,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        router = gcp.compute.Router("router",
            region=subnet.region,
            network=net.id)
        addr1 = gcp.compute.Address("addr1", region=subnet.region)
        addr2 = gcp.compute.Address("addr2", region=subnet.region)
        addr3 = gcp.compute.Address("addr3", region=subnet.region)
        nat_rules = gcp.compute.RouterNat("natRules",
            router=router.name,
            region=router.region,
            nat_ip_allocate_option="MANUAL_ONLY",
            nat_ips=[addr1.self_link],
            source_subnetwork_ip_ranges_to_nat="LIST_OF_SUBNETWORKS",
            subnetworks=[gcp.compute.RouterNatSubnetworkArgs(
                name=subnet.id,
                source_ip_ranges_to_nats=["ALL_IP_RANGES"],
            )],
            rules=[gcp.compute.RouterNatRuleArgs(
                rule_number=100,
                description="nat rules example",
                match="inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')",
                action=gcp.compute.RouterNatRuleActionArgs(
                    source_nat_active_ips=[
                        addr2.self_link,
                        addr3.self_link,
                    ],
                ),
            )],
            enable_endpoint_independent_mapping=False)
        ```

        ## Import

        RouterNat can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/routerNat:RouterNat default projects/{{project}}/regions/{{region}}/routers/{{router}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/routerNat:RouterNat default {{project}}/{{region}}/{{router}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/routerNat:RouterNat default {{region}}/{{router}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/routerNat:RouterNat default {{router}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] drain_nat_ips: A list of URLs of the IP resources to be drained. These IPs must be
               valid static external IPs that have been assigned to the NAT.
        :param pulumi.Input[bool] enable_dynamic_port_allocation: Enable Dynamic Port Allocation.
               If minPortsPerVm is set, minPortsPerVm must be set to a power of two greater than or equal to 32.
               If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
               If maxPortsPerVm is set, maxPortsPerVm must be set to a power of two greater than minPortsPerVm.
               If maxPortsPerVm is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
               Mutually exclusive with enableEndpointIndependentMapping.
        :param pulumi.Input[bool] enable_endpoint_independent_mapping: Specifies if endpoint independent mapping is enabled. This is enabled by default. For more information
               see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
        :param pulumi.Input[int] icmp_idle_timeout_sec: Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
        :param pulumi.Input[pulumi.InputType['RouterNatLogConfigArgs']] log_config: Configuration for logging on NAT
               Structure is documented below.
        :param pulumi.Input[int] max_ports_per_vm: Maximum number of ports allocated to a VM from this NAT.
               This field can only be set when enableDynamicPortAllocation is enabled.
        :param pulumi.Input[int] min_ports_per_vm: Minimum number of ports allocated to a VM from this NAT.
        :param pulumi.Input[str] name: Name of the NAT service. The name must be 1-63 characters long and
               comply with RFC1035.
        :param pulumi.Input[str] nat_ip_allocate_option: How external IPs should be allocated for this NAT. Valid values are
               `AUTO_ONLY` for only allowing NAT IPs allocated by Google Cloud
               Platform, or `MANUAL_ONLY` for only user-allocated NAT IP addresses.
               Possible values are `MANUAL_ONLY` and `AUTO_ONLY`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nat_ips: Self-links of NAT IPs. Only valid if natIpAllocateOption
               is set to MANUAL_ONLY.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region where the router and NAT reside.
        :param pulumi.Input[str] router: The name of the Cloud Router in which this NAT will be configured.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouterNatRuleArgs']]]] rules: A list of rules associated with this NAT.
               Structure is documented below.
        :param pulumi.Input[str] source_subnetwork_ip_ranges_to_nat: How NAT should be configured per Subnetwork.
               If `ALL_SUBNETWORKS_ALL_IP_RANGES`, all of the
               IP ranges in every Subnetwork are allowed to Nat.
               If `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, all of the primary IP
               ranges in every Subnetwork are allowed to Nat.
               `LIST_OF_SUBNETWORKS`: A list of Subnetworks are allowed to Nat
               (specified in the field subnetwork below). Note that if this field
               contains ALL_SUBNETWORKS_ALL_IP_RANGES or
               ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any
               other RouterNat section in any Router for this network in this region.
               Possible values are `ALL_SUBNETWORKS_ALL_IP_RANGES`, `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, and `LIST_OF_SUBNETWORKS`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouterNatSubnetworkArgs']]]] subnetworks: One or more subnetwork NAT configurations. Only used if
               `source_subnetwork_ip_ranges_to_nat` is set to `LIST_OF_SUBNETWORKS`
               Structure is documented below.
        :param pulumi.Input[int] tcp_established_idle_timeout_sec: Timeout (in seconds) for TCP established connections.
               Defaults to 1200s if not set.
        :param pulumi.Input[int] tcp_time_wait_timeout_sec: Timeout (in seconds) for TCP connections that are in TIME_WAIT state.
               Defaults to 120s if not set.
        :param pulumi.Input[int] tcp_transitory_idle_timeout_sec: Timeout (in seconds) for TCP transitory connections.
               Defaults to 30s if not set.
        :param pulumi.Input[int] udp_idle_timeout_sec: Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouterNatArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A NAT service created in a router.

        To get more information about RouterNat, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/routers)
        * How-to Guides
            * [Google Cloud Router](https://cloud.google.com/router/docs/)

        ## Example Usage
        ### Router Nat Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net")
        subnet = gcp.compute.Subnetwork("subnet",
            network=net.id,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        router = gcp.compute.Router("router",
            region=subnet.region,
            network=net.id,
            bgp=gcp.compute.RouterBgpArgs(
                asn=64514,
            ))
        nat = gcp.compute.RouterNat("nat",
            router=router.name,
            region=router.region,
            nat_ip_allocate_option="AUTO_ONLY",
            source_subnetwork_ip_ranges_to_nat="ALL_SUBNETWORKS_ALL_IP_RANGES",
            log_config=gcp.compute.RouterNatLogConfigArgs(
                enable=True,
                filter="ERRORS_ONLY",
            ))
        ```
        ### Router Nat Manual Ips

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net")
        subnet = gcp.compute.Subnetwork("subnet",
            network=net.id,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        router = gcp.compute.Router("router",
            region=subnet.region,
            network=net.id)
        address = []
        for range in [{"value": i} for i in range(0, 2)]:
            address.append(gcp.compute.Address(f"address-{range['value']}", region=subnet.region))
        nat_manual = gcp.compute.RouterNat("natManual",
            router=router.name,
            region=router.region,
            nat_ip_allocate_option="MANUAL_ONLY",
            nat_ips=[__item.self_link for __item in address],
            source_subnetwork_ip_ranges_to_nat="LIST_OF_SUBNETWORKS",
            subnetworks=[gcp.compute.RouterNatSubnetworkArgs(
                name=subnet.id,
                source_ip_ranges_to_nats=["ALL_IP_RANGES"],
            )])
        ```
        ### Router Nat Rules

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net", auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            network=net.id,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        router = gcp.compute.Router("router",
            region=subnet.region,
            network=net.id)
        addr1 = gcp.compute.Address("addr1", region=subnet.region)
        addr2 = gcp.compute.Address("addr2", region=subnet.region)
        addr3 = gcp.compute.Address("addr3", region=subnet.region)
        nat_rules = gcp.compute.RouterNat("natRules",
            router=router.name,
            region=router.region,
            nat_ip_allocate_option="MANUAL_ONLY",
            nat_ips=[addr1.self_link],
            source_subnetwork_ip_ranges_to_nat="LIST_OF_SUBNETWORKS",
            subnetworks=[gcp.compute.RouterNatSubnetworkArgs(
                name=subnet.id,
                source_ip_ranges_to_nats=["ALL_IP_RANGES"],
            )],
            rules=[gcp.compute.RouterNatRuleArgs(
                rule_number=100,
                description="nat rules example",
                match="inIpRange(destination.ip, '1.1.0.0/16') || inIpRange(destination.ip, '2.2.0.0/16')",
                action=gcp.compute.RouterNatRuleActionArgs(
                    source_nat_active_ips=[
                        addr2.self_link,
                        addr3.self_link,
                    ],
                ),
            )],
            enable_endpoint_independent_mapping=False)
        ```

        ## Import

        RouterNat can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/routerNat:RouterNat default projects/{{project}}/regions/{{region}}/routers/{{router}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/routerNat:RouterNat default {{project}}/{{region}}/{{router}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/routerNat:RouterNat default {{region}}/{{router}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/routerNat:RouterNat default {{router}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RouterNatArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouterNatArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 drain_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_dynamic_port_allocation: Optional[pulumi.Input[bool]] = None,
                 enable_endpoint_independent_mapping: Optional[pulumi.Input[bool]] = None,
                 icmp_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
                 log_config: Optional[pulumi.Input[pulumi.InputType['RouterNatLogConfigArgs']]] = None,
                 max_ports_per_vm: Optional[pulumi.Input[int]] = None,
                 min_ports_per_vm: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nat_ip_allocate_option: Optional[pulumi.Input[str]] = None,
                 nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouterNatRuleArgs']]]]] = None,
                 source_subnetwork_ip_ranges_to_nat: Optional[pulumi.Input[str]] = None,
                 subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouterNatSubnetworkArgs']]]]] = None,
                 tcp_established_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
                 tcp_time_wait_timeout_sec: Optional[pulumi.Input[int]] = None,
                 tcp_transitory_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
                 udp_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouterNatArgs.__new__(RouterNatArgs)

            __props__.__dict__["drain_nat_ips"] = drain_nat_ips
            __props__.__dict__["enable_dynamic_port_allocation"] = enable_dynamic_port_allocation
            __props__.__dict__["enable_endpoint_independent_mapping"] = enable_endpoint_independent_mapping
            __props__.__dict__["icmp_idle_timeout_sec"] = icmp_idle_timeout_sec
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["max_ports_per_vm"] = max_ports_per_vm
            __props__.__dict__["min_ports_per_vm"] = min_ports_per_vm
            __props__.__dict__["name"] = name
            if nat_ip_allocate_option is None and not opts.urn:
                raise TypeError("Missing required property 'nat_ip_allocate_option'")
            __props__.__dict__["nat_ip_allocate_option"] = nat_ip_allocate_option
            __props__.__dict__["nat_ips"] = nat_ips
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            if router is None and not opts.urn:
                raise TypeError("Missing required property 'router'")
            __props__.__dict__["router"] = router
            __props__.__dict__["rules"] = rules
            if source_subnetwork_ip_ranges_to_nat is None and not opts.urn:
                raise TypeError("Missing required property 'source_subnetwork_ip_ranges_to_nat'")
            __props__.__dict__["source_subnetwork_ip_ranges_to_nat"] = source_subnetwork_ip_ranges_to_nat
            __props__.__dict__["subnetworks"] = subnetworks
            __props__.__dict__["tcp_established_idle_timeout_sec"] = tcp_established_idle_timeout_sec
            __props__.__dict__["tcp_time_wait_timeout_sec"] = tcp_time_wait_timeout_sec
            __props__.__dict__["tcp_transitory_idle_timeout_sec"] = tcp_transitory_idle_timeout_sec
            __props__.__dict__["udp_idle_timeout_sec"] = udp_idle_timeout_sec
        super(RouterNat, __self__).__init__(
            'gcp:compute/routerNat:RouterNat',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            drain_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            enable_dynamic_port_allocation: Optional[pulumi.Input[bool]] = None,
            enable_endpoint_independent_mapping: Optional[pulumi.Input[bool]] = None,
            icmp_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
            log_config: Optional[pulumi.Input[pulumi.InputType['RouterNatLogConfigArgs']]] = None,
            max_ports_per_vm: Optional[pulumi.Input[int]] = None,
            min_ports_per_vm: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nat_ip_allocate_option: Optional[pulumi.Input[str]] = None,
            nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            project: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            router: Optional[pulumi.Input[str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouterNatRuleArgs']]]]] = None,
            source_subnetwork_ip_ranges_to_nat: Optional[pulumi.Input[str]] = None,
            subnetworks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouterNatSubnetworkArgs']]]]] = None,
            tcp_established_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
            tcp_time_wait_timeout_sec: Optional[pulumi.Input[int]] = None,
            tcp_transitory_idle_timeout_sec: Optional[pulumi.Input[int]] = None,
            udp_idle_timeout_sec: Optional[pulumi.Input[int]] = None) -> 'RouterNat':
        """
        Get an existing RouterNat resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] drain_nat_ips: A list of URLs of the IP resources to be drained. These IPs must be
               valid static external IPs that have been assigned to the NAT.
        :param pulumi.Input[bool] enable_dynamic_port_allocation: Enable Dynamic Port Allocation.
               If minPortsPerVm is set, minPortsPerVm must be set to a power of two greater than or equal to 32.
               If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
               If maxPortsPerVm is set, maxPortsPerVm must be set to a power of two greater than minPortsPerVm.
               If maxPortsPerVm is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
               Mutually exclusive with enableEndpointIndependentMapping.
        :param pulumi.Input[bool] enable_endpoint_independent_mapping: Specifies if endpoint independent mapping is enabled. This is enabled by default. For more information
               see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
        :param pulumi.Input[int] icmp_idle_timeout_sec: Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
        :param pulumi.Input[pulumi.InputType['RouterNatLogConfigArgs']] log_config: Configuration for logging on NAT
               Structure is documented below.
        :param pulumi.Input[int] max_ports_per_vm: Maximum number of ports allocated to a VM from this NAT.
               This field can only be set when enableDynamicPortAllocation is enabled.
        :param pulumi.Input[int] min_ports_per_vm: Minimum number of ports allocated to a VM from this NAT.
        :param pulumi.Input[str] name: Name of the NAT service. The name must be 1-63 characters long and
               comply with RFC1035.
        :param pulumi.Input[str] nat_ip_allocate_option: How external IPs should be allocated for this NAT. Valid values are
               `AUTO_ONLY` for only allowing NAT IPs allocated by Google Cloud
               Platform, or `MANUAL_ONLY` for only user-allocated NAT IP addresses.
               Possible values are `MANUAL_ONLY` and `AUTO_ONLY`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nat_ips: Self-links of NAT IPs. Only valid if natIpAllocateOption
               is set to MANUAL_ONLY.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region where the router and NAT reside.
        :param pulumi.Input[str] router: The name of the Cloud Router in which this NAT will be configured.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouterNatRuleArgs']]]] rules: A list of rules associated with this NAT.
               Structure is documented below.
        :param pulumi.Input[str] source_subnetwork_ip_ranges_to_nat: How NAT should be configured per Subnetwork.
               If `ALL_SUBNETWORKS_ALL_IP_RANGES`, all of the
               IP ranges in every Subnetwork are allowed to Nat.
               If `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, all of the primary IP
               ranges in every Subnetwork are allowed to Nat.
               `LIST_OF_SUBNETWORKS`: A list of Subnetworks are allowed to Nat
               (specified in the field subnetwork below). Note that if this field
               contains ALL_SUBNETWORKS_ALL_IP_RANGES or
               ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any
               other RouterNat section in any Router for this network in this region.
               Possible values are `ALL_SUBNETWORKS_ALL_IP_RANGES`, `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, and `LIST_OF_SUBNETWORKS`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouterNatSubnetworkArgs']]]] subnetworks: One or more subnetwork NAT configurations. Only used if
               `source_subnetwork_ip_ranges_to_nat` is set to `LIST_OF_SUBNETWORKS`
               Structure is documented below.
        :param pulumi.Input[int] tcp_established_idle_timeout_sec: Timeout (in seconds) for TCP established connections.
               Defaults to 1200s if not set.
        :param pulumi.Input[int] tcp_time_wait_timeout_sec: Timeout (in seconds) for TCP connections that are in TIME_WAIT state.
               Defaults to 120s if not set.
        :param pulumi.Input[int] tcp_transitory_idle_timeout_sec: Timeout (in seconds) for TCP transitory connections.
               Defaults to 30s if not set.
        :param pulumi.Input[int] udp_idle_timeout_sec: Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouterNatState.__new__(_RouterNatState)

        __props__.__dict__["drain_nat_ips"] = drain_nat_ips
        __props__.__dict__["enable_dynamic_port_allocation"] = enable_dynamic_port_allocation
        __props__.__dict__["enable_endpoint_independent_mapping"] = enable_endpoint_independent_mapping
        __props__.__dict__["icmp_idle_timeout_sec"] = icmp_idle_timeout_sec
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["max_ports_per_vm"] = max_ports_per_vm
        __props__.__dict__["min_ports_per_vm"] = min_ports_per_vm
        __props__.__dict__["name"] = name
        __props__.__dict__["nat_ip_allocate_option"] = nat_ip_allocate_option
        __props__.__dict__["nat_ips"] = nat_ips
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["router"] = router
        __props__.__dict__["rules"] = rules
        __props__.__dict__["source_subnetwork_ip_ranges_to_nat"] = source_subnetwork_ip_ranges_to_nat
        __props__.__dict__["subnetworks"] = subnetworks
        __props__.__dict__["tcp_established_idle_timeout_sec"] = tcp_established_idle_timeout_sec
        __props__.__dict__["tcp_time_wait_timeout_sec"] = tcp_time_wait_timeout_sec
        __props__.__dict__["tcp_transitory_idle_timeout_sec"] = tcp_transitory_idle_timeout_sec
        __props__.__dict__["udp_idle_timeout_sec"] = udp_idle_timeout_sec
        return RouterNat(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="drainNatIps")
    def drain_nat_ips(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of URLs of the IP resources to be drained. These IPs must be
        valid static external IPs that have been assigned to the NAT.
        """
        return pulumi.get(self, "drain_nat_ips")

    @property
    @pulumi.getter(name="enableDynamicPortAllocation")
    def enable_dynamic_port_allocation(self) -> pulumi.Output[bool]:
        """
        Enable Dynamic Port Allocation.
        If minPortsPerVm is set, minPortsPerVm must be set to a power of two greater than or equal to 32.
        If minPortsPerVm is not set, a minimum of 32 ports will be allocated to a VM from this NAT config.
        If maxPortsPerVm is set, maxPortsPerVm must be set to a power of two greater than minPortsPerVm.
        If maxPortsPerVm is not set, a maximum of 65536 ports will be allocated to a VM from this NAT config.
        Mutually exclusive with enableEndpointIndependentMapping.
        """
        return pulumi.get(self, "enable_dynamic_port_allocation")

    @property
    @pulumi.getter(name="enableEndpointIndependentMapping")
    def enable_endpoint_independent_mapping(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies if endpoint independent mapping is enabled. This is enabled by default. For more information
        see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
        """
        return pulumi.get(self, "enable_endpoint_independent_mapping")

    @property
    @pulumi.getter(name="icmpIdleTimeoutSec")
    def icmp_idle_timeout_sec(self) -> pulumi.Output[Optional[int]]:
        """
        Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
        """
        return pulumi.get(self, "icmp_idle_timeout_sec")

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output[Optional['outputs.RouterNatLogConfig']]:
        """
        Configuration for logging on NAT
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @property
    @pulumi.getter(name="maxPortsPerVm")
    def max_ports_per_vm(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum number of ports allocated to a VM from this NAT.
        This field can only be set when enableDynamicPortAllocation is enabled.
        """
        return pulumi.get(self, "max_ports_per_vm")

    @property
    @pulumi.getter(name="minPortsPerVm")
    def min_ports_per_vm(self) -> pulumi.Output[Optional[int]]:
        """
        Minimum number of ports allocated to a VM from this NAT.
        """
        return pulumi.get(self, "min_ports_per_vm")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the NAT service. The name must be 1-63 characters long and
        comply with RFC1035.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="natIpAllocateOption")
    def nat_ip_allocate_option(self) -> pulumi.Output[str]:
        """
        How external IPs should be allocated for this NAT. Valid values are
        `AUTO_ONLY` for only allowing NAT IPs allocated by Google Cloud
        Platform, or `MANUAL_ONLY` for only user-allocated NAT IP addresses.
        Possible values are `MANUAL_ONLY` and `AUTO_ONLY`.
        """
        return pulumi.get(self, "nat_ip_allocate_option")

    @property
    @pulumi.getter(name="natIps")
    def nat_ips(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Self-links of NAT IPs. Only valid if natIpAllocateOption
        is set to MANUAL_ONLY.
        """
        return pulumi.get(self, "nat_ips")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Region where the router and NAT reside.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def router(self) -> pulumi.Output[str]:
        """
        The name of the Cloud Router in which this NAT will be configured.
        """
        return pulumi.get(self, "router")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.RouterNatRule']]]:
        """
        A list of rules associated with this NAT.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="sourceSubnetworkIpRangesToNat")
    def source_subnetwork_ip_ranges_to_nat(self) -> pulumi.Output[str]:
        """
        How NAT should be configured per Subnetwork.
        If `ALL_SUBNETWORKS_ALL_IP_RANGES`, all of the
        IP ranges in every Subnetwork are allowed to Nat.
        If `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, all of the primary IP
        ranges in every Subnetwork are allowed to Nat.
        `LIST_OF_SUBNETWORKS`: A list of Subnetworks are allowed to Nat
        (specified in the field subnetwork below). Note that if this field
        contains ALL_SUBNETWORKS_ALL_IP_RANGES or
        ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any
        other RouterNat section in any Router for this network in this region.
        Possible values are `ALL_SUBNETWORKS_ALL_IP_RANGES`, `ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES`, and `LIST_OF_SUBNETWORKS`.
        """
        return pulumi.get(self, "source_subnetwork_ip_ranges_to_nat")

    @property
    @pulumi.getter
    def subnetworks(self) -> pulumi.Output[Optional[Sequence['outputs.RouterNatSubnetwork']]]:
        """
        One or more subnetwork NAT configurations. Only used if
        `source_subnetwork_ip_ranges_to_nat` is set to `LIST_OF_SUBNETWORKS`
        Structure is documented below.
        """
        return pulumi.get(self, "subnetworks")

    @property
    @pulumi.getter(name="tcpEstablishedIdleTimeoutSec")
    def tcp_established_idle_timeout_sec(self) -> pulumi.Output[Optional[int]]:
        """
        Timeout (in seconds) for TCP established connections.
        Defaults to 1200s if not set.
        """
        return pulumi.get(self, "tcp_established_idle_timeout_sec")

    @property
    @pulumi.getter(name="tcpTimeWaitTimeoutSec")
    def tcp_time_wait_timeout_sec(self) -> pulumi.Output[Optional[int]]:
        """
        Timeout (in seconds) for TCP connections that are in TIME_WAIT state.
        Defaults to 120s if not set.
        """
        return pulumi.get(self, "tcp_time_wait_timeout_sec")

    @property
    @pulumi.getter(name="tcpTransitoryIdleTimeoutSec")
    def tcp_transitory_idle_timeout_sec(self) -> pulumi.Output[Optional[int]]:
        """
        Timeout (in seconds) for TCP transitory connections.
        Defaults to 30s if not set.
        """
        return pulumi.get(self, "tcp_transitory_idle_timeout_sec")

    @property
    @pulumi.getter(name="udpIdleTimeoutSec")
    def udp_idle_timeout_sec(self) -> pulumi.Output[Optional[int]]:
        """
        Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
        """
        return pulumi.get(self, "udp_idle_timeout_sec")

