# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceAttachmentArgs', 'ServiceAttachment']

@pulumi.input_type
class ServiceAttachmentArgs:
    def __init__(__self__, *,
                 connection_preference: pulumi.Input[str],
                 enable_proxy_protocol: pulumi.Input[bool],
                 nat_subnets: pulumi.Input[Sequence[pulumi.Input[str]]],
                 target_service: pulumi.Input[str],
                 consumer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConsumerAcceptListArgs']]]] = None,
                 consumer_reject_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ServiceAttachment resource.
        :param pulumi.Input[str] connection_preference: The connection preference to use for this service attachment. Valid
               values include "ACCEPT_AUTOMATIC", "ACCEPT_MANUAL".
        :param pulumi.Input[bool] enable_proxy_protocol: If true, enable the proxy protocol which is for supplying client TCP/IP
               address data in TCP connections that traverse proxies on their way to
               destination servers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nat_subnets: An array of subnets that is provided for NAT in this service attachment.
        :param pulumi.Input[str] target_service: The URL of a forwarding rule that represents the service identified by
               this service attachment.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConsumerAcceptListArgs']]] consumer_accept_lists: An array of projects that are allowed to connect to this service
               attachment.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] consumer_reject_lists: An array of projects that are not allowed to connect to this service
               attachment.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domain_names: If specified, the domain name will be used during the integration between
               the PSC connected endpoints and the Cloud DNS. For example, this is a
               valid domain name: "p.mycompany.com.". Current max number of domain names
               supported is 1.
        :param pulumi.Input[str] name: Name of the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?`
               which means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: URL of the region where the resource resides.
        """
        pulumi.set(__self__, "connection_preference", connection_preference)
        pulumi.set(__self__, "enable_proxy_protocol", enable_proxy_protocol)
        pulumi.set(__self__, "nat_subnets", nat_subnets)
        pulumi.set(__self__, "target_service", target_service)
        if consumer_accept_lists is not None:
            pulumi.set(__self__, "consumer_accept_lists", consumer_accept_lists)
        if consumer_reject_lists is not None:
            pulumi.set(__self__, "consumer_reject_lists", consumer_reject_lists)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_names is not None:
            pulumi.set(__self__, "domain_names", domain_names)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="connectionPreference")
    def connection_preference(self) -> pulumi.Input[str]:
        """
        The connection preference to use for this service attachment. Valid
        values include "ACCEPT_AUTOMATIC", "ACCEPT_MANUAL".
        """
        return pulumi.get(self, "connection_preference")

    @connection_preference.setter
    def connection_preference(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_preference", value)

    @property
    @pulumi.getter(name="enableProxyProtocol")
    def enable_proxy_protocol(self) -> pulumi.Input[bool]:
        """
        If true, enable the proxy protocol which is for supplying client TCP/IP
        address data in TCP connections that traverse proxies on their way to
        destination servers.
        """
        return pulumi.get(self, "enable_proxy_protocol")

    @enable_proxy_protocol.setter
    def enable_proxy_protocol(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_proxy_protocol", value)

    @property
    @pulumi.getter(name="natSubnets")
    def nat_subnets(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        An array of subnets that is provided for NAT in this service attachment.
        """
        return pulumi.get(self, "nat_subnets")

    @nat_subnets.setter
    def nat_subnets(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "nat_subnets", value)

    @property
    @pulumi.getter(name="targetService")
    def target_service(self) -> pulumi.Input[str]:
        """
        The URL of a forwarding rule that represents the service identified by
        this service attachment.
        """
        return pulumi.get(self, "target_service")

    @target_service.setter
    def target_service(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_service", value)

    @property
    @pulumi.getter(name="consumerAcceptLists")
    def consumer_accept_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConsumerAcceptListArgs']]]]:
        """
        An array of projects that are allowed to connect to this service
        attachment.
        Structure is documented below.
        """
        return pulumi.get(self, "consumer_accept_lists")

    @consumer_accept_lists.setter
    def consumer_accept_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConsumerAcceptListArgs']]]]):
        pulumi.set(self, "consumer_accept_lists", value)

    @property
    @pulumi.getter(name="consumerRejectLists")
    def consumer_reject_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of projects that are not allowed to connect to this service
        attachment.
        """
        return pulumi.get(self, "consumer_reject_lists")

    @consumer_reject_lists.setter
    def consumer_reject_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "consumer_reject_lists", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If specified, the domain name will be used during the integration between
        the PSC connected endpoints and the Cloud DNS. For example, this is a
        valid domain name: "p.mycompany.com.". Current max number of domain names
        supported is 1.
        """
        return pulumi.get(self, "domain_names")

    @domain_names.setter
    def domain_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domain_names", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. The name must be 1-63 characters long, and
        comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?`
        which means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the region where the resource resides.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ServiceAttachmentState:
    def __init__(__self__, *,
                 connected_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConnectedEndpointArgs']]]] = None,
                 connection_preference: Optional[pulumi.Input[str]] = None,
                 consumer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConsumerAcceptListArgs']]]] = None,
                 consumer_reject_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_proxy_protocol: Optional[pulumi.Input[bool]] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nat_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 target_service: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServiceAttachment resources.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConnectedEndpointArgs']]] connected_endpoints: An array of the consumer forwarding rules connected to this service
               attachment.
               Structure is documented below.
        :param pulumi.Input[str] connection_preference: The connection preference to use for this service attachment. Valid
               values include "ACCEPT_AUTOMATIC", "ACCEPT_MANUAL".
        :param pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConsumerAcceptListArgs']]] consumer_accept_lists: An array of projects that are allowed to connect to this service
               attachment.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] consumer_reject_lists: An array of projects that are not allowed to connect to this service
               attachment.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domain_names: If specified, the domain name will be used during the integration between
               the PSC connected endpoints and the Cloud DNS. For example, this is a
               valid domain name: "p.mycompany.com.". Current max number of domain names
               supported is 1.
        :param pulumi.Input[bool] enable_proxy_protocol: If true, enable the proxy protocol which is for supplying client TCP/IP
               address data in TCP connections that traverse proxies on their way to
               destination servers.
        :param pulumi.Input[str] fingerprint: Fingerprint of this resource. This field is used internally during
               updates of this resource.
        :param pulumi.Input[str] name: Name of the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?`
               which means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nat_subnets: An array of subnets that is provided for NAT in this service attachment.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: URL of the region where the resource resides.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] target_service: The URL of a forwarding rule that represents the service identified by
               this service attachment.
        """
        if connected_endpoints is not None:
            pulumi.set(__self__, "connected_endpoints", connected_endpoints)
        if connection_preference is not None:
            pulumi.set(__self__, "connection_preference", connection_preference)
        if consumer_accept_lists is not None:
            pulumi.set(__self__, "consumer_accept_lists", consumer_accept_lists)
        if consumer_reject_lists is not None:
            pulumi.set(__self__, "consumer_reject_lists", consumer_reject_lists)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_names is not None:
            pulumi.set(__self__, "domain_names", domain_names)
        if enable_proxy_protocol is not None:
            pulumi.set(__self__, "enable_proxy_protocol", enable_proxy_protocol)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_subnets is not None:
            pulumi.set(__self__, "nat_subnets", nat_subnets)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if target_service is not None:
            pulumi.set(__self__, "target_service", target_service)

    @property
    @pulumi.getter(name="connectedEndpoints")
    def connected_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConnectedEndpointArgs']]]]:
        """
        An array of the consumer forwarding rules connected to this service
        attachment.
        Structure is documented below.
        """
        return pulumi.get(self, "connected_endpoints")

    @connected_endpoints.setter
    def connected_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConnectedEndpointArgs']]]]):
        pulumi.set(self, "connected_endpoints", value)

    @property
    @pulumi.getter(name="connectionPreference")
    def connection_preference(self) -> Optional[pulumi.Input[str]]:
        """
        The connection preference to use for this service attachment. Valid
        values include "ACCEPT_AUTOMATIC", "ACCEPT_MANUAL".
        """
        return pulumi.get(self, "connection_preference")

    @connection_preference.setter
    def connection_preference(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_preference", value)

    @property
    @pulumi.getter(name="consumerAcceptLists")
    def consumer_accept_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConsumerAcceptListArgs']]]]:
        """
        An array of projects that are allowed to connect to this service
        attachment.
        Structure is documented below.
        """
        return pulumi.get(self, "consumer_accept_lists")

    @consumer_accept_lists.setter
    def consumer_accept_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConsumerAcceptListArgs']]]]):
        pulumi.set(self, "consumer_accept_lists", value)

    @property
    @pulumi.getter(name="consumerRejectLists")
    def consumer_reject_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of projects that are not allowed to connect to this service
        attachment.
        """
        return pulumi.get(self, "consumer_reject_lists")

    @consumer_reject_lists.setter
    def consumer_reject_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "consumer_reject_lists", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If specified, the domain name will be used during the integration between
        the PSC connected endpoints and the Cloud DNS. For example, this is a
        valid domain name: "p.mycompany.com.". Current max number of domain names
        supported is 1.
        """
        return pulumi.get(self, "domain_names")

    @domain_names.setter
    def domain_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domain_names", value)

    @property
    @pulumi.getter(name="enableProxyProtocol")
    def enable_proxy_protocol(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, enable the proxy protocol which is for supplying client TCP/IP
        address data in TCP connections that traverse proxies on their way to
        destination servers.
        """
        return pulumi.get(self, "enable_proxy_protocol")

    @enable_proxy_protocol.setter
    def enable_proxy_protocol(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_proxy_protocol", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        Fingerprint of this resource. This field is used internally during
        updates of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. The name must be 1-63 characters long, and
        comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?`
        which means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="natSubnets")
    def nat_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of subnets that is provided for NAT in this service attachment.
        """
        return pulumi.get(self, "nat_subnets")

    @nat_subnets.setter
    def nat_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nat_subnets", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the region where the resource resides.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="targetService")
    def target_service(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of a forwarding rule that represents the service identified by
        this service attachment.
        """
        return pulumi.get(self, "target_service")

    @target_service.setter
    def target_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_service", value)


class ServiceAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_preference: Optional[pulumi.Input[str]] = None,
                 consumer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceAttachmentConsumerAcceptListArgs']]]]] = None,
                 consumer_reject_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_proxy_protocol: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nat_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 target_service: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Represents a ServiceAttachment resource.

        To get more information about ServiceAttachment, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/beta/serviceAttachments)
        * How-to Guides
            * [Configuring Private Service Connect to access services](https://cloud.google.com/vpc/docs/configure-private-service-connect-services)

        ## Example Usage

        ## Import

        ServiceAttachment can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/serviceAttachment:ServiceAttachment default projects/{{project}}/regions/{{region}}/serviceAttachments/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/serviceAttachment:ServiceAttachment default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/serviceAttachment:ServiceAttachment default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/serviceAttachment:ServiceAttachment default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_preference: The connection preference to use for this service attachment. Valid
               values include "ACCEPT_AUTOMATIC", "ACCEPT_MANUAL".
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceAttachmentConsumerAcceptListArgs']]]] consumer_accept_lists: An array of projects that are allowed to connect to this service
               attachment.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] consumer_reject_lists: An array of projects that are not allowed to connect to this service
               attachment.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domain_names: If specified, the domain name will be used during the integration between
               the PSC connected endpoints and the Cloud DNS. For example, this is a
               valid domain name: "p.mycompany.com.". Current max number of domain names
               supported is 1.
        :param pulumi.Input[bool] enable_proxy_protocol: If true, enable the proxy protocol which is for supplying client TCP/IP
               address data in TCP connections that traverse proxies on their way to
               destination servers.
        :param pulumi.Input[str] name: Name of the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?`
               which means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nat_subnets: An array of subnets that is provided for NAT in this service attachment.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: URL of the region where the resource resides.
        :param pulumi.Input[str] target_service: The URL of a forwarding rule that represents the service identified by
               this service attachment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a ServiceAttachment resource.

        To get more information about ServiceAttachment, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/beta/serviceAttachments)
        * How-to Guides
            * [Configuring Private Service Connect to access services](https://cloud.google.com/vpc/docs/configure-private-service-connect-services)

        ## Example Usage

        ## Import

        ServiceAttachment can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/serviceAttachment:ServiceAttachment default projects/{{project}}/regions/{{region}}/serviceAttachments/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/serviceAttachment:ServiceAttachment default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/serviceAttachment:ServiceAttachment default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/serviceAttachment:ServiceAttachment default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ServiceAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_preference: Optional[pulumi.Input[str]] = None,
                 consumer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceAttachmentConsumerAcceptListArgs']]]]] = None,
                 consumer_reject_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_proxy_protocol: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nat_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 target_service: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceAttachmentArgs.__new__(ServiceAttachmentArgs)

            if connection_preference is None and not opts.urn:
                raise TypeError("Missing required property 'connection_preference'")
            __props__.__dict__["connection_preference"] = connection_preference
            __props__.__dict__["consumer_accept_lists"] = consumer_accept_lists
            __props__.__dict__["consumer_reject_lists"] = consumer_reject_lists
            __props__.__dict__["description"] = description
            __props__.__dict__["domain_names"] = domain_names
            if enable_proxy_protocol is None and not opts.urn:
                raise TypeError("Missing required property 'enable_proxy_protocol'")
            __props__.__dict__["enable_proxy_protocol"] = enable_proxy_protocol
            __props__.__dict__["name"] = name
            if nat_subnets is None and not opts.urn:
                raise TypeError("Missing required property 'nat_subnets'")
            __props__.__dict__["nat_subnets"] = nat_subnets
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            if target_service is None and not opts.urn:
                raise TypeError("Missing required property 'target_service'")
            __props__.__dict__["target_service"] = target_service
            __props__.__dict__["connected_endpoints"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["self_link"] = None
        super(ServiceAttachment, __self__).__init__(
            'gcp:compute/serviceAttachment:ServiceAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connected_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceAttachmentConnectedEndpointArgs']]]]] = None,
            connection_preference: Optional[pulumi.Input[str]] = None,
            consumer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceAttachmentConsumerAcceptListArgs']]]]] = None,
            consumer_reject_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            enable_proxy_protocol: Optional[pulumi.Input[bool]] = None,
            fingerprint: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nat_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            project: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            target_service: Optional[pulumi.Input[str]] = None) -> 'ServiceAttachment':
        """
        Get an existing ServiceAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceAttachmentConnectedEndpointArgs']]]] connected_endpoints: An array of the consumer forwarding rules connected to this service
               attachment.
               Structure is documented below.
        :param pulumi.Input[str] connection_preference: The connection preference to use for this service attachment. Valid
               values include "ACCEPT_AUTOMATIC", "ACCEPT_MANUAL".
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceAttachmentConsumerAcceptListArgs']]]] consumer_accept_lists: An array of projects that are allowed to connect to this service
               attachment.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] consumer_reject_lists: An array of projects that are not allowed to connect to this service
               attachment.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domain_names: If specified, the domain name will be used during the integration between
               the PSC connected endpoints and the Cloud DNS. For example, this is a
               valid domain name: "p.mycompany.com.". Current max number of domain names
               supported is 1.
        :param pulumi.Input[bool] enable_proxy_protocol: If true, enable the proxy protocol which is for supplying client TCP/IP
               address data in TCP connections that traverse proxies on their way to
               destination servers.
        :param pulumi.Input[str] fingerprint: Fingerprint of this resource. This field is used internally during
               updates of this resource.
        :param pulumi.Input[str] name: Name of the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?`
               which means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nat_subnets: An array of subnets that is provided for NAT in this service attachment.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: URL of the region where the resource resides.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] target_service: The URL of a forwarding rule that represents the service identified by
               this service attachment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceAttachmentState.__new__(_ServiceAttachmentState)

        __props__.__dict__["connected_endpoints"] = connected_endpoints
        __props__.__dict__["connection_preference"] = connection_preference
        __props__.__dict__["consumer_accept_lists"] = consumer_accept_lists
        __props__.__dict__["consumer_reject_lists"] = consumer_reject_lists
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_names"] = domain_names
        __props__.__dict__["enable_proxy_protocol"] = enable_proxy_protocol
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["name"] = name
        __props__.__dict__["nat_subnets"] = nat_subnets
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["target_service"] = target_service
        return ServiceAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectedEndpoints")
    def connected_endpoints(self) -> pulumi.Output[Sequence['outputs.ServiceAttachmentConnectedEndpoint']]:
        """
        An array of the consumer forwarding rules connected to this service
        attachment.
        Structure is documented below.
        """
        return pulumi.get(self, "connected_endpoints")

    @property
    @pulumi.getter(name="connectionPreference")
    def connection_preference(self) -> pulumi.Output[str]:
        """
        The connection preference to use for this service attachment. Valid
        values include "ACCEPT_AUTOMATIC", "ACCEPT_MANUAL".
        """
        return pulumi.get(self, "connection_preference")

    @property
    @pulumi.getter(name="consumerAcceptLists")
    def consumer_accept_lists(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceAttachmentConsumerAcceptList']]]:
        """
        An array of projects that are allowed to connect to this service
        attachment.
        Structure is documented below.
        """
        return pulumi.get(self, "consumer_accept_lists")

    @property
    @pulumi.getter(name="consumerRejectLists")
    def consumer_reject_lists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array of projects that are not allowed to connect to this service
        attachment.
        """
        return pulumi.get(self, "consumer_reject_lists")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        If specified, the domain name will be used during the integration between
        the PSC connected endpoints and the Cloud DNS. For example, this is a
        valid domain name: "p.mycompany.com.". Current max number of domain names
        supported is 1.
        """
        return pulumi.get(self, "domain_names")

    @property
    @pulumi.getter(name="enableProxyProtocol")
    def enable_proxy_protocol(self) -> pulumi.Output[bool]:
        """
        If true, enable the proxy protocol which is for supplying client TCP/IP
        address data in TCP connections that traverse proxies on their way to
        destination servers.
        """
        return pulumi.get(self, "enable_proxy_protocol")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[str]:
        """
        Fingerprint of this resource. This field is used internally during
        updates of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource. The name must be 1-63 characters long, and
        comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?`
        which means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="natSubnets")
    def nat_subnets(self) -> pulumi.Output[Sequence[str]]:
        """
        An array of subnets that is provided for NAT in this service attachment.
        """
        return pulumi.get(self, "nat_subnets")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        URL of the region where the resource resides.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="targetService")
    def target_service(self) -> pulumi.Output[str]:
        """
        The URL of a forwarding rule that represents the service identified by
        this service attachment.
        """
        return pulumi.get(self, "target_service")

