# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetRegistryRepositoryResult',
    'AwaitableGetRegistryRepositoryResult',
    'get_registry_repository',
    'get_registry_repository_output',
]

@pulumi.output_type
class GetRegistryRepositoryResult:
    """
    A collection of values returned by getRegistryRepository.
    """
    def __init__(__self__, id=None, project=None, region=None, repository_url=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if repository_url and not isinstance(repository_url, str):
            raise TypeError("Expected argument 'repository_url' to be a str")
        pulumi.set(__self__, "repository_url", repository_url)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> str:
        """
        The URL at which the repository can be accessed.
        """
        return pulumi.get(self, "repository_url")


class AwaitableGetRegistryRepositoryResult(GetRegistryRepositoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegistryRepositoryResult(
            id=self.id,
            project=self.project,
            region=self.region,
            repository_url=self.repository_url)


def get_registry_repository(project: Optional[str] = None,
                            region: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegistryRepositoryResult:
    """
    This data source fetches the project name, and provides the appropriate URLs to use for container registry for this project.

    The URLs are computed entirely offline - as long as the project exists, they will be valid, but this data source does not contact Google Container Registry (GCR) at any point.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.container.get_registry_repository()
    pulumi.export("gcrLocation", foo.repository_url)
    ```


    :param str project: The project ID that this repository is attached to.  If not provided, provider project will be used instead.
    :param str region: The GCR region to use.  As of this writing, one of `asia`, `eu`, and `us`.  See [the documentation](https://cloud.google.com/container-registry/docs/pushing-and-pulling) for additional information.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:container/getRegistryRepository:getRegistryRepository', __args__, opts=opts, typ=GetRegistryRepositoryResult).value

    return AwaitableGetRegistryRepositoryResult(
        id=__ret__.id,
        project=__ret__.project,
        region=__ret__.region,
        repository_url=__ret__.repository_url)


@_utilities.lift_output_func(get_registry_repository)
def get_registry_repository_output(project: Optional[pulumi.Input[Optional[str]]] = None,
                                   region: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRegistryRepositoryResult]:
    """
    This data source fetches the project name, and provides the appropriate URLs to use for container registry for this project.

    The URLs are computed entirely offline - as long as the project exists, they will be valid, but this data source does not contact Google Container Registry (GCR) at any point.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.container.get_registry_repository()
    pulumi.export("gcrLocation", foo.repository_url)
    ```


    :param str project: The project ID that this repository is attached to.  If not provided, provider project will be used instead.
    :param str region: The GCR region to use.  As of this writing, one of `asia`, `eu`, and `us`.  See [the documentation](https://cloud.google.com/container-registry/docs/pushing-and-pulling) for additional information.
    """
    ...
