# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'NoteAttestationAuthority',
    'NoteAttestationAuthorityHint',
    'NoteRelatedUrl',
    'OccurenceAttestation',
    'OccurenceAttestationSignature',
]

@pulumi.output_type
class NoteAttestationAuthority(dict):
    def __init__(__self__, *,
                 hint: 'outputs.NoteAttestationAuthorityHint'):
        """
        :param 'NoteAttestationAuthorityHintArgs' hint: This submessage provides human-readable hints about the purpose of
               the AttestationAuthority. Because the name of a Note acts as its
               resource reference, it is important to disambiguate the canonical
               name of the Note (which might be a UUID for security purposes)
               from "readable" names more suitable for debug output. Note that
               these hints should NOT be used to look up AttestationAuthorities
               in security sensitive contexts, such as when looking up
               Attestations to verify.
               Structure is documented below.
        """
        pulumi.set(__self__, "hint", hint)

    @property
    @pulumi.getter
    def hint(self) -> 'outputs.NoteAttestationAuthorityHint':
        """
        This submessage provides human-readable hints about the purpose of
        the AttestationAuthority. Because the name of a Note acts as its
        resource reference, it is important to disambiguate the canonical
        name of the Note (which might be a UUID for security purposes)
        from "readable" names more suitable for debug output. Note that
        these hints should NOT be used to look up AttestationAuthorities
        in security sensitive contexts, such as when looking up
        Attestations to verify.
        Structure is documented below.
        """
        return pulumi.get(self, "hint")


@pulumi.output_type
class NoteAttestationAuthorityHint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "humanReadableName":
            suggest = "human_readable_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NoteAttestationAuthorityHint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NoteAttestationAuthorityHint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NoteAttestationAuthorityHint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 human_readable_name: str):
        """
        :param str human_readable_name: The human readable name of this Attestation Authority, for
               example "qa".
        """
        pulumi.set(__self__, "human_readable_name", human_readable_name)

    @property
    @pulumi.getter(name="humanReadableName")
    def human_readable_name(self) -> str:
        """
        The human readable name of this Attestation Authority, for
        example "qa".
        """
        return pulumi.get(self, "human_readable_name")


@pulumi.output_type
class NoteRelatedUrl(dict):
    def __init__(__self__, *,
                 url: str,
                 label: Optional[str] = None):
        """
        :param str url: Specific URL associated with the resource.
        :param str label: Label to describe usage of the URL
        """
        pulumi.set(__self__, "url", url)
        if label is not None:
            pulumi.set(__self__, "label", label)

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Specific URL associated with the resource.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        Label to describe usage of the URL
        """
        return pulumi.get(self, "label")


@pulumi.output_type
class OccurenceAttestation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serializedPayload":
            suggest = "serialized_payload"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OccurenceAttestation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OccurenceAttestation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OccurenceAttestation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 serialized_payload: str,
                 signatures: Sequence['outputs.OccurenceAttestationSignature']):
        """
        :param str serialized_payload: The serialized payload that is verified by one or
               more signatures. A base64-encoded string.
        :param Sequence['OccurenceAttestationSignatureArgs'] signatures: One or more signatures over serializedPayload.
               Verifier implementations should consider this attestation
               message verified if at least one signature verifies
               serializedPayload. See Signature in common.proto for more
               details on signature structure and verification.
               Structure is documented below.
        """
        pulumi.set(__self__, "serialized_payload", serialized_payload)
        pulumi.set(__self__, "signatures", signatures)

    @property
    @pulumi.getter(name="serializedPayload")
    def serialized_payload(self) -> str:
        """
        The serialized payload that is verified by one or
        more signatures. A base64-encoded string.
        """
        return pulumi.get(self, "serialized_payload")

    @property
    @pulumi.getter
    def signatures(self) -> Sequence['outputs.OccurenceAttestationSignature']:
        """
        One or more signatures over serializedPayload.
        Verifier implementations should consider this attestation
        message verified if at least one signature verifies
        serializedPayload. See Signature in common.proto for more
        details on signature structure and verification.
        Structure is documented below.
        """
        return pulumi.get(self, "signatures")


@pulumi.output_type
class OccurenceAttestationSignature(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKeyId":
            suggest = "public_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OccurenceAttestationSignature. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OccurenceAttestationSignature.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OccurenceAttestationSignature.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_key_id: str,
                 signature: Optional[str] = None):
        """
        :param str public_key_id: The identifier for the public key that verifies this
               signature. MUST be an RFC3986 conformant
               URI. * When possible, the key id should be an
               immutable reference, such as a cryptographic digest.
               Examples of valid values:
               * OpenPGP V4 public key fingerprint. See https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr
               for more details on this scheme.
               * `openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA`
               * RFC6920 digest-named SubjectPublicKeyInfo (digest of the DER serialization):
               * "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU"
        :param str signature: The content of the signature, an opaque bytestring.
               The payload that this signature verifies MUST be
               unambiguously provided with the Signature during
               verification. A wrapper message might provide the
               payload explicitly. Alternatively, a message might
               have a canonical serialization that can always be
               unambiguously computed to derive the payload.
        """
        pulumi.set(__self__, "public_key_id", public_key_id)
        if signature is not None:
            pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="publicKeyId")
    def public_key_id(self) -> str:
        """
        The identifier for the public key that verifies this
        signature. MUST be an RFC3986 conformant
        URI. * When possible, the key id should be an
        immutable reference, such as a cryptographic digest.
        Examples of valid values:
        * OpenPGP V4 public key fingerprint. See https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr
        for more details on this scheme.
        * `openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA`
        * RFC6920 digest-named SubjectPublicKeyInfo (digest of the DER serialization):
        * "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU"
        """
        return pulumi.get(self, "public_key_id")

    @property
    @pulumi.getter
    def signature(self) -> Optional[str]:
        """
        The content of the signature, an opaque bytestring.
        The payload that this signature verifies MUST be
        unambiguously provided with the Signature during
        verification. A wrapper message might provide the
        payload explicitly. Alternatively, a message might
        have a canonical serialization that can always be
        unambiguously computed to derive the payload.
        """
        return pulumi.get(self, "signature")


