# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DnsManagedZoneIamBindingConditionArgs',
    'DnsManagedZoneIamMemberConditionArgs',
    'ManagedZoneCloudLoggingConfigArgs',
    'ManagedZoneDnssecConfigArgs',
    'ManagedZoneDnssecConfigDefaultKeySpecArgs',
    'ManagedZoneForwardingConfigArgs',
    'ManagedZoneForwardingConfigTargetNameServerArgs',
    'ManagedZonePeeringConfigArgs',
    'ManagedZonePeeringConfigTargetNetworkArgs',
    'ManagedZonePrivateVisibilityConfigArgs',
    'ManagedZonePrivateVisibilityConfigGkeClusterArgs',
    'ManagedZonePrivateVisibilityConfigNetworkArgs',
    'ManagedZoneServiceDirectoryConfigArgs',
    'ManagedZoneServiceDirectoryConfigNamespaceArgs',
    'PolicyAlternativeNameServerConfigArgs',
    'PolicyAlternativeNameServerConfigTargetNameServerArgs',
    'PolicyNetworkArgs',
    'RecordSetRoutingPolicyArgs',
    'RecordSetRoutingPolicyGeoArgs',
    'RecordSetRoutingPolicyGeoHealthCheckedTargetsArgs',
    'RecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancerArgs',
    'RecordSetRoutingPolicyPrimaryBackupArgs',
    'RecordSetRoutingPolicyPrimaryBackupBackupGeoArgs',
    'RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsArgs',
    'RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancerArgs',
    'RecordSetRoutingPolicyPrimaryBackupPrimaryArgs',
    'RecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancerArgs',
    'RecordSetRoutingPolicyWrrArgs',
    'RecordSetRoutingPolicyWrrHealthCheckedTargetsArgs',
    'RecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancerArgs',
    'ResponsePolicyGkeClusterArgs',
    'ResponsePolicyNetworkArgs',
    'ResponsePolicyRuleLocalDataArgs',
    'ResponsePolicyRuleLocalDataLocalDataArgs',
]

@pulumi.input_type
class DnsManagedZoneIamBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class DnsManagedZoneIamMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class ManagedZoneCloudLoggingConfigArgs:
    def __init__(__self__, *,
                 enable_logging: pulumi.Input[bool]):
        """
        :param pulumi.Input[bool] enable_logging: If set, enable query logging for this ManagedZone. False by default, making logging opt-in.
        """
        pulumi.set(__self__, "enable_logging", enable_logging)

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> pulumi.Input[bool]:
        """
        If set, enable query logging for this ManagedZone. False by default, making logging opt-in.
        """
        return pulumi.get(self, "enable_logging")

    @enable_logging.setter
    def enable_logging(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_logging", value)


@pulumi.input_type
class ManagedZoneDnssecConfigArgs:
    def __init__(__self__, *,
                 default_key_specs: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedZoneDnssecConfigDefaultKeySpecArgs']]]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 non_existence: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ManagedZoneDnssecConfigDefaultKeySpecArgs']]] default_key_specs: Specifies parameters that will be used for generating initial DnsKeys
               for this ManagedZone. If you provide a spec for keySigning or zoneSigning,
               you must also provide one for the other.
               default_key_specs can only be updated when the state is `off`.
               Structure is documented below.
        :param pulumi.Input[str] kind: Identifies what kind of resource this is
        :param pulumi.Input[str] non_existence: Specifies the mechanism used to provide authenticated denial-of-existence responses.
               non_existence can only be updated when the state is `off`.
               Possible values are `nsec` and `nsec3`.
        :param pulumi.Input[str] state: Specifies whether DNSSEC is enabled, and what mode it is in
               Possible values are `off`, `on`, and `transfer`.
        """
        if default_key_specs is not None:
            pulumi.set(__self__, "default_key_specs", default_key_specs)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if non_existence is not None:
            pulumi.set(__self__, "non_existence", non_existence)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="defaultKeySpecs")
    def default_key_specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedZoneDnssecConfigDefaultKeySpecArgs']]]]:
        """
        Specifies parameters that will be used for generating initial DnsKeys
        for this ManagedZone. If you provide a spec for keySigning or zoneSigning,
        you must also provide one for the other.
        default_key_specs can only be updated when the state is `off`.
        Structure is documented below.
        """
        return pulumi.get(self, "default_key_specs")

    @default_key_specs.setter
    def default_key_specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedZoneDnssecConfigDefaultKeySpecArgs']]]]):
        pulumi.set(self, "default_key_specs", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies what kind of resource this is
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="nonExistence")
    def non_existence(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the mechanism used to provide authenticated denial-of-existence responses.
        non_existence can only be updated when the state is `off`.
        Possible values are `nsec` and `nsec3`.
        """
        return pulumi.get(self, "non_existence")

    @non_existence.setter
    def non_existence(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "non_existence", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether DNSSEC is enabled, and what mode it is in
        Possible values are `off`, `on`, and `transfer`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class ManagedZoneDnssecConfigDefaultKeySpecArgs:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[str]] = None,
                 key_length: Optional[pulumi.Input[int]] = None,
                 key_type: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] algorithm: String mnemonic specifying the DNSSEC algorithm of this key
               Possible values are `ecdsap256sha256`, `ecdsap384sha384`, `rsasha1`, `rsasha256`, and `rsasha512`.
        :param pulumi.Input[int] key_length: Length of the keys in bits
        :param pulumi.Input[str] key_type: Specifies whether this is a key signing key (KSK) or a zone
               signing key (ZSK). Key signing keys have the Secure Entry
               Point flag set and, when active, will only be used to sign
               resource record sets of type DNSKEY. Zone signing keys do
               not have the Secure Entry Point flag set and will be used
               to sign all other types of resource record sets.
               Possible values are `keySigning` and `zoneSigning`.
        :param pulumi.Input[str] kind: Identifies what kind of resource this is
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if key_length is not None:
            pulumi.set(__self__, "key_length", key_length)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        String mnemonic specifying the DNSSEC algorithm of this key
        Possible values are `ecdsap256sha256`, `ecdsap384sha384`, `rsasha1`, `rsasha256`, and `rsasha512`.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="keyLength")
    def key_length(self) -> Optional[pulumi.Input[int]]:
        """
        Length of the keys in bits
        """
        return pulumi.get(self, "key_length")

    @key_length.setter
    def key_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "key_length", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether this is a key signing key (KSK) or a zone
        signing key (ZSK). Key signing keys have the Secure Entry
        Point flag set and, when active, will only be used to sign
        resource record sets of type DNSKEY. Zone signing keys do
        not have the Secure Entry Point flag set and will be used
        to sign all other types of resource record sets.
        Possible values are `keySigning` and `zoneSigning`.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies what kind of resource this is
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)


@pulumi.input_type
class ManagedZoneForwardingConfigArgs:
    def __init__(__self__, *,
                 target_name_servers: pulumi.Input[Sequence[pulumi.Input['ManagedZoneForwardingConfigTargetNameServerArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ManagedZoneForwardingConfigTargetNameServerArgs']]] target_name_servers: List of target name servers to forward to. Cloud DNS will
               select the best available name server if more than
               one target is given.
               Structure is documented below.
        """
        pulumi.set(__self__, "target_name_servers", target_name_servers)

    @property
    @pulumi.getter(name="targetNameServers")
    def target_name_servers(self) -> pulumi.Input[Sequence[pulumi.Input['ManagedZoneForwardingConfigTargetNameServerArgs']]]:
        """
        List of target name servers to forward to. Cloud DNS will
        select the best available name server if more than
        one target is given.
        Structure is documented below.
        """
        return pulumi.get(self, "target_name_servers")

    @target_name_servers.setter
    def target_name_servers(self, value: pulumi.Input[Sequence[pulumi.Input['ManagedZoneForwardingConfigTargetNameServerArgs']]]):
        pulumi.set(self, "target_name_servers", value)


@pulumi.input_type
class ManagedZoneForwardingConfigTargetNameServerArgs:
    def __init__(__self__, *,
                 ipv4_address: pulumi.Input[str],
                 forwarding_path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ipv4_address: IPv4 address of a target name server.
        :param pulumi.Input[str] forwarding_path: Forwarding path for this TargetNameServer. If unset or `default` Cloud DNS will make forwarding
               decision based on address ranges, i.e. RFC1918 addresses go to the VPC, Non-RFC1918 addresses go
               to the Internet. When set to `private`, Cloud DNS will always send queries through VPC for this target
               Possible values are `default` and `private`.
        """
        pulumi.set(__self__, "ipv4_address", ipv4_address)
        if forwarding_path is not None:
            pulumi.set(__self__, "forwarding_path", forwarding_path)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> pulumi.Input[str]:
        """
        IPv4 address of a target name server.
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ipv4_address", value)

    @property
    @pulumi.getter(name="forwardingPath")
    def forwarding_path(self) -> Optional[pulumi.Input[str]]:
        """
        Forwarding path for this TargetNameServer. If unset or `default` Cloud DNS will make forwarding
        decision based on address ranges, i.e. RFC1918 addresses go to the VPC, Non-RFC1918 addresses go
        to the Internet. When set to `private`, Cloud DNS will always send queries through VPC for this target
        Possible values are `default` and `private`.
        """
        return pulumi.get(self, "forwarding_path")

    @forwarding_path.setter
    def forwarding_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "forwarding_path", value)


@pulumi.input_type
class ManagedZonePeeringConfigArgs:
    def __init__(__self__, *,
                 target_network: pulumi.Input['ManagedZonePeeringConfigTargetNetworkArgs']):
        """
        :param pulumi.Input['ManagedZonePeeringConfigTargetNetworkArgs'] target_network: The network with which to peer.
               Structure is documented below.
        """
        pulumi.set(__self__, "target_network", target_network)

    @property
    @pulumi.getter(name="targetNetwork")
    def target_network(self) -> pulumi.Input['ManagedZonePeeringConfigTargetNetworkArgs']:
        """
        The network with which to peer.
        Structure is documented below.
        """
        return pulumi.get(self, "target_network")

    @target_network.setter
    def target_network(self, value: pulumi.Input['ManagedZonePeeringConfigTargetNetworkArgs']):
        pulumi.set(self, "target_network", value)


@pulumi.input_type
class ManagedZonePeeringConfigTargetNetworkArgs:
    def __init__(__self__, *,
                 network_url: pulumi.Input[str]):
        """
        :param pulumi.Input[str] network_url: The id or fully qualified URL of the VPC network to forward queries to.
               This should be formatted like `projects/{project}/global/networks/{network}` or
               `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`
        """
        pulumi.set(__self__, "network_url", network_url)

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> pulumi.Input[str]:
        """
        The id or fully qualified URL of the VPC network to forward queries to.
        This should be formatted like `projects/{project}/global/networks/{network}` or
        `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`
        """
        return pulumi.get(self, "network_url")

    @network_url.setter
    def network_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_url", value)


@pulumi.input_type
class ManagedZonePrivateVisibilityConfigArgs:
    def __init__(__self__, *,
                 networks: pulumi.Input[Sequence[pulumi.Input['ManagedZonePrivateVisibilityConfigNetworkArgs']]],
                 gke_clusters: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedZonePrivateVisibilityConfigGkeClusterArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ManagedZonePrivateVisibilityConfigGkeClusterArgs']]] gke_clusters: The list of Google Kubernetes Engine clusters that can see this zone.
               Structure is documented below.
        """
        pulumi.set(__self__, "networks", networks)
        if gke_clusters is not None:
            pulumi.set(__self__, "gke_clusters", gke_clusters)

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Input[Sequence[pulumi.Input['ManagedZonePrivateVisibilityConfigNetworkArgs']]]:
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: pulumi.Input[Sequence[pulumi.Input['ManagedZonePrivateVisibilityConfigNetworkArgs']]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter(name="gkeClusters")
    def gke_clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedZonePrivateVisibilityConfigGkeClusterArgs']]]]:
        """
        The list of Google Kubernetes Engine clusters that can see this zone.
        Structure is documented below.
        """
        return pulumi.get(self, "gke_clusters")

    @gke_clusters.setter
    def gke_clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedZonePrivateVisibilityConfigGkeClusterArgs']]]]):
        pulumi.set(self, "gke_clusters", value)


@pulumi.input_type
class ManagedZonePrivateVisibilityConfigGkeClusterArgs:
    def __init__(__self__, *,
                 gke_cluster_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] gke_cluster_name: The resource name of the cluster to bind this ManagedZone to.
               This should be specified in the format like
               `projects/*/locations/*/clusters/*`
        """
        pulumi.set(__self__, "gke_cluster_name", gke_cluster_name)

    @property
    @pulumi.getter(name="gkeClusterName")
    def gke_cluster_name(self) -> pulumi.Input[str]:
        """
        The resource name of the cluster to bind this ManagedZone to.
        This should be specified in the format like
        `projects/*/locations/*/clusters/*`
        """
        return pulumi.get(self, "gke_cluster_name")

    @gke_cluster_name.setter
    def gke_cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "gke_cluster_name", value)


@pulumi.input_type
class ManagedZonePrivateVisibilityConfigNetworkArgs:
    def __init__(__self__, *,
                 network_url: pulumi.Input[str]):
        """
        :param pulumi.Input[str] network_url: The id or fully qualified URL of the VPC network to bind to.
               This should be formatted like `projects/{project}/global/networks/{network}` or
               `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`
        """
        pulumi.set(__self__, "network_url", network_url)

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> pulumi.Input[str]:
        """
        The id or fully qualified URL of the VPC network to bind to.
        This should be formatted like `projects/{project}/global/networks/{network}` or
        `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`
        """
        return pulumi.get(self, "network_url")

    @network_url.setter
    def network_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_url", value)


@pulumi.input_type
class ManagedZoneServiceDirectoryConfigArgs:
    def __init__(__self__, *,
                 namespace: pulumi.Input['ManagedZoneServiceDirectoryConfigNamespaceArgs']):
        """
        :param pulumi.Input['ManagedZoneServiceDirectoryConfigNamespaceArgs'] namespace: The namespace associated with the zone.
               Structure is documented below.
        """
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input['ManagedZoneServiceDirectoryConfigNamespaceArgs']:
        """
        The namespace associated with the zone.
        Structure is documented below.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input['ManagedZoneServiceDirectoryConfigNamespaceArgs']):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class ManagedZoneServiceDirectoryConfigNamespaceArgs:
    def __init__(__self__, *,
                 namespace_url: pulumi.Input[str]):
        """
        :param pulumi.Input[str] namespace_url: The fully qualified or partial URL of the service directory namespace that should be
               associated with the zone. This should be formatted like
               `https://servicedirectory.googleapis.com/v1/projects/{project}/locations/{location}/namespaces/{namespace_id}`
               or simply `projects/{project}/locations/{location}/namespaces/{namespace_id}`
               Ignored for `public` visibility zones.
        """
        pulumi.set(__self__, "namespace_url", namespace_url)

    @property
    @pulumi.getter(name="namespaceUrl")
    def namespace_url(self) -> pulumi.Input[str]:
        """
        The fully qualified or partial URL of the service directory namespace that should be
        associated with the zone. This should be formatted like
        `https://servicedirectory.googleapis.com/v1/projects/{project}/locations/{location}/namespaces/{namespace_id}`
        or simply `projects/{project}/locations/{location}/namespaces/{namespace_id}`
        Ignored for `public` visibility zones.
        """
        return pulumi.get(self, "namespace_url")

    @namespace_url.setter
    def namespace_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace_url", value)


@pulumi.input_type
class PolicyAlternativeNameServerConfigArgs:
    def __init__(__self__, *,
                 target_name_servers: pulumi.Input[Sequence[pulumi.Input['PolicyAlternativeNameServerConfigTargetNameServerArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['PolicyAlternativeNameServerConfigTargetNameServerArgs']]] target_name_servers: Sets an alternative name server for the associated networks. When specified,
               all DNS queries are forwarded to a name server that you choose. Names such as .internal
               are not available when an alternative name server is specified.
               Structure is documented below.
        """
        pulumi.set(__self__, "target_name_servers", target_name_servers)

    @property
    @pulumi.getter(name="targetNameServers")
    def target_name_servers(self) -> pulumi.Input[Sequence[pulumi.Input['PolicyAlternativeNameServerConfigTargetNameServerArgs']]]:
        """
        Sets an alternative name server for the associated networks. When specified,
        all DNS queries are forwarded to a name server that you choose. Names such as .internal
        are not available when an alternative name server is specified.
        Structure is documented below.
        """
        return pulumi.get(self, "target_name_servers")

    @target_name_servers.setter
    def target_name_servers(self, value: pulumi.Input[Sequence[pulumi.Input['PolicyAlternativeNameServerConfigTargetNameServerArgs']]]):
        pulumi.set(self, "target_name_servers", value)


@pulumi.input_type
class PolicyAlternativeNameServerConfigTargetNameServerArgs:
    def __init__(__self__, *,
                 ipv4_address: pulumi.Input[str],
                 forwarding_path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ipv4_address: IPv4 address to forward to.
        :param pulumi.Input[str] forwarding_path: Forwarding path for this TargetNameServer. If unset or `default` Cloud DNS will make forwarding
               decision based on address ranges, i.e. RFC1918 addresses go to the VPC, Non-RFC1918 addresses go
               to the Internet. When set to `private`, Cloud DNS will always send queries through VPC for this target
               Possible values are `default` and `private`.
        """
        pulumi.set(__self__, "ipv4_address", ipv4_address)
        if forwarding_path is not None:
            pulumi.set(__self__, "forwarding_path", forwarding_path)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> pulumi.Input[str]:
        """
        IPv4 address to forward to.
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ipv4_address", value)

    @property
    @pulumi.getter(name="forwardingPath")
    def forwarding_path(self) -> Optional[pulumi.Input[str]]:
        """
        Forwarding path for this TargetNameServer. If unset or `default` Cloud DNS will make forwarding
        decision based on address ranges, i.e. RFC1918 addresses go to the VPC, Non-RFC1918 addresses go
        to the Internet. When set to `private`, Cloud DNS will always send queries through VPC for this target
        Possible values are `default` and `private`.
        """
        return pulumi.get(self, "forwarding_path")

    @forwarding_path.setter
    def forwarding_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "forwarding_path", value)


@pulumi.input_type
class PolicyNetworkArgs:
    def __init__(__self__, *,
                 network_url: pulumi.Input[str]):
        """
        :param pulumi.Input[str] network_url: The id or fully qualified URL of the VPC network to forward queries to.
               This should be formatted like `projects/{project}/global/networks/{network}` or
               `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`
        """
        pulumi.set(__self__, "network_url", network_url)

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> pulumi.Input[str]:
        """
        The id or fully qualified URL of the VPC network to forward queries to.
        This should be formatted like `projects/{project}/global/networks/{network}` or
        `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`
        """
        return pulumi.get(self, "network_url")

    @network_url.setter
    def network_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_url", value)


@pulumi.input_type
class RecordSetRoutingPolicyArgs:
    def __init__(__self__, *,
                 enable_geo_fencing: Optional[pulumi.Input[bool]] = None,
                 geos: Optional[pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyGeoArgs']]]] = None,
                 primary_backup: Optional[pulumi.Input['RecordSetRoutingPolicyPrimaryBackupArgs']] = None,
                 wrrs: Optional[pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyWrrArgs']]]] = None):
        """
        :param pulumi.Input[bool] enable_geo_fencing: Specifies whether to enable fencing for geo queries.
        :param pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyGeoArgs']]] geos: The configuration for Geolocation based routing policy.
               Structure is document below.
        :param pulumi.Input['RecordSetRoutingPolicyPrimaryBackupArgs'] primary_backup: The configuration for a primary-backup policy with global to regional failover. Queries are responded to with the global primary targets, but if none of the primary targets are healthy, then we fallback to a regional failover policy.
               Structure is document below.
        :param pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyWrrArgs']]] wrrs: The configuration for Weighted Round Robin based routing policy.
               Structure is document below.
        """
        if enable_geo_fencing is not None:
            pulumi.set(__self__, "enable_geo_fencing", enable_geo_fencing)
        if geos is not None:
            pulumi.set(__self__, "geos", geos)
        if primary_backup is not None:
            pulumi.set(__self__, "primary_backup", primary_backup)
        if wrrs is not None:
            pulumi.set(__self__, "wrrs", wrrs)

    @property
    @pulumi.getter(name="enableGeoFencing")
    def enable_geo_fencing(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable fencing for geo queries.
        """
        return pulumi.get(self, "enable_geo_fencing")

    @enable_geo_fencing.setter
    def enable_geo_fencing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_geo_fencing", value)

    @property
    @pulumi.getter
    def geos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyGeoArgs']]]]:
        """
        The configuration for Geolocation based routing policy.
        Structure is document below.
        """
        return pulumi.get(self, "geos")

    @geos.setter
    def geos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyGeoArgs']]]]):
        pulumi.set(self, "geos", value)

    @property
    @pulumi.getter(name="primaryBackup")
    def primary_backup(self) -> Optional[pulumi.Input['RecordSetRoutingPolicyPrimaryBackupArgs']]:
        """
        The configuration for a primary-backup policy with global to regional failover. Queries are responded to with the global primary targets, but if none of the primary targets are healthy, then we fallback to a regional failover policy.
        Structure is document below.
        """
        return pulumi.get(self, "primary_backup")

    @primary_backup.setter
    def primary_backup(self, value: Optional[pulumi.Input['RecordSetRoutingPolicyPrimaryBackupArgs']]):
        pulumi.set(self, "primary_backup", value)

    @property
    @pulumi.getter
    def wrrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyWrrArgs']]]]:
        """
        The configuration for Weighted Round Robin based routing policy.
        Structure is document below.
        """
        return pulumi.get(self, "wrrs")

    @wrrs.setter
    def wrrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyWrrArgs']]]]):
        pulumi.set(self, "wrrs", value)


@pulumi.input_type
class RecordSetRoutingPolicyGeoArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 health_checked_targets: Optional[pulumi.Input['RecordSetRoutingPolicyGeoHealthCheckedTargetsArgs']] = None,
                 rrdatas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] location: The location name defined in Google Cloud.
        :param pulumi.Input['RecordSetRoutingPolicyGeoHealthCheckedTargetsArgs'] health_checked_targets: For A and AAAA types only. The list of targets to be health checked. These can be specified along with `rrdatas` within this item.
               Structure is document below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rrdatas: Same as `rrdatas` above.
        """
        pulumi.set(__self__, "location", location)
        if health_checked_targets is not None:
            pulumi.set(__self__, "health_checked_targets", health_checked_targets)
        if rrdatas is not None:
            pulumi.set(__self__, "rrdatas", rrdatas)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location name defined in Google Cloud.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="healthCheckedTargets")
    def health_checked_targets(self) -> Optional[pulumi.Input['RecordSetRoutingPolicyGeoHealthCheckedTargetsArgs']]:
        """
        For A and AAAA types only. The list of targets to be health checked. These can be specified along with `rrdatas` within this item.
        Structure is document below.
        """
        return pulumi.get(self, "health_checked_targets")

    @health_checked_targets.setter
    def health_checked_targets(self, value: Optional[pulumi.Input['RecordSetRoutingPolicyGeoHealthCheckedTargetsArgs']]):
        pulumi.set(self, "health_checked_targets", value)

    @property
    @pulumi.getter
    def rrdatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Same as `rrdatas` above.
        """
        return pulumi.get(self, "rrdatas")

    @rrdatas.setter
    def rrdatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rrdatas", value)


@pulumi.input_type
class RecordSetRoutingPolicyGeoHealthCheckedTargetsArgs:
    def __init__(__self__, *,
                 internal_load_balancers: pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancerArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancerArgs']]] internal_load_balancers: The list of internal load balancers to health check.
               Structure is document below.
        """
        pulumi.set(__self__, "internal_load_balancers", internal_load_balancers)

    @property
    @pulumi.getter(name="internalLoadBalancers")
    def internal_load_balancers(self) -> pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancerArgs']]]:
        """
        The list of internal load balancers to health check.
        Structure is document below.
        """
        return pulumi.get(self, "internal_load_balancers")

    @internal_load_balancers.setter
    def internal_load_balancers(self, value: pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancerArgs']]]):
        pulumi.set(self, "internal_load_balancers", value)


@pulumi.input_type
class RecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancerArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 ip_protocol: pulumi.Input[str],
                 load_balancer_type: pulumi.Input[str],
                 network_url: pulumi.Input[str],
                 port: pulumi.Input[str],
                 project: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip_address: The frontend IP address of the load balancer.
        :param pulumi.Input[str] ip_protocol: The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
        :param pulumi.Input[str] load_balancer_type: The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb"]
        :param pulumi.Input[str] network_url: The fully qualified url of the network in which the load balancer belongs. This should be formatted like `projects/{project}/global/networks/{network}` or `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
        :param pulumi.Input[str] port: The configured port of the load balancer.
        :param pulumi.Input[str] project: The ID of the project in which the load balancer belongs.
        :param pulumi.Input[str] region: The region of the load balancer. Only needed for regional load balancers.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        pulumi.set(__self__, "network_url", network_url)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The frontend IP address of the load balancer.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> pulumi.Input[str]:
        """
        The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> pulumi.Input[str]:
        """
        The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb"]
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "load_balancer_type", value)

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> pulumi.Input[str]:
        """
        The fully qualified url of the network in which the load balancer belongs. This should be formatted like `projects/{project}/global/networks/{network}` or `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
        """
        return pulumi.get(self, "network_url")

    @network_url.setter
    def network_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_url", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[str]:
        """
        The configured port of the load balancer.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[str]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The ID of the project in which the load balancer belongs.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the load balancer. Only needed for regional load balancers.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class RecordSetRoutingPolicyPrimaryBackupArgs:
    def __init__(__self__, *,
                 backup_geos: pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyPrimaryBackupBackupGeoArgs']]],
                 primary: pulumi.Input['RecordSetRoutingPolicyPrimaryBackupPrimaryArgs'],
                 enable_geo_fencing_for_backups: Optional[pulumi.Input[bool]] = None,
                 trickle_ratio: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyPrimaryBackupBackupGeoArgs']]] backup_geos: The backup geo targets, which provide a regional failover policy for the otherwise global primary targets.
               Structure is document above.
        :param pulumi.Input['RecordSetRoutingPolicyPrimaryBackupPrimaryArgs'] primary: The list of global primary targets to be health checked.
               Structure is document below.
        :param pulumi.Input[bool] enable_geo_fencing_for_backups: Specifies whether to enable fencing for backup geo queries.
        :param pulumi.Input[float] trickle_ratio: Specifies the percentage of traffic to send to the backup targets even when the primary targets are healthy.
        """
        pulumi.set(__self__, "backup_geos", backup_geos)
        pulumi.set(__self__, "primary", primary)
        if enable_geo_fencing_for_backups is not None:
            pulumi.set(__self__, "enable_geo_fencing_for_backups", enable_geo_fencing_for_backups)
        if trickle_ratio is not None:
            pulumi.set(__self__, "trickle_ratio", trickle_ratio)

    @property
    @pulumi.getter(name="backupGeos")
    def backup_geos(self) -> pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyPrimaryBackupBackupGeoArgs']]]:
        """
        The backup geo targets, which provide a regional failover policy for the otherwise global primary targets.
        Structure is document above.
        """
        return pulumi.get(self, "backup_geos")

    @backup_geos.setter
    def backup_geos(self, value: pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyPrimaryBackupBackupGeoArgs']]]):
        pulumi.set(self, "backup_geos", value)

    @property
    @pulumi.getter
    def primary(self) -> pulumi.Input['RecordSetRoutingPolicyPrimaryBackupPrimaryArgs']:
        """
        The list of global primary targets to be health checked.
        Structure is document below.
        """
        return pulumi.get(self, "primary")

    @primary.setter
    def primary(self, value: pulumi.Input['RecordSetRoutingPolicyPrimaryBackupPrimaryArgs']):
        pulumi.set(self, "primary", value)

    @property
    @pulumi.getter(name="enableGeoFencingForBackups")
    def enable_geo_fencing_for_backups(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable fencing for backup geo queries.
        """
        return pulumi.get(self, "enable_geo_fencing_for_backups")

    @enable_geo_fencing_for_backups.setter
    def enable_geo_fencing_for_backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_geo_fencing_for_backups", value)

    @property
    @pulumi.getter(name="trickleRatio")
    def trickle_ratio(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the percentage of traffic to send to the backup targets even when the primary targets are healthy.
        """
        return pulumi.get(self, "trickle_ratio")

    @trickle_ratio.setter
    def trickle_ratio(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "trickle_ratio", value)


@pulumi.input_type
class RecordSetRoutingPolicyPrimaryBackupBackupGeoArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 health_checked_targets: Optional[pulumi.Input['RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsArgs']] = None,
                 rrdatas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] location: The location name defined in Google Cloud.
        :param pulumi.Input['RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsArgs'] health_checked_targets: The list of targets to be health checked. Note that if DNSSEC is enabled for this zone, only one of `rrdatas` or `health_checked_targets` can be set.
               Structure is document below.
               Structure is document below.
        """
        pulumi.set(__self__, "location", location)
        if health_checked_targets is not None:
            pulumi.set(__self__, "health_checked_targets", health_checked_targets)
        if rrdatas is not None:
            pulumi.set(__self__, "rrdatas", rrdatas)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location name defined in Google Cloud.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="healthCheckedTargets")
    def health_checked_targets(self) -> Optional[pulumi.Input['RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsArgs']]:
        """
        The list of targets to be health checked. Note that if DNSSEC is enabled for this zone, only one of `rrdatas` or `health_checked_targets` can be set.
        Structure is document below.
        Structure is document below.
        """
        return pulumi.get(self, "health_checked_targets")

    @health_checked_targets.setter
    def health_checked_targets(self, value: Optional[pulumi.Input['RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsArgs']]):
        pulumi.set(self, "health_checked_targets", value)

    @property
    @pulumi.getter
    def rrdatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "rrdatas")

    @rrdatas.setter
    def rrdatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rrdatas", value)


@pulumi.input_type
class RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsArgs:
    def __init__(__self__, *,
                 internal_load_balancers: pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancerArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancerArgs']]] internal_load_balancers: The list of internal load balancers to health check.
               Structure is document below.
        """
        pulumi.set(__self__, "internal_load_balancers", internal_load_balancers)

    @property
    @pulumi.getter(name="internalLoadBalancers")
    def internal_load_balancers(self) -> pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancerArgs']]]:
        """
        The list of internal load balancers to health check.
        Structure is document below.
        """
        return pulumi.get(self, "internal_load_balancers")

    @internal_load_balancers.setter
    def internal_load_balancers(self, value: pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancerArgs']]]):
        pulumi.set(self, "internal_load_balancers", value)


@pulumi.input_type
class RecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancerArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 ip_protocol: pulumi.Input[str],
                 load_balancer_type: pulumi.Input[str],
                 network_url: pulumi.Input[str],
                 port: pulumi.Input[str],
                 project: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip_address: The frontend IP address of the load balancer.
        :param pulumi.Input[str] ip_protocol: The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
        :param pulumi.Input[str] load_balancer_type: The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb"]
        :param pulumi.Input[str] network_url: The fully qualified url of the network in which the load balancer belongs. This should be formatted like `projects/{project}/global/networks/{network}` or `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
        :param pulumi.Input[str] port: The configured port of the load balancer.
        :param pulumi.Input[str] project: The ID of the project in which the load balancer belongs.
        :param pulumi.Input[str] region: The region of the load balancer. Only needed for regional load balancers.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        pulumi.set(__self__, "network_url", network_url)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The frontend IP address of the load balancer.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> pulumi.Input[str]:
        """
        The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> pulumi.Input[str]:
        """
        The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb"]
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "load_balancer_type", value)

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> pulumi.Input[str]:
        """
        The fully qualified url of the network in which the load balancer belongs. This should be formatted like `projects/{project}/global/networks/{network}` or `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
        """
        return pulumi.get(self, "network_url")

    @network_url.setter
    def network_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_url", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[str]:
        """
        The configured port of the load balancer.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[str]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The ID of the project in which the load balancer belongs.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the load balancer. Only needed for regional load balancers.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class RecordSetRoutingPolicyPrimaryBackupPrimaryArgs:
    def __init__(__self__, *,
                 internal_load_balancers: pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancerArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancerArgs']]] internal_load_balancers: The list of internal load balancers to health check.
               Structure is document below.
        """
        pulumi.set(__self__, "internal_load_balancers", internal_load_balancers)

    @property
    @pulumi.getter(name="internalLoadBalancers")
    def internal_load_balancers(self) -> pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancerArgs']]]:
        """
        The list of internal load balancers to health check.
        Structure is document below.
        """
        return pulumi.get(self, "internal_load_balancers")

    @internal_load_balancers.setter
    def internal_load_balancers(self, value: pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancerArgs']]]):
        pulumi.set(self, "internal_load_balancers", value)


@pulumi.input_type
class RecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancerArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 ip_protocol: pulumi.Input[str],
                 load_balancer_type: pulumi.Input[str],
                 network_url: pulumi.Input[str],
                 port: pulumi.Input[str],
                 project: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip_address: The frontend IP address of the load balancer.
        :param pulumi.Input[str] ip_protocol: The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
        :param pulumi.Input[str] load_balancer_type: The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb"]
        :param pulumi.Input[str] network_url: The fully qualified url of the network in which the load balancer belongs. This should be formatted like `projects/{project}/global/networks/{network}` or `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
        :param pulumi.Input[str] port: The configured port of the load balancer.
        :param pulumi.Input[str] project: The ID of the project in which the load balancer belongs.
        :param pulumi.Input[str] region: The region of the load balancer. Only needed for regional load balancers.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        pulumi.set(__self__, "network_url", network_url)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The frontend IP address of the load balancer.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> pulumi.Input[str]:
        """
        The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> pulumi.Input[str]:
        """
        The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb"]
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "load_balancer_type", value)

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> pulumi.Input[str]:
        """
        The fully qualified url of the network in which the load balancer belongs. This should be formatted like `projects/{project}/global/networks/{network}` or `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
        """
        return pulumi.get(self, "network_url")

    @network_url.setter
    def network_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_url", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[str]:
        """
        The configured port of the load balancer.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[str]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The ID of the project in which the load balancer belongs.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the load balancer. Only needed for regional load balancers.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class RecordSetRoutingPolicyWrrArgs:
    def __init__(__self__, *,
                 weight: pulumi.Input[float],
                 health_checked_targets: Optional[pulumi.Input['RecordSetRoutingPolicyWrrHealthCheckedTargetsArgs']] = None,
                 rrdatas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[float] weight: The ratio of traffic routed to the target.
        :param pulumi.Input['RecordSetRoutingPolicyWrrHealthCheckedTargetsArgs'] health_checked_targets: The list of targets to be health checked. Note that if DNSSEC is enabled for this zone, only one of `rrdatas` or `health_checked_targets` can be set.
               Structure is document below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rrdatas: Same as `rrdatas` above.
        """
        pulumi.set(__self__, "weight", weight)
        if health_checked_targets is not None:
            pulumi.set(__self__, "health_checked_targets", health_checked_targets)
        if rrdatas is not None:
            pulumi.set(__self__, "rrdatas", rrdatas)

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Input[float]:
        """
        The ratio of traffic routed to the target.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: pulumi.Input[float]):
        pulumi.set(self, "weight", value)

    @property
    @pulumi.getter(name="healthCheckedTargets")
    def health_checked_targets(self) -> Optional[pulumi.Input['RecordSetRoutingPolicyWrrHealthCheckedTargetsArgs']]:
        """
        The list of targets to be health checked. Note that if DNSSEC is enabled for this zone, only one of `rrdatas` or `health_checked_targets` can be set.
        Structure is document below.
        """
        return pulumi.get(self, "health_checked_targets")

    @health_checked_targets.setter
    def health_checked_targets(self, value: Optional[pulumi.Input['RecordSetRoutingPolicyWrrHealthCheckedTargetsArgs']]):
        pulumi.set(self, "health_checked_targets", value)

    @property
    @pulumi.getter
    def rrdatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Same as `rrdatas` above.
        """
        return pulumi.get(self, "rrdatas")

    @rrdatas.setter
    def rrdatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rrdatas", value)


@pulumi.input_type
class RecordSetRoutingPolicyWrrHealthCheckedTargetsArgs:
    def __init__(__self__, *,
                 internal_load_balancers: pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancerArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancerArgs']]] internal_load_balancers: The list of internal load balancers to health check.
               Structure is document below.
        """
        pulumi.set(__self__, "internal_load_balancers", internal_load_balancers)

    @property
    @pulumi.getter(name="internalLoadBalancers")
    def internal_load_balancers(self) -> pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancerArgs']]]:
        """
        The list of internal load balancers to health check.
        Structure is document below.
        """
        return pulumi.get(self, "internal_load_balancers")

    @internal_load_balancers.setter
    def internal_load_balancers(self, value: pulumi.Input[Sequence[pulumi.Input['RecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancerArgs']]]):
        pulumi.set(self, "internal_load_balancers", value)


@pulumi.input_type
class RecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancerArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 ip_protocol: pulumi.Input[str],
                 load_balancer_type: pulumi.Input[str],
                 network_url: pulumi.Input[str],
                 port: pulumi.Input[str],
                 project: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip_address: The frontend IP address of the load balancer.
        :param pulumi.Input[str] ip_protocol: The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
        :param pulumi.Input[str] load_balancer_type: The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb"]
        :param pulumi.Input[str] network_url: The fully qualified url of the network in which the load balancer belongs. This should be formatted like `projects/{project}/global/networks/{network}` or `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
        :param pulumi.Input[str] port: The configured port of the load balancer.
        :param pulumi.Input[str] project: The ID of the project in which the load balancer belongs.
        :param pulumi.Input[str] region: The region of the load balancer. Only needed for regional load balancers.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        pulumi.set(__self__, "network_url", network_url)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The frontend IP address of the load balancer.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> pulumi.Input[str]:
        """
        The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> pulumi.Input[str]:
        """
        The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb"]
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "load_balancer_type", value)

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> pulumi.Input[str]:
        """
        The fully qualified url of the network in which the load balancer belongs. This should be formatted like `projects/{project}/global/networks/{network}` or `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
        """
        return pulumi.get(self, "network_url")

    @network_url.setter
    def network_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_url", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[str]:
        """
        The configured port of the load balancer.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[str]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The ID of the project in which the load balancer belongs.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the load balancer. Only needed for regional load balancers.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class ResponsePolicyGkeClusterArgs:
    def __init__(__self__, *,
                 gke_cluster_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] gke_cluster_name: The resource name of the cluster to bind this ManagedZone to.
               This should be specified in the format like
               `projects/*/locations/*/clusters/*`
        """
        pulumi.set(__self__, "gke_cluster_name", gke_cluster_name)

    @property
    @pulumi.getter(name="gkeClusterName")
    def gke_cluster_name(self) -> pulumi.Input[str]:
        """
        The resource name of the cluster to bind this ManagedZone to.
        This should be specified in the format like
        `projects/*/locations/*/clusters/*`
        """
        return pulumi.get(self, "gke_cluster_name")

    @gke_cluster_name.setter
    def gke_cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "gke_cluster_name", value)


@pulumi.input_type
class ResponsePolicyNetworkArgs:
    def __init__(__self__, *,
                 network_url: pulumi.Input[str]):
        """
        :param pulumi.Input[str] network_url: The fully qualified URL of the VPC network to bind to.
               This should be formatted like
               `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`
        """
        pulumi.set(__self__, "network_url", network_url)

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> pulumi.Input[str]:
        """
        The fully qualified URL of the VPC network to bind to.
        This should be formatted like
        `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`
        """
        return pulumi.get(self, "network_url")

    @network_url.setter
    def network_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_url", value)


@pulumi.input_type
class ResponsePolicyRuleLocalDataArgs:
    def __init__(__self__, *,
                 local_datas: pulumi.Input[Sequence[pulumi.Input['ResponsePolicyRuleLocalDataLocalDataArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ResponsePolicyRuleLocalDataLocalDataArgs']]] local_datas: All resource record sets for this selector, one per resource record type. The name must match the dns_name.
               Structure is documented below.
        """
        pulumi.set(__self__, "local_datas", local_datas)

    @property
    @pulumi.getter(name="localDatas")
    def local_datas(self) -> pulumi.Input[Sequence[pulumi.Input['ResponsePolicyRuleLocalDataLocalDataArgs']]]:
        """
        All resource record sets for this selector, one per resource record type. The name must match the dns_name.
        Structure is documented below.
        """
        return pulumi.get(self, "local_datas")

    @local_datas.setter
    def local_datas(self, value: pulumi.Input[Sequence[pulumi.Input['ResponsePolicyRuleLocalDataLocalDataArgs']]]):
        pulumi.set(self, "local_datas", value)


@pulumi.input_type
class ResponsePolicyRuleLocalDataLocalDataArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 rrdatas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] name: For example, www.example.com.
        :param pulumi.Input[str] type: One of valid DNS resource types.
               Possible values are `A`, `AAAA`, `CAA`, `CNAME`, `DNSKEY`, `DS`, `HTTPS`, `IPSECVPNKEY`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV`, `SSHFP`, `SVCB`, `TLSA`, and `TXT`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rrdatas: As defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1)
        :param pulumi.Input[int] ttl: Number of seconds that this ResourceRecordSet can be cached by
               resolvers.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if rrdatas is not None:
            pulumi.set(__self__, "rrdatas", rrdatas)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        For example, www.example.com.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        One of valid DNS resource types.
        Possible values are `A`, `AAAA`, `CAA`, `CNAME`, `DNSKEY`, `DS`, `HTTPS`, `IPSECVPNKEY`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV`, `SSHFP`, `SVCB`, `TLSA`, and `TXT`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def rrdatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        As defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1)
        """
        return pulumi.get(self, "rrdatas")

    @rrdatas.setter
    def rrdatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rrdatas", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds that this ResourceRecordSet can be cached by
        resolvers.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)


