# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAppleAppResult',
    'AwaitableGetAppleAppResult',
    'get_apple_app',
    'get_apple_app_output',
]

@pulumi.output_type
class GetAppleAppResult:
    """
    A collection of values returned by getAppleApp.
    """
    def __init__(__self__, app_id=None, app_store_id=None, bundle_id=None, deletion_policy=None, display_name=None, id=None, name=None, project=None, team_id=None):
        if app_id and not isinstance(app_id, str):
            raise TypeError("Expected argument 'app_id' to be a str")
        pulumi.set(__self__, "app_id", app_id)
        if app_store_id and not isinstance(app_store_id, str):
            raise TypeError("Expected argument 'app_store_id' to be a str")
        pulumi.set(__self__, "app_store_id", app_store_id)
        if bundle_id and not isinstance(bundle_id, str):
            raise TypeError("Expected argument 'bundle_id' to be a str")
        pulumi.set(__self__, "bundle_id", bundle_id)
        if deletion_policy and not isinstance(deletion_policy, str):
            raise TypeError("Expected argument 'deletion_policy' to be a str")
        pulumi.set(__self__, "deletion_policy", deletion_policy)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if team_id and not isinstance(team_id, str):
            raise TypeError("Expected argument 'team_id' to be a str")
        pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> str:
        """
        Immutable. The globally unique, Firebase-assigned identifier of the App.
        This identifier should be treated as an opaque token, as the data format is not specified.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="appStoreId")
    def app_store_id(self) -> str:
        """
        The automatically generated Apple ID assigned to the Apple app by Apple in the Apple App Store.
        """
        return pulumi.get(self, "app_store_id")

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> str:
        """
        The canonical bundle ID of the Apple app as it would appear in the Apple AppStore.
        """
        return pulumi.get(self, "bundle_id")

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> str:
        return pulumi.get(self, "deletion_policy")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-assigned display name of the App.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The fully qualified resource name of the App, for example:
        projects/projectId/iosApps/appId
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> str:
        """
        The Apple Developer Team ID associated with the App in the App Store.
        """
        return pulumi.get(self, "team_id")


class AwaitableGetAppleAppResult(GetAppleAppResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppleAppResult(
            app_id=self.app_id,
            app_store_id=self.app_store_id,
            bundle_id=self.bundle_id,
            deletion_policy=self.deletion_policy,
            display_name=self.display_name,
            id=self.id,
            name=self.name,
            project=self.project,
            team_id=self.team_id)


def get_apple_app(app_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppleAppResult:
    """
    Use this data source to access information about an existing resource.

    :param str app_id: The app_id of name of the Firebase iosApp.
    """
    __args__ = dict()
    __args__['appId'] = app_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:firebase/getAppleApp:getAppleApp', __args__, opts=opts, typ=GetAppleAppResult).value

    return AwaitableGetAppleAppResult(
        app_id=__ret__.app_id,
        app_store_id=__ret__.app_store_id,
        bundle_id=__ret__.bundle_id,
        deletion_policy=__ret__.deletion_policy,
        display_name=__ret__.display_name,
        id=__ret__.id,
        name=__ret__.name,
        project=__ret__.project,
        team_id=__ret__.team_id)


@_utilities.lift_output_func(get_apple_app)
def get_apple_app_output(app_id: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAppleAppResult]:
    """
    Use this data source to access information about an existing resource.

    :param str app_id: The app_id of name of the Firebase iosApp.
    """
    ...
