# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'InboundSamlConfigIdpConfigArgs',
    'InboundSamlConfigIdpConfigIdpCertificateArgs',
    'InboundSamlConfigSpConfigArgs',
    'InboundSamlConfigSpConfigSpCertificateArgs',
    'ProjectDefaultConfigSignInArgs',
    'ProjectDefaultConfigSignInAnonymousArgs',
    'ProjectDefaultConfigSignInEmailArgs',
    'ProjectDefaultConfigSignInHashConfigArgs',
    'ProjectDefaultConfigSignInPhoneNumberArgs',
    'TenantInboundSamlConfigIdpConfigArgs',
    'TenantInboundSamlConfigIdpConfigIdpCertificateArgs',
    'TenantInboundSamlConfigSpConfigArgs',
    'TenantInboundSamlConfigSpConfigSpCertificateArgs',
]

@pulumi.input_type
class InboundSamlConfigIdpConfigArgs:
    def __init__(__self__, *,
                 idp_certificates: pulumi.Input[Sequence[pulumi.Input['InboundSamlConfigIdpConfigIdpCertificateArgs']]],
                 idp_entity_id: pulumi.Input[str],
                 sso_url: pulumi.Input[str],
                 sign_request: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['InboundSamlConfigIdpConfigIdpCertificateArgs']]] idp_certificates: The IdP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
               Structure is documented below.
        :param pulumi.Input[str] idp_entity_id: Unique identifier for all SAML entities
        :param pulumi.Input[str] sso_url: URL to send Authentication request to.
        :param pulumi.Input[bool] sign_request: Indicates if outbounding SAMLRequest should be signed.
        """
        pulumi.set(__self__, "idp_certificates", idp_certificates)
        pulumi.set(__self__, "idp_entity_id", idp_entity_id)
        pulumi.set(__self__, "sso_url", sso_url)
        if sign_request is not None:
            pulumi.set(__self__, "sign_request", sign_request)

    @property
    @pulumi.getter(name="idpCertificates")
    def idp_certificates(self) -> pulumi.Input[Sequence[pulumi.Input['InboundSamlConfigIdpConfigIdpCertificateArgs']]]:
        """
        The IdP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
        Structure is documented below.
        """
        return pulumi.get(self, "idp_certificates")

    @idp_certificates.setter
    def idp_certificates(self, value: pulumi.Input[Sequence[pulumi.Input['InboundSamlConfigIdpConfigIdpCertificateArgs']]]):
        pulumi.set(self, "idp_certificates", value)

    @property
    @pulumi.getter(name="idpEntityId")
    def idp_entity_id(self) -> pulumi.Input[str]:
        """
        Unique identifier for all SAML entities
        """
        return pulumi.get(self, "idp_entity_id")

    @idp_entity_id.setter
    def idp_entity_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "idp_entity_id", value)

    @property
    @pulumi.getter(name="ssoUrl")
    def sso_url(self) -> pulumi.Input[str]:
        """
        URL to send Authentication request to.
        """
        return pulumi.get(self, "sso_url")

    @sso_url.setter
    def sso_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "sso_url", value)

    @property
    @pulumi.getter(name="signRequest")
    def sign_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if outbounding SAMLRequest should be signed.
        """
        return pulumi.get(self, "sign_request")

    @sign_request.setter
    def sign_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sign_request", value)


@pulumi.input_type
class InboundSamlConfigIdpConfigIdpCertificateArgs:
    def __init__(__self__, *,
                 x509_certificate: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] x509_certificate: The IdP's x509 certificate.
        """
        if x509_certificate is not None:
            pulumi.set(__self__, "x509_certificate", x509_certificate)

    @property
    @pulumi.getter(name="x509Certificate")
    def x509_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The IdP's x509 certificate.
        """
        return pulumi.get(self, "x509_certificate")

    @x509_certificate.setter
    def x509_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "x509_certificate", value)


@pulumi.input_type
class InboundSamlConfigSpConfigArgs:
    def __init__(__self__, *,
                 callback_uri: Optional[pulumi.Input[str]] = None,
                 sp_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['InboundSamlConfigSpConfigSpCertificateArgs']]]] = None,
                 sp_entity_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] callback_uri: Callback URI where responses from IDP are handled. Must start with `https://`.
        :param pulumi.Input[Sequence[pulumi.Input['InboundSamlConfigSpConfigSpCertificateArgs']]] sp_certificates: The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
               Structure is documented below.
        :param pulumi.Input[str] sp_entity_id: Unique identifier for all SAML entities.
        """
        if callback_uri is not None:
            pulumi.set(__self__, "callback_uri", callback_uri)
        if sp_certificates is not None:
            pulumi.set(__self__, "sp_certificates", sp_certificates)
        if sp_entity_id is not None:
            pulumi.set(__self__, "sp_entity_id", sp_entity_id)

    @property
    @pulumi.getter(name="callbackUri")
    def callback_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Callback URI where responses from IDP are handled. Must start with `https://`.
        """
        return pulumi.get(self, "callback_uri")

    @callback_uri.setter
    def callback_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "callback_uri", value)

    @property
    @pulumi.getter(name="spCertificates")
    def sp_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InboundSamlConfigSpConfigSpCertificateArgs']]]]:
        """
        The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
        Structure is documented below.
        """
        return pulumi.get(self, "sp_certificates")

    @sp_certificates.setter
    def sp_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InboundSamlConfigSpConfigSpCertificateArgs']]]]):
        pulumi.set(self, "sp_certificates", value)

    @property
    @pulumi.getter(name="spEntityId")
    def sp_entity_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for all SAML entities.
        """
        return pulumi.get(self, "sp_entity_id")

    @sp_entity_id.setter
    def sp_entity_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sp_entity_id", value)


@pulumi.input_type
class InboundSamlConfigSpConfigSpCertificateArgs:
    def __init__(__self__, *,
                 x509_certificate: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] x509_certificate: The IdP's x509 certificate.
               The x509 certificate
        """
        if x509_certificate is not None:
            pulumi.set(__self__, "x509_certificate", x509_certificate)

    @property
    @pulumi.getter(name="x509Certificate")
    def x509_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The IdP's x509 certificate.
        The x509 certificate
        """
        return pulumi.get(self, "x509_certificate")

    @x509_certificate.setter
    def x509_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "x509_certificate", value)


@pulumi.input_type
class ProjectDefaultConfigSignInArgs:
    def __init__(__self__, *,
                 allow_duplicate_emails: Optional[pulumi.Input[bool]] = None,
                 anonymous: Optional[pulumi.Input['ProjectDefaultConfigSignInAnonymousArgs']] = None,
                 email: Optional[pulumi.Input['ProjectDefaultConfigSignInEmailArgs']] = None,
                 hash_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectDefaultConfigSignInHashConfigArgs']]]] = None,
                 phone_number: Optional[pulumi.Input['ProjectDefaultConfigSignInPhoneNumberArgs']] = None):
        """
        :param pulumi.Input[bool] allow_duplicate_emails: Whether to allow more than one account to have the same email.
        :param pulumi.Input['ProjectDefaultConfigSignInAnonymousArgs'] anonymous: Configuration options related to authenticating an anonymous user.
               Structure is documented below.
        :param pulumi.Input['ProjectDefaultConfigSignInEmailArgs'] email: Configuration options related to authenticating a user by their email address.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectDefaultConfigSignInHashConfigArgs']]] hash_configs: Output only. Hash config information.
               Structure is documented below.
        :param pulumi.Input['ProjectDefaultConfigSignInPhoneNumberArgs'] phone_number: Configuration options related to authenticated a user by their phone number.
               Structure is documented below.
        """
        if allow_duplicate_emails is not None:
            pulumi.set(__self__, "allow_duplicate_emails", allow_duplicate_emails)
        if anonymous is not None:
            pulumi.set(__self__, "anonymous", anonymous)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if hash_configs is not None:
            pulumi.set(__self__, "hash_configs", hash_configs)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="allowDuplicateEmails")
    def allow_duplicate_emails(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow more than one account to have the same email.
        """
        return pulumi.get(self, "allow_duplicate_emails")

    @allow_duplicate_emails.setter
    def allow_duplicate_emails(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_duplicate_emails", value)

    @property
    @pulumi.getter
    def anonymous(self) -> Optional[pulumi.Input['ProjectDefaultConfigSignInAnonymousArgs']]:
        """
        Configuration options related to authenticating an anonymous user.
        Structure is documented below.
        """
        return pulumi.get(self, "anonymous")

    @anonymous.setter
    def anonymous(self, value: Optional[pulumi.Input['ProjectDefaultConfigSignInAnonymousArgs']]):
        pulumi.set(self, "anonymous", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input['ProjectDefaultConfigSignInEmailArgs']]:
        """
        Configuration options related to authenticating a user by their email address.
        Structure is documented below.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input['ProjectDefaultConfigSignInEmailArgs']]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="hashConfigs")
    def hash_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectDefaultConfigSignInHashConfigArgs']]]]:
        """
        Output only. Hash config information.
        Structure is documented below.
        """
        return pulumi.get(self, "hash_configs")

    @hash_configs.setter
    def hash_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectDefaultConfigSignInHashConfigArgs']]]]):
        pulumi.set(self, "hash_configs", value)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input['ProjectDefaultConfigSignInPhoneNumberArgs']]:
        """
        Configuration options related to authenticated a user by their phone number.
        Structure is documented below.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input['ProjectDefaultConfigSignInPhoneNumberArgs']]):
        pulumi.set(self, "phone_number", value)


@pulumi.input_type
class ProjectDefaultConfigSignInAnonymousArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool]):
        """
        :param pulumi.Input[bool] enabled: Whether anonymous user auth is enabled for the project or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether anonymous user auth is enabled for the project or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ProjectDefaultConfigSignInEmailArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 password_required: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] enabled: Whether email auth is enabled for the project or not.
        :param pulumi.Input[bool] password_required: Whether a password is required for email auth or not. If true, both an email and
               password must be provided to sign in. If false, a user may sign in via either
               email/password or email link.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if password_required is not None:
            pulumi.set(__self__, "password_required", password_required)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether email auth is enabled for the project or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="passwordRequired")
    def password_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether a password is required for email auth or not. If true, both an email and
        password must be provided to sign in. If false, a user may sign in via either
        email/password or email link.
        """
        return pulumi.get(self, "password_required")

    @password_required.setter
    def password_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_required", value)


@pulumi.input_type
class ProjectDefaultConfigSignInHashConfigArgs:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[str]] = None,
                 memory_cost: Optional[pulumi.Input[int]] = None,
                 rounds: Optional[pulumi.Input[int]] = None,
                 salt_separator: Optional[pulumi.Input[str]] = None,
                 signer_key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] algorithm: Different password hash algorithms used in Identity Toolkit.
        :param pulumi.Input[int] memory_cost: Memory cost for hash calculation. Used by scrypt and other similar password derivation algorithms. See https://tools.ietf.org/html/rfc7914 for explanation of field.
        :param pulumi.Input[int] rounds: How many rounds for hash calculation. Used by scrypt and other similar password derivation algorithms.
        :param pulumi.Input[str] salt_separator: Non-printable character to be inserted between the salt and plain text password in base64.
        :param pulumi.Input[str] signer_key: Signer key in base64.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if memory_cost is not None:
            pulumi.set(__self__, "memory_cost", memory_cost)
        if rounds is not None:
            pulumi.set(__self__, "rounds", rounds)
        if salt_separator is not None:
            pulumi.set(__self__, "salt_separator", salt_separator)
        if signer_key is not None:
            pulumi.set(__self__, "signer_key", signer_key)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Different password hash algorithms used in Identity Toolkit.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="memoryCost")
    def memory_cost(self) -> Optional[pulumi.Input[int]]:
        """
        Memory cost for hash calculation. Used by scrypt and other similar password derivation algorithms. See https://tools.ietf.org/html/rfc7914 for explanation of field.
        """
        return pulumi.get(self, "memory_cost")

    @memory_cost.setter
    def memory_cost(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_cost", value)

    @property
    @pulumi.getter
    def rounds(self) -> Optional[pulumi.Input[int]]:
        """
        How many rounds for hash calculation. Used by scrypt and other similar password derivation algorithms.
        """
        return pulumi.get(self, "rounds")

    @rounds.setter
    def rounds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rounds", value)

    @property
    @pulumi.getter(name="saltSeparator")
    def salt_separator(self) -> Optional[pulumi.Input[str]]:
        """
        Non-printable character to be inserted between the salt and plain text password in base64.
        """
        return pulumi.get(self, "salt_separator")

    @salt_separator.setter
    def salt_separator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "salt_separator", value)

    @property
    @pulumi.getter(name="signerKey")
    def signer_key(self) -> Optional[pulumi.Input[str]]:
        """
        Signer key in base64.
        """
        return pulumi.get(self, "signer_key")

    @signer_key.setter
    def signer_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signer_key", value)


@pulumi.input_type
class ProjectDefaultConfigSignInPhoneNumberArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 test_phone_numbers: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[bool] enabled: Whether phone number auth is enabled for the project or not.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] test_phone_numbers: A map of <test phone number, fake code> that can be used for phone auth testing.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if test_phone_numbers is not None:
            pulumi.set(__self__, "test_phone_numbers", test_phone_numbers)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether phone number auth is enabled for the project or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="testPhoneNumbers")
    def test_phone_numbers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of <test phone number, fake code> that can be used for phone auth testing.
        """
        return pulumi.get(self, "test_phone_numbers")

    @test_phone_numbers.setter
    def test_phone_numbers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "test_phone_numbers", value)


@pulumi.input_type
class TenantInboundSamlConfigIdpConfigArgs:
    def __init__(__self__, *,
                 idp_certificates: pulumi.Input[Sequence[pulumi.Input['TenantInboundSamlConfigIdpConfigIdpCertificateArgs']]],
                 idp_entity_id: pulumi.Input[str],
                 sso_url: pulumi.Input[str],
                 sign_request: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['TenantInboundSamlConfigIdpConfigIdpCertificateArgs']]] idp_certificates: The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
               Structure is documented below.
        :param pulumi.Input[str] idp_entity_id: Unique identifier for all SAML entities
        :param pulumi.Input[str] sso_url: URL to send Authentication request to.
        :param pulumi.Input[bool] sign_request: Indicates if outbounding SAMLRequest should be signed.
        """
        pulumi.set(__self__, "idp_certificates", idp_certificates)
        pulumi.set(__self__, "idp_entity_id", idp_entity_id)
        pulumi.set(__self__, "sso_url", sso_url)
        if sign_request is not None:
            pulumi.set(__self__, "sign_request", sign_request)

    @property
    @pulumi.getter(name="idpCertificates")
    def idp_certificates(self) -> pulumi.Input[Sequence[pulumi.Input['TenantInboundSamlConfigIdpConfigIdpCertificateArgs']]]:
        """
        The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
        Structure is documented below.
        """
        return pulumi.get(self, "idp_certificates")

    @idp_certificates.setter
    def idp_certificates(self, value: pulumi.Input[Sequence[pulumi.Input['TenantInboundSamlConfigIdpConfigIdpCertificateArgs']]]):
        pulumi.set(self, "idp_certificates", value)

    @property
    @pulumi.getter(name="idpEntityId")
    def idp_entity_id(self) -> pulumi.Input[str]:
        """
        Unique identifier for all SAML entities
        """
        return pulumi.get(self, "idp_entity_id")

    @idp_entity_id.setter
    def idp_entity_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "idp_entity_id", value)

    @property
    @pulumi.getter(name="ssoUrl")
    def sso_url(self) -> pulumi.Input[str]:
        """
        URL to send Authentication request to.
        """
        return pulumi.get(self, "sso_url")

    @sso_url.setter
    def sso_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "sso_url", value)

    @property
    @pulumi.getter(name="signRequest")
    def sign_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if outbounding SAMLRequest should be signed.
        """
        return pulumi.get(self, "sign_request")

    @sign_request.setter
    def sign_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sign_request", value)


@pulumi.input_type
class TenantInboundSamlConfigIdpConfigIdpCertificateArgs:
    def __init__(__self__, *,
                 x509_certificate: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] x509_certificate: The x509 certificate
        """
        if x509_certificate is not None:
            pulumi.set(__self__, "x509_certificate", x509_certificate)

    @property
    @pulumi.getter(name="x509Certificate")
    def x509_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The x509 certificate
        """
        return pulumi.get(self, "x509_certificate")

    @x509_certificate.setter
    def x509_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "x509_certificate", value)


@pulumi.input_type
class TenantInboundSamlConfigSpConfigArgs:
    def __init__(__self__, *,
                 callback_uri: pulumi.Input[str],
                 sp_entity_id: pulumi.Input[str],
                 sp_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['TenantInboundSamlConfigSpConfigSpCertificateArgs']]]] = None):
        """
        :param pulumi.Input[str] callback_uri: Callback URI where responses from IDP are handled. Must start with `https://`.
        :param pulumi.Input[str] sp_entity_id: Unique identifier for all SAML entities.
        :param pulumi.Input[Sequence[pulumi.Input['TenantInboundSamlConfigSpConfigSpCertificateArgs']]] sp_certificates: The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
               Structure is documented below.
        """
        pulumi.set(__self__, "callback_uri", callback_uri)
        pulumi.set(__self__, "sp_entity_id", sp_entity_id)
        if sp_certificates is not None:
            pulumi.set(__self__, "sp_certificates", sp_certificates)

    @property
    @pulumi.getter(name="callbackUri")
    def callback_uri(self) -> pulumi.Input[str]:
        """
        Callback URI where responses from IDP are handled. Must start with `https://`.
        """
        return pulumi.get(self, "callback_uri")

    @callback_uri.setter
    def callback_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "callback_uri", value)

    @property
    @pulumi.getter(name="spEntityId")
    def sp_entity_id(self) -> pulumi.Input[str]:
        """
        Unique identifier for all SAML entities.
        """
        return pulumi.get(self, "sp_entity_id")

    @sp_entity_id.setter
    def sp_entity_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "sp_entity_id", value)

    @property
    @pulumi.getter(name="spCertificates")
    def sp_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TenantInboundSamlConfigSpConfigSpCertificateArgs']]]]:
        """
        The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
        Structure is documented below.
        """
        return pulumi.get(self, "sp_certificates")

    @sp_certificates.setter
    def sp_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TenantInboundSamlConfigSpConfigSpCertificateArgs']]]]):
        pulumi.set(self, "sp_certificates", value)


@pulumi.input_type
class TenantInboundSamlConfigSpConfigSpCertificateArgs:
    def __init__(__self__, *,
                 x509_certificate: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] x509_certificate: The x509 certificate
               The x509 certificate
        """
        if x509_certificate is not None:
            pulumi.set(__self__, "x509_certificate", x509_certificate)

    @property
    @pulumi.getter(name="x509Certificate")
    def x509_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The x509 certificate
        The x509 certificate
        """
        return pulumi.get(self, "x509_certificate")

    @x509_certificate.setter
    def x509_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "x509_certificate", value)


