# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MetricDescriptorArgs', 'MetricDescriptor']

@pulumi.input_type
class MetricDescriptorArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 metric_kind: pulumi.Input[str],
                 type: pulumi.Input[str],
                 value_type: pulumi.Input[str],
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['MetricDescriptorLabelArgs']]]] = None,
                 launch_stage: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['MetricDescriptorMetadataArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 unit: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MetricDescriptor resource.
        :param pulumi.Input[str] description: A detailed description of the metric, which can be used in documentation.
        :param pulumi.Input[str] display_name: A concise name for the metric, which can be displayed in user interfaces. Use sentence case without an ending period, for example "Request count".
        :param pulumi.Input[str] metric_kind: Whether the metric records instantaneous values, changes to a value, etc. Some combinations of metricKind and valueType might not be supported.
               Possible values are `METRIC_KIND_UNSPECIFIED`, `GAUGE`, `DELTA`, and `CUMULATIVE`.
        :param pulumi.Input[str] type: The metric type, including its DNS name prefix. The type is not URL-encoded. All service defined metrics must be prefixed with the service name, in the format of {service name}/{relative metric name}, such as cloudsql.googleapis.com/database/cpu/utilization. The relative metric name must have only upper and lower-case letters, digits, '/' and underscores '_' are allowed. Additionally, the maximum number of characters allowed for the relative_metric_name is 100. All user-defined metric types have the DNS name custom.googleapis.com, external.googleapis.com, or logging.googleapis.com/user/.
        :param pulumi.Input[str] value_type: Whether the measurement is an integer, a floating-point number, etc. Some combinations of metricKind and valueType might not be supported.
               Possible values are `BOOL`, `INT64`, `DOUBLE`, `STRING`, and `DISTRIBUTION`.
        :param pulumi.Input[Sequence[pulumi.Input['MetricDescriptorLabelArgs']]] labels: The set of labels that can be used to describe a specific instance of this metric type. In order to delete a label, the entire resource must be deleted, then created with the desired labels.
               Structure is documented below.
        :param pulumi.Input[str] launch_stage: The launch stage of the metric definition.
               Possible values are `LAUNCH_STAGE_UNSPECIFIED`, `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, and `DEPRECATED`.
        :param pulumi.Input['MetricDescriptorMetadataArgs'] metadata: Metadata which can be used to guide usage of the metric.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] unit: The units in which the metric value is reported. It is only applicable if the
               valueType is INT64, DOUBLE, or DISTRIBUTION. The unit defines the representation of
               the stored metric values.
               Different systems may scale the values to be more easily displayed (so a value of
               0.02KBy might be displayed as 20By, and a value of 3523KBy might be displayed as
               3.5MBy). However, if the unit is KBy, then the value of the metric is always in
               thousands of bytes, no matter how it may be displayed.
               If you want a custom metric to record the exact number of CPU-seconds used by a job,
               you can create an INT64 CUMULATIVE metric whose unit is s{CPU} (or equivalently
               1s{CPU} or just s). If the job uses 12,005 CPU-seconds, then the value is written as
               12005.
               Alternatively, if you want a custom metric to record data in a more granular way, you
               can create a DOUBLE CUMULATIVE metric whose unit is ks{CPU}, and then write the value
               12.005 (which is 12005/1000), or use Kis{CPU} and write 11.723 (which is 12005/1024).
               The supported units are a subset of The Unified Code for Units of Measure standard.
               More info can be found in the API documentation
               (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.metricDescriptors).
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "metric_kind", metric_kind)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value_type", value_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if launch_stage is not None:
            pulumi.set(__self__, "launch_stage", launch_stage)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        A detailed description of the metric, which can be used in documentation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        A concise name for the metric, which can be displayed in user interfaces. Use sentence case without an ending period, for example "Request count".
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="metricKind")
    def metric_kind(self) -> pulumi.Input[str]:
        """
        Whether the metric records instantaneous values, changes to a value, etc. Some combinations of metricKind and valueType might not be supported.
        Possible values are `METRIC_KIND_UNSPECIFIED`, `GAUGE`, `DELTA`, and `CUMULATIVE`.
        """
        return pulumi.get(self, "metric_kind")

    @metric_kind.setter
    def metric_kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_kind", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The metric type, including its DNS name prefix. The type is not URL-encoded. All service defined metrics must be prefixed with the service name, in the format of {service name}/{relative metric name}, such as cloudsql.googleapis.com/database/cpu/utilization. The relative metric name must have only upper and lower-case letters, digits, '/' and underscores '_' are allowed. Additionally, the maximum number of characters allowed for the relative_metric_name is 100. All user-defined metric types have the DNS name custom.googleapis.com, external.googleapis.com, or logging.googleapis.com/user/.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> pulumi.Input[str]:
        """
        Whether the measurement is an integer, a floating-point number, etc. Some combinations of metricKind and valueType might not be supported.
        Possible values are `BOOL`, `INT64`, `DOUBLE`, `STRING`, and `DISTRIBUTION`.
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "value_type", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricDescriptorLabelArgs']]]]:
        """
        The set of labels that can be used to describe a specific instance of this metric type. In order to delete a label, the entire resource must be deleted, then created with the desired labels.
        Structure is documented below.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricDescriptorLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> Optional[pulumi.Input[str]]:
        """
        The launch stage of the metric definition.
        Possible values are `LAUNCH_STAGE_UNSPECIFIED`, `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, and `DEPRECATED`.
        """
        return pulumi.get(self, "launch_stage")

    @launch_stage.setter
    def launch_stage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_stage", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['MetricDescriptorMetadataArgs']]:
        """
        Metadata which can be used to guide usage of the metric.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['MetricDescriptorMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        The units in which the metric value is reported. It is only applicable if the
        valueType is INT64, DOUBLE, or DISTRIBUTION. The unit defines the representation of
        the stored metric values.
        Different systems may scale the values to be more easily displayed (so a value of
        0.02KBy might be displayed as 20By, and a value of 3523KBy might be displayed as
        3.5MBy). However, if the unit is KBy, then the value of the metric is always in
        thousands of bytes, no matter how it may be displayed.
        If you want a custom metric to record the exact number of CPU-seconds used by a job,
        you can create an INT64 CUMULATIVE metric whose unit is s{CPU} (or equivalently
        1s{CPU} or just s). If the job uses 12,005 CPU-seconds, then the value is written as
        12005.
        Alternatively, if you want a custom metric to record data in a more granular way, you
        can create a DOUBLE CUMULATIVE metric whose unit is ks{CPU}, and then write the value
        12.005 (which is 12005/1000), or use Kis{CPU} and write 11.723 (which is 12005/1024).
        The supported units are a subset of The Unified Code for Units of Measure standard.
        More info can be found in the API documentation
        (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.metricDescriptors).
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)


@pulumi.input_type
class _MetricDescriptorState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['MetricDescriptorLabelArgs']]]] = None,
                 launch_stage: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['MetricDescriptorMetadataArgs']] = None,
                 metric_kind: Optional[pulumi.Input[str]] = None,
                 monitored_resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 unit: Optional[pulumi.Input[str]] = None,
                 value_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MetricDescriptor resources.
        :param pulumi.Input[str] description: A detailed description of the metric, which can be used in documentation.
        :param pulumi.Input[str] display_name: A concise name for the metric, which can be displayed in user interfaces. Use sentence case without an ending period, for example "Request count".
        :param pulumi.Input[Sequence[pulumi.Input['MetricDescriptorLabelArgs']]] labels: The set of labels that can be used to describe a specific instance of this metric type. In order to delete a label, the entire resource must be deleted, then created with the desired labels.
               Structure is documented below.
        :param pulumi.Input[str] launch_stage: The launch stage of the metric definition.
               Possible values are `LAUNCH_STAGE_UNSPECIFIED`, `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, and `DEPRECATED`.
        :param pulumi.Input['MetricDescriptorMetadataArgs'] metadata: Metadata which can be used to guide usage of the metric.
               Structure is documented below.
        :param pulumi.Input[str] metric_kind: Whether the metric records instantaneous values, changes to a value, etc. Some combinations of metricKind and valueType might not be supported.
               Possible values are `METRIC_KIND_UNSPECIFIED`, `GAUGE`, `DELTA`, and `CUMULATIVE`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] monitored_resource_types: If present, then a time series, which is identified partially by a metric type and a MonitoredResourceDescriptor, that is associated with this metric type can only be associated with one of the monitored resource types listed here. This field allows time series to be associated with the intersection of this metric type and the monitored resource types in this list.
        :param pulumi.Input[str] name: The resource name of the metric descriptor.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] type: The metric type, including its DNS name prefix. The type is not URL-encoded. All service defined metrics must be prefixed with the service name, in the format of {service name}/{relative metric name}, such as cloudsql.googleapis.com/database/cpu/utilization. The relative metric name must have only upper and lower-case letters, digits, '/' and underscores '_' are allowed. Additionally, the maximum number of characters allowed for the relative_metric_name is 100. All user-defined metric types have the DNS name custom.googleapis.com, external.googleapis.com, or logging.googleapis.com/user/.
        :param pulumi.Input[str] unit: The units in which the metric value is reported. It is only applicable if the
               valueType is INT64, DOUBLE, or DISTRIBUTION. The unit defines the representation of
               the stored metric values.
               Different systems may scale the values to be more easily displayed (so a value of
               0.02KBy might be displayed as 20By, and a value of 3523KBy might be displayed as
               3.5MBy). However, if the unit is KBy, then the value of the metric is always in
               thousands of bytes, no matter how it may be displayed.
               If you want a custom metric to record the exact number of CPU-seconds used by a job,
               you can create an INT64 CUMULATIVE metric whose unit is s{CPU} (or equivalently
               1s{CPU} or just s). If the job uses 12,005 CPU-seconds, then the value is written as
               12005.
               Alternatively, if you want a custom metric to record data in a more granular way, you
               can create a DOUBLE CUMULATIVE metric whose unit is ks{CPU}, and then write the value
               12.005 (which is 12005/1000), or use Kis{CPU} and write 11.723 (which is 12005/1024).
               The supported units are a subset of The Unified Code for Units of Measure standard.
               More info can be found in the API documentation
               (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.metricDescriptors).
        :param pulumi.Input[str] value_type: Whether the measurement is an integer, a floating-point number, etc. Some combinations of metricKind and valueType might not be supported.
               Possible values are `BOOL`, `INT64`, `DOUBLE`, `STRING`, and `DISTRIBUTION`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if launch_stage is not None:
            pulumi.set(__self__, "launch_stage", launch_stage)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metric_kind is not None:
            pulumi.set(__self__, "metric_kind", metric_kind)
        if monitored_resource_types is not None:
            pulumi.set(__self__, "monitored_resource_types", monitored_resource_types)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A detailed description of the metric, which can be used in documentation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A concise name for the metric, which can be displayed in user interfaces. Use sentence case without an ending period, for example "Request count".
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricDescriptorLabelArgs']]]]:
        """
        The set of labels that can be used to describe a specific instance of this metric type. In order to delete a label, the entire resource must be deleted, then created with the desired labels.
        Structure is documented below.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricDescriptorLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> Optional[pulumi.Input[str]]:
        """
        The launch stage of the metric definition.
        Possible values are `LAUNCH_STAGE_UNSPECIFIED`, `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, and `DEPRECATED`.
        """
        return pulumi.get(self, "launch_stage")

    @launch_stage.setter
    def launch_stage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_stage", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['MetricDescriptorMetadataArgs']]:
        """
        Metadata which can be used to guide usage of the metric.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['MetricDescriptorMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="metricKind")
    def metric_kind(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the metric records instantaneous values, changes to a value, etc. Some combinations of metricKind and valueType might not be supported.
        Possible values are `METRIC_KIND_UNSPECIFIED`, `GAUGE`, `DELTA`, and `CUMULATIVE`.
        """
        return pulumi.get(self, "metric_kind")

    @metric_kind.setter
    def metric_kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_kind", value)

    @property
    @pulumi.getter(name="monitoredResourceTypes")
    def monitored_resource_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If present, then a time series, which is identified partially by a metric type and a MonitoredResourceDescriptor, that is associated with this metric type can only be associated with one of the monitored resource types listed here. This field allows time series to be associated with the intersection of this metric type and the monitored resource types in this list.
        """
        return pulumi.get(self, "monitored_resource_types")

    @monitored_resource_types.setter
    def monitored_resource_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "monitored_resource_types", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name of the metric descriptor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The metric type, including its DNS name prefix. The type is not URL-encoded. All service defined metrics must be prefixed with the service name, in the format of {service name}/{relative metric name}, such as cloudsql.googleapis.com/database/cpu/utilization. The relative metric name must have only upper and lower-case letters, digits, '/' and underscores '_' are allowed. Additionally, the maximum number of characters allowed for the relative_metric_name is 100. All user-defined metric types have the DNS name custom.googleapis.com, external.googleapis.com, or logging.googleapis.com/user/.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        The units in which the metric value is reported. It is only applicable if the
        valueType is INT64, DOUBLE, or DISTRIBUTION. The unit defines the representation of
        the stored metric values.
        Different systems may scale the values to be more easily displayed (so a value of
        0.02KBy might be displayed as 20By, and a value of 3523KBy might be displayed as
        3.5MBy). However, if the unit is KBy, then the value of the metric is always in
        thousands of bytes, no matter how it may be displayed.
        If you want a custom metric to record the exact number of CPU-seconds used by a job,
        you can create an INT64 CUMULATIVE metric whose unit is s{CPU} (or equivalently
        1s{CPU} or just s). If the job uses 12,005 CPU-seconds, then the value is written as
        12005.
        Alternatively, if you want a custom metric to record data in a more granular way, you
        can create a DOUBLE CUMULATIVE metric whose unit is ks{CPU}, and then write the value
        12.005 (which is 12005/1000), or use Kis{CPU} and write 11.723 (which is 12005/1024).
        The supported units are a subset of The Unified Code for Units of Measure standard.
        More info can be found in the API documentation
        (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.metricDescriptors).
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the measurement is an integer, a floating-point number, etc. Some combinations of metricKind and valueType might not be supported.
        Possible values are `BOOL`, `INT64`, `DOUBLE`, `STRING`, and `DISTRIBUTION`.
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value_type", value)


class MetricDescriptor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricDescriptorLabelArgs']]]]] = None,
                 launch_stage: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[pulumi.InputType['MetricDescriptorMetadataArgs']]] = None,
                 metric_kind: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 unit: Optional[pulumi.Input[str]] = None,
                 value_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Defines a metric type and its schema. Once a metric descriptor is created, deleting or altering it stops data collection and makes the metric type's existing data unusable.

        To get more information about MetricDescriptor, see:

        * [API documentation](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.metricDescriptors)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/monitoring/custom-metrics/)

        ## Example Usage
        ### Monitoring Metric Descriptor Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.monitoring.MetricDescriptor("basic",
            description="Daily sales records from all branch stores.",
            display_name="metric-descriptor",
            labels=[gcp.monitoring.MetricDescriptorLabelArgs(
                description="The ID of the store.",
                key="store_id",
                value_type="STRING",
            )],
            launch_stage="BETA",
            metadata=gcp.monitoring.MetricDescriptorMetadataArgs(
                ingest_delay="30s",
                sample_period="60s",
            ),
            metric_kind="GAUGE",
            type="custom.googleapis.com/stores/daily_sales",
            unit="{USD}",
            value_type="DOUBLE")
        ```
        ### Monitoring Metric Descriptor Alert

        ```python
        import pulumi
        import pulumi_gcp as gcp

        with_alert = gcp.monitoring.MetricDescriptor("withAlert",
            description="Daily sales records from all branch stores.",
            display_name="metric-descriptor",
            metric_kind="GAUGE",
            type="custom.googleapis.com/stores/daily_sales",
            unit="{USD}",
            value_type="DOUBLE")
        alert_policy = gcp.monitoring.AlertPolicy("alertPolicy",
            combiner="OR",
            conditions=[gcp.monitoring.AlertPolicyConditionArgs(
                condition_threshold=gcp.monitoring.AlertPolicyConditionConditionThresholdArgs(
                    comparison="COMPARISON_GT",
                    duration="60s",
                    filter=with_alert.type.apply(lambda type: f"metric.type=\\"{type}\\" AND resource.type=\\"gce_instance\\""),
                ),
                display_name="test condition",
            )],
            display_name="metric-descriptor")
        ```

        ## Import

        MetricDescriptor can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:monitoring/metricDescriptor:MetricDescriptor default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A detailed description of the metric, which can be used in documentation.
        :param pulumi.Input[str] display_name: A concise name for the metric, which can be displayed in user interfaces. Use sentence case without an ending period, for example "Request count".
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricDescriptorLabelArgs']]]] labels: The set of labels that can be used to describe a specific instance of this metric type. In order to delete a label, the entire resource must be deleted, then created with the desired labels.
               Structure is documented below.
        :param pulumi.Input[str] launch_stage: The launch stage of the metric definition.
               Possible values are `LAUNCH_STAGE_UNSPECIFIED`, `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, and `DEPRECATED`.
        :param pulumi.Input[pulumi.InputType['MetricDescriptorMetadataArgs']] metadata: Metadata which can be used to guide usage of the metric.
               Structure is documented below.
        :param pulumi.Input[str] metric_kind: Whether the metric records instantaneous values, changes to a value, etc. Some combinations of metricKind and valueType might not be supported.
               Possible values are `METRIC_KIND_UNSPECIFIED`, `GAUGE`, `DELTA`, and `CUMULATIVE`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] type: The metric type, including its DNS name prefix. The type is not URL-encoded. All service defined metrics must be prefixed with the service name, in the format of {service name}/{relative metric name}, such as cloudsql.googleapis.com/database/cpu/utilization. The relative metric name must have only upper and lower-case letters, digits, '/' and underscores '_' are allowed. Additionally, the maximum number of characters allowed for the relative_metric_name is 100. All user-defined metric types have the DNS name custom.googleapis.com, external.googleapis.com, or logging.googleapis.com/user/.
        :param pulumi.Input[str] unit: The units in which the metric value is reported. It is only applicable if the
               valueType is INT64, DOUBLE, or DISTRIBUTION. The unit defines the representation of
               the stored metric values.
               Different systems may scale the values to be more easily displayed (so a value of
               0.02KBy might be displayed as 20By, and a value of 3523KBy might be displayed as
               3.5MBy). However, if the unit is KBy, then the value of the metric is always in
               thousands of bytes, no matter how it may be displayed.
               If you want a custom metric to record the exact number of CPU-seconds used by a job,
               you can create an INT64 CUMULATIVE metric whose unit is s{CPU} (or equivalently
               1s{CPU} or just s). If the job uses 12,005 CPU-seconds, then the value is written as
               12005.
               Alternatively, if you want a custom metric to record data in a more granular way, you
               can create a DOUBLE CUMULATIVE metric whose unit is ks{CPU}, and then write the value
               12.005 (which is 12005/1000), or use Kis{CPU} and write 11.723 (which is 12005/1024).
               The supported units are a subset of The Unified Code for Units of Measure standard.
               More info can be found in the API documentation
               (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.metricDescriptors).
        :param pulumi.Input[str] value_type: Whether the measurement is an integer, a floating-point number, etc. Some combinations of metricKind and valueType might not be supported.
               Possible values are `BOOL`, `INT64`, `DOUBLE`, `STRING`, and `DISTRIBUTION`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetricDescriptorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Defines a metric type and its schema. Once a metric descriptor is created, deleting or altering it stops data collection and makes the metric type's existing data unusable.

        To get more information about MetricDescriptor, see:

        * [API documentation](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.metricDescriptors)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/monitoring/custom-metrics/)

        ## Example Usage
        ### Monitoring Metric Descriptor Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.monitoring.MetricDescriptor("basic",
            description="Daily sales records from all branch stores.",
            display_name="metric-descriptor",
            labels=[gcp.monitoring.MetricDescriptorLabelArgs(
                description="The ID of the store.",
                key="store_id",
                value_type="STRING",
            )],
            launch_stage="BETA",
            metadata=gcp.monitoring.MetricDescriptorMetadataArgs(
                ingest_delay="30s",
                sample_period="60s",
            ),
            metric_kind="GAUGE",
            type="custom.googleapis.com/stores/daily_sales",
            unit="{USD}",
            value_type="DOUBLE")
        ```
        ### Monitoring Metric Descriptor Alert

        ```python
        import pulumi
        import pulumi_gcp as gcp

        with_alert = gcp.monitoring.MetricDescriptor("withAlert",
            description="Daily sales records from all branch stores.",
            display_name="metric-descriptor",
            metric_kind="GAUGE",
            type="custom.googleapis.com/stores/daily_sales",
            unit="{USD}",
            value_type="DOUBLE")
        alert_policy = gcp.monitoring.AlertPolicy("alertPolicy",
            combiner="OR",
            conditions=[gcp.monitoring.AlertPolicyConditionArgs(
                condition_threshold=gcp.monitoring.AlertPolicyConditionConditionThresholdArgs(
                    comparison="COMPARISON_GT",
                    duration="60s",
                    filter=with_alert.type.apply(lambda type: f"metric.type=\\"{type}\\" AND resource.type=\\"gce_instance\\""),
                ),
                display_name="test condition",
            )],
            display_name="metric-descriptor")
        ```

        ## Import

        MetricDescriptor can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:monitoring/metricDescriptor:MetricDescriptor default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param MetricDescriptorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetricDescriptorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricDescriptorLabelArgs']]]]] = None,
                 launch_stage: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[pulumi.InputType['MetricDescriptorMetadataArgs']]] = None,
                 metric_kind: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 unit: Optional[pulumi.Input[str]] = None,
                 value_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetricDescriptorArgs.__new__(MetricDescriptorArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["labels"] = labels
            __props__.__dict__["launch_stage"] = launch_stage
            __props__.__dict__["metadata"] = metadata
            if metric_kind is None and not opts.urn:
                raise TypeError("Missing required property 'metric_kind'")
            __props__.__dict__["metric_kind"] = metric_kind
            __props__.__dict__["project"] = project
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["unit"] = unit
            if value_type is None and not opts.urn:
                raise TypeError("Missing required property 'value_type'")
            __props__.__dict__["value_type"] = value_type
            __props__.__dict__["monitored_resource_types"] = None
            __props__.__dict__["name"] = None
        super(MetricDescriptor, __self__).__init__(
            'gcp:monitoring/metricDescriptor:MetricDescriptor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricDescriptorLabelArgs']]]]] = None,
            launch_stage: Optional[pulumi.Input[str]] = None,
            metadata: Optional[pulumi.Input[pulumi.InputType['MetricDescriptorMetadataArgs']]] = None,
            metric_kind: Optional[pulumi.Input[str]] = None,
            monitored_resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            unit: Optional[pulumi.Input[str]] = None,
            value_type: Optional[pulumi.Input[str]] = None) -> 'MetricDescriptor':
        """
        Get an existing MetricDescriptor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A detailed description of the metric, which can be used in documentation.
        :param pulumi.Input[str] display_name: A concise name for the metric, which can be displayed in user interfaces. Use sentence case without an ending period, for example "Request count".
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricDescriptorLabelArgs']]]] labels: The set of labels that can be used to describe a specific instance of this metric type. In order to delete a label, the entire resource must be deleted, then created with the desired labels.
               Structure is documented below.
        :param pulumi.Input[str] launch_stage: The launch stage of the metric definition.
               Possible values are `LAUNCH_STAGE_UNSPECIFIED`, `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, and `DEPRECATED`.
        :param pulumi.Input[pulumi.InputType['MetricDescriptorMetadataArgs']] metadata: Metadata which can be used to guide usage of the metric.
               Structure is documented below.
        :param pulumi.Input[str] metric_kind: Whether the metric records instantaneous values, changes to a value, etc. Some combinations of metricKind and valueType might not be supported.
               Possible values are `METRIC_KIND_UNSPECIFIED`, `GAUGE`, `DELTA`, and `CUMULATIVE`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] monitored_resource_types: If present, then a time series, which is identified partially by a metric type and a MonitoredResourceDescriptor, that is associated with this metric type can only be associated with one of the monitored resource types listed here. This field allows time series to be associated with the intersection of this metric type and the monitored resource types in this list.
        :param pulumi.Input[str] name: The resource name of the metric descriptor.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] type: The metric type, including its DNS name prefix. The type is not URL-encoded. All service defined metrics must be prefixed with the service name, in the format of {service name}/{relative metric name}, such as cloudsql.googleapis.com/database/cpu/utilization. The relative metric name must have only upper and lower-case letters, digits, '/' and underscores '_' are allowed. Additionally, the maximum number of characters allowed for the relative_metric_name is 100. All user-defined metric types have the DNS name custom.googleapis.com, external.googleapis.com, or logging.googleapis.com/user/.
        :param pulumi.Input[str] unit: The units in which the metric value is reported. It is only applicable if the
               valueType is INT64, DOUBLE, or DISTRIBUTION. The unit defines the representation of
               the stored metric values.
               Different systems may scale the values to be more easily displayed (so a value of
               0.02KBy might be displayed as 20By, and a value of 3523KBy might be displayed as
               3.5MBy). However, if the unit is KBy, then the value of the metric is always in
               thousands of bytes, no matter how it may be displayed.
               If you want a custom metric to record the exact number of CPU-seconds used by a job,
               you can create an INT64 CUMULATIVE metric whose unit is s{CPU} (or equivalently
               1s{CPU} or just s). If the job uses 12,005 CPU-seconds, then the value is written as
               12005.
               Alternatively, if you want a custom metric to record data in a more granular way, you
               can create a DOUBLE CUMULATIVE metric whose unit is ks{CPU}, and then write the value
               12.005 (which is 12005/1000), or use Kis{CPU} and write 11.723 (which is 12005/1024).
               The supported units are a subset of The Unified Code for Units of Measure standard.
               More info can be found in the API documentation
               (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.metricDescriptors).
        :param pulumi.Input[str] value_type: Whether the measurement is an integer, a floating-point number, etc. Some combinations of metricKind and valueType might not be supported.
               Possible values are `BOOL`, `INT64`, `DOUBLE`, `STRING`, and `DISTRIBUTION`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetricDescriptorState.__new__(_MetricDescriptorState)

        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["labels"] = labels
        __props__.__dict__["launch_stage"] = launch_stage
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["metric_kind"] = metric_kind
        __props__.__dict__["monitored_resource_types"] = monitored_resource_types
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["type"] = type
        __props__.__dict__["unit"] = unit
        __props__.__dict__["value_type"] = value_type
        return MetricDescriptor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        A detailed description of the metric, which can be used in documentation.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        A concise name for the metric, which can be displayed in user interfaces. Use sentence case without an ending period, for example "Request count".
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence['outputs.MetricDescriptorLabel']]]:
        """
        The set of labels that can be used to describe a specific instance of this metric type. In order to delete a label, the entire resource must be deleted, then created with the desired labels.
        Structure is documented below.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> pulumi.Output[Optional[str]]:
        """
        The launch stage of the metric definition.
        Possible values are `LAUNCH_STAGE_UNSPECIFIED`, `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, and `DEPRECATED`.
        """
        return pulumi.get(self, "launch_stage")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional['outputs.MetricDescriptorMetadata']]:
        """
        Metadata which can be used to guide usage of the metric.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="metricKind")
    def metric_kind(self) -> pulumi.Output[str]:
        """
        Whether the metric records instantaneous values, changes to a value, etc. Some combinations of metricKind and valueType might not be supported.
        Possible values are `METRIC_KIND_UNSPECIFIED`, `GAUGE`, `DELTA`, and `CUMULATIVE`.
        """
        return pulumi.get(self, "metric_kind")

    @property
    @pulumi.getter(name="monitoredResourceTypes")
    def monitored_resource_types(self) -> pulumi.Output[Sequence[str]]:
        """
        If present, then a time series, which is identified partially by a metric type and a MonitoredResourceDescriptor, that is associated with this metric type can only be associated with one of the monitored resource types listed here. This field allows time series to be associated with the intersection of this metric type and the monitored resource types in this list.
        """
        return pulumi.get(self, "monitored_resource_types")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name of the metric descriptor.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The metric type, including its DNS name prefix. The type is not URL-encoded. All service defined metrics must be prefixed with the service name, in the format of {service name}/{relative metric name}, such as cloudsql.googleapis.com/database/cpu/utilization. The relative metric name must have only upper and lower-case letters, digits, '/' and underscores '_' are allowed. Additionally, the maximum number of characters allowed for the relative_metric_name is 100. All user-defined metric types have the DNS name custom.googleapis.com, external.googleapis.com, or logging.googleapis.com/user/.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def unit(self) -> pulumi.Output[Optional[str]]:
        """
        The units in which the metric value is reported. It is only applicable if the
        valueType is INT64, DOUBLE, or DISTRIBUTION. The unit defines the representation of
        the stored metric values.
        Different systems may scale the values to be more easily displayed (so a value of
        0.02KBy might be displayed as 20By, and a value of 3523KBy might be displayed as
        3.5MBy). However, if the unit is KBy, then the value of the metric is always in
        thousands of bytes, no matter how it may be displayed.
        If you want a custom metric to record the exact number of CPU-seconds used by a job,
        you can create an INT64 CUMULATIVE metric whose unit is s{CPU} (or equivalently
        1s{CPU} or just s). If the job uses 12,005 CPU-seconds, then the value is written as
        12005.
        Alternatively, if you want a custom metric to record data in a more granular way, you
        can create a DOUBLE CUMULATIVE metric whose unit is ks{CPU}, and then write the value
        12.005 (which is 12005/1000), or use Kis{CPU} and write 11.723 (which is 12005/1024).
        The supported units are a subset of The Unified Code for Units of Measure standard.
        More info can be found in the API documentation
        (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.metricDescriptors).
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> pulumi.Output[str]:
        """
        Whether the measurement is an integer, a floating-point number, etc. Some combinations of metricKind and valueType might not be supported.
        Possible values are `BOOL`, `INT64`, `DOUBLE`, `STRING`, and `DISTRIBUTION`.
        """
        return pulumi.get(self, "value_type")

