# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetSubscriptionResult',
    'AwaitableGetSubscriptionResult',
    'get_subscription',
    'get_subscription_output',
]

@pulumi.output_type
class GetSubscriptionResult:
    """
    A collection of values returned by getSubscription.
    """
    def __init__(__self__, ack_deadline_seconds=None, bigquery_configs=None, dead_letter_policies=None, enable_exactly_once_delivery=None, enable_message_ordering=None, expiration_policies=None, filter=None, id=None, labels=None, message_retention_duration=None, name=None, project=None, push_configs=None, retain_acked_messages=None, retry_policies=None, topic=None):
        if ack_deadline_seconds and not isinstance(ack_deadline_seconds, int):
            raise TypeError("Expected argument 'ack_deadline_seconds' to be a int")
        pulumi.set(__self__, "ack_deadline_seconds", ack_deadline_seconds)
        if bigquery_configs and not isinstance(bigquery_configs, list):
            raise TypeError("Expected argument 'bigquery_configs' to be a list")
        pulumi.set(__self__, "bigquery_configs", bigquery_configs)
        if dead_letter_policies and not isinstance(dead_letter_policies, list):
            raise TypeError("Expected argument 'dead_letter_policies' to be a list")
        pulumi.set(__self__, "dead_letter_policies", dead_letter_policies)
        if enable_exactly_once_delivery and not isinstance(enable_exactly_once_delivery, bool):
            raise TypeError("Expected argument 'enable_exactly_once_delivery' to be a bool")
        pulumi.set(__self__, "enable_exactly_once_delivery", enable_exactly_once_delivery)
        if enable_message_ordering and not isinstance(enable_message_ordering, bool):
            raise TypeError("Expected argument 'enable_message_ordering' to be a bool")
        pulumi.set(__self__, "enable_message_ordering", enable_message_ordering)
        if expiration_policies and not isinstance(expiration_policies, list):
            raise TypeError("Expected argument 'expiration_policies' to be a list")
        pulumi.set(__self__, "expiration_policies", expiration_policies)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if message_retention_duration and not isinstance(message_retention_duration, str):
            raise TypeError("Expected argument 'message_retention_duration' to be a str")
        pulumi.set(__self__, "message_retention_duration", message_retention_duration)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if push_configs and not isinstance(push_configs, list):
            raise TypeError("Expected argument 'push_configs' to be a list")
        pulumi.set(__self__, "push_configs", push_configs)
        if retain_acked_messages and not isinstance(retain_acked_messages, bool):
            raise TypeError("Expected argument 'retain_acked_messages' to be a bool")
        pulumi.set(__self__, "retain_acked_messages", retain_acked_messages)
        if retry_policies and not isinstance(retry_policies, list):
            raise TypeError("Expected argument 'retry_policies' to be a list")
        pulumi.set(__self__, "retry_policies", retry_policies)
        if topic and not isinstance(topic, str):
            raise TypeError("Expected argument 'topic' to be a str")
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="ackDeadlineSeconds")
    def ack_deadline_seconds(self) -> int:
        return pulumi.get(self, "ack_deadline_seconds")

    @property
    @pulumi.getter(name="bigqueryConfigs")
    def bigquery_configs(self) -> Sequence['outputs.GetSubscriptionBigqueryConfigResult']:
        return pulumi.get(self, "bigquery_configs")

    @property
    @pulumi.getter(name="deadLetterPolicies")
    def dead_letter_policies(self) -> Sequence['outputs.GetSubscriptionDeadLetterPolicyResult']:
        return pulumi.get(self, "dead_letter_policies")

    @property
    @pulumi.getter(name="enableExactlyOnceDelivery")
    def enable_exactly_once_delivery(self) -> bool:
        return pulumi.get(self, "enable_exactly_once_delivery")

    @property
    @pulumi.getter(name="enableMessageOrdering")
    def enable_message_ordering(self) -> bool:
        return pulumi.get(self, "enable_message_ordering")

    @property
    @pulumi.getter(name="expirationPolicies")
    def expiration_policies(self) -> Sequence['outputs.GetSubscriptionExpirationPolicyResult']:
        return pulumi.get(self, "expiration_policies")

    @property
    @pulumi.getter
    def filter(self) -> str:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="messageRetentionDuration")
    def message_retention_duration(self) -> str:
        return pulumi.get(self, "message_retention_duration")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pushConfigs")
    def push_configs(self) -> Sequence['outputs.GetSubscriptionPushConfigResult']:
        return pulumi.get(self, "push_configs")

    @property
    @pulumi.getter(name="retainAckedMessages")
    def retain_acked_messages(self) -> bool:
        return pulumi.get(self, "retain_acked_messages")

    @property
    @pulumi.getter(name="retryPolicies")
    def retry_policies(self) -> Sequence['outputs.GetSubscriptionRetryPolicyResult']:
        return pulumi.get(self, "retry_policies")

    @property
    @pulumi.getter
    def topic(self) -> str:
        return pulumi.get(self, "topic")


class AwaitableGetSubscriptionResult(GetSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionResult(
            ack_deadline_seconds=self.ack_deadline_seconds,
            bigquery_configs=self.bigquery_configs,
            dead_letter_policies=self.dead_letter_policies,
            enable_exactly_once_delivery=self.enable_exactly_once_delivery,
            enable_message_ordering=self.enable_message_ordering,
            expiration_policies=self.expiration_policies,
            filter=self.filter,
            id=self.id,
            labels=self.labels,
            message_retention_duration=self.message_retention_duration,
            name=self.name,
            project=self.project,
            push_configs=self.push_configs,
            retain_acked_messages=self.retain_acked_messages,
            retry_policies=self.retry_policies,
            topic=self.topic)


def get_subscription(name: Optional[str] = None,
                     project: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionResult:
    """
    Get information about a Google Cloud Pub/Sub Subscription. For more information see
    the [official documentation](https://cloud.google.com/pubsub/docs/)
    and [API](https://cloud.google.com/pubsub/docs/apis).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_pubsub_subscription = gcp.pubsub.get_subscription(name="my-pubsub-subscription")
    ```


    :param str name: The name of the Cloud Pub/Sub Subscription.
    :param str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:pubsub/getSubscription:getSubscription', __args__, opts=opts, typ=GetSubscriptionResult).value

    return AwaitableGetSubscriptionResult(
        ack_deadline_seconds=__ret__.ack_deadline_seconds,
        bigquery_configs=__ret__.bigquery_configs,
        dead_letter_policies=__ret__.dead_letter_policies,
        enable_exactly_once_delivery=__ret__.enable_exactly_once_delivery,
        enable_message_ordering=__ret__.enable_message_ordering,
        expiration_policies=__ret__.expiration_policies,
        filter=__ret__.filter,
        id=__ret__.id,
        labels=__ret__.labels,
        message_retention_duration=__ret__.message_retention_duration,
        name=__ret__.name,
        project=__ret__.project,
        push_configs=__ret__.push_configs,
        retain_acked_messages=__ret__.retain_acked_messages,
        retry_policies=__ret__.retry_policies,
        topic=__ret__.topic)


@_utilities.lift_output_func(get_subscription)
def get_subscription_output(name: Optional[pulumi.Input[str]] = None,
                            project: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSubscriptionResult]:
    """
    Get information about a Google Cloud Pub/Sub Subscription. For more information see
    the [official documentation](https://cloud.google.com/pubsub/docs/)
    and [API](https://cloud.google.com/pubsub/docs/apis).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_pubsub_subscription = gcp.pubsub.get_subscription(name="my-pubsub-subscription")
    ```


    :param str name: The name of the Cloud Pub/Sub Subscription.
    :param str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    ...
