# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDatabaseInstancesResult',
    'AwaitableGetDatabaseInstancesResult',
    'get_database_instances',
    'get_database_instances_output',
]

@pulumi.output_type
class GetDatabaseInstancesResult:
    """
    A collection of values returned by getDatabaseInstances.
    """
    def __init__(__self__, database_version=None, id=None, instances=None, project=None, region=None, state=None, tier=None, zone=None):
        if database_version and not isinstance(database_version, str):
            raise TypeError("Expected argument 'database_version' to be a str")
        pulumi.set(__self__, "database_version", database_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tier and not isinstance(tier, str):
            raise TypeError("Expected argument 'tier' to be a str")
        pulumi.set(__self__, "tier", tier)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[str]:
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetDatabaseInstancesInstanceResult']:
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        return pulumi.get(self, "zone")


class AwaitableGetDatabaseInstancesResult(GetDatabaseInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseInstancesResult(
            database_version=self.database_version,
            id=self.id,
            instances=self.instances,
            project=self.project,
            region=self.region,
            state=self.state,
            tier=self.tier,
            zone=self.zone)


def get_database_instances(database_version: Optional[str] = None,
                           project: Optional[str] = None,
                           region: Optional[str] = None,
                           state: Optional[str] = None,
                           tier: Optional[str] = None,
                           zone: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseInstancesResult:
    """
    Use this data source to get information about a list of Cloud SQL instances in a project. You can also apply some filters over this list to get a more filtered list of Cloud SQL instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    qa = gcp.sql.get_database_instances(project="test-project")
    ```


    :param str database_version: To filter out the Cloud SQL instances which are of the specified database version.
    :param str project: The ID of the project in which the resources belong. If it is not provided, the provider project is used.
    :param str region: To filter out the Cloud SQL instances which are located in the specified region.
    :param str state: To filter out the Cloud SQL instances based on the current serving state of the database instance. Supported values include `SQL_INSTANCE_STATE_UNSPECIFIED`, `RUNNABLE`, `SUSPENDED`, `PENDING_DELETE`, `PENDING_CREATE`, `MAINTENANCE`, `FAILED`.
    :param str tier: To filter out the Cloud SQL instances based on the tier(or machine type) of the database instances.
    :param str zone: To filter out the Cloud SQL instances which are located in the specified zone. This zone refers to the Compute Engine zone that the instance is currently serving from.
    """
    __args__ = dict()
    __args__['databaseVersion'] = database_version
    __args__['project'] = project
    __args__['region'] = region
    __args__['state'] = state
    __args__['tier'] = tier
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:sql/getDatabaseInstances:getDatabaseInstances', __args__, opts=opts, typ=GetDatabaseInstancesResult).value

    return AwaitableGetDatabaseInstancesResult(
        database_version=__ret__.database_version,
        id=__ret__.id,
        instances=__ret__.instances,
        project=__ret__.project,
        region=__ret__.region,
        state=__ret__.state,
        tier=__ret__.tier,
        zone=__ret__.zone)


@_utilities.lift_output_func(get_database_instances)
def get_database_instances_output(database_version: Optional[pulumi.Input[Optional[str]]] = None,
                                  project: Optional[pulumi.Input[Optional[str]]] = None,
                                  region: Optional[pulumi.Input[Optional[str]]] = None,
                                  state: Optional[pulumi.Input[Optional[str]]] = None,
                                  tier: Optional[pulumi.Input[Optional[str]]] = None,
                                  zone: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDatabaseInstancesResult]:
    """
    Use this data source to get information about a list of Cloud SQL instances in a project. You can also apply some filters over this list to get a more filtered list of Cloud SQL instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    qa = gcp.sql.get_database_instances(project="test-project")
    ```


    :param str database_version: To filter out the Cloud SQL instances which are of the specified database version.
    :param str project: The ID of the project in which the resources belong. If it is not provided, the provider project is used.
    :param str region: To filter out the Cloud SQL instances which are located in the specified region.
    :param str state: To filter out the Cloud SQL instances based on the current serving state of the database instance. Supported values include `SQL_INSTANCE_STATE_UNSPECIFIED`, `RUNNABLE`, `SUSPENDED`, `PENDING_DELETE`, `PENDING_CREATE`, `MAINTENANCE`, `FAILED`.
    :param str tier: To filter out the Cloud SQL instances based on the tier(or machine type) of the database instances.
    :param str zone: To filter out the Cloud SQL instances which are located in the specified zone. This zone refers to the Compute Engine zone that the instance is currently serving from.
    """
    ...
