# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DatabaseInstanceClone',
    'DatabaseInstanceIpAddress',
    'DatabaseInstanceReplicaConfiguration',
    'DatabaseInstanceRestoreBackupContext',
    'DatabaseInstanceServerCaCert',
    'DatabaseInstanceSettings',
    'DatabaseInstanceSettingsActiveDirectoryConfig',
    'DatabaseInstanceSettingsBackupConfiguration',
    'DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings',
    'DatabaseInstanceSettingsDatabaseFlag',
    'DatabaseInstanceSettingsDenyMaintenancePeriod',
    'DatabaseInstanceSettingsInsightsConfig',
    'DatabaseInstanceSettingsIpConfiguration',
    'DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork',
    'DatabaseInstanceSettingsLocationPreference',
    'DatabaseInstanceSettingsMaintenanceWindow',
    'DatabaseInstanceSettingsPasswordValidationPolicy',
    'DatabaseInstanceSettingsSqlServerAuditConfig',
    'UserPasswordPolicy',
    'UserPasswordPolicyStatus',
    'UserSqlServerUserDetail',
    'GetCaCertsCertResult',
    'GetDatabaseInstanceCloneResult',
    'GetDatabaseInstanceIpAddressResult',
    'GetDatabaseInstanceReplicaConfigurationResult',
    'GetDatabaseInstanceRestoreBackupContextResult',
    'GetDatabaseInstanceServerCaCertResult',
    'GetDatabaseInstanceSettingResult',
    'GetDatabaseInstanceSettingActiveDirectoryConfigResult',
    'GetDatabaseInstanceSettingBackupConfigurationResult',
    'GetDatabaseInstanceSettingBackupConfigurationBackupRetentionSettingResult',
    'GetDatabaseInstanceSettingDatabaseFlagResult',
    'GetDatabaseInstanceSettingDenyMaintenancePeriodResult',
    'GetDatabaseInstanceSettingInsightsConfigResult',
    'GetDatabaseInstanceSettingIpConfigurationResult',
    'GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult',
    'GetDatabaseInstanceSettingLocationPreferenceResult',
    'GetDatabaseInstanceSettingMaintenanceWindowResult',
    'GetDatabaseInstanceSettingPasswordValidationPolicyResult',
    'GetDatabaseInstanceSettingSqlServerAuditConfigResult',
    'GetDatabaseInstancesInstanceResult',
    'GetDatabaseInstancesInstanceCloneResult',
    'GetDatabaseInstancesInstanceIpAddressResult',
    'GetDatabaseInstancesInstanceReplicaConfigurationResult',
    'GetDatabaseInstancesInstanceRestoreBackupContextResult',
    'GetDatabaseInstancesInstanceServerCaCertResult',
    'GetDatabaseInstancesInstanceSettingResult',
    'GetDatabaseInstancesInstanceSettingActiveDirectoryConfigResult',
    'GetDatabaseInstancesInstanceSettingBackupConfigurationResult',
    'GetDatabaseInstancesInstanceSettingBackupConfigurationBackupRetentionSettingResult',
    'GetDatabaseInstancesInstanceSettingDatabaseFlagResult',
    'GetDatabaseInstancesInstanceSettingDenyMaintenancePeriodResult',
    'GetDatabaseInstancesInstanceSettingInsightsConfigResult',
    'GetDatabaseInstancesInstanceSettingIpConfigurationResult',
    'GetDatabaseInstancesInstanceSettingIpConfigurationAuthorizedNetworkResult',
    'GetDatabaseInstancesInstanceSettingLocationPreferenceResult',
    'GetDatabaseInstancesInstanceSettingMaintenanceWindowResult',
    'GetDatabaseInstancesInstanceSettingPasswordValidationPolicyResult',
    'GetDatabaseInstancesInstanceSettingSqlServerAuditConfigResult',
]

@pulumi.output_type
class DatabaseInstanceClone(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceInstanceName":
            suggest = "source_instance_name"
        elif key == "allocatedIpRange":
            suggest = "allocated_ip_range"
        elif key == "pointInTime":
            suggest = "point_in_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceClone. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceClone.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceClone.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_instance_name: str,
                 allocated_ip_range: Optional[str] = None,
                 point_in_time: Optional[str] = None):
        """
        :param str source_instance_name: Name of the source instance which will be cloned.
        :param str allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param str point_in_time: The timestamp of the point in time that should be restored.
        """
        pulumi.set(__self__, "source_instance_name", source_instance_name)
        if allocated_ip_range is not None:
            pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        if point_in_time is not None:
            pulumi.set(__self__, "point_in_time", point_in_time)

    @property
    @pulumi.getter(name="sourceInstanceName")
    def source_instance_name(self) -> str:
        """
        Name of the source instance which will be cloned.
        """
        return pulumi.get(self, "source_instance_name")

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> Optional[str]:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> Optional[str]:
        """
        The timestamp of the point in time that should be restored.
        """
        return pulumi.get(self, "point_in_time")


@pulumi.output_type
class DatabaseInstanceIpAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "timeToRetire":
            suggest = "time_to_retire"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceIpAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceIpAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceIpAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: Optional[str] = None,
                 time_to_retire: Optional[str] = None,
                 type: Optional[str] = None):
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if time_to_retire is not None:
            pulumi.set(__self__, "time_to_retire", time_to_retire)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="timeToRetire")
    def time_to_retire(self) -> Optional[str]:
        return pulumi.get(self, "time_to_retire")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class DatabaseInstanceReplicaConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificate":
            suggest = "ca_certificate"
        elif key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "connectRetryInterval":
            suggest = "connect_retry_interval"
        elif key == "dumpFilePath":
            suggest = "dump_file_path"
        elif key == "failoverTarget":
            suggest = "failover_target"
        elif key == "masterHeartbeatPeriod":
            suggest = "master_heartbeat_period"
        elif key == "sslCipher":
            suggest = "ssl_cipher"
        elif key == "verifyServerCertificate":
            suggest = "verify_server_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceReplicaConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceReplicaConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceReplicaConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certificate: Optional[str] = None,
                 client_certificate: Optional[str] = None,
                 client_key: Optional[str] = None,
                 connect_retry_interval: Optional[int] = None,
                 dump_file_path: Optional[str] = None,
                 failover_target: Optional[bool] = None,
                 master_heartbeat_period: Optional[int] = None,
                 password: Optional[str] = None,
                 ssl_cipher: Optional[str] = None,
                 username: Optional[str] = None,
                 verify_server_certificate: Optional[bool] = None):
        """
        :param str ca_certificate: PEM representation of the trusted CA's x509
               certificate.
        :param str client_certificate: PEM representation of the replica's x509
               certificate.
        :param str client_key: PEM representation of the replica's private key. The
               corresponding public key in encoded in the `client_certificate`.
        :param int connect_retry_interval: The number of seconds
               between connect retries. MySQL's default is 60 seconds.
        :param str dump_file_path: Path to a SQL file in GCS from which replica
               instances are created. Format is `gs://bucket/filename`.
        :param bool failover_target: Specifies if the replica is the failover target.
               If the field is set to true the replica will be designated as a failover replica.
               If the master instance fails, the replica instance will be promoted as
               the new master instance.
        :param int master_heartbeat_period: Time in ms between replication
               heartbeats.
        :param str password: Password for the replication connection.
        :param str username: Username for replication connection.
        :param bool verify_server_certificate: True if the master's common name
               value is checked during the SSL handshake.
        """
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if connect_retry_interval is not None:
            pulumi.set(__self__, "connect_retry_interval", connect_retry_interval)
        if dump_file_path is not None:
            pulumi.set(__self__, "dump_file_path", dump_file_path)
        if failover_target is not None:
            pulumi.set(__self__, "failover_target", failover_target)
        if master_heartbeat_period is not None:
            pulumi.set(__self__, "master_heartbeat_period", master_heartbeat_period)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if ssl_cipher is not None:
            pulumi.set(__self__, "ssl_cipher", ssl_cipher)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if verify_server_certificate is not None:
            pulumi.set(__self__, "verify_server_certificate", verify_server_certificate)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[str]:
        """
        PEM representation of the trusted CA's x509
        certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[str]:
        """
        PEM representation of the replica's x509
        certificate.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[str]:
        """
        PEM representation of the replica's private key. The
        corresponding public key in encoded in the `client_certificate`.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="connectRetryInterval")
    def connect_retry_interval(self) -> Optional[int]:
        """
        The number of seconds
        between connect retries. MySQL's default is 60 seconds.
        """
        return pulumi.get(self, "connect_retry_interval")

    @property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> Optional[str]:
        """
        Path to a SQL file in GCS from which replica
        instances are created. Format is `gs://bucket/filename`.
        """
        return pulumi.get(self, "dump_file_path")

    @property
    @pulumi.getter(name="failoverTarget")
    def failover_target(self) -> Optional[bool]:
        """
        Specifies if the replica is the failover target.
        If the field is set to true the replica will be designated as a failover replica.
        If the master instance fails, the replica instance will be promoted as
        the new master instance.
        """
        return pulumi.get(self, "failover_target")

    @property
    @pulumi.getter(name="masterHeartbeatPeriod")
    def master_heartbeat_period(self) -> Optional[int]:
        """
        Time in ms between replication
        heartbeats.
        """
        return pulumi.get(self, "master_heartbeat_period")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password for the replication connection.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> Optional[str]:
        return pulumi.get(self, "ssl_cipher")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username for replication connection.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="verifyServerCertificate")
    def verify_server_certificate(self) -> Optional[bool]:
        """
        True if the master's common name
        value is checked during the SSL handshake.
        """
        return pulumi.get(self, "verify_server_certificate")


@pulumi.output_type
class DatabaseInstanceRestoreBackupContext(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupRunId":
            suggest = "backup_run_id"
        elif key == "instanceId":
            suggest = "instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceRestoreBackupContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceRestoreBackupContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceRestoreBackupContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_run_id: int,
                 instance_id: Optional[str] = None,
                 project: Optional[str] = None):
        """
        :param int backup_run_id: The ID of the backup run to restore from.
        :param str instance_id: The ID of the instance that the backup was taken from. If left empty,
               this instance's ID will be used.
        :param str project: The full project ID of the source instance.`
        """
        pulumi.set(__self__, "backup_run_id", backup_run_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="backupRunId")
    def backup_run_id(self) -> int:
        """
        The ID of the backup run to restore from.
        """
        return pulumi.get(self, "backup_run_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        The ID of the instance that the backup was taken from. If left empty,
        this instance's ID will be used.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        """
        The full project ID of the source instance.`
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class DatabaseInstanceServerCaCert(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "expirationTime":
            suggest = "expiration_time"
        elif key == "sha1Fingerprint":
            suggest = "sha1_fingerprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceServerCaCert. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceServerCaCert.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceServerCaCert.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert: Optional[str] = None,
                 common_name: Optional[str] = None,
                 create_time: Optional[str] = None,
                 expiration_time: Optional[str] = None,
                 sha1_fingerprint: Optional[str] = None):
        """
        :param str expiration_time: The [RFC 3339](https://tools.ietf.org/html/rfc3339)
               formatted date time string indicating when this whitelist expires.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if sha1_fingerprint is not None:
            pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> Optional[str]:
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[str]:
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[str]:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[str]:
        """
        The [RFC 3339](https://tools.ietf.org/html/rfc3339)
        formatted date time string indicating when this whitelist expires.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> Optional[str]:
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class DatabaseInstanceSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activationPolicy":
            suggest = "activation_policy"
        elif key == "activeDirectoryConfig":
            suggest = "active_directory_config"
        elif key == "availabilityType":
            suggest = "availability_type"
        elif key == "backupConfiguration":
            suggest = "backup_configuration"
        elif key == "connectorEnforcement":
            suggest = "connector_enforcement"
        elif key == "databaseFlags":
            suggest = "database_flags"
        elif key == "deletionProtectionEnabled":
            suggest = "deletion_protection_enabled"
        elif key == "denyMaintenancePeriod":
            suggest = "deny_maintenance_period"
        elif key == "diskAutoresize":
            suggest = "disk_autoresize"
        elif key == "diskAutoresizeLimit":
            suggest = "disk_autoresize_limit"
        elif key == "diskSize":
            suggest = "disk_size"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "insightsConfig":
            suggest = "insights_config"
        elif key == "ipConfiguration":
            suggest = "ip_configuration"
        elif key == "locationPreference":
            suggest = "location_preference"
        elif key == "maintenanceWindow":
            suggest = "maintenance_window"
        elif key == "passwordValidationPolicy":
            suggest = "password_validation_policy"
        elif key == "pricingPlan":
            suggest = "pricing_plan"
        elif key == "sqlServerAuditConfig":
            suggest = "sql_server_audit_config"
        elif key == "timeZone":
            suggest = "time_zone"
        elif key == "userLabels":
            suggest = "user_labels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tier: str,
                 activation_policy: Optional[str] = None,
                 active_directory_config: Optional['outputs.DatabaseInstanceSettingsActiveDirectoryConfig'] = None,
                 availability_type: Optional[str] = None,
                 backup_configuration: Optional['outputs.DatabaseInstanceSettingsBackupConfiguration'] = None,
                 collation: Optional[str] = None,
                 connector_enforcement: Optional[str] = None,
                 database_flags: Optional[Sequence['outputs.DatabaseInstanceSettingsDatabaseFlag']] = None,
                 deletion_protection_enabled: Optional[bool] = None,
                 deny_maintenance_period: Optional['outputs.DatabaseInstanceSettingsDenyMaintenancePeriod'] = None,
                 disk_autoresize: Optional[bool] = None,
                 disk_autoresize_limit: Optional[int] = None,
                 disk_size: Optional[int] = None,
                 disk_type: Optional[str] = None,
                 insights_config: Optional['outputs.DatabaseInstanceSettingsInsightsConfig'] = None,
                 ip_configuration: Optional['outputs.DatabaseInstanceSettingsIpConfiguration'] = None,
                 location_preference: Optional['outputs.DatabaseInstanceSettingsLocationPreference'] = None,
                 maintenance_window: Optional['outputs.DatabaseInstanceSettingsMaintenanceWindow'] = None,
                 password_validation_policy: Optional['outputs.DatabaseInstanceSettingsPasswordValidationPolicy'] = None,
                 pricing_plan: Optional[str] = None,
                 sql_server_audit_config: Optional['outputs.DatabaseInstanceSettingsSqlServerAuditConfig'] = None,
                 time_zone: Optional[str] = None,
                 user_labels: Optional[Mapping[str, str]] = None,
                 version: Optional[int] = None):
        """
        :param str tier: The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
               for more details and supported versions. Postgres supports only shared-core machine types,
               and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        :param str activation_policy: This specifies when the instance should be
               active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        :param str availability_type: The availability type of the Cloud SQL
               instance, high availability (`REGIONAL`) or single zone (`ZONAL`).' For all instances, ensure that
               `settings.backup_configuration.enabled` is set to `true`.
               For MySQL instances, ensure that `settings.backup_configuration.binary_log_enabled` is set to `true`.
               For Postgres and SQL Server instances, ensure that `settings.backup_configuration.point_in_time_recovery_enabled`
               is set to `true`. Defaults to `ZONAL`.
        :param str collation: The name of server instance collation.
        :param str connector_enforcement: Specifies if connections must use Cloud SQL connectors.
        :param bool disk_autoresize: Enables auto-resizing of the storage size. Defaults to `true`.
        :param int disk_autoresize_limit: The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        :param int disk_size: The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB.
        :param str disk_type: The type of data disk: PD_SSD or PD_HDD. Defaults to `PD_SSD`.
        :param str pricing_plan: Pricing plan for this instance, can only be `PER_USE`.
        :param str time_zone: The time_zone to be used by the database engine (supported only for SQL Server), in SQL Server timezone format.
        :param Mapping[str, str] user_labels: A set of key/value user label pairs to assign to the instance.
        """
        pulumi.set(__self__, "tier", tier)
        if activation_policy is not None:
            pulumi.set(__self__, "activation_policy", activation_policy)
        if active_directory_config is not None:
            pulumi.set(__self__, "active_directory_config", active_directory_config)
        if availability_type is not None:
            pulumi.set(__self__, "availability_type", availability_type)
        if backup_configuration is not None:
            pulumi.set(__self__, "backup_configuration", backup_configuration)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if connector_enforcement is not None:
            pulumi.set(__self__, "connector_enforcement", connector_enforcement)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if deny_maintenance_period is not None:
            pulumi.set(__self__, "deny_maintenance_period", deny_maintenance_period)
        if disk_autoresize is not None:
            pulumi.set(__self__, "disk_autoresize", disk_autoresize)
        if disk_autoresize_limit is not None:
            pulumi.set(__self__, "disk_autoresize_limit", disk_autoresize_limit)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if insights_config is not None:
            pulumi.set(__self__, "insights_config", insights_config)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if location_preference is not None:
            pulumi.set(__self__, "location_preference", location_preference)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if password_validation_policy is not None:
            pulumi.set(__self__, "password_validation_policy", password_validation_policy)
        if pricing_plan is not None:
            pulumi.set(__self__, "pricing_plan", pricing_plan)
        if sql_server_audit_config is not None:
            pulumi.set(__self__, "sql_server_audit_config", sql_server_audit_config)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
        for more details and supported versions. Postgres supports only shared-core machine types,
        and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> Optional[str]:
        """
        This specifies when the instance should be
        active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        """
        return pulumi.get(self, "activation_policy")

    @property
    @pulumi.getter(name="activeDirectoryConfig")
    def active_directory_config(self) -> Optional['outputs.DatabaseInstanceSettingsActiveDirectoryConfig']:
        return pulumi.get(self, "active_directory_config")

    @property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> Optional[str]:
        """
        The availability type of the Cloud SQL
        instance, high availability (`REGIONAL`) or single zone (`ZONAL`).' For all instances, ensure that
        `settings.backup_configuration.enabled` is set to `true`.
        For MySQL instances, ensure that `settings.backup_configuration.binary_log_enabled` is set to `true`.
        For Postgres and SQL Server instances, ensure that `settings.backup_configuration.point_in_time_recovery_enabled`
        is set to `true`. Defaults to `ZONAL`.
        """
        return pulumi.get(self, "availability_type")

    @property
    @pulumi.getter(name="backupConfiguration")
    def backup_configuration(self) -> Optional['outputs.DatabaseInstanceSettingsBackupConfiguration']:
        return pulumi.get(self, "backup_configuration")

    @property
    @pulumi.getter
    def collation(self) -> Optional[str]:
        """
        The name of server instance collation.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter(name="connectorEnforcement")
    def connector_enforcement(self) -> Optional[str]:
        """
        Specifies if connections must use Cloud SQL connectors.
        """
        return pulumi.get(self, "connector_enforcement")

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[Sequence['outputs.DatabaseInstanceSettingsDatabaseFlag']]:
        return pulumi.get(self, "database_flags")

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "deletion_protection_enabled")

    @property
    @pulumi.getter(name="denyMaintenancePeriod")
    def deny_maintenance_period(self) -> Optional['outputs.DatabaseInstanceSettingsDenyMaintenancePeriod']:
        return pulumi.get(self, "deny_maintenance_period")

    @property
    @pulumi.getter(name="diskAutoresize")
    def disk_autoresize(self) -> Optional[bool]:
        """
        Enables auto-resizing of the storage size. Defaults to `true`.
        """
        return pulumi.get(self, "disk_autoresize")

    @property
    @pulumi.getter(name="diskAutoresizeLimit")
    def disk_autoresize_limit(self) -> Optional[int]:
        """
        The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        """
        return pulumi.get(self, "disk_autoresize_limit")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[int]:
        """
        The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. The minimum value is 10GB.
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[str]:
        """
        The type of data disk: PD_SSD or PD_HDD. Defaults to `PD_SSD`.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="insightsConfig")
    def insights_config(self) -> Optional['outputs.DatabaseInstanceSettingsInsightsConfig']:
        return pulumi.get(self, "insights_config")

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional['outputs.DatabaseInstanceSettingsIpConfiguration']:
        return pulumi.get(self, "ip_configuration")

    @property
    @pulumi.getter(name="locationPreference")
    def location_preference(self) -> Optional['outputs.DatabaseInstanceSettingsLocationPreference']:
        return pulumi.get(self, "location_preference")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional['outputs.DatabaseInstanceSettingsMaintenanceWindow']:
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="passwordValidationPolicy")
    def password_validation_policy(self) -> Optional['outputs.DatabaseInstanceSettingsPasswordValidationPolicy']:
        return pulumi.get(self, "password_validation_policy")

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> Optional[str]:
        """
        Pricing plan for this instance, can only be `PER_USE`.
        """
        return pulumi.get(self, "pricing_plan")

    @property
    @pulumi.getter(name="sqlServerAuditConfig")
    def sql_server_audit_config(self) -> Optional['outputs.DatabaseInstanceSettingsSqlServerAuditConfig']:
        return pulumi.get(self, "sql_server_audit_config")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        The time_zone to be used by the database engine (supported only for SQL Server), in SQL Server timezone format.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[Mapping[str, str]]:
        """
        A set of key/value user label pairs to assign to the instance.
        """
        return pulumi.get(self, "user_labels")

    @property
    @pulumi.getter
    def version(self) -> Optional[int]:
        return pulumi.get(self, "version")


@pulumi.output_type
class DatabaseInstanceSettingsActiveDirectoryConfig(dict):
    def __init__(__self__, *,
                 domain: str):
        """
        :param str domain: The domain name for the active directory (e.g., mydomain.com).
               Can only be used with SQL Server.
        """
        pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The domain name for the active directory (e.g., mydomain.com).
        Can only be used with SQL Server.
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class DatabaseInstanceSettingsBackupConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupRetentionSettings":
            suggest = "backup_retention_settings"
        elif key == "binaryLogEnabled":
            suggest = "binary_log_enabled"
        elif key == "pointInTimeRecoveryEnabled":
            suggest = "point_in_time_recovery_enabled"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "transactionLogRetentionDays":
            suggest = "transaction_log_retention_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsBackupConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsBackupConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsBackupConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_retention_settings: Optional['outputs.DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings'] = None,
                 binary_log_enabled: Optional[bool] = None,
                 enabled: Optional[bool] = None,
                 location: Optional[str] = None,
                 point_in_time_recovery_enabled: Optional[bool] = None,
                 start_time: Optional[str] = None,
                 transaction_log_retention_days: Optional[int] = None):
        """
        :param 'DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs' backup_retention_settings: Backup retention settings. The configuration is detailed below.
        :param bool binary_log_enabled: True if binary logging is enabled.
               Can only be used with MySQL.
        :param bool enabled: True if backup configuration is enabled.
        :param str location: The region where the backup will be stored
        :param bool point_in_time_recovery_enabled: True if Point-in-time recovery is enabled. Will restart database if enabled after instance creation. Valid only for PostgreSQL and SQL Server instances.
        :param str start_time: `HH:MM` format time indicating when backup
               configuration starts.
        :param int transaction_log_retention_days: The number of days of transaction logs we retain for point in time restore, from 1-7.
        """
        if backup_retention_settings is not None:
            pulumi.set(__self__, "backup_retention_settings", backup_retention_settings)
        if binary_log_enabled is not None:
            pulumi.set(__self__, "binary_log_enabled", binary_log_enabled)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if point_in_time_recovery_enabled is not None:
            pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if transaction_log_retention_days is not None:
            pulumi.set(__self__, "transaction_log_retention_days", transaction_log_retention_days)

    @property
    @pulumi.getter(name="backupRetentionSettings")
    def backup_retention_settings(self) -> Optional['outputs.DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings']:
        """
        Backup retention settings. The configuration is detailed below.
        """
        return pulumi.get(self, "backup_retention_settings")

    @property
    @pulumi.getter(name="binaryLogEnabled")
    def binary_log_enabled(self) -> Optional[bool]:
        """
        True if binary logging is enabled.
        Can only be used with MySQL.
        """
        return pulumi.get(self, "binary_log_enabled")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        True if backup configuration is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The region where the backup will be stored
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> Optional[bool]:
        """
        True if Point-in-time recovery is enabled. Will restart database if enabled after instance creation. Valid only for PostgreSQL and SQL Server instances.
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        `HH:MM` format time indicating when backup
        configuration starts.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="transactionLogRetentionDays")
    def transaction_log_retention_days(self) -> Optional[int]:
        """
        The number of days of transaction logs we retain for point in time restore, from 1-7.
        """
        return pulumi.get(self, "transaction_log_retention_days")


@pulumi.output_type
class DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retainedBackups":
            suggest = "retained_backups"
        elif key == "retentionUnit":
            suggest = "retention_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retained_backups: int,
                 retention_unit: Optional[str] = None):
        """
        :param int retained_backups: Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit
               is 'COUNT', we will retain this many backups.
        :param str retention_unit: The unit that 'retained_backups' represents. Defaults to `COUNT`.
        """
        pulumi.set(__self__, "retained_backups", retained_backups)
        if retention_unit is not None:
            pulumi.set(__self__, "retention_unit", retention_unit)

    @property
    @pulumi.getter(name="retainedBackups")
    def retained_backups(self) -> int:
        """
        Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit
        is 'COUNT', we will retain this many backups.
        """
        return pulumi.get(self, "retained_backups")

    @property
    @pulumi.getter(name="retentionUnit")
    def retention_unit(self) -> Optional[str]:
        """
        The unit that 'retained_backups' represents. Defaults to `COUNT`.
        """
        return pulumi.get(self, "retention_unit")


@pulumi.output_type
class DatabaseInstanceSettingsDatabaseFlag(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: Name of the flag.
        :param str value: Value of the flag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the flag.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the flag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DatabaseInstanceSettingsDenyMaintenancePeriod(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDate":
            suggest = "end_date"
        elif key == "startDate":
            suggest = "start_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsDenyMaintenancePeriod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsDenyMaintenancePeriod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsDenyMaintenancePeriod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_date: str,
                 start_date: str,
                 time: str):
        """
        :param str end_date: "deny maintenance period" end date. If the year of the end date is empty, the year of the start date also must be empty. In this case, it means the no maintenance interval recurs every year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        :param str start_date: "deny maintenance period" start date. If the year of the start date is empty, the year of the end date also must be empty. In this case, it means the deny maintenance period recurs every year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        :param str time: Time in UTC when the "deny maintenance period" starts on startDate and ends on endDate. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> str:
        """
        "deny maintenance period" end date. If the year of the end date is empty, the year of the start date also must be empty. In this case, it means the no maintenance interval recurs every year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> str:
        """
        "deny maintenance period" start date. If the year of the start date is empty, the year of the end date also must be empty. In this case, it means the deny maintenance period recurs every year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def time(self) -> str:
        """
        Time in UTC when the "deny maintenance period" starts on startDate and ends on endDate. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class DatabaseInstanceSettingsInsightsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryInsightsEnabled":
            suggest = "query_insights_enabled"
        elif key == "queryPlansPerMinute":
            suggest = "query_plans_per_minute"
        elif key == "queryStringLength":
            suggest = "query_string_length"
        elif key == "recordApplicationTags":
            suggest = "record_application_tags"
        elif key == "recordClientAddress":
            suggest = "record_client_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsInsightsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsInsightsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsInsightsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_insights_enabled: Optional[bool] = None,
                 query_plans_per_minute: Optional[int] = None,
                 query_string_length: Optional[int] = None,
                 record_application_tags: Optional[bool] = None,
                 record_client_address: Optional[bool] = None):
        """
        :param bool query_insights_enabled: True if Query Insights feature is enabled.
        :param int query_plans_per_minute: Number of query execution plans captured by Insights per minute for all queries combined. Between 0 and 20. Default to 5.
        :param int query_string_length: Maximum query length stored in bytes. Between 256 and 4500. Default to 1024.
        :param bool record_application_tags: True if Query Insights will record application tags from query when enabled.
        :param bool record_client_address: True if Query Insights will record client address when enabled.
        """
        if query_insights_enabled is not None:
            pulumi.set(__self__, "query_insights_enabled", query_insights_enabled)
        if query_plans_per_minute is not None:
            pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        if query_string_length is not None:
            pulumi.set(__self__, "query_string_length", query_string_length)
        if record_application_tags is not None:
            pulumi.set(__self__, "record_application_tags", record_application_tags)
        if record_client_address is not None:
            pulumi.set(__self__, "record_client_address", record_client_address)

    @property
    @pulumi.getter(name="queryInsightsEnabled")
    def query_insights_enabled(self) -> Optional[bool]:
        """
        True if Query Insights feature is enabled.
        """
        return pulumi.get(self, "query_insights_enabled")

    @property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> Optional[int]:
        """
        Number of query execution plans captured by Insights per minute for all queries combined. Between 0 and 20. Default to 5.
        """
        return pulumi.get(self, "query_plans_per_minute")

    @property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> Optional[int]:
        """
        Maximum query length stored in bytes. Between 256 and 4500. Default to 1024.
        """
        return pulumi.get(self, "query_string_length")

    @property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> Optional[bool]:
        """
        True if Query Insights will record application tags from query when enabled.
        """
        return pulumi.get(self, "record_application_tags")

    @property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> Optional[bool]:
        """
        True if Query Insights will record client address when enabled.
        """
        return pulumi.get(self, "record_client_address")


@pulumi.output_type
class DatabaseInstanceSettingsIpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocatedIpRange":
            suggest = "allocated_ip_range"
        elif key == "authorizedNetworks":
            suggest = "authorized_networks"
        elif key == "ipv4Enabled":
            suggest = "ipv4_enabled"
        elif key == "privateNetwork":
            suggest = "private_network"
        elif key == "requireSsl":
            suggest = "require_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsIpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsIpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsIpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocated_ip_range: Optional[str] = None,
                 authorized_networks: Optional[Sequence['outputs.DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork']] = None,
                 ipv4_enabled: Optional[bool] = None,
                 private_network: Optional[str] = None,
                 require_ssl: Optional[bool] = None):
        """
        :param str allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://datatracker.ietf.org/doc/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param bool ipv4_enabled: Whether this Cloud SQL instance should be assigned
               a public IPV4 address. At least `ipv4_enabled` must be enabled or a
               `private_network` must be configured.
        :param str private_network: The VPC network from which the Cloud SQL
               instance is accessible for private IP. For example, projects/myProject/global/networks/default.
               Specifying a network enables private IP.
               At least `ipv4_enabled` must be enabled or a `private_network` must be configured.
               This setting can be updated, but it cannot be removed after it is set.
        :param bool require_ssl: Whether SSL connections over IP are enforced or not.
        """
        if allocated_ip_range is not None:
            pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        if authorized_networks is not None:
            pulumi.set(__self__, "authorized_networks", authorized_networks)
        if ipv4_enabled is not None:
            pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if require_ssl is not None:
            pulumi.set(__self__, "require_ssl", require_ssl)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> Optional[str]:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://datatracker.ietf.org/doc/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Optional[Sequence['outputs.DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork']]:
        return pulumi.get(self, "authorized_networks")

    @property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> Optional[bool]:
        """
        Whether this Cloud SQL instance should be assigned
        a public IPV4 address. At least `ipv4_enabled` must be enabled or a
        `private_network` must be configured.
        """
        return pulumi.get(self, "ipv4_enabled")

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[str]:
        """
        The VPC network from which the Cloud SQL
        instance is accessible for private IP. For example, projects/myProject/global/networks/default.
        Specifying a network enables private IP.
        At least `ipv4_enabled` must be enabled or a `private_network` must be configured.
        This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> Optional[bool]:
        """
        Whether SSL connections over IP are enforced or not.
        """
        return pulumi.get(self, "require_ssl")


@pulumi.output_type
class DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationTime":
            suggest = "expiration_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: str,
                 expiration_time: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str value: A CIDR notation IPv4 or IPv6 address that is allowed to
               access this instance. Must be set even if other two attributes are not for
               the whitelist to become active.
        :param str expiration_time: The [RFC 3339](https://tools.ietf.org/html/rfc3339)
               formatted date time string indicating when this whitelist expires.
        :param str name: A name for this whitelist entry.
        """
        pulumi.set(__self__, "value", value)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        A CIDR notation IPv4 or IPv6 address that is allowed to
        access this instance. Must be set even if other two attributes are not for
        the whitelist to become active.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[str]:
        """
        The [RFC 3339](https://tools.ietf.org/html/rfc3339)
        formatted date time string indicating when this whitelist expires.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A name for this whitelist entry.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DatabaseInstanceSettingsLocationPreference(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "followGaeApplication":
            suggest = "follow_gae_application"
        elif key == "secondaryZone":
            suggest = "secondary_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsLocationPreference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsLocationPreference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsLocationPreference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 follow_gae_application: Optional[str] = None,
                 secondary_zone: Optional[str] = None,
                 zone: Optional[str] = None):
        """
        :param str follow_gae_application: A GAE application whose zone to remain
               in. Must be in the same region as this instance.
        :param str secondary_zone: The preferred Compute Engine zone for the secondary/failover.
        :param str zone: The preferred compute engine
               [zone](https://cloud.google.com/compute/docs/zones?hl=en).
        """
        if follow_gae_application is not None:
            pulumi.set(__self__, "follow_gae_application", follow_gae_application)
        if secondary_zone is not None:
            pulumi.set(__self__, "secondary_zone", secondary_zone)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="followGaeApplication")
    def follow_gae_application(self) -> Optional[str]:
        """
        A GAE application whose zone to remain
        in. Must be in the same region as this instance.
        """
        return pulumi.get(self, "follow_gae_application")

    @property
    @pulumi.getter(name="secondaryZone")
    def secondary_zone(self) -> Optional[str]:
        """
        The preferred Compute Engine zone for the secondary/failover.
        """
        return pulumi.get(self, "secondary_zone")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        The preferred compute engine
        [zone](https://cloud.google.com/compute/docs/zones?hl=en).
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class DatabaseInstanceSettingsMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateTrack":
            suggest = "update_track"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: Optional[int] = None,
                 hour: Optional[int] = None,
                 update_track: Optional[str] = None):
        """
        :param int day: Day of week (`1-7`), starting on Monday
        :param int hour: Hour of day (`0-23`), ignored if `day` not set
        :param str update_track: Receive updates earlier (`canary`) or later
               (`stable`)
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if update_track is not None:
            pulumi.set(__self__, "update_track", update_track)

    @property
    @pulumi.getter
    def day(self) -> Optional[int]:
        """
        Day of week (`1-7`), starting on Monday
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def hour(self) -> Optional[int]:
        """
        Hour of day (`0-23`), ignored if `day` not set
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter(name="updateTrack")
    def update_track(self) -> Optional[str]:
        """
        Receive updates earlier (`canary`) or later
        (`stable`)
        """
        return pulumi.get(self, "update_track")


@pulumi.output_type
class DatabaseInstanceSettingsPasswordValidationPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enablePasswordPolicy":
            suggest = "enable_password_policy"
        elif key == "disallowUsernameSubstring":
            suggest = "disallow_username_substring"
        elif key == "minLength":
            suggest = "min_length"
        elif key == "passwordChangeInterval":
            suggest = "password_change_interval"
        elif key == "reuseInterval":
            suggest = "reuse_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsPasswordValidationPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsPasswordValidationPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsPasswordValidationPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_password_policy: bool,
                 complexity: Optional[str] = None,
                 disallow_username_substring: Optional[bool] = None,
                 min_length: Optional[int] = None,
                 password_change_interval: Optional[str] = None,
                 reuse_interval: Optional[int] = None):
        """
        :param bool enable_password_policy: Enables or disable the password validation policy.
        :param str complexity: Checks if the password is a combination of lowercase, uppercase, numeric, and non-alphanumeric characters.
        :param bool disallow_username_substring: Prevents the use of the username in the password.
        :param int min_length: Specifies the minimum number of characters that the password must have.
        :param str password_change_interval: Specifies the minimum duration after which you can change the password.
        :param int reuse_interval: Specifies the number of previous passwords that you can't reuse.
        """
        pulumi.set(__self__, "enable_password_policy", enable_password_policy)
        if complexity is not None:
            pulumi.set(__self__, "complexity", complexity)
        if disallow_username_substring is not None:
            pulumi.set(__self__, "disallow_username_substring", disallow_username_substring)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if password_change_interval is not None:
            pulumi.set(__self__, "password_change_interval", password_change_interval)
        if reuse_interval is not None:
            pulumi.set(__self__, "reuse_interval", reuse_interval)

    @property
    @pulumi.getter(name="enablePasswordPolicy")
    def enable_password_policy(self) -> bool:
        """
        Enables or disable the password validation policy.
        """
        return pulumi.get(self, "enable_password_policy")

    @property
    @pulumi.getter
    def complexity(self) -> Optional[str]:
        """
        Checks if the password is a combination of lowercase, uppercase, numeric, and non-alphanumeric characters.
        """
        return pulumi.get(self, "complexity")

    @property
    @pulumi.getter(name="disallowUsernameSubstring")
    def disallow_username_substring(self) -> Optional[bool]:
        """
        Prevents the use of the username in the password.
        """
        return pulumi.get(self, "disallow_username_substring")

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[int]:
        """
        Specifies the minimum number of characters that the password must have.
        """
        return pulumi.get(self, "min_length")

    @property
    @pulumi.getter(name="passwordChangeInterval")
    def password_change_interval(self) -> Optional[str]:
        """
        Specifies the minimum duration after which you can change the password.
        """
        return pulumi.get(self, "password_change_interval")

    @property
    @pulumi.getter(name="reuseInterval")
    def reuse_interval(self) -> Optional[int]:
        """
        Specifies the number of previous passwords that you can't reuse.
        """
        return pulumi.get(self, "reuse_interval")


@pulumi.output_type
class DatabaseInstanceSettingsSqlServerAuditConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionInterval":
            suggest = "retention_interval"
        elif key == "uploadInterval":
            suggest = "upload_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsSqlServerAuditConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsSqlServerAuditConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsSqlServerAuditConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: Optional[str] = None,
                 retention_interval: Optional[str] = None,
                 upload_interval: Optional[str] = None):
        """
        :param str bucket: The name of the destination bucket (e.g., gs://mybucket).
        :param str retention_interval: How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param str upload_interval: How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if retention_interval is not None:
            pulumi.set(__self__, "retention_interval", retention_interval)
        if upload_interval is not None:
            pulumi.set(__self__, "upload_interval", upload_interval)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        The name of the destination bucket (e.g., gs://mybucket).
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="retentionInterval")
    def retention_interval(self) -> Optional[str]:
        """
        How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "retention_interval")

    @property
    @pulumi.getter(name="uploadInterval")
    def upload_interval(self) -> Optional[str]:
        """
        How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "upload_interval")


@pulumi.output_type
class UserPasswordPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedFailedAttempts":
            suggest = "allowed_failed_attempts"
        elif key == "enableFailedAttemptsCheck":
            suggest = "enable_failed_attempts_check"
        elif key == "enablePasswordVerification":
            suggest = "enable_password_verification"
        elif key == "passwordExpirationDuration":
            suggest = "password_expiration_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPasswordPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPasswordPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPasswordPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_failed_attempts: Optional[int] = None,
                 enable_failed_attempts_check: Optional[bool] = None,
                 enable_password_verification: Optional[bool] = None,
                 password_expiration_duration: Optional[str] = None,
                 statuses: Optional[Sequence['outputs.UserPasswordPolicyStatus']] = None):
        """
        :param int allowed_failed_attempts: Number of failed attempts allowed before the user get locked.
        :param bool enable_failed_attempts_check: If true, the check that will lock user after too many failed login attempts will be enabled.
        :param bool enable_password_verification: If true, the user must specify the current password before changing the password. This flag is supported only for MySQL.
        :param str password_expiration_duration: Password expiration duration with one week grace period.
        """
        if allowed_failed_attempts is not None:
            pulumi.set(__self__, "allowed_failed_attempts", allowed_failed_attempts)
        if enable_failed_attempts_check is not None:
            pulumi.set(__self__, "enable_failed_attempts_check", enable_failed_attempts_check)
        if enable_password_verification is not None:
            pulumi.set(__self__, "enable_password_verification", enable_password_verification)
        if password_expiration_duration is not None:
            pulumi.set(__self__, "password_expiration_duration", password_expiration_duration)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)

    @property
    @pulumi.getter(name="allowedFailedAttempts")
    def allowed_failed_attempts(self) -> Optional[int]:
        """
        Number of failed attempts allowed before the user get locked.
        """
        return pulumi.get(self, "allowed_failed_attempts")

    @property
    @pulumi.getter(name="enableFailedAttemptsCheck")
    def enable_failed_attempts_check(self) -> Optional[bool]:
        """
        If true, the check that will lock user after too many failed login attempts will be enabled.
        """
        return pulumi.get(self, "enable_failed_attempts_check")

    @property
    @pulumi.getter(name="enablePasswordVerification")
    def enable_password_verification(self) -> Optional[bool]:
        """
        If true, the user must specify the current password before changing the password. This flag is supported only for MySQL.
        """
        return pulumi.get(self, "enable_password_verification")

    @property
    @pulumi.getter(name="passwordExpirationDuration")
    def password_expiration_duration(self) -> Optional[str]:
        """
        Password expiration duration with one week grace period.
        """
        return pulumi.get(self, "password_expiration_duration")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.UserPasswordPolicyStatus']]:
        return pulumi.get(self, "statuses")


@pulumi.output_type
class UserPasswordPolicyStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordExpirationTime":
            suggest = "password_expiration_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPasswordPolicyStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPasswordPolicyStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPasswordPolicyStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 locked: Optional[bool] = None,
                 password_expiration_time: Optional[str] = None):
        """
        :param bool locked: If true, user does not have login privileges.
        :param str password_expiration_time: Password expiration duration with one week grace period.
        """
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if password_expiration_time is not None:
            pulumi.set(__self__, "password_expiration_time", password_expiration_time)

    @property
    @pulumi.getter
    def locked(self) -> Optional[bool]:
        """
        If true, user does not have login privileges.
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter(name="passwordExpirationTime")
    def password_expiration_time(self) -> Optional[str]:
        """
        Password expiration duration with one week grace period.
        """
        return pulumi.get(self, "password_expiration_time")


@pulumi.output_type
class UserSqlServerUserDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverRoles":
            suggest = "server_roles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserSqlServerUserDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserSqlServerUserDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserSqlServerUserDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled: Optional[bool] = None,
                 server_roles: Optional[Sequence[str]] = None):
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if server_roles is not None:
            pulumi.set(__self__, "server_roles", server_roles)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="serverRoles")
    def server_roles(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "server_roles")


@pulumi.output_type
class GetCaCertsCertResult(dict):
    def __init__(__self__, *,
                 cert: str,
                 common_name: str,
                 create_time: str,
                 expiration_time: str,
                 sha1_fingerprint: str):
        """
        :param str cert: The CA certificate used to connect to the SQL instance via SSL.
        :param str common_name: The CN valid for the CA cert.
        :param str create_time: Creation time of the CA cert.
        :param str expiration_time: Expiration time of the CA cert.
        :param str sha1_fingerprint: SHA1 fingerprint of the CA cert.
        """
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> str:
        """
        The CA certificate used to connect to the SQL instance via SSL.
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        """
        The CN valid for the CA cert.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Creation time of the CA cert.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        """
        Expiration time of the CA cert.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> str:
        """
        SHA1 fingerprint of the CA cert.
        """
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class GetDatabaseInstanceCloneResult(dict):
    def __init__(__self__, *,
                 allocated_ip_range: str,
                 point_in_time: str,
                 source_instance_name: str):
        pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        pulumi.set(__self__, "point_in_time", point_in_time)
        pulumi.set(__self__, "source_instance_name", source_instance_name)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> str:
        return pulumi.get(self, "allocated_ip_range")

    @property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> str:
        return pulumi.get(self, "point_in_time")

    @property
    @pulumi.getter(name="sourceInstanceName")
    def source_instance_name(self) -> str:
        return pulumi.get(self, "source_instance_name")


@pulumi.output_type
class GetDatabaseInstanceIpAddressResult(dict):
    def __init__(__self__, *,
                 ip_address: str,
                 time_to_retire: str,
                 type: str):
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "time_to_retire", time_to_retire)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="timeToRetire")
    def time_to_retire(self) -> str:
        return pulumi.get(self, "time_to_retire")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDatabaseInstanceReplicaConfigurationResult(dict):
    def __init__(__self__, *,
                 ca_certificate: str,
                 client_certificate: str,
                 client_key: str,
                 connect_retry_interval: int,
                 dump_file_path: str,
                 failover_target: bool,
                 master_heartbeat_period: int,
                 password: str,
                 ssl_cipher: str,
                 username: str,
                 verify_server_certificate: bool):
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "connect_retry_interval", connect_retry_interval)
        pulumi.set(__self__, "dump_file_path", dump_file_path)
        pulumi.set(__self__, "failover_target", failover_target)
        pulumi.set(__self__, "master_heartbeat_period", master_heartbeat_period)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "ssl_cipher", ssl_cipher)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "verify_server_certificate", verify_server_certificate)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> str:
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> str:
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> str:
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="connectRetryInterval")
    def connect_retry_interval(self) -> int:
        return pulumi.get(self, "connect_retry_interval")

    @property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> str:
        return pulumi.get(self, "dump_file_path")

    @property
    @pulumi.getter(name="failoverTarget")
    def failover_target(self) -> bool:
        return pulumi.get(self, "failover_target")

    @property
    @pulumi.getter(name="masterHeartbeatPeriod")
    def master_heartbeat_period(self) -> int:
        return pulumi.get(self, "master_heartbeat_period")

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> str:
        return pulumi.get(self, "ssl_cipher")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="verifyServerCertificate")
    def verify_server_certificate(self) -> bool:
        return pulumi.get(self, "verify_server_certificate")


@pulumi.output_type
class GetDatabaseInstanceRestoreBackupContextResult(dict):
    def __init__(__self__, *,
                 backup_run_id: int,
                 instance_id: str,
                 project: str):
        """
        :param str project: The ID of the project in which the resource belongs.
        """
        pulumi.set(__self__, "backup_run_id", backup_run_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="backupRunId")
    def backup_run_id(self) -> int:
        return pulumi.get(self, "backup_run_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The ID of the project in which the resource belongs.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class GetDatabaseInstanceServerCaCertResult(dict):
    def __init__(__self__, *,
                 cert: str,
                 common_name: str,
                 create_time: str,
                 expiration_time: str,
                 sha1_fingerprint: str):
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> str:
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> str:
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class GetDatabaseInstanceSettingResult(dict):
    def __init__(__self__, *,
                 activation_policy: str,
                 active_directory_configs: Sequence['outputs.GetDatabaseInstanceSettingActiveDirectoryConfigResult'],
                 availability_type: str,
                 backup_configurations: Sequence['outputs.GetDatabaseInstanceSettingBackupConfigurationResult'],
                 collation: str,
                 connector_enforcement: str,
                 database_flags: Sequence['outputs.GetDatabaseInstanceSettingDatabaseFlagResult'],
                 deletion_protection_enabled: bool,
                 deny_maintenance_periods: Sequence['outputs.GetDatabaseInstanceSettingDenyMaintenancePeriodResult'],
                 disk_autoresize: bool,
                 disk_autoresize_limit: int,
                 disk_size: int,
                 disk_type: str,
                 insights_configs: Sequence['outputs.GetDatabaseInstanceSettingInsightsConfigResult'],
                 ip_configurations: Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationResult'],
                 location_preferences: Sequence['outputs.GetDatabaseInstanceSettingLocationPreferenceResult'],
                 maintenance_windows: Sequence['outputs.GetDatabaseInstanceSettingMaintenanceWindowResult'],
                 password_validation_policies: Sequence['outputs.GetDatabaseInstanceSettingPasswordValidationPolicyResult'],
                 pricing_plan: str,
                 sql_server_audit_configs: Sequence['outputs.GetDatabaseInstanceSettingSqlServerAuditConfigResult'],
                 tier: str,
                 time_zone: str,
                 user_labels: Mapping[str, str],
                 version: int):
        pulumi.set(__self__, "activation_policy", activation_policy)
        pulumi.set(__self__, "active_directory_configs", active_directory_configs)
        pulumi.set(__self__, "availability_type", availability_type)
        pulumi.set(__self__, "backup_configurations", backup_configurations)
        pulumi.set(__self__, "collation", collation)
        pulumi.set(__self__, "connector_enforcement", connector_enforcement)
        pulumi.set(__self__, "database_flags", database_flags)
        pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        pulumi.set(__self__, "deny_maintenance_periods", deny_maintenance_periods)
        pulumi.set(__self__, "disk_autoresize", disk_autoresize)
        pulumi.set(__self__, "disk_autoresize_limit", disk_autoresize_limit)
        pulumi.set(__self__, "disk_size", disk_size)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "insights_configs", insights_configs)
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "location_preferences", location_preferences)
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        pulumi.set(__self__, "password_validation_policies", password_validation_policies)
        pulumi.set(__self__, "pricing_plan", pricing_plan)
        pulumi.set(__self__, "sql_server_audit_configs", sql_server_audit_configs)
        pulumi.set(__self__, "tier", tier)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "user_labels", user_labels)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> str:
        return pulumi.get(self, "activation_policy")

    @property
    @pulumi.getter(name="activeDirectoryConfigs")
    def active_directory_configs(self) -> Sequence['outputs.GetDatabaseInstanceSettingActiveDirectoryConfigResult']:
        return pulumi.get(self, "active_directory_configs")

    @property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> str:
        return pulumi.get(self, "availability_type")

    @property
    @pulumi.getter(name="backupConfigurations")
    def backup_configurations(self) -> Sequence['outputs.GetDatabaseInstanceSettingBackupConfigurationResult']:
        return pulumi.get(self, "backup_configurations")

    @property
    @pulumi.getter
    def collation(self) -> str:
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter(name="connectorEnforcement")
    def connector_enforcement(self) -> str:
        return pulumi.get(self, "connector_enforcement")

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Sequence['outputs.GetDatabaseInstanceSettingDatabaseFlagResult']:
        return pulumi.get(self, "database_flags")

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> bool:
        return pulumi.get(self, "deletion_protection_enabled")

    @property
    @pulumi.getter(name="denyMaintenancePeriods")
    def deny_maintenance_periods(self) -> Sequence['outputs.GetDatabaseInstanceSettingDenyMaintenancePeriodResult']:
        return pulumi.get(self, "deny_maintenance_periods")

    @property
    @pulumi.getter(name="diskAutoresize")
    def disk_autoresize(self) -> bool:
        return pulumi.get(self, "disk_autoresize")

    @property
    @pulumi.getter(name="diskAutoresizeLimit")
    def disk_autoresize_limit(self) -> int:
        return pulumi.get(self, "disk_autoresize_limit")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> int:
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="insightsConfigs")
    def insights_configs(self) -> Sequence['outputs.GetDatabaseInstanceSettingInsightsConfigResult']:
        return pulumi.get(self, "insights_configs")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationResult']:
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter(name="locationPreferences")
    def location_preferences(self) -> Sequence['outputs.GetDatabaseInstanceSettingLocationPreferenceResult']:
        return pulumi.get(self, "location_preferences")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetDatabaseInstanceSettingMaintenanceWindowResult']:
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="passwordValidationPolicies")
    def password_validation_policies(self) -> Sequence['outputs.GetDatabaseInstanceSettingPasswordValidationPolicyResult']:
        return pulumi.get(self, "password_validation_policies")

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> str:
        return pulumi.get(self, "pricing_plan")

    @property
    @pulumi.getter(name="sqlServerAuditConfigs")
    def sql_server_audit_configs(self) -> Sequence['outputs.GetDatabaseInstanceSettingSqlServerAuditConfigResult']:
        return pulumi.get(self, "sql_server_audit_configs")

    @property
    @pulumi.getter
    def tier(self) -> str:
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "user_labels")

    @property
    @pulumi.getter
    def version(self) -> int:
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDatabaseInstanceSettingActiveDirectoryConfigResult(dict):
    def __init__(__self__, *,
                 domain: str):
        pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter
    def domain(self) -> str:
        return pulumi.get(self, "domain")


@pulumi.output_type
class GetDatabaseInstanceSettingBackupConfigurationResult(dict):
    def __init__(__self__, *,
                 backup_retention_settings: Sequence['outputs.GetDatabaseInstanceSettingBackupConfigurationBackupRetentionSettingResult'],
                 binary_log_enabled: bool,
                 enabled: bool,
                 location: str,
                 point_in_time_recovery_enabled: bool,
                 start_time: str,
                 transaction_log_retention_days: int):
        pulumi.set(__self__, "backup_retention_settings", backup_retention_settings)
        pulumi.set(__self__, "binary_log_enabled", binary_log_enabled)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "transaction_log_retention_days", transaction_log_retention_days)

    @property
    @pulumi.getter(name="backupRetentionSettings")
    def backup_retention_settings(self) -> Sequence['outputs.GetDatabaseInstanceSettingBackupConfigurationBackupRetentionSettingResult']:
        return pulumi.get(self, "backup_retention_settings")

    @property
    @pulumi.getter(name="binaryLogEnabled")
    def binary_log_enabled(self) -> bool:
        return pulumi.get(self, "binary_log_enabled")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> bool:
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="transactionLogRetentionDays")
    def transaction_log_retention_days(self) -> int:
        return pulumi.get(self, "transaction_log_retention_days")


@pulumi.output_type
class GetDatabaseInstanceSettingBackupConfigurationBackupRetentionSettingResult(dict):
    def __init__(__self__, *,
                 retained_backups: int,
                 retention_unit: str):
        pulumi.set(__self__, "retained_backups", retained_backups)
        pulumi.set(__self__, "retention_unit", retention_unit)

    @property
    @pulumi.getter(name="retainedBackups")
    def retained_backups(self) -> int:
        return pulumi.get(self, "retained_backups")

    @property
    @pulumi.getter(name="retentionUnit")
    def retention_unit(self) -> str:
        return pulumi.get(self, "retention_unit")


@pulumi.output_type
class GetDatabaseInstanceSettingDatabaseFlagResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the instance.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstanceSettingDenyMaintenancePeriodResult(dict):
    def __init__(__self__, *,
                 end_date: str,
                 start_date: str,
                 time: str):
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> str:
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> str:
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def time(self) -> str:
        return pulumi.get(self, "time")


@pulumi.output_type
class GetDatabaseInstanceSettingInsightsConfigResult(dict):
    def __init__(__self__, *,
                 query_insights_enabled: bool,
                 query_plans_per_minute: int,
                 query_string_length: int,
                 record_application_tags: bool,
                 record_client_address: bool):
        pulumi.set(__self__, "query_insights_enabled", query_insights_enabled)
        pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        pulumi.set(__self__, "query_string_length", query_string_length)
        pulumi.set(__self__, "record_application_tags", record_application_tags)
        pulumi.set(__self__, "record_client_address", record_client_address)

    @property
    @pulumi.getter(name="queryInsightsEnabled")
    def query_insights_enabled(self) -> bool:
        return pulumi.get(self, "query_insights_enabled")

    @property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> int:
        return pulumi.get(self, "query_plans_per_minute")

    @property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> int:
        return pulumi.get(self, "query_string_length")

    @property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> bool:
        return pulumi.get(self, "record_application_tags")

    @property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> bool:
        return pulumi.get(self, "record_client_address")


@pulumi.output_type
class GetDatabaseInstanceSettingIpConfigurationResult(dict):
    def __init__(__self__, *,
                 allocated_ip_range: str,
                 authorized_networks: Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult'],
                 ipv4_enabled: bool,
                 private_network: str,
                 require_ssl: bool):
        pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        pulumi.set(__self__, "authorized_networks", authorized_networks)
        pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        pulumi.set(__self__, "private_network", private_network)
        pulumi.set(__self__, "require_ssl", require_ssl)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> str:
        return pulumi.get(self, "allocated_ip_range")

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult']:
        return pulumi.get(self, "authorized_networks")

    @property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> bool:
        return pulumi.get(self, "ipv4_enabled")

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> str:
        return pulumi.get(self, "private_network")

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> bool:
        return pulumi.get(self, "require_ssl")


@pulumi.output_type
class GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult(dict):
    def __init__(__self__, *,
                 expiration_time: str,
                 name: str,
                 value: str):
        """
        :param str name: The name of the instance.
        """
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstanceSettingLocationPreferenceResult(dict):
    def __init__(__self__, *,
                 follow_gae_application: str,
                 secondary_zone: str,
                 zone: str):
        pulumi.set(__self__, "follow_gae_application", follow_gae_application)
        pulumi.set(__self__, "secondary_zone", secondary_zone)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="followGaeApplication")
    def follow_gae_application(self) -> str:
        return pulumi.get(self, "follow_gae_application")

    @property
    @pulumi.getter(name="secondaryZone")
    def secondary_zone(self) -> str:
        return pulumi.get(self, "secondary_zone")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetDatabaseInstanceSettingMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day: int,
                 hour: int,
                 update_track: str):
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "hour", hour)
        pulumi.set(__self__, "update_track", update_track)

    @property
    @pulumi.getter
    def day(self) -> int:
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def hour(self) -> int:
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter(name="updateTrack")
    def update_track(self) -> str:
        return pulumi.get(self, "update_track")


@pulumi.output_type
class GetDatabaseInstanceSettingPasswordValidationPolicyResult(dict):
    def __init__(__self__, *,
                 complexity: str,
                 disallow_username_substring: bool,
                 enable_password_policy: bool,
                 min_length: int,
                 password_change_interval: str,
                 reuse_interval: int):
        pulumi.set(__self__, "complexity", complexity)
        pulumi.set(__self__, "disallow_username_substring", disallow_username_substring)
        pulumi.set(__self__, "enable_password_policy", enable_password_policy)
        pulumi.set(__self__, "min_length", min_length)
        pulumi.set(__self__, "password_change_interval", password_change_interval)
        pulumi.set(__self__, "reuse_interval", reuse_interval)

    @property
    @pulumi.getter
    def complexity(self) -> str:
        return pulumi.get(self, "complexity")

    @property
    @pulumi.getter(name="disallowUsernameSubstring")
    def disallow_username_substring(self) -> bool:
        return pulumi.get(self, "disallow_username_substring")

    @property
    @pulumi.getter(name="enablePasswordPolicy")
    def enable_password_policy(self) -> bool:
        return pulumi.get(self, "enable_password_policy")

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> int:
        return pulumi.get(self, "min_length")

    @property
    @pulumi.getter(name="passwordChangeInterval")
    def password_change_interval(self) -> str:
        return pulumi.get(self, "password_change_interval")

    @property
    @pulumi.getter(name="reuseInterval")
    def reuse_interval(self) -> int:
        return pulumi.get(self, "reuse_interval")


@pulumi.output_type
class GetDatabaseInstanceSettingSqlServerAuditConfigResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 retention_interval: str,
                 upload_interval: str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "retention_interval", retention_interval)
        pulumi.set(__self__, "upload_interval", upload_interval)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="retentionInterval")
    def retention_interval(self) -> str:
        return pulumi.get(self, "retention_interval")

    @property
    @pulumi.getter(name="uploadInterval")
    def upload_interval(self) -> str:
        return pulumi.get(self, "upload_interval")


@pulumi.output_type
class GetDatabaseInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 available_maintenance_versions: Sequence[str],
                 clones: Sequence['outputs.GetDatabaseInstancesInstanceCloneResult'],
                 connection_name: str,
                 database_version: str,
                 deletion_protection: bool,
                 encryption_key_name: str,
                 first_ip_address: str,
                 instance_type: str,
                 ip_addresses: Sequence['outputs.GetDatabaseInstancesInstanceIpAddressResult'],
                 maintenance_version: str,
                 master_instance_name: str,
                 name: str,
                 private_ip_address: str,
                 project: str,
                 public_ip_address: str,
                 region: str,
                 replica_configurations: Sequence['outputs.GetDatabaseInstancesInstanceReplicaConfigurationResult'],
                 restore_backup_contexts: Sequence['outputs.GetDatabaseInstancesInstanceRestoreBackupContextResult'],
                 root_password: str,
                 self_link: str,
                 server_ca_certs: Sequence['outputs.GetDatabaseInstancesInstanceServerCaCertResult'],
                 service_account_email_address: str,
                 settings: Sequence['outputs.GetDatabaseInstancesInstanceSettingResult']):
        """
        :param str database_version: To filter out the Cloud SQL instances which are of the specified database version.
        :param str project: The ID of the project in which the resources belong. If it is not provided, the provider project is used.
        :param str region: To filter out the Cloud SQL instances which are located in the specified region.
        """
        pulumi.set(__self__, "available_maintenance_versions", available_maintenance_versions)
        pulumi.set(__self__, "clones", clones)
        pulumi.set(__self__, "connection_name", connection_name)
        pulumi.set(__self__, "database_version", database_version)
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        pulumi.set(__self__, "encryption_key_name", encryption_key_name)
        pulumi.set(__self__, "first_ip_address", first_ip_address)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "maintenance_version", maintenance_version)
        pulumi.set(__self__, "master_instance_name", master_instance_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "replica_configurations", replica_configurations)
        pulumi.set(__self__, "restore_backup_contexts", restore_backup_contexts)
        pulumi.set(__self__, "root_password", root_password)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "server_ca_certs", server_ca_certs)
        pulumi.set(__self__, "service_account_email_address", service_account_email_address)
        pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="availableMaintenanceVersions")
    def available_maintenance_versions(self) -> Sequence[str]:
        return pulumi.get(self, "available_maintenance_versions")

    @property
    @pulumi.getter
    def clones(self) -> Sequence['outputs.GetDatabaseInstancesInstanceCloneResult']:
        return pulumi.get(self, "clones")

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> str:
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> str:
        """
        To filter out the Cloud SQL instances which are of the specified database version.
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> bool:
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="encryptionKeyName")
    def encryption_key_name(self) -> str:
        return pulumi.get(self, "encryption_key_name")

    @property
    @pulumi.getter(name="firstIpAddress")
    def first_ip_address(self) -> str:
        return pulumi.get(self, "first_ip_address")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence['outputs.GetDatabaseInstancesInstanceIpAddressResult']:
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter(name="maintenanceVersion")
    def maintenance_version(self) -> str:
        return pulumi.get(self, "maintenance_version")

    @property
    @pulumi.getter(name="masterInstanceName")
    def master_instance_name(self) -> str:
        return pulumi.get(self, "master_instance_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> str:
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The ID of the project in which the resources belong. If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        To filter out the Cloud SQL instances which are located in the specified region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replicaConfigurations")
    def replica_configurations(self) -> Sequence['outputs.GetDatabaseInstancesInstanceReplicaConfigurationResult']:
        return pulumi.get(self, "replica_configurations")

    @property
    @pulumi.getter(name="restoreBackupContexts")
    def restore_backup_contexts(self) -> Sequence['outputs.GetDatabaseInstancesInstanceRestoreBackupContextResult']:
        return pulumi.get(self, "restore_backup_contexts")

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> str:
        return pulumi.get(self, "root_password")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="serverCaCerts")
    def server_ca_certs(self) -> Sequence['outputs.GetDatabaseInstancesInstanceServerCaCertResult']:
        return pulumi.get(self, "server_ca_certs")

    @property
    @pulumi.getter(name="serviceAccountEmailAddress")
    def service_account_email_address(self) -> str:
        return pulumi.get(self, "service_account_email_address")

    @property
    @pulumi.getter
    def settings(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingResult']:
        return pulumi.get(self, "settings")


@pulumi.output_type
class GetDatabaseInstancesInstanceCloneResult(dict):
    def __init__(__self__, *,
                 allocated_ip_range: str,
                 point_in_time: str,
                 source_instance_name: str):
        pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        pulumi.set(__self__, "point_in_time", point_in_time)
        pulumi.set(__self__, "source_instance_name", source_instance_name)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> str:
        return pulumi.get(self, "allocated_ip_range")

    @property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> str:
        return pulumi.get(self, "point_in_time")

    @property
    @pulumi.getter(name="sourceInstanceName")
    def source_instance_name(self) -> str:
        return pulumi.get(self, "source_instance_name")


@pulumi.output_type
class GetDatabaseInstancesInstanceIpAddressResult(dict):
    def __init__(__self__, *,
                 ip_address: str,
                 time_to_retire: str,
                 type: str):
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "time_to_retire", time_to_retire)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="timeToRetire")
    def time_to_retire(self) -> str:
        return pulumi.get(self, "time_to_retire")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDatabaseInstancesInstanceReplicaConfigurationResult(dict):
    def __init__(__self__, *,
                 ca_certificate: str,
                 client_certificate: str,
                 client_key: str,
                 connect_retry_interval: int,
                 dump_file_path: str,
                 failover_target: bool,
                 master_heartbeat_period: int,
                 password: str,
                 ssl_cipher: str,
                 username: str,
                 verify_server_certificate: bool):
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "connect_retry_interval", connect_retry_interval)
        pulumi.set(__self__, "dump_file_path", dump_file_path)
        pulumi.set(__self__, "failover_target", failover_target)
        pulumi.set(__self__, "master_heartbeat_period", master_heartbeat_period)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "ssl_cipher", ssl_cipher)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "verify_server_certificate", verify_server_certificate)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> str:
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> str:
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> str:
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="connectRetryInterval")
    def connect_retry_interval(self) -> int:
        return pulumi.get(self, "connect_retry_interval")

    @property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> str:
        return pulumi.get(self, "dump_file_path")

    @property
    @pulumi.getter(name="failoverTarget")
    def failover_target(self) -> bool:
        return pulumi.get(self, "failover_target")

    @property
    @pulumi.getter(name="masterHeartbeatPeriod")
    def master_heartbeat_period(self) -> int:
        return pulumi.get(self, "master_heartbeat_period")

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> str:
        return pulumi.get(self, "ssl_cipher")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="verifyServerCertificate")
    def verify_server_certificate(self) -> bool:
        return pulumi.get(self, "verify_server_certificate")


@pulumi.output_type
class GetDatabaseInstancesInstanceRestoreBackupContextResult(dict):
    def __init__(__self__, *,
                 backup_run_id: int,
                 instance_id: str,
                 project: str):
        """
        :param str project: The ID of the project in which the resources belong. If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "backup_run_id", backup_run_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="backupRunId")
    def backup_run_id(self) -> int:
        return pulumi.get(self, "backup_run_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The ID of the project in which the resources belong. If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class GetDatabaseInstancesInstanceServerCaCertResult(dict):
    def __init__(__self__, *,
                 cert: str,
                 common_name: str,
                 create_time: str,
                 expiration_time: str,
                 sha1_fingerprint: str):
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> str:
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> str:
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingResult(dict):
    def __init__(__self__, *,
                 activation_policy: str,
                 active_directory_configs: Sequence['outputs.GetDatabaseInstancesInstanceSettingActiveDirectoryConfigResult'],
                 availability_type: str,
                 backup_configurations: Sequence['outputs.GetDatabaseInstancesInstanceSettingBackupConfigurationResult'],
                 collation: str,
                 connector_enforcement: str,
                 database_flags: Sequence['outputs.GetDatabaseInstancesInstanceSettingDatabaseFlagResult'],
                 deletion_protection_enabled: bool,
                 deny_maintenance_periods: Sequence['outputs.GetDatabaseInstancesInstanceSettingDenyMaintenancePeriodResult'],
                 disk_autoresize: bool,
                 disk_autoresize_limit: int,
                 disk_size: int,
                 disk_type: str,
                 insights_configs: Sequence['outputs.GetDatabaseInstancesInstanceSettingInsightsConfigResult'],
                 ip_configurations: Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationResult'],
                 location_preferences: Sequence['outputs.GetDatabaseInstancesInstanceSettingLocationPreferenceResult'],
                 maintenance_windows: Sequence['outputs.GetDatabaseInstancesInstanceSettingMaintenanceWindowResult'],
                 password_validation_policies: Sequence['outputs.GetDatabaseInstancesInstanceSettingPasswordValidationPolicyResult'],
                 pricing_plan: str,
                 sql_server_audit_configs: Sequence['outputs.GetDatabaseInstancesInstanceSettingSqlServerAuditConfigResult'],
                 tier: str,
                 time_zone: str,
                 user_labels: Mapping[str, str],
                 version: int):
        """
        :param str tier: To filter out the Cloud SQL instances based on the tier(or machine type) of the database instances.
        """
        pulumi.set(__self__, "activation_policy", activation_policy)
        pulumi.set(__self__, "active_directory_configs", active_directory_configs)
        pulumi.set(__self__, "availability_type", availability_type)
        pulumi.set(__self__, "backup_configurations", backup_configurations)
        pulumi.set(__self__, "collation", collation)
        pulumi.set(__self__, "connector_enforcement", connector_enforcement)
        pulumi.set(__self__, "database_flags", database_flags)
        pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        pulumi.set(__self__, "deny_maintenance_periods", deny_maintenance_periods)
        pulumi.set(__self__, "disk_autoresize", disk_autoresize)
        pulumi.set(__self__, "disk_autoresize_limit", disk_autoresize_limit)
        pulumi.set(__self__, "disk_size", disk_size)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "insights_configs", insights_configs)
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "location_preferences", location_preferences)
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        pulumi.set(__self__, "password_validation_policies", password_validation_policies)
        pulumi.set(__self__, "pricing_plan", pricing_plan)
        pulumi.set(__self__, "sql_server_audit_configs", sql_server_audit_configs)
        pulumi.set(__self__, "tier", tier)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "user_labels", user_labels)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> str:
        return pulumi.get(self, "activation_policy")

    @property
    @pulumi.getter(name="activeDirectoryConfigs")
    def active_directory_configs(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingActiveDirectoryConfigResult']:
        return pulumi.get(self, "active_directory_configs")

    @property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> str:
        return pulumi.get(self, "availability_type")

    @property
    @pulumi.getter(name="backupConfigurations")
    def backup_configurations(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingBackupConfigurationResult']:
        return pulumi.get(self, "backup_configurations")

    @property
    @pulumi.getter
    def collation(self) -> str:
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter(name="connectorEnforcement")
    def connector_enforcement(self) -> str:
        return pulumi.get(self, "connector_enforcement")

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingDatabaseFlagResult']:
        return pulumi.get(self, "database_flags")

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> bool:
        return pulumi.get(self, "deletion_protection_enabled")

    @property
    @pulumi.getter(name="denyMaintenancePeriods")
    def deny_maintenance_periods(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingDenyMaintenancePeriodResult']:
        return pulumi.get(self, "deny_maintenance_periods")

    @property
    @pulumi.getter(name="diskAutoresize")
    def disk_autoresize(self) -> bool:
        return pulumi.get(self, "disk_autoresize")

    @property
    @pulumi.getter(name="diskAutoresizeLimit")
    def disk_autoresize_limit(self) -> int:
        return pulumi.get(self, "disk_autoresize_limit")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> int:
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="insightsConfigs")
    def insights_configs(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingInsightsConfigResult']:
        return pulumi.get(self, "insights_configs")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationResult']:
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter(name="locationPreferences")
    def location_preferences(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingLocationPreferenceResult']:
        return pulumi.get(self, "location_preferences")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingMaintenanceWindowResult']:
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="passwordValidationPolicies")
    def password_validation_policies(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingPasswordValidationPolicyResult']:
        return pulumi.get(self, "password_validation_policies")

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> str:
        return pulumi.get(self, "pricing_plan")

    @property
    @pulumi.getter(name="sqlServerAuditConfigs")
    def sql_server_audit_configs(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingSqlServerAuditConfigResult']:
        return pulumi.get(self, "sql_server_audit_configs")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        To filter out the Cloud SQL instances based on the tier(or machine type) of the database instances.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "user_labels")

    @property
    @pulumi.getter
    def version(self) -> int:
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingActiveDirectoryConfigResult(dict):
    def __init__(__self__, *,
                 domain: str):
        pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter
    def domain(self) -> str:
        return pulumi.get(self, "domain")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingBackupConfigurationResult(dict):
    def __init__(__self__, *,
                 backup_retention_settings: Sequence['outputs.GetDatabaseInstancesInstanceSettingBackupConfigurationBackupRetentionSettingResult'],
                 binary_log_enabled: bool,
                 enabled: bool,
                 location: str,
                 point_in_time_recovery_enabled: bool,
                 start_time: str,
                 transaction_log_retention_days: int):
        pulumi.set(__self__, "backup_retention_settings", backup_retention_settings)
        pulumi.set(__self__, "binary_log_enabled", binary_log_enabled)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "transaction_log_retention_days", transaction_log_retention_days)

    @property
    @pulumi.getter(name="backupRetentionSettings")
    def backup_retention_settings(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingBackupConfigurationBackupRetentionSettingResult']:
        return pulumi.get(self, "backup_retention_settings")

    @property
    @pulumi.getter(name="binaryLogEnabled")
    def binary_log_enabled(self) -> bool:
        return pulumi.get(self, "binary_log_enabled")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> bool:
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="transactionLogRetentionDays")
    def transaction_log_retention_days(self) -> int:
        return pulumi.get(self, "transaction_log_retention_days")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingBackupConfigurationBackupRetentionSettingResult(dict):
    def __init__(__self__, *,
                 retained_backups: int,
                 retention_unit: str):
        pulumi.set(__self__, "retained_backups", retained_backups)
        pulumi.set(__self__, "retention_unit", retention_unit)

    @property
    @pulumi.getter(name="retainedBackups")
    def retained_backups(self) -> int:
        return pulumi.get(self, "retained_backups")

    @property
    @pulumi.getter(name="retentionUnit")
    def retention_unit(self) -> str:
        return pulumi.get(self, "retention_unit")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingDatabaseFlagResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingDenyMaintenancePeriodResult(dict):
    def __init__(__self__, *,
                 end_date: str,
                 start_date: str,
                 time: str):
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> str:
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> str:
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def time(self) -> str:
        return pulumi.get(self, "time")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingInsightsConfigResult(dict):
    def __init__(__self__, *,
                 query_insights_enabled: bool,
                 query_plans_per_minute: int,
                 query_string_length: int,
                 record_application_tags: bool,
                 record_client_address: bool):
        pulumi.set(__self__, "query_insights_enabled", query_insights_enabled)
        pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        pulumi.set(__self__, "query_string_length", query_string_length)
        pulumi.set(__self__, "record_application_tags", record_application_tags)
        pulumi.set(__self__, "record_client_address", record_client_address)

    @property
    @pulumi.getter(name="queryInsightsEnabled")
    def query_insights_enabled(self) -> bool:
        return pulumi.get(self, "query_insights_enabled")

    @property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> int:
        return pulumi.get(self, "query_plans_per_minute")

    @property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> int:
        return pulumi.get(self, "query_string_length")

    @property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> bool:
        return pulumi.get(self, "record_application_tags")

    @property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> bool:
        return pulumi.get(self, "record_client_address")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingIpConfigurationResult(dict):
    def __init__(__self__, *,
                 allocated_ip_range: str,
                 authorized_networks: Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationAuthorizedNetworkResult'],
                 ipv4_enabled: bool,
                 private_network: str,
                 require_ssl: bool):
        pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        pulumi.set(__self__, "authorized_networks", authorized_networks)
        pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        pulumi.set(__self__, "private_network", private_network)
        pulumi.set(__self__, "require_ssl", require_ssl)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> str:
        return pulumi.get(self, "allocated_ip_range")

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Sequence['outputs.GetDatabaseInstancesInstanceSettingIpConfigurationAuthorizedNetworkResult']:
        return pulumi.get(self, "authorized_networks")

    @property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> bool:
        return pulumi.get(self, "ipv4_enabled")

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> str:
        return pulumi.get(self, "private_network")

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> bool:
        return pulumi.get(self, "require_ssl")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingIpConfigurationAuthorizedNetworkResult(dict):
    def __init__(__self__, *,
                 expiration_time: str,
                 name: str,
                 value: str):
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingLocationPreferenceResult(dict):
    def __init__(__self__, *,
                 follow_gae_application: str,
                 secondary_zone: str,
                 zone: str):
        """
        :param str zone: To filter out the Cloud SQL instances which are located in the specified zone. This zone refers to the Compute Engine zone that the instance is currently serving from.
        """
        pulumi.set(__self__, "follow_gae_application", follow_gae_application)
        pulumi.set(__self__, "secondary_zone", secondary_zone)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="followGaeApplication")
    def follow_gae_application(self) -> str:
        return pulumi.get(self, "follow_gae_application")

    @property
    @pulumi.getter(name="secondaryZone")
    def secondary_zone(self) -> str:
        return pulumi.get(self, "secondary_zone")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        To filter out the Cloud SQL instances which are located in the specified zone. This zone refers to the Compute Engine zone that the instance is currently serving from.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day: int,
                 hour: int,
                 update_track: str):
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "hour", hour)
        pulumi.set(__self__, "update_track", update_track)

    @property
    @pulumi.getter
    def day(self) -> int:
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def hour(self) -> int:
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter(name="updateTrack")
    def update_track(self) -> str:
        return pulumi.get(self, "update_track")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingPasswordValidationPolicyResult(dict):
    def __init__(__self__, *,
                 complexity: str,
                 disallow_username_substring: bool,
                 enable_password_policy: bool,
                 min_length: int,
                 password_change_interval: str,
                 reuse_interval: int):
        pulumi.set(__self__, "complexity", complexity)
        pulumi.set(__self__, "disallow_username_substring", disallow_username_substring)
        pulumi.set(__self__, "enable_password_policy", enable_password_policy)
        pulumi.set(__self__, "min_length", min_length)
        pulumi.set(__self__, "password_change_interval", password_change_interval)
        pulumi.set(__self__, "reuse_interval", reuse_interval)

    @property
    @pulumi.getter
    def complexity(self) -> str:
        return pulumi.get(self, "complexity")

    @property
    @pulumi.getter(name="disallowUsernameSubstring")
    def disallow_username_substring(self) -> bool:
        return pulumi.get(self, "disallow_username_substring")

    @property
    @pulumi.getter(name="enablePasswordPolicy")
    def enable_password_policy(self) -> bool:
        return pulumi.get(self, "enable_password_policy")

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> int:
        return pulumi.get(self, "min_length")

    @property
    @pulumi.getter(name="passwordChangeInterval")
    def password_change_interval(self) -> str:
        return pulumi.get(self, "password_change_interval")

    @property
    @pulumi.getter(name="reuseInterval")
    def reuse_interval(self) -> int:
        return pulumi.get(self, "reuse_interval")


@pulumi.output_type
class GetDatabaseInstancesInstanceSettingSqlServerAuditConfigResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 retention_interval: str,
                 upload_interval: str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "retention_interval", retention_interval)
        pulumi.set(__self__, "upload_interval", upload_interval)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="retentionInterval")
    def retention_interval(self) -> str:
        return pulumi.get(self, "retention_interval")

    @property
    @pulumi.getter(name="uploadInterval")
    def upload_interval(self) -> str:
        return pulumi.get(self, "upload_interval")


