# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['BucketAccessControlArgs', 'BucketAccessControl']

@pulumi.input_type
class BucketAccessControlArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 entity: pulumi.Input[str],
                 role: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BucketAccessControl resource.
        :param pulumi.Input[str] bucket: The name of the bucket.
        :param pulumi.Input[str] entity: The entity holding the permission, in one of the following forms:
               user-userId
               user-email
               group-groupId
               group-email
               domain-domain
               project-team-projectId
               allUsers
               allAuthenticatedUsers
               Examples:
               The user liz@example.com would be user-liz@example.com.
               The group example@googlegroups.com would be
               group-example@googlegroups.com.
               To refer to all members of the Google Apps for Business domain
               example.com, the entity would be domain-example.com.
        :param pulumi.Input[str] role: The access permission for the entity.
               Possible values are `OWNER`, `READER`, and `WRITER`.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "entity", entity)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def entity(self) -> pulumi.Input[str]:
        """
        The entity holding the permission, in one of the following forms:
        user-userId
        user-email
        group-groupId
        group-email
        domain-domain
        project-team-projectId
        allUsers
        allAuthenticatedUsers
        Examples:
        The user liz@example.com would be user-liz@example.com.
        The group example@googlegroups.com would be
        group-example@googlegroups.com.
        To refer to all members of the Google Apps for Business domain
        example.com, the entity would be domain-example.com.
        """
        return pulumi.get(self, "entity")

    @entity.setter
    def entity(self, value: pulumi.Input[str]):
        pulumi.set(self, "entity", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The access permission for the entity.
        Possible values are `OWNER`, `READER`, and `WRITER`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class _BucketAccessControlState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 entity: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering BucketAccessControl resources.
        :param pulumi.Input[str] bucket: The name of the bucket.
        :param pulumi.Input[str] domain: The domain associated with the entity.
        :param pulumi.Input[str] email: The email address associated with the entity.
        :param pulumi.Input[str] entity: The entity holding the permission, in one of the following forms:
               user-userId
               user-email
               group-groupId
               group-email
               domain-domain
               project-team-projectId
               allUsers
               allAuthenticatedUsers
               Examples:
               The user liz@example.com would be user-liz@example.com.
               The group example@googlegroups.com would be
               group-example@googlegroups.com.
               To refer to all members of the Google Apps for Business domain
               example.com, the entity would be domain-example.com.
        :param pulumi.Input[str] role: The access permission for the entity.
               Possible values are `OWNER`, `READER`, and `WRITER`.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if entity is not None:
            pulumi.set(__self__, "entity", entity)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain associated with the entity.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The email address associated with the entity.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def entity(self) -> Optional[pulumi.Input[str]]:
        """
        The entity holding the permission, in one of the following forms:
        user-userId
        user-email
        group-groupId
        group-email
        domain-domain
        project-team-projectId
        allUsers
        allAuthenticatedUsers
        Examples:
        The user liz@example.com would be user-liz@example.com.
        The group example@googlegroups.com would be
        group-example@googlegroups.com.
        To refer to all members of the Google Apps for Business domain
        example.com, the entity would be domain-example.com.
        """
        return pulumi.get(self, "entity")

    @entity.setter
    def entity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The access permission for the entity.
        Possible values are `OWNER`, `READER`, and `WRITER`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


class BucketAccessControl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 entity: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### Storage Bucket Access Control Public Bucket

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket", location="US")
        public_rule = gcp.storage.BucketAccessControl("publicRule",
            bucket=bucket.name,
            role="READER",
            entity="allUsers")
        ```

        ## Import

        BucketAccessControl can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:storage/bucketAccessControl:BucketAccessControl default {{bucket}}/{{entity}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bucket: The name of the bucket.
        :param pulumi.Input[str] entity: The entity holding the permission, in one of the following forms:
               user-userId
               user-email
               group-groupId
               group-email
               domain-domain
               project-team-projectId
               allUsers
               allAuthenticatedUsers
               Examples:
               The user liz@example.com would be user-liz@example.com.
               The group example@googlegroups.com would be
               group-example@googlegroups.com.
               To refer to all members of the Google Apps for Business domain
               example.com, the entity would be domain-example.com.
        :param pulumi.Input[str] role: The access permission for the entity.
               Possible values are `OWNER`, `READER`, and `WRITER`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketAccessControlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### Storage Bucket Access Control Public Bucket

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket", location="US")
        public_rule = gcp.storage.BucketAccessControl("publicRule",
            bucket=bucket.name,
            role="READER",
            entity="allUsers")
        ```

        ## Import

        BucketAccessControl can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:storage/bucketAccessControl:BucketAccessControl default {{bucket}}/{{entity}}
        ```

        :param str resource_name: The name of the resource.
        :param BucketAccessControlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketAccessControlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 entity: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketAccessControlArgs.__new__(BucketAccessControlArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            if entity is None and not opts.urn:
                raise TypeError("Missing required property 'entity'")
            __props__.__dict__["entity"] = entity
            __props__.__dict__["role"] = role
            __props__.__dict__["domain"] = None
            __props__.__dict__["email"] = None
        super(BucketAccessControl, __self__).__init__(
            'gcp:storage/bucketAccessControl:BucketAccessControl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            email: Optional[pulumi.Input[str]] = None,
            entity: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None) -> 'BucketAccessControl':
        """
        Get an existing BucketAccessControl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bucket: The name of the bucket.
        :param pulumi.Input[str] domain: The domain associated with the entity.
        :param pulumi.Input[str] email: The email address associated with the entity.
        :param pulumi.Input[str] entity: The entity holding the permission, in one of the following forms:
               user-userId
               user-email
               group-groupId
               group-email
               domain-domain
               project-team-projectId
               allUsers
               allAuthenticatedUsers
               Examples:
               The user liz@example.com would be user-liz@example.com.
               The group example@googlegroups.com would be
               group-example@googlegroups.com.
               To refer to all members of the Google Apps for Business domain
               example.com, the entity would be domain-example.com.
        :param pulumi.Input[str] role: The access permission for the entity.
               Possible values are `OWNER`, `READER`, and `WRITER`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketAccessControlState.__new__(_BucketAccessControlState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["domain"] = domain
        __props__.__dict__["email"] = email
        __props__.__dict__["entity"] = entity
        __props__.__dict__["role"] = role
        return BucketAccessControl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        The domain associated with the entity.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        The email address associated with the entity.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def entity(self) -> pulumi.Output[str]:
        """
        The entity holding the permission, in one of the following forms:
        user-userId
        user-email
        group-groupId
        group-email
        domain-domain
        project-team-projectId
        allUsers
        allAuthenticatedUsers
        Examples:
        The user liz@example.com would be user-liz@example.com.
        The group example@googlegroups.com would be
        group-example@googlegroups.com.
        To refer to all members of the Google Apps for Business domain
        example.com, the entity would be domain-example.com.
        """
        return pulumi.get(self, "entity")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[str]]:
        """
        The access permission for the entity.
        Possible values are `OWNER`, `READER`, and `WRITER`.
        """
        return pulumi.get(self, "role")

