# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetProjectServiceAccountResult',
    'AwaitableGetProjectServiceAccountResult',
    'get_project_service_account',
    'get_project_service_account_output',
]

@pulumi.output_type
class GetProjectServiceAccountResult:
    """
    A collection of values returned by getProjectServiceAccount.
    """
    def __init__(__self__, email_address=None, id=None, member=None, project=None, user_project=None):
        if email_address and not isinstance(email_address, str):
            raise TypeError("Expected argument 'email_address' to be a str")
        pulumi.set(__self__, "email_address", email_address)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if member and not isinstance(member, str):
            raise TypeError("Expected argument 'member' to be a str")
        pulumi.set(__self__, "member", member)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if user_project and not isinstance(user_project, str):
            raise TypeError("Expected argument 'user_project' to be a str")
        pulumi.set(__self__, "user_project", user_project)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> str:
        """
        The email address of the service account. This value is often used to refer to the service account
        in order to grant IAM permissions.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def member(self) -> str:
        """
        The Identity of the service account in the form `serviceAccount:{email_address}`. This value is often used to refer to the service account in order to grant IAM permissions.
        """
        return pulumi.get(self, "member")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="userProject")
    def user_project(self) -> Optional[str]:
        return pulumi.get(self, "user_project")


class AwaitableGetProjectServiceAccountResult(GetProjectServiceAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectServiceAccountResult(
            email_address=self.email_address,
            id=self.id,
            member=self.member,
            project=self.project,
            user_project=self.user_project)


def get_project_service_account(project: Optional[str] = None,
                                user_project: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectServiceAccountResult:
    """
    ## Example Usage
    ### Pub/Sub Notifications

    ```python
    import pulumi
    import pulumi_gcp as gcp

    gcs_account = gcp.storage.get_project_service_account()
    binding = gcp.pubsub.TopicIAMBinding("binding",
        topic=google_pubsub_topic["topic"]["name"],
        role="roles/pubsub.publisher",
        members=[f"serviceAccount:{gcs_account.email_address}"])
    ```
    ### Cloud KMS Keys

    ```python
    import pulumi
    import pulumi_gcp as gcp

    gcs_account = gcp.storage.get_project_service_account()
    binding = gcp.kms.CryptoKeyIAMBinding("binding",
        crypto_key_id="your-crypto-key-id",
        role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
        members=[f"serviceAccount:{gcs_account.email_address}"])
    bucket = gcp.storage.Bucket("bucket",
        location="US",
        encryption=gcp.storage.BucketEncryptionArgs(
            default_kms_key_name="your-crypto-key-id",
        ),
        opts=pulumi.ResourceOptions(depends_on=[binding]))
    ```


    :param str project: The project the unique service account was created for. If it is not provided, the provider project is used.
    :param str user_project: The project the lookup originates from. This field is used if you are making the request
           from a different account than the one you are finding the service account for.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['userProject'] = user_project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:storage/getProjectServiceAccount:getProjectServiceAccount', __args__, opts=opts, typ=GetProjectServiceAccountResult).value

    return AwaitableGetProjectServiceAccountResult(
        email_address=__ret__.email_address,
        id=__ret__.id,
        member=__ret__.member,
        project=__ret__.project,
        user_project=__ret__.user_project)


@_utilities.lift_output_func(get_project_service_account)
def get_project_service_account_output(project: Optional[pulumi.Input[Optional[str]]] = None,
                                       user_project: Optional[pulumi.Input[Optional[str]]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProjectServiceAccountResult]:
    """
    ## Example Usage
    ### Pub/Sub Notifications

    ```python
    import pulumi
    import pulumi_gcp as gcp

    gcs_account = gcp.storage.get_project_service_account()
    binding = gcp.pubsub.TopicIAMBinding("binding",
        topic=google_pubsub_topic["topic"]["name"],
        role="roles/pubsub.publisher",
        members=[f"serviceAccount:{gcs_account.email_address}"])
    ```
    ### Cloud KMS Keys

    ```python
    import pulumi
    import pulumi_gcp as gcp

    gcs_account = gcp.storage.get_project_service_account()
    binding = gcp.kms.CryptoKeyIAMBinding("binding",
        crypto_key_id="your-crypto-key-id",
        role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
        members=[f"serviceAccount:{gcs_account.email_address}"])
    bucket = gcp.storage.Bucket("bucket",
        location="US",
        encryption=gcp.storage.BucketEncryptionArgs(
            default_kms_key_name="your-crypto-key-id",
        ),
        opts=pulumi.ResourceOptions(depends_on=[binding]))
    ```


    :param str project: The project the unique service account was created for. If it is not provided, the provider project is used.
    :param str user_project: The project the lookup originates from. This field is used if you are making the request
           from a different account than the one you are finding the service account for.
    """
    ...
