# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'AiDatasetEncryptionSpecArgs',
    'AiEndpointDeployedModelArgs',
    'AiEndpointDeployedModelAutomaticResourceArgs',
    'AiEndpointDeployedModelDedicatedResourceArgs',
    'AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpecArgs',
    'AiEndpointDeployedModelDedicatedResourceMachineSpecArgs',
    'AiEndpointDeployedModelPrivateEndpointArgs',
    'AiEndpointEncryptionSpecArgs',
    'AiFeatureStoreEncryptionSpecArgs',
    'AiFeatureStoreEntityTypeIamBindingConditionArgs',
    'AiFeatureStoreEntityTypeIamMemberConditionArgs',
    'AiFeatureStoreEntityTypeMonitoringConfigArgs',
    'AiFeatureStoreEntityTypeMonitoringConfigCategoricalThresholdConfigArgs',
    'AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysisArgs',
    'AiFeatureStoreEntityTypeMonitoringConfigNumericalThresholdConfigArgs',
    'AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysisArgs',
    'AiFeatureStoreIamBindingConditionArgs',
    'AiFeatureStoreIamMemberConditionArgs',
    'AiFeatureStoreOnlineServingConfigArgs',
    'AiFeatureStoreOnlineServingConfigScalingArgs',
    'AiIndexDeployedIndexArgs',
    'AiIndexIndexStatArgs',
    'AiIndexMetadataArgs',
    'AiIndexMetadataConfigArgs',
    'AiIndexMetadataConfigAlgorithmConfigArgs',
    'AiIndexMetadataConfigAlgorithmConfigBruteForceConfigArgs',
    'AiIndexMetadataConfigAlgorithmConfigTreeAhConfigArgs',
    'AiMetadataStoreEncryptionSpecArgs',
    'AiMetadataStoreStateArgs',
    'AiTensorboardEncryptionSpecArgs',
]

@pulumi.input_type
class AiDatasetEncryptionSpecArgs:
    def __init__(__self__, *,
                 kms_key_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kms_key_name: Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
               Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
        Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)


@pulumi.input_type
class AiEndpointDeployedModelArgs:
    def __init__(__self__, *,
                 automatic_resources: Optional[pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelAutomaticResourceArgs']]]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 dedicated_resources: Optional[pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelDedicatedResourceArgs']]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enable_access_logging: Optional[pulumi.Input[bool]] = None,
                 enable_container_logging: Optional[pulumi.Input[bool]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 model: Optional[pulumi.Input[str]] = None,
                 model_version_id: Optional[pulumi.Input[str]] = None,
                 private_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelPrivateEndpointArgs']]]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 shared_resources: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelAutomaticResourceArgs']]] automatic_resources: A description of resources that to large degree are decided by Vertex AI, and require only a modest additional configuration.
               Structure is documented below.
        :param pulumi.Input[str] create_time: Output only. Timestamp when the DeployedModel was created.
        :param pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelDedicatedResourceArgs']]] dedicated_resources: A description of resources that are dedicated to the DeployedModel, and that need a higher degree of manual configuration.
               Structure is documented below.
        :param pulumi.Input[str] display_name: Required. The display name of the Endpoint. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        :param pulumi.Input[bool] enable_access_logging: These logs are like standard server access logs, containing information like timestamp and latency for each prediction request. Note that Stackdriver logs may incur a cost, especially if your project receives prediction requests at a high queries per second rate (QPS). Estimate your costs before enabling this option.
        :param pulumi.Input[bool] enable_container_logging: If true, the container of the DeployedModel instances will send `stderr` and `stdout` streams to Stackdriver Logging. Only supported for custom-trained Models and AutoML Tabular Models.
        :param pulumi.Input[str] id: The ID of the DeployedModel. If not provided upon deployment, Vertex AI will generate a value for this ID. This value should be 1-10 characters, and valid characters are /[0-9]/.
        :param pulumi.Input[str] model: The name of the Model that this is the deployment of. Note that the Model may be in a different location than the DeployedModel's Endpoint.
        :param pulumi.Input[str] model_version_id: Output only. The version ID of the model that is deployed.
        :param pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelPrivateEndpointArgs']]] private_endpoints: Output only. Provide paths for users to send predict/explain/health requests directly to the deployed model services running on Cloud via private services access. This field is populated if network is configured.
               Structure is documented below.
        :param pulumi.Input[str] service_account: The service account that the DeployedModel's container runs as. Specify the email address of the service account. If this service account is not specified, the container runs as a service account that doesn't have access to the resource project. Users deploying the Model must have the `iam.serviceAccounts.actAs` permission on this service account.
        :param pulumi.Input[str] shared_resources: The resource name of the shared DeploymentResourcePool to deploy on. Format: projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}
        """
        if automatic_resources is not None:
            pulumi.set(__self__, "automatic_resources", automatic_resources)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dedicated_resources is not None:
            pulumi.set(__self__, "dedicated_resources", dedicated_resources)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enable_access_logging is not None:
            pulumi.set(__self__, "enable_access_logging", enable_access_logging)
        if enable_container_logging is not None:
            pulumi.set(__self__, "enable_container_logging", enable_container_logging)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if model_version_id is not None:
            pulumi.set(__self__, "model_version_id", model_version_id)
        if private_endpoints is not None:
            pulumi.set(__self__, "private_endpoints", private_endpoints)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shared_resources is not None:
            pulumi.set(__self__, "shared_resources", shared_resources)

    @property
    @pulumi.getter(name="automaticResources")
    def automatic_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelAutomaticResourceArgs']]]]:
        """
        A description of resources that to large degree are decided by Vertex AI, and require only a modest additional configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "automatic_resources")

    @automatic_resources.setter
    def automatic_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelAutomaticResourceArgs']]]]):
        pulumi.set(self, "automatic_resources", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Timestamp when the DeployedModel was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="dedicatedResources")
    def dedicated_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelDedicatedResourceArgs']]]]:
        """
        A description of resources that are dedicated to the DeployedModel, and that need a higher degree of manual configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "dedicated_resources")

    @dedicated_resources.setter
    def dedicated_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelDedicatedResourceArgs']]]]):
        pulumi.set(self, "dedicated_resources", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The display name of the Endpoint. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="enableAccessLogging")
    def enable_access_logging(self) -> Optional[pulumi.Input[bool]]:
        """
        These logs are like standard server access logs, containing information like timestamp and latency for each prediction request. Note that Stackdriver logs may incur a cost, especially if your project receives prediction requests at a high queries per second rate (QPS). Estimate your costs before enabling this option.
        """
        return pulumi.get(self, "enable_access_logging")

    @enable_access_logging.setter
    def enable_access_logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_access_logging", value)

    @property
    @pulumi.getter(name="enableContainerLogging")
    def enable_container_logging(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the container of the DeployedModel instances will send `stderr` and `stdout` streams to Stackdriver Logging. Only supported for custom-trained Models and AutoML Tabular Models.
        """
        return pulumi.get(self, "enable_container_logging")

    @enable_container_logging.setter
    def enable_container_logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_container_logging", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the DeployedModel. If not provided upon deployment, Vertex AI will generate a value for this ID. This value should be 1-10 characters, and valid characters are /[0-9]/.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Model that this is the deployment of. Note that the Model may be in a different location than the DeployedModel's Endpoint.
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model", value)

    @property
    @pulumi.getter(name="modelVersionId")
    def model_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The version ID of the model that is deployed.
        """
        return pulumi.get(self, "model_version_id")

    @model_version_id.setter
    def model_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_version_id", value)

    @property
    @pulumi.getter(name="privateEndpoints")
    def private_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelPrivateEndpointArgs']]]]:
        """
        Output only. Provide paths for users to send predict/explain/health requests directly to the deployed model services running on Cloud via private services access. This field is populated if network is configured.
        Structure is documented below.
        """
        return pulumi.get(self, "private_endpoints")

    @private_endpoints.setter
    def private_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelPrivateEndpointArgs']]]]):
        pulumi.set(self, "private_endpoints", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        The service account that the DeployedModel's container runs as. Specify the email address of the service account. If this service account is not specified, the container runs as a service account that doesn't have access to the resource project. Users deploying the Model must have the `iam.serviceAccounts.actAs` permission on this service account.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="sharedResources")
    def shared_resources(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name of the shared DeploymentResourcePool to deploy on. Format: projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}
        """
        return pulumi.get(self, "shared_resources")

    @shared_resources.setter
    def shared_resources(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_resources", value)


@pulumi.input_type
class AiEndpointDeployedModelAutomaticResourceArgs:
    def __init__(__self__, *,
                 max_replica_count: Optional[pulumi.Input[int]] = None,
                 min_replica_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] max_replica_count: The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If the requested value is too large, the deployment will error, but if deployment succeeds then the ability to scale the model to that many replicas is guaranteed (barring service outages). If traffic against the DeployedModel increases beyond what its replicas at maximum may handle, a portion of the traffic will be dropped. If this value is not provided, a no upper bound for scaling under heavy traffic will be assume, though Vertex AI may be unable to scale beyond certain replica number.
        :param pulumi.Input[int] min_replica_count: The minimum number of replicas this DeployedModel will be always deployed on. If traffic against it increases, it may dynamically be deployed onto more replicas up to max_replica_count, and as traffic decreases, some of these extra replicas may be freed. If the requested value is too large, the deployment will error.
        """
        if max_replica_count is not None:
            pulumi.set(__self__, "max_replica_count", max_replica_count)
        if min_replica_count is not None:
            pulumi.set(__self__, "min_replica_count", min_replica_count)

    @property
    @pulumi.getter(name="maxReplicaCount")
    def max_replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If the requested value is too large, the deployment will error, but if deployment succeeds then the ability to scale the model to that many replicas is guaranteed (barring service outages). If traffic against the DeployedModel increases beyond what its replicas at maximum may handle, a portion of the traffic will be dropped. If this value is not provided, a no upper bound for scaling under heavy traffic will be assume, though Vertex AI may be unable to scale beyond certain replica number.
        """
        return pulumi.get(self, "max_replica_count")

    @max_replica_count.setter
    def max_replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_replica_count", value)

    @property
    @pulumi.getter(name="minReplicaCount")
    def min_replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of replicas this DeployedModel will be always deployed on. If traffic against it increases, it may dynamically be deployed onto more replicas up to max_replica_count, and as traffic decreases, some of these extra replicas may be freed. If the requested value is too large, the deployment will error.
        """
        return pulumi.get(self, "min_replica_count")

    @min_replica_count.setter
    def min_replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_replica_count", value)


@pulumi.input_type
class AiEndpointDeployedModelDedicatedResourceArgs:
    def __init__(__self__, *,
                 autoscaling_metric_specs: Optional[pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpecArgs']]]] = None,
                 machine_specs: Optional[pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelDedicatedResourceMachineSpecArgs']]]] = None,
                 max_replica_count: Optional[pulumi.Input[int]] = None,
                 min_replica_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpecArgs']]] autoscaling_metric_specs: The metric specifications that overrides a resource utilization metric (CPU utilization, accelerator's duty cycle, and so on) target value (default to 60 if not set). At most one entry is allowed per metric. If machine_spec.accelerator_count is above 0, the autoscaling will be based on both CPU utilization and accelerator's duty cycle metrics and scale up when either metrics exceeds its target value while scale down if both metrics are under their target value. The default target value is 60 for both metrics. If machine_spec.accelerator_count is 0, the autoscaling will be based on CPU utilization metric only with default target value 60 if not explicitly set. For example, in the case of Online Prediction, if you want to override target CPU utilization to 80, you should set autoscaling_metric_specs.metric_name to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and autoscaling_metric_specs.target to `80`.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelDedicatedResourceMachineSpecArgs']]] machine_specs: The specification of a single machine used by the prediction.
               Structure is documented below.
        :param pulumi.Input[int] max_replica_count: The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If the requested value is too large, the deployment will error, but if deployment succeeds then the ability to scale the model to that many replicas is guaranteed (barring service outages). If traffic against the DeployedModel increases beyond what its replicas at maximum may handle, a portion of the traffic will be dropped. If this value is not provided, a no upper bound for scaling under heavy traffic will be assume, though Vertex AI may be unable to scale beyond certain replica number.
        :param pulumi.Input[int] min_replica_count: The minimum number of replicas this DeployedModel will be always deployed on. If traffic against it increases, it may dynamically be deployed onto more replicas up to max_replica_count, and as traffic decreases, some of these extra replicas may be freed. If the requested value is too large, the deployment will error.
        """
        if autoscaling_metric_specs is not None:
            pulumi.set(__self__, "autoscaling_metric_specs", autoscaling_metric_specs)
        if machine_specs is not None:
            pulumi.set(__self__, "machine_specs", machine_specs)
        if max_replica_count is not None:
            pulumi.set(__self__, "max_replica_count", max_replica_count)
        if min_replica_count is not None:
            pulumi.set(__self__, "min_replica_count", min_replica_count)

    @property
    @pulumi.getter(name="autoscalingMetricSpecs")
    def autoscaling_metric_specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpecArgs']]]]:
        """
        The metric specifications that overrides a resource utilization metric (CPU utilization, accelerator's duty cycle, and so on) target value (default to 60 if not set). At most one entry is allowed per metric. If machine_spec.accelerator_count is above 0, the autoscaling will be based on both CPU utilization and accelerator's duty cycle metrics and scale up when either metrics exceeds its target value while scale down if both metrics are under their target value. The default target value is 60 for both metrics. If machine_spec.accelerator_count is 0, the autoscaling will be based on CPU utilization metric only with default target value 60 if not explicitly set. For example, in the case of Online Prediction, if you want to override target CPU utilization to 80, you should set autoscaling_metric_specs.metric_name to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and autoscaling_metric_specs.target to `80`.
        Structure is documented below.
        """
        return pulumi.get(self, "autoscaling_metric_specs")

    @autoscaling_metric_specs.setter
    def autoscaling_metric_specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpecArgs']]]]):
        pulumi.set(self, "autoscaling_metric_specs", value)

    @property
    @pulumi.getter(name="machineSpecs")
    def machine_specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelDedicatedResourceMachineSpecArgs']]]]:
        """
        The specification of a single machine used by the prediction.
        Structure is documented below.
        """
        return pulumi.get(self, "machine_specs")

    @machine_specs.setter
    def machine_specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AiEndpointDeployedModelDedicatedResourceMachineSpecArgs']]]]):
        pulumi.set(self, "machine_specs", value)

    @property
    @pulumi.getter(name="maxReplicaCount")
    def max_replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If the requested value is too large, the deployment will error, but if deployment succeeds then the ability to scale the model to that many replicas is guaranteed (barring service outages). If traffic against the DeployedModel increases beyond what its replicas at maximum may handle, a portion of the traffic will be dropped. If this value is not provided, a no upper bound for scaling under heavy traffic will be assume, though Vertex AI may be unable to scale beyond certain replica number.
        """
        return pulumi.get(self, "max_replica_count")

    @max_replica_count.setter
    def max_replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_replica_count", value)

    @property
    @pulumi.getter(name="minReplicaCount")
    def min_replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of replicas this DeployedModel will be always deployed on. If traffic against it increases, it may dynamically be deployed onto more replicas up to max_replica_count, and as traffic decreases, some of these extra replicas may be freed. If the requested value is too large, the deployment will error.
        """
        return pulumi.get(self, "min_replica_count")

    @min_replica_count.setter
    def min_replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_replica_count", value)


@pulumi.input_type
class AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpecArgs:
    def __init__(__self__, *,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] metric_name: The resource metric name. Supported metrics: * For Online Prediction: * `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle` * `aiplatform.googleapis.com/prediction/online/cpu/utilization`
        :param pulumi.Input[int] target: The target resource utilization in percentage (1% - 100%) for the given metric; once the real usage deviates from the target by a certain percentage, the machine replicas change. The default value is 60 (representing 60%) if not provided.
        """
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource metric name. Supported metrics: * For Online Prediction: * `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle` * `aiplatform.googleapis.com/prediction/online/cpu/utilization`
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[int]]:
        """
        The target resource utilization in percentage (1% - 100%) for the given metric; once the real usage deviates from the target by a certain percentage, the machine replicas change. The default value is 60 (representing 60%) if not provided.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class AiEndpointDeployedModelDedicatedResourceMachineSpecArgs:
    def __init__(__self__, *,
                 accelerator_count: Optional[pulumi.Input[int]] = None,
                 accelerator_type: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] accelerator_count: The number of accelerators to attach to the machine.
        :param pulumi.Input[str] accelerator_type: The type of accelerator(s) that may be attached to the machine as per accelerator_count. See possible values [here](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec#AcceleratorType).
        :param pulumi.Input[str] machine_type: The type of the machine. See the [list of machine types supported for prediction](https://cloud.google.com/vertex-ai/docs/predictions/configure-compute#machine-types) See the [list of machine types supported for custom training](https://cloud.google.com/vertex-ai/docs/training/configure-compute#machine-types). For DeployedModel this field is optional, and the default value is `n1-standard-2`. For BatchPredictionJob or as part of WorkerPoolSpec this field is required. TODO(rsurowka): Try to better unify the required vs optional.
        """
        if accelerator_count is not None:
            pulumi.set(__self__, "accelerator_count", accelerator_count)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of accelerators to attach to the machine.
        """
        return pulumi.get(self, "accelerator_count")

    @accelerator_count.setter
    def accelerator_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "accelerator_count", value)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of accelerator(s) that may be attached to the machine as per accelerator_count. See possible values [here](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec#AcceleratorType).
        """
        return pulumi.get(self, "accelerator_type")

    @accelerator_type.setter
    def accelerator_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accelerator_type", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the machine. See the [list of machine types supported for prediction](https://cloud.google.com/vertex-ai/docs/predictions/configure-compute#machine-types) See the [list of machine types supported for custom training](https://cloud.google.com/vertex-ai/docs/training/configure-compute#machine-types). For DeployedModel this field is optional, and the default value is `n1-standard-2`. For BatchPredictionJob or as part of WorkerPoolSpec this field is required. TODO(rsurowka): Try to better unify the required vs optional.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)


@pulumi.input_type
class AiEndpointDeployedModelPrivateEndpointArgs:
    def __init__(__self__, *,
                 explain_http_uri: Optional[pulumi.Input[str]] = None,
                 health_http_uri: Optional[pulumi.Input[str]] = None,
                 predict_http_uri: Optional[pulumi.Input[str]] = None,
                 service_attachment: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] explain_http_uri: Output only. Http(s) path to send explain requests.
        :param pulumi.Input[str] health_http_uri: Output only. Http(s) path to send health check requests.
        :param pulumi.Input[str] predict_http_uri: Output only. Http(s) path to send prediction requests.
        :param pulumi.Input[str] service_attachment: Output only. The name of the service attachment resource. Populated if private service connect is enabled.
        """
        if explain_http_uri is not None:
            pulumi.set(__self__, "explain_http_uri", explain_http_uri)
        if health_http_uri is not None:
            pulumi.set(__self__, "health_http_uri", health_http_uri)
        if predict_http_uri is not None:
            pulumi.set(__self__, "predict_http_uri", predict_http_uri)
        if service_attachment is not None:
            pulumi.set(__self__, "service_attachment", service_attachment)

    @property
    @pulumi.getter(name="explainHttpUri")
    def explain_http_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Http(s) path to send explain requests.
        """
        return pulumi.get(self, "explain_http_uri")

    @explain_http_uri.setter
    def explain_http_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "explain_http_uri", value)

    @property
    @pulumi.getter(name="healthHttpUri")
    def health_http_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Http(s) path to send health check requests.
        """
        return pulumi.get(self, "health_http_uri")

    @health_http_uri.setter
    def health_http_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_http_uri", value)

    @property
    @pulumi.getter(name="predictHttpUri")
    def predict_http_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Http(s) path to send prediction requests.
        """
        return pulumi.get(self, "predict_http_uri")

    @predict_http_uri.setter
    def predict_http_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "predict_http_uri", value)

    @property
    @pulumi.getter(name="serviceAttachment")
    def service_attachment(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The name of the service attachment resource. Populated if private service connect is enabled.
        """
        return pulumi.get(self, "service_attachment")

    @service_attachment.setter
    def service_attachment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_attachment", value)


@pulumi.input_type
class AiEndpointEncryptionSpecArgs:
    def __init__(__self__, *,
                 kms_key_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] kms_key_name: Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource. Has the form: `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`. The key needs to be in the same region as where the compute resource is created.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Input[str]:
        """
        Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource. Has the form: `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`. The key needs to be in the same region as where the compute resource is created.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_key_name", value)


@pulumi.input_type
class AiFeatureStoreEncryptionSpecArgs:
    def __init__(__self__, *,
                 kms_key_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] kms_key_name: The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource. Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the compute resource is created.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Input[str]:
        """
        The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource. Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the compute resource is created.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_key_name", value)


@pulumi.input_type
class AiFeatureStoreEntityTypeIamBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class AiFeatureStoreEntityTypeIamMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class AiFeatureStoreEntityTypeMonitoringConfigArgs:
    def __init__(__self__, *,
                 categorical_threshold_config: Optional[pulumi.Input['AiFeatureStoreEntityTypeMonitoringConfigCategoricalThresholdConfigArgs']] = None,
                 import_features_analysis: Optional[pulumi.Input['AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysisArgs']] = None,
                 numerical_threshold_config: Optional[pulumi.Input['AiFeatureStoreEntityTypeMonitoringConfigNumericalThresholdConfigArgs']] = None,
                 snapshot_analysis: Optional[pulumi.Input['AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysisArgs']] = None):
        """
        :param pulumi.Input['AiFeatureStoreEntityTypeMonitoringConfigCategoricalThresholdConfigArgs'] categorical_threshold_config: Threshold for categorical features of anomaly detection. This is shared by all types of Featurestore Monitoring for categorical features (i.e. Features with type (Feature.ValueType) BOOL or STRING).
               Structure is documented below.
        :param pulumi.Input['AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysisArgs'] import_features_analysis: The config for ImportFeatures Analysis Based Feature Monitoring.
               Structure is documented below.
        :param pulumi.Input['AiFeatureStoreEntityTypeMonitoringConfigNumericalThresholdConfigArgs'] numerical_threshold_config: Threshold for numerical features of anomaly detection. This is shared by all objectives of Featurestore Monitoring for numerical features (i.e. Features with type (Feature.ValueType) DOUBLE or INT64).
               Structure is documented below.
        :param pulumi.Input['AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysisArgs'] snapshot_analysis: The config for Snapshot Analysis Based Feature Monitoring.
               Structure is documented below.
        """
        if categorical_threshold_config is not None:
            pulumi.set(__self__, "categorical_threshold_config", categorical_threshold_config)
        if import_features_analysis is not None:
            pulumi.set(__self__, "import_features_analysis", import_features_analysis)
        if numerical_threshold_config is not None:
            pulumi.set(__self__, "numerical_threshold_config", numerical_threshold_config)
        if snapshot_analysis is not None:
            pulumi.set(__self__, "snapshot_analysis", snapshot_analysis)

    @property
    @pulumi.getter(name="categoricalThresholdConfig")
    def categorical_threshold_config(self) -> Optional[pulumi.Input['AiFeatureStoreEntityTypeMonitoringConfigCategoricalThresholdConfigArgs']]:
        """
        Threshold for categorical features of anomaly detection. This is shared by all types of Featurestore Monitoring for categorical features (i.e. Features with type (Feature.ValueType) BOOL or STRING).
        Structure is documented below.
        """
        return pulumi.get(self, "categorical_threshold_config")

    @categorical_threshold_config.setter
    def categorical_threshold_config(self, value: Optional[pulumi.Input['AiFeatureStoreEntityTypeMonitoringConfigCategoricalThresholdConfigArgs']]):
        pulumi.set(self, "categorical_threshold_config", value)

    @property
    @pulumi.getter(name="importFeaturesAnalysis")
    def import_features_analysis(self) -> Optional[pulumi.Input['AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysisArgs']]:
        """
        The config for ImportFeatures Analysis Based Feature Monitoring.
        Structure is documented below.
        """
        return pulumi.get(self, "import_features_analysis")

    @import_features_analysis.setter
    def import_features_analysis(self, value: Optional[pulumi.Input['AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysisArgs']]):
        pulumi.set(self, "import_features_analysis", value)

    @property
    @pulumi.getter(name="numericalThresholdConfig")
    def numerical_threshold_config(self) -> Optional[pulumi.Input['AiFeatureStoreEntityTypeMonitoringConfigNumericalThresholdConfigArgs']]:
        """
        Threshold for numerical features of anomaly detection. This is shared by all objectives of Featurestore Monitoring for numerical features (i.e. Features with type (Feature.ValueType) DOUBLE or INT64).
        Structure is documented below.
        """
        return pulumi.get(self, "numerical_threshold_config")

    @numerical_threshold_config.setter
    def numerical_threshold_config(self, value: Optional[pulumi.Input['AiFeatureStoreEntityTypeMonitoringConfigNumericalThresholdConfigArgs']]):
        pulumi.set(self, "numerical_threshold_config", value)

    @property
    @pulumi.getter(name="snapshotAnalysis")
    def snapshot_analysis(self) -> Optional[pulumi.Input['AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysisArgs']]:
        """
        The config for Snapshot Analysis Based Feature Monitoring.
        Structure is documented below.
        """
        return pulumi.get(self, "snapshot_analysis")

    @snapshot_analysis.setter
    def snapshot_analysis(self, value: Optional[pulumi.Input['AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysisArgs']]):
        pulumi.set(self, "snapshot_analysis", value)


@pulumi.input_type
class AiFeatureStoreEntityTypeMonitoringConfigCategoricalThresholdConfigArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[float]):
        """
        :param pulumi.Input[float] value: Specify a threshold value that can trigger the alert. For categorical feature, the distribution distance is calculated by L-inifinity norm. Each feature must have a non-zero threshold if they need to be monitored. Otherwise no alert will be triggered for that feature. The default value is 0.3.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[float]:
        """
        Specify a threshold value that can trigger the alert. For categorical feature, the distribution distance is calculated by L-inifinity norm. Each feature must have a non-zero threshold if they need to be monitored. Otherwise no alert will be triggered for that feature. The default value is 0.3.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[float]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysisArgs:
    def __init__(__self__, *,
                 anomaly_detection_baseline: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] anomaly_detection_baseline: Defines the baseline to do anomaly detection for feature values imported by each [entityTypes.importFeatureValues][] operation. The value must be one of the values below:
               * LATEST_STATS: Choose the later one statistics generated by either most recent snapshot analysis or previous import features analysis. If non of them exists, skip anomaly detection and only generate a statistics.
               * MOST_RECENT_SNAPSHOT_STATS: Use the statistics generated by the most recent snapshot analysis if exists.
               * PREVIOUS_IMPORT_FEATURES_STATS: Use the statistics generated by the previous import features analysis if exists.
        :param pulumi.Input[str] state: Whether to enable / disable / inherite default hebavior for import features analysis. The value must be one of the values below:
               * DEFAULT: The default behavior of whether to enable the monitoring. EntityType-level config: disabled.
               * ENABLED: Explicitly enables import features analysis. EntityType-level config: by default enables import features analysis for all Features under it.
               * DISABLED: Explicitly disables import features analysis. EntityType-level config: by default disables import features analysis for all Features under it.
        """
        if anomaly_detection_baseline is not None:
            pulumi.set(__self__, "anomaly_detection_baseline", anomaly_detection_baseline)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="anomalyDetectionBaseline")
    def anomaly_detection_baseline(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the baseline to do anomaly detection for feature values imported by each [entityTypes.importFeatureValues][] operation. The value must be one of the values below:
        * LATEST_STATS: Choose the later one statistics generated by either most recent snapshot analysis or previous import features analysis. If non of them exists, skip anomaly detection and only generate a statistics.
        * MOST_RECENT_SNAPSHOT_STATS: Use the statistics generated by the most recent snapshot analysis if exists.
        * PREVIOUS_IMPORT_FEATURES_STATS: Use the statistics generated by the previous import features analysis if exists.
        """
        return pulumi.get(self, "anomaly_detection_baseline")

    @anomaly_detection_baseline.setter
    def anomaly_detection_baseline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "anomaly_detection_baseline", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to enable / disable / inherite default hebavior for import features analysis. The value must be one of the values below:
        * DEFAULT: The default behavior of whether to enable the monitoring. EntityType-level config: disabled.
        * ENABLED: Explicitly enables import features analysis. EntityType-level config: by default enables import features analysis for all Features under it.
        * DISABLED: Explicitly disables import features analysis. EntityType-level config: by default disables import features analysis for all Features under it.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class AiFeatureStoreEntityTypeMonitoringConfigNumericalThresholdConfigArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[float]):
        """
        :param pulumi.Input[float] value: Specify a threshold value that can trigger the alert. For numerical feature, the distribution distance is calculated by Jensen–Shannon divergence. Each feature must have a non-zero threshold if they need to be monitored. Otherwise no alert will be triggered for that feature. The default value is 0.3.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[float]:
        """
        Specify a threshold value that can trigger the alert. For numerical feature, the distribution distance is calculated by Jensen–Shannon divergence. Each feature must have a non-zero threshold if they need to be monitored. Otherwise no alert will be triggered for that feature. The default value is 0.3.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[float]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysisArgs:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 monitoring_interval: Optional[pulumi.Input[str]] = None,
                 monitoring_interval_days: Optional[pulumi.Input[int]] = None,
                 staleness_days: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[bool] disabled: The monitoring schedule for snapshot analysis. For EntityType-level config: unset / disabled = true indicates disabled by default for Features under it; otherwise by default enable snapshot analysis monitoring with monitoringInterval for Features under it.
        :param pulumi.Input[int] monitoring_interval_days: Configuration of the snapshot analysis based monitoring pipeline running interval. The value indicates number of days. The default value is 1.
               If both FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days and [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval][] are set when creating/updating EntityTypes/Features, FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days will be used.
        :param pulumi.Input[int] staleness_days: Customized export features time window for snapshot analysis. Unit is one day. The default value is 21 days. Minimum value is 1 day. Maximum value is 4000 days.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if monitoring_interval is not None:
            warnings.warn("""This field is unavailable in the GA provider and will be removed from the beta provider in a future release.""", DeprecationWarning)
            pulumi.log.warn("""monitoring_interval is deprecated: This field is unavailable in the GA provider and will be removed from the beta provider in a future release.""")
        if monitoring_interval is not None:
            pulumi.set(__self__, "monitoring_interval", monitoring_interval)
        if monitoring_interval_days is not None:
            pulumi.set(__self__, "monitoring_interval_days", monitoring_interval_days)
        if staleness_days is not None:
            pulumi.set(__self__, "staleness_days", staleness_days)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The monitoring schedule for snapshot analysis. For EntityType-level config: unset / disabled = true indicates disabled by default for Features under it; otherwise by default enable snapshot analysis monitoring with monitoringInterval for Features under it.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="monitoringInterval")
    def monitoring_interval(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "monitoring_interval")

    @monitoring_interval.setter
    def monitoring_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitoring_interval", value)

    @property
    @pulumi.getter(name="monitoringIntervalDays")
    def monitoring_interval_days(self) -> Optional[pulumi.Input[int]]:
        """
        Configuration of the snapshot analysis based monitoring pipeline running interval. The value indicates number of days. The default value is 1.
        If both FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days and [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval][] are set when creating/updating EntityTypes/Features, FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days will be used.
        """
        return pulumi.get(self, "monitoring_interval_days")

    @monitoring_interval_days.setter
    def monitoring_interval_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "monitoring_interval_days", value)

    @property
    @pulumi.getter(name="stalenessDays")
    def staleness_days(self) -> Optional[pulumi.Input[int]]:
        """
        Customized export features time window for snapshot analysis. Unit is one day. The default value is 21 days. Minimum value is 1 day. Maximum value is 4000 days.
        """
        return pulumi.get(self, "staleness_days")

    @staleness_days.setter
    def staleness_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "staleness_days", value)


@pulumi.input_type
class AiFeatureStoreIamBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class AiFeatureStoreIamMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class AiFeatureStoreOnlineServingConfigArgs:
    def __init__(__self__, *,
                 fixed_node_count: Optional[pulumi.Input[int]] = None,
                 scaling: Optional[pulumi.Input['AiFeatureStoreOnlineServingConfigScalingArgs']] = None):
        """
        :param pulumi.Input[int] fixed_node_count: The number of nodes for each cluster. The number of nodes will not scale automatically but can be scaled manually by providing different values when updating.
        :param pulumi.Input['AiFeatureStoreOnlineServingConfigScalingArgs'] scaling: Online serving scaling configuration. Only one of fixedNodeCount and scaling can be set. Setting one will reset the other.
               Structure is documented below.
        """
        if fixed_node_count is not None:
            pulumi.set(__self__, "fixed_node_count", fixed_node_count)
        if scaling is not None:
            pulumi.set(__self__, "scaling", scaling)

    @property
    @pulumi.getter(name="fixedNodeCount")
    def fixed_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes for each cluster. The number of nodes will not scale automatically but can be scaled manually by providing different values when updating.
        """
        return pulumi.get(self, "fixed_node_count")

    @fixed_node_count.setter
    def fixed_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fixed_node_count", value)

    @property
    @pulumi.getter
    def scaling(self) -> Optional[pulumi.Input['AiFeatureStoreOnlineServingConfigScalingArgs']]:
        """
        Online serving scaling configuration. Only one of fixedNodeCount and scaling can be set. Setting one will reset the other.
        Structure is documented below.
        """
        return pulumi.get(self, "scaling")

    @scaling.setter
    def scaling(self, value: Optional[pulumi.Input['AiFeatureStoreOnlineServingConfigScalingArgs']]):
        pulumi.set(self, "scaling", value)


@pulumi.input_type
class AiFeatureStoreOnlineServingConfigScalingArgs:
    def __init__(__self__, *,
                 max_node_count: pulumi.Input[int],
                 min_node_count: pulumi.Input[int]):
        """
        :param pulumi.Input[int] max_node_count: The maximum number of nodes to scale up to. Must be greater than minNodeCount, and less than or equal to 10 times of 'minNodeCount'.
        :param pulumi.Input[int] min_node_count: The minimum number of nodes to scale down to. Must be greater than or equal to 1.
        """
        pulumi.set(__self__, "max_node_count", max_node_count)
        pulumi.set(__self__, "min_node_count", min_node_count)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> pulumi.Input[int]:
        """
        The maximum number of nodes to scale up to. Must be greater than minNodeCount, and less than or equal to 10 times of 'minNodeCount'.
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_node_count", value)

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> pulumi.Input[int]:
        """
        The minimum number of nodes to scale down to. Must be greater than or equal to 1.
        """
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_node_count", value)


@pulumi.input_type
class AiIndexDeployedIndexArgs:
    def __init__(__self__, *,
                 deployed_index_id: Optional[pulumi.Input[str]] = None,
                 index_endpoint: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] deployed_index_id: The ID of the DeployedIndex in the above IndexEndpoint.
        :param pulumi.Input[str] index_endpoint: A resource name of the IndexEndpoint.
        """
        if deployed_index_id is not None:
            pulumi.set(__self__, "deployed_index_id", deployed_index_id)
        if index_endpoint is not None:
            pulumi.set(__self__, "index_endpoint", index_endpoint)

    @property
    @pulumi.getter(name="deployedIndexId")
    def deployed_index_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the DeployedIndex in the above IndexEndpoint.
        """
        return pulumi.get(self, "deployed_index_id")

    @deployed_index_id.setter
    def deployed_index_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployed_index_id", value)

    @property
    @pulumi.getter(name="indexEndpoint")
    def index_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        A resource name of the IndexEndpoint.
        """
        return pulumi.get(self, "index_endpoint")

    @index_endpoint.setter
    def index_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "index_endpoint", value)


@pulumi.input_type
class AiIndexIndexStatArgs:
    def __init__(__self__, *,
                 shards_count: Optional[pulumi.Input[int]] = None,
                 vectors_count: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] shards_count: The number of shards in the Index.
        :param pulumi.Input[str] vectors_count: The number of vectors in the Index.
        """
        if shards_count is not None:
            pulumi.set(__self__, "shards_count", shards_count)
        if vectors_count is not None:
            pulumi.set(__self__, "vectors_count", vectors_count)

    @property
    @pulumi.getter(name="shardsCount")
    def shards_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of shards in the Index.
        """
        return pulumi.get(self, "shards_count")

    @shards_count.setter
    def shards_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shards_count", value)

    @property
    @pulumi.getter(name="vectorsCount")
    def vectors_count(self) -> Optional[pulumi.Input[str]]:
        """
        The number of vectors in the Index.
        """
        return pulumi.get(self, "vectors_count")

    @vectors_count.setter
    def vectors_count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vectors_count", value)


@pulumi.input_type
class AiIndexMetadataArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['AiIndexMetadataConfigArgs']] = None,
                 contents_delta_uri: Optional[pulumi.Input[str]] = None,
                 is_complete_overwrite: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input['AiIndexMetadataConfigArgs'] config: The configuration of the Matching Engine Index.
               Structure is documented below.
        :param pulumi.Input[str] contents_delta_uri: Allows inserting, updating  or deleting the contents of the Matching Engine Index.
               The string must be a valid Cloud Storage directory path. If this
               field is set when calling IndexService.UpdateIndex, then no other
               Index field can be also updated as part of the same call.
               The expected structure and format of the files this URI points to is
               described at https://cloud.google.com/vertex-ai/docs/matching-engine/using-matching-engine#input-data-format
        :param pulumi.Input[bool] is_complete_overwrite: If this field is set together with contentsDeltaUri when calling IndexService.UpdateIndex,
               then existing content of the Index will be replaced by the data from the contentsDeltaUri.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if contents_delta_uri is not None:
            pulumi.set(__self__, "contents_delta_uri", contents_delta_uri)
        if is_complete_overwrite is not None:
            pulumi.set(__self__, "is_complete_overwrite", is_complete_overwrite)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['AiIndexMetadataConfigArgs']]:
        """
        The configuration of the Matching Engine Index.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['AiIndexMetadataConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="contentsDeltaUri")
    def contents_delta_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Allows inserting, updating  or deleting the contents of the Matching Engine Index.
        The string must be a valid Cloud Storage directory path. If this
        field is set when calling IndexService.UpdateIndex, then no other
        Index field can be also updated as part of the same call.
        The expected structure and format of the files this URI points to is
        described at https://cloud.google.com/vertex-ai/docs/matching-engine/using-matching-engine#input-data-format
        """
        return pulumi.get(self, "contents_delta_uri")

    @contents_delta_uri.setter
    def contents_delta_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contents_delta_uri", value)

    @property
    @pulumi.getter(name="isCompleteOverwrite")
    def is_complete_overwrite(self) -> Optional[pulumi.Input[bool]]:
        """
        If this field is set together with contentsDeltaUri when calling IndexService.UpdateIndex,
        then existing content of the Index will be replaced by the data from the contentsDeltaUri.
        """
        return pulumi.get(self, "is_complete_overwrite")

    @is_complete_overwrite.setter
    def is_complete_overwrite(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_complete_overwrite", value)


@pulumi.input_type
class AiIndexMetadataConfigArgs:
    def __init__(__self__, *,
                 dimensions: pulumi.Input[int],
                 algorithm_config: Optional[pulumi.Input['AiIndexMetadataConfigAlgorithmConfigArgs']] = None,
                 approximate_neighbors_count: Optional[pulumi.Input[int]] = None,
                 distance_measure_type: Optional[pulumi.Input[str]] = None,
                 feature_norm_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] dimensions: The number of dimensions of the input vectors.
        :param pulumi.Input['AiIndexMetadataConfigAlgorithmConfigArgs'] algorithm_config: The configuration with regard to the algorithms used for efficient search.
               Structure is documented below.
        :param pulumi.Input[int] approximate_neighbors_count: The default number of neighbors to find via approximate search before exact reordering is
               performed. Exact reordering is a procedure where results returned by an
               approximate search algorithm are reordered via a more expensive distance computation.
               Required if tree-AH algorithm is used.
        :param pulumi.Input[str] distance_measure_type: The distance measure used in nearest neighbor search. The value must be one of the followings:
               * SQUARED_L2_DISTANCE: Euclidean (L_2) Distance
               * L1_DISTANCE: Manhattan (L_1) Distance
               * COSINE_DISTANCE: Cosine Distance. Defined as 1 - cosine similarity.
               * DOT_PRODUCT_DISTANCE: Dot Product Distance. Defined as a negative of the dot product
        :param pulumi.Input[str] feature_norm_type: Type of normalization to be carried out on each vector. The value must be one of the followings:
               * UNIT_L2_NORM: Unit L2 normalization type
               * NONE: No normalization type is specified.
        """
        pulumi.set(__self__, "dimensions", dimensions)
        if algorithm_config is not None:
            pulumi.set(__self__, "algorithm_config", algorithm_config)
        if approximate_neighbors_count is not None:
            pulumi.set(__self__, "approximate_neighbors_count", approximate_neighbors_count)
        if distance_measure_type is not None:
            pulumi.set(__self__, "distance_measure_type", distance_measure_type)
        if feature_norm_type is not None:
            pulumi.set(__self__, "feature_norm_type", feature_norm_type)

    @property
    @pulumi.getter
    def dimensions(self) -> pulumi.Input[int]:
        """
        The number of dimensions of the input vectors.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: pulumi.Input[int]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="algorithmConfig")
    def algorithm_config(self) -> Optional[pulumi.Input['AiIndexMetadataConfigAlgorithmConfigArgs']]:
        """
        The configuration with regard to the algorithms used for efficient search.
        Structure is documented below.
        """
        return pulumi.get(self, "algorithm_config")

    @algorithm_config.setter
    def algorithm_config(self, value: Optional[pulumi.Input['AiIndexMetadataConfigAlgorithmConfigArgs']]):
        pulumi.set(self, "algorithm_config", value)

    @property
    @pulumi.getter(name="approximateNeighborsCount")
    def approximate_neighbors_count(self) -> Optional[pulumi.Input[int]]:
        """
        The default number of neighbors to find via approximate search before exact reordering is
        performed. Exact reordering is a procedure where results returned by an
        approximate search algorithm are reordered via a more expensive distance computation.
        Required if tree-AH algorithm is used.
        """
        return pulumi.get(self, "approximate_neighbors_count")

    @approximate_neighbors_count.setter
    def approximate_neighbors_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "approximate_neighbors_count", value)

    @property
    @pulumi.getter(name="distanceMeasureType")
    def distance_measure_type(self) -> Optional[pulumi.Input[str]]:
        """
        The distance measure used in nearest neighbor search. The value must be one of the followings:
        * SQUARED_L2_DISTANCE: Euclidean (L_2) Distance
        * L1_DISTANCE: Manhattan (L_1) Distance
        * COSINE_DISTANCE: Cosine Distance. Defined as 1 - cosine similarity.
        * DOT_PRODUCT_DISTANCE: Dot Product Distance. Defined as a negative of the dot product
        """
        return pulumi.get(self, "distance_measure_type")

    @distance_measure_type.setter
    def distance_measure_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "distance_measure_type", value)

    @property
    @pulumi.getter(name="featureNormType")
    def feature_norm_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of normalization to be carried out on each vector. The value must be one of the followings:
        * UNIT_L2_NORM: Unit L2 normalization type
        * NONE: No normalization type is specified.
        """
        return pulumi.get(self, "feature_norm_type")

    @feature_norm_type.setter
    def feature_norm_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_norm_type", value)


@pulumi.input_type
class AiIndexMetadataConfigAlgorithmConfigArgs:
    def __init__(__self__, *,
                 brute_force_config: Optional[pulumi.Input['AiIndexMetadataConfigAlgorithmConfigBruteForceConfigArgs']] = None,
                 tree_ah_config: Optional[pulumi.Input['AiIndexMetadataConfigAlgorithmConfigTreeAhConfigArgs']] = None):
        """
        :param pulumi.Input['AiIndexMetadataConfigAlgorithmConfigBruteForceConfigArgs'] brute_force_config: Configuration options for using brute force search, which simply implements the
               standard linear search in the database for each query.
        :param pulumi.Input['AiIndexMetadataConfigAlgorithmConfigTreeAhConfigArgs'] tree_ah_config: Configuration options for using the tree-AH algorithm (Shallow tree + Asymmetric Hashing).
               Please refer to this paper for more details: https://arxiv.org/abs/1908.10396
               Structure is documented below.
        """
        if brute_force_config is not None:
            pulumi.set(__self__, "brute_force_config", brute_force_config)
        if tree_ah_config is not None:
            pulumi.set(__self__, "tree_ah_config", tree_ah_config)

    @property
    @pulumi.getter(name="bruteForceConfig")
    def brute_force_config(self) -> Optional[pulumi.Input['AiIndexMetadataConfigAlgorithmConfigBruteForceConfigArgs']]:
        """
        Configuration options for using brute force search, which simply implements the
        standard linear search in the database for each query.
        """
        return pulumi.get(self, "brute_force_config")

    @brute_force_config.setter
    def brute_force_config(self, value: Optional[pulumi.Input['AiIndexMetadataConfigAlgorithmConfigBruteForceConfigArgs']]):
        pulumi.set(self, "brute_force_config", value)

    @property
    @pulumi.getter(name="treeAhConfig")
    def tree_ah_config(self) -> Optional[pulumi.Input['AiIndexMetadataConfigAlgorithmConfigTreeAhConfigArgs']]:
        """
        Configuration options for using the tree-AH algorithm (Shallow tree + Asymmetric Hashing).
        Please refer to this paper for more details: https://arxiv.org/abs/1908.10396
        Structure is documented below.
        """
        return pulumi.get(self, "tree_ah_config")

    @tree_ah_config.setter
    def tree_ah_config(self, value: Optional[pulumi.Input['AiIndexMetadataConfigAlgorithmConfigTreeAhConfigArgs']]):
        pulumi.set(self, "tree_ah_config", value)


@pulumi.input_type
class AiIndexMetadataConfigAlgorithmConfigBruteForceConfigArgs:
    def __init__(__self__):
        pass


@pulumi.input_type
class AiIndexMetadataConfigAlgorithmConfigTreeAhConfigArgs:
    def __init__(__self__, *,
                 leaf_node_embedding_count: Optional[pulumi.Input[int]] = None,
                 leaf_nodes_to_search_percent: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] leaf_node_embedding_count: Number of embeddings on each leaf node. The default value is 1000 if not set.
        :param pulumi.Input[int] leaf_nodes_to_search_percent: The default percentage of leaf nodes that any query may be searched. Must be in
               range 1-100, inclusive. The default value is 10 (means 10%) if not set.
        """
        if leaf_node_embedding_count is not None:
            pulumi.set(__self__, "leaf_node_embedding_count", leaf_node_embedding_count)
        if leaf_nodes_to_search_percent is not None:
            pulumi.set(__self__, "leaf_nodes_to_search_percent", leaf_nodes_to_search_percent)

    @property
    @pulumi.getter(name="leafNodeEmbeddingCount")
    def leaf_node_embedding_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of embeddings on each leaf node. The default value is 1000 if not set.
        """
        return pulumi.get(self, "leaf_node_embedding_count")

    @leaf_node_embedding_count.setter
    def leaf_node_embedding_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "leaf_node_embedding_count", value)

    @property
    @pulumi.getter(name="leafNodesToSearchPercent")
    def leaf_nodes_to_search_percent(self) -> Optional[pulumi.Input[int]]:
        """
        The default percentage of leaf nodes that any query may be searched. Must be in
        range 1-100, inclusive. The default value is 10 (means 10%) if not set.
        """
        return pulumi.get(self, "leaf_nodes_to_search_percent")

    @leaf_nodes_to_search_percent.setter
    def leaf_nodes_to_search_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "leaf_nodes_to_search_percent", value)


@pulumi.input_type
class AiMetadataStoreEncryptionSpecArgs:
    def __init__(__self__, *,
                 kms_key_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kms_key_name: Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
               Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
        Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)


@pulumi.input_type
class AiMetadataStoreStateArgs:
    def __init__(__self__, *,
                 disk_utilization_bytes: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] disk_utilization_bytes: The disk utilization of the MetadataStore in bytes.
        """
        if disk_utilization_bytes is not None:
            pulumi.set(__self__, "disk_utilization_bytes", disk_utilization_bytes)

    @property
    @pulumi.getter(name="diskUtilizationBytes")
    def disk_utilization_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        The disk utilization of the MetadataStore in bytes.
        """
        return pulumi.get(self, "disk_utilization_bytes")

    @disk_utilization_bytes.setter
    def disk_utilization_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_utilization_bytes", value)


@pulumi.input_type
class AiTensorboardEncryptionSpecArgs:
    def __init__(__self__, *,
                 kms_key_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] kms_key_name: The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
               Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Input[str]:
        """
        The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
        Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_key_name", value)


