# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'WorkstationClusterCondition',
    'WorkstationClusterPrivateClusterConfig',
]

@pulumi.output_type
class WorkstationClusterCondition(dict):
    def __init__(__self__, *,
                 code: Optional[int] = None,
                 details: Optional[Sequence[Mapping[str, Any]]] = None,
                 message: Optional[str] = None):
        """
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, Any]] details: A list of messages that carry the error details.
        :param str message: Human readable message indicating details about the current status.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[int]:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence[Mapping[str, Any]]]:
        """
        A list of messages that carry the error details.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class WorkstationClusterPrivateClusterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enablePrivateEndpoint":
            suggest = "enable_private_endpoint"
        elif key == "clusterHostname":
            suggest = "cluster_hostname"
        elif key == "serviceAttachmentUri":
            suggest = "service_attachment_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkstationClusterPrivateClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkstationClusterPrivateClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkstationClusterPrivateClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_private_endpoint: bool,
                 cluster_hostname: Optional[str] = None,
                 service_attachment_uri: Optional[str] = None):
        """
        :param bool enable_private_endpoint: Whether Workstations endpoint is private.
        :param str cluster_hostname: Hostname for the workstation cluster.
               This field will be populated only when private endpoint is enabled.
               To access workstations in the cluster, create a new DNS zone mapping this domain name to an internal IP address and a forwarding rule mapping that address to the service attachment.
        :param str service_attachment_uri: Service attachment URI for the workstation cluster.
               The service attachemnt is created when private endpoint is enabled.
               To access workstations in the cluster, configure access to the managed service using (Private Service Connect)[https://cloud.google.com/vpc/docs/configure-private-service-connect-services].
        """
        pulumi.set(__self__, "enable_private_endpoint", enable_private_endpoint)
        if cluster_hostname is not None:
            pulumi.set(__self__, "cluster_hostname", cluster_hostname)
        if service_attachment_uri is not None:
            pulumi.set(__self__, "service_attachment_uri", service_attachment_uri)

    @property
    @pulumi.getter(name="enablePrivateEndpoint")
    def enable_private_endpoint(self) -> bool:
        """
        Whether Workstations endpoint is private.
        """
        return pulumi.get(self, "enable_private_endpoint")

    @property
    @pulumi.getter(name="clusterHostname")
    def cluster_hostname(self) -> Optional[str]:
        """
        Hostname for the workstation cluster.
        This field will be populated only when private endpoint is enabled.
        To access workstations in the cluster, create a new DNS zone mapping this domain name to an internal IP address and a forwarding rule mapping that address to the service attachment.
        """
        return pulumi.get(self, "cluster_hostname")

    @property
    @pulumi.getter(name="serviceAttachmentUri")
    def service_attachment_uri(self) -> Optional[str]:
        """
        Service attachment URI for the workstation cluster.
        The service attachemnt is created when private endpoint is enabled.
        To access workstations in the cluster, configure access to the managed service using (Private Service Connect)[https://cloud.google.com/vpc/docs/configure-private-service-connect-services].
        """
        return pulumi.get(self, "service_attachment_uri")


