# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['stairlight']

package_data = \
{'': ['*']}

install_requires = \
['Jinja2>=2.10.3', 'PyYAML>=5.0', 'google-cloud-storage>=1.28.1,<2.0.0']

entry_points = \
{'console_scripts': ['stairlight = stairlight.cli:main']}

setup_kwargs = {
    'name': 'stairlight',
    'version': '0.2.0',
    'description': 'Table-level data lineage tool',
    'long_description': '# Stairlight\n\n[![License: MIT](https://img.shields.io/badge/License-MIT-blue.svg)](https://opensource.org/licenses/MIT) [![CI](https://github.com/tosh2230/stairlight/actions/workflows/ci.yml/badge.svg)](https://github.com/tosh2230/stairlight/actions/workflows/ci.yml)\n\nStairlight is a table-level data lineage tool, detects table dependencies from \'Transform\' SQL files such as plain SELECT, \'CREATE TABLE AS SELECT\', \'CREATE VIEW AS SELECT\'.\n\n## Installation\n\n```sh\n$ pip install stairlight\n```\n\n## Getting Started\n\nThere are three steps to use.\n\n```sh\n# Step 1: Initialize and set data location settings\n$ stairlight init\n\'./stairlight.yaml\' has created.\nPlease edit it to set your data sources.\n\n# Step 2: Map SQL files and tables, and add metadata\n$ stairlight check\n\'./mapping_yyyyMMddhhmmss.yaml\' has created.\nPlease map undefined tables and parameters, and append to your latest file.\n\n# Step 3: Get a table dependency map\n$ stairlight\n```\n\n## Description\n\n### Input\n\n- SQL files\n- Configuration files (YAML)\n    - stairlight.yaml: SQL file locations and include/exclude files.\n    - mapping.yaml: Mapping SQL files and tables.\n\n### Output\n\n- Dependency map (JSON)\n\n    <details>\n\n    <summary>Example</summary>\n\n    ```json\n    {\n        "PROJECT_d.DATASET_e.TABLE_f": {\n            "PROJECT_j.DATASET_k.TABLE_l": {\n                "type": "fs",\n                "file": "tests/sql/main/test_e.sql",\n                "uri": "/foo/bar/stairlight/tests/sql/main/test_e.sql",\n                "lines": [\n                    {\n                        "num": 1,\n                        "str": "SELECT * FROM PROJECT_j.DATASET_k.TABLE_l WHERE 1 = 1"\n                    }\n                ]\n            },\n            "PROJECT_g.DATASET_h.TABLE_i": {\n                "type": "gcs",\n                "file": "sql/test_b/test_b.sql",\n                "uri": "gs://baz/sql/test_b/test_b.sql",\n                "lines": [\n                    {\n                        "num": 23,\n                        "str": "    PROJECT_g.DATASET_h.TABLE_i AS b",\n                    }\n                ],\n                "bucket": "stairlight"\n            },\n            "PROJECT_C.DATASET_C.TABLE_C": {\n                "type": "gcs",\n                "file": "sql/test_b/test_b.sql",\n                "uri": "gs://baz/sql/test_b/test_b.sql",\n                "lines": [\n                    {\n                        "num": 6,\n                        "str": "        PROJECT_C.DATASET_C.TABLE_C",\n                    }\n                ],\n                "bucket": "stairlight"\n            },\n            "PROJECT_d.DATASET_d.TABLE_d": {\n                "type": "gcs",\n                "file": "sql/test_b/test_b.sql",\n                "uri": "gs://baz/sql/test_b/test_b.sql",\n                "lines": [\n                    {\n                        "num": 15,\n                        "str": "        PROJECT_d.DATASET_d.TABLE_d",\n                    }\n                ],\n                "bucket": "stairlight"\n            }\n        },\n        "PROJECT_j.DATASET_k.TABLE_l": {\n            "PROJECT_d.DATASET_e.TABLE_f": {\n                "type": "fs",\n                "file": "tests/sql/main/test_d.sql",\n                "uri": "/foo/bar/stairlight/tests/sql/main/test_d.sql",\n                "lines": [\n                    {\n                        "num": 1,\n                        "str": "SELECT * FROM PROJECT_d.DATASET_e.TABLE_f WHERE 1 = 1"\n                    }\n                ]\n            }\n        },\n        "PROJECT_d.DATASET_d.TABLE_d": {\n            "PROJECT_e.DATASET_e.TABLE_e": {\n                "type": "fs",\n                "file": "tests/sql/main/test_f.sql",\n                "uri": "/foo/bar/stairlight/tests/sql/main/test_f.sql",\n                "lines": [\n                    {\n                        "num": 1,\n                        "str": "SELECT * FROM PROJECT_e.DATASET_e.TABLE_e WHERE 1 = 1"\n                    }\n                ]\n            }\n        },\n    }\n    ```\n\n    </details>\n\n## Configuration\n\nConfig files used for unit test in CI can be found [here](https://github.com/tosh2230/stairlight/tree/main/config).\n\n### stairlight.yaml\n\n\'stairlight.yaml\' is for setting up Stairlight itself.\n\nIt is responsible for specifying the destination of SQL files to be read, and for specifying the prefix of mapping files.\n\nSQL files can be read from the following storage.\n\n- Local file system(with python pathlib module)\n- Google Cloud Storage\n\n### mapping.yaml\n\n\'mapping.yaml\' is used to define relationships between input files and tables.\n\n#### mapping section\n\nThis section is used to define relationships between SQL files and tables created as a result of query execution.\n\nThe `params` attribute allows you to reflect settings in [jinja](https://jinja.palletsprojects.com/) template variables embedded in SQL files. If multiple settings are applied to a SQL file using jinja template, the file will be read as if there were the same number of files as the number of settings.\n\n#### metadata section\n\nThis section is mainly used to set labels to tables written in SQL files.\n\n## Command and option\n\n```txt\n$ stairlight --help\nusage: stairlight [-h] [-c CONFIG] [--save SAVE | --load LOAD] {init,check,up,down} ...\n\nA table-level data lineage tool, detects table dependencies from \'Transform\' SQL files.\nWithout positional arguments, return a table dependency map as JSON format.\n\npositional arguments:\n  {init,check,up,down}\n    init                create a new Stairlight configuration file\n    check               create a new configuration file about undefined mappings\n    up                  return upstairs ( table | SQL file ) list\n    down                return downstairs ( table | SQL file ) list\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -c CONFIG, --config CONFIG\n                        set a Stairlight configuration directory\n  --save SAVE           save results to a file\n  --load LOAD           load results from a file\n```\n\n### init\n\n`init` creates a new Stairlight configuration file.\n\n```txt\n$ stairlight init --help\nusage: stairlight init [-h] [-c CONFIG] [-s SAVE | -l LOAD]\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -c CONFIG, --config CONFIG\n                        set a Stairlight configuration directory.\n```\n\n### check\n\n`check` creates a new configuration file about undefined mappings.\nThe option specification is the same as `init`.\n\n### up\n\n`up` outputs a list of tables or SQL files located upstream from the specified table.\n\n- Use table(`-t`, `--table`) or label(`-l`, `--label`) option to specify tables to search.\n- Recursive option(`-r`, `--recursive`) is set, Stairlight will find tables recursively and output as a list.\n- Verbose option(`-v`, `--verbose`) is set, Stairlight will add detailed information and output it as a dict.\n\n```txt\n$ stairlight up --help\nusage: stairlight up [-h] [-c CONFIG] [--save SAVE | --load LOAD] (-t TABLE | -l LABEL)\n                  [-o {table,file}] [-v] [-r]\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -c CONFIG, --config CONFIG\n                        set a Stairlight configuration directory\n  --save SAVE           save results to a file\n  --load LOAD           load results from a file\n  -t TABLE, --table TABLE\n                        table names that Stairlight searches for, can be specified\n                        multiple times. e.g. -t PROJECT_a.DATASET_b.TABLE_c -t\n                        PROJECT_d.DATASET_e.TABLE_f\n  -l LABEL, --label LABEL\n                        labels set for the table in mapping configuration, can be\n                        specified multiple times. The separator between key and value\n                        should be a colon(:). e.g. -l key_1:value_1 -l key_2:value_2\n  -o {table,file}, --output {table,file}\n                        output type\n  -v, --verbose         return verbose results\n  -r, --recursive       search recursively\n```\n\n### down\n\n`down` outputs a list of tables or SQL files located downstream from the specified table.\nThe option specification is the same as `up`.\n\n## Use as a library\n\nStairlight can also be used as a library.\n\n[tosh2230/stairlight-app](https://github.com/tosh2230/stairlight-app) is a sample web application rendering table dependency graph with Stairlight, using Graphviz, Streamlit and Google Cloud Run.\n',
    'author': 'tosh2230',
    'author_email': 'rev.to12@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.2,<4.0.0',
}


setup(**setup_kwargs)
