"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceMonitorGrant = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor_grant snowflake_resource_monitor_grant}
*/
class ResourceMonitorGrant extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor_grant snowflake_resource_monitor_grant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceMonitorGrantConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_resource_monitor_grant',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.32.0',
                providerVersionConstraint: ' ~> 0.25'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._enableMultipleGrants = config.enableMultipleGrants;
        this._monitorName = config.monitorName;
        this._privilege = config.privilege;
        this._roles = config.roles;
        this._withGrantOption = config.withGrantOption;
    }
    get enableMultipleGrants() {
        return this.getBooleanAttribute('enable_multiple_grants');
    }
    set enableMultipleGrants(value) {
        this._enableMultipleGrants = value;
    }
    resetEnableMultipleGrants() {
        this._enableMultipleGrants = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableMultipleGrantsInput() {
        return this._enableMultipleGrants;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get monitorName() {
        return this.getStringAttribute('monitor_name');
    }
    set monitorName(value) {
        this._monitorName = value;
    }
    // Temporarily expose input value. Use with caution.
    get monitorNameInput() {
        return this._monitorName;
    }
    get privilege() {
        return this.getStringAttribute('privilege');
    }
    set privilege(value) {
        this._privilege = value;
    }
    resetPrivilege() {
        this._privilege = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privilegeInput() {
        return this._privilege;
    }
    get roles() {
        return cdktf.Fn.tolist(this.getListAttribute('roles'));
    }
    set roles(value) {
        this._roles = value;
    }
    resetRoles() {
        this._roles = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rolesInput() {
        return this._roles;
    }
    get withGrantOption() {
        return this.getBooleanAttribute('with_grant_option');
    }
    set withGrantOption(value) {
        this._withGrantOption = value;
    }
    resetWithGrantOption() {
        this._withGrantOption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get withGrantOptionInput() {
        return this._withGrantOption;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            enable_multiple_grants: cdktf.booleanToTerraform(this._enableMultipleGrants),
            monitor_name: cdktf.stringToTerraform(this._monitorName),
            privilege: cdktf.stringToTerraform(this._privilege),
            roles: cdktf.listMapper(cdktf.stringToTerraform)(this._roles),
            with_grant_option: cdktf.booleanToTerraform(this._withGrantOption),
        };
    }
}
exports.ResourceMonitorGrant = ResourceMonitorGrant;
_a = JSII_RTTI_SYMBOL_1;
ResourceMonitorGrant[_a] = { fqn: "@cdktf/provider-snowflake.ResourceMonitorGrant", version: "0.1.39" };
// =================
// STATIC PROPERTIES
// =================
ResourceMonitorGrant.tfResourceType = "snowflake_resource_monitor_grant";
//# sourceMappingURL=data:application/json;base64,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