MockBlocoEafPastTendenciaHidrolPMO = [
    "         ENERGIAS AFLUENTES PASSADAS PARA A TENDENCIA HIDROLOGICA EM REFERENCIA A PRIMEIRA CONFIGURACAO DO SISTEMA (MWmes)\n",
    " X--------------------------------------------------------------------------------------------------------------------------------------------X\n",
    " SISTEMA           1          2          3          4          5          6          7          8          9         10         11         12\n",
    " X--------------------------------------------------------------------------------------------------------------------------------------------X\n",
    " SUDESTE       7196.96    9745.33   11886.20    7767.14    4202.72    3035.47    2315.42    2114.86    1668.24    2063.36    4073.77    4769.50\n",
    " MADEIRA       9650.59   11146.05   11085.25    9915.49    6337.30    3964.90    2982.11    1775.02    1524.38    1085.95    1459.81    3889.26\n",
    " TPIRES        2209.46    3148.16    4402.83    3440.01    2070.33    1120.19     704.22     538.87     484.66     502.84     724.43     942.96\n",
    " ITAIPU        3650.07    3126.87    4058.15    2888.40    2659.18    2949.05    2750.66    3233.77    2364.17    1804.99    1966.37    2290.16\n",
    " PARANA       24055.73   44189.65   37315.10   22040.68   15225.15   12395.52    9966.95    7810.76    5781.77    5993.25    9530.96   17415.70\n",
    " PRNPANEMA     1753.18    2207.97    1316.79     906.83     888.98    1382.95    1423.51    1913.04    1042.84     937.69    1009.05    1554.60\n",
    " SUL           1654.69    1253.54     696.36     464.33     809.86    3322.23   10783.62    5447.58    3111.36    1553.84     959.06    2271.35\n",
    " IGUACU        1727.38    1478.44    1151.62     585.42     944.50    3803.28    2479.50    4363.05    1951.43    1206.06    1086.38    4765.96\n",
    " NORDESTE      5769.45   11740.79   14158.40   11998.58    5596.48    3422.05    2737.30    2366.39    1979.33    1672.45    4630.82    4704.52\n",
    " NORTE         4692.22   10120.59   17354.59   17070.33   10396.31    4348.98    2099.47    1320.92     977.88     924.47    2579.38    2740.43\n",
    " BMONTE        4271.65    6618.03   11734.71   12261.70   11783.69    5513.00    1715.77     543.60     190.04      99.19     554.61    1352.06\n",
    " MAN-AP         534.84     524.74     566.74    1443.92    2018.64    1494.69    1150.44     652.14     480.96     307.93     434.04     409.13\n",
    " X--------------------------------------------------------------------------------------------------------------------------------------------X\n",
    " \n",
    "\n",
    "\n",
]

MockBlocoEafPastCfugaMedioPMO = [
    "         ENERGIAS AFLUENTES PASSADAS EM REFERENCIA A PRIMEIRA CONFIGURACAO DO SISTEMA CONSIDERANDO CANAL DE FUGA MEDIO (MWmes)\n",
    " X--------------------------------------------------------------------------------------------------------------------------------------------X\n",
    " SISTEMA           1          2          3          4          5          6          7          8          9         10         11         12\n",
    " X--------------------------------------------------------------------------------------------------------------------------------------------X\n",
    " SUDESTE       7196.96    9745.33   11886.20    7767.14    4202.72    3035.47    2315.42    2114.86    1668.24    2063.36    4073.77    4769.50\n",
    " MADEIRA      10336.16   11930.35   11844.40   10616.03    6790.27    4249.33    3199.72    1902.84    1635.66    1161.39    1563.40    4174.87\n",
    " TPIRES        2209.46    3148.16    4402.83    3440.01    2070.33    1120.19     704.22     538.87     484.66     502.84     724.43     942.96\n",
    " ITAIPU        3650.07    3126.87    4058.15    2888.40    2659.18    2949.05    2750.66    3233.77    2364.17    1804.99    1966.37    2290.16\n",
    " PARANA       24055.73   44189.65   37315.10   22040.68   15225.15   12395.52    9966.95    7810.76    5781.77    5993.25    9530.96   17415.70\n",
    " PRNPANEMA     1753.18    2207.97    1316.79     906.83     888.98    1382.95    1423.51    1913.04    1042.84     937.69    1009.05    1554.60\n",
    " SUL           1654.69    1253.54     696.36     464.33     809.86    3322.23   10783.62    5447.58    3111.36    1553.84     959.06    2271.35\n",
    " IGUACU        1727.38    1478.44    1151.62     585.42     944.50    3803.28    2479.50    4363.05    1951.43    1206.06    1086.38    4765.96\n",
    " NORDESTE      5769.45   11740.79   14158.40   11998.58    5596.48    3422.05    2737.30    2366.39    1979.33    1672.45    4630.82    4704.52\n",
    " NORTE         4651.35   10030.94   17198.05   16916.09   10299.87    4309.33    2081.01    1309.63     969.68     916.76    2557.67    2716.96\n",
    " BMONTE        4271.65    6618.03   11734.71   12261.70   11783.69    5513.00    1715.77     543.60     190.04      99.19     554.61    1352.06\n",
    " MAN-AP         534.84     524.74     566.74    1443.92    2018.64    1494.69    1150.44     652.14     480.96     307.93     434.04     409.13\n",
    " X--------------------------------------------------------------------------------------------------------------------------------------------X\n",
    " \n",
    "\x0c\n",
    " CEPEL                         MODELO ESTRATEGICO DE GERACAO HIDROTERMICA A SUBSISTEMAS              VERSAO  27.5.1_CPAMP_L                          \n",
]

MockBlocoConvergenciaPMO = [
    "    ITER               LIM.INF.                   ZINF               LIM.SUP.                   ZSUP                  DZINF             ZSUP ITER.\n",
    "                        ($10^6)                ($10^6)                ($10^6)                ($10^6)                    (%)                ($10^6)\n",
    "   X----X----------------------X----------------------X----------------------X----------------------X----------------------X----------------------X------------------------------------------------------------------------------------------------------------------------------------------------X\n",
    "      1                84283.82               82573.81              102843.97               93930.86                                                B    000h00min52.000s\n",
    "      1                81011.66               82573.81              105898.78               93930.86                                                B     (99%)\n",
    "      1                74890.74               82573.81               93450.89               84537.78          -                           84537.78  B\n",
    "                                                             2021   4.5   20.7   1.5    5.9   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   1.0    5.8   0.5    1.7   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.5    1.5   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.5    0.2   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.5   15.0   0.5    3.9   0.0    0.0   0.0    0.0\n",
    "                                                             2030   2.0   13.3   1.0    5.5   0.5    0.1   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   4.5          1.5          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   1.0          0.5          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.5          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.5          0.0          0.0\n",
    "                                                             2029   0.5          0.5          0.0          0.0\n",
    "                                                             2030   2.0          1.0          0.5          0.0\n",
    "      2                52542.35               89043.16               65007.53               58976.90                                                B    000h00min54.000s\n",
    "      2                50198.99               89043.16               66607.06               58976.90                                                B     (99%)\n",
    "      2                46644.66               89043.16               59109.84               53079.21        7.835                         53079.21  B\n",
    "                                                             2021   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.5    7.3   1.0    5.3   0.0    0.0   0.5    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.5    1.3   0.5    3.1   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.5    3.5   0.0    0.0   0.5    0.5   0.5    0.1\n",
    "                                                             2027   1.5    7.0   1.0    3.9   0.5    0.2   0.5    0.0\n",
    "                                                             2028   1.0    5.8   1.5    7.7   0.0    0.0   0.5    0.5\n",
    "                                                             2029   0.5    3.6   1.0    5.1   0.0    0.0   0.5    0.1\n",
    "                                                             2030   1.0    3.8   1.0    1.8   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.5          1.0          0.0          0.5\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.5          0.5          0.0          0.0\n",
    "                                                             2026   0.5          0.0          0.5          0.5\n",
    "                                                             2027   1.5          1.0          0.5          0.5\n",
    "                                                             2028   1.0          1.5          0.0          0.5\n",
    "                                                             2029   0.5          1.0          0.0          0.5\n",
    "                                                             2030   1.0          1.0          0.0          0.0\n",
    "      3                47818.26               96725.49               64084.99               56904.82                                                B    000h01min03.000s\n",
    "      3                44098.12               96725.49               65570.60               56904.82                                                B     (99%)\n",
    "      3                42127.78               96725.49               58394.51               51214.34        8.628                         51214.34  B\n",
    "                                                             2021   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   1.0    3.2   0.5    2.0   0.5    0.2   1.0    0.6\n",
    "                                                             2023   0.5    7.3   1.0    6.4   0.0    0.0   0.5    0.4\n",
    "                                                             2024   0.5    3.0   0.5    4.1   0.5    0.1   0.5    1.2\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   1.0   15.4   0.5    2.4   0.0    0.0   1.0    0.4\n",
    "                                                             2027   1.0    4.3   0.0    0.0   0.0    0.0   0.5    0.0\n",
    "                                                             2028   0.5    0.3   0.5    2.1   0.5    0.6   0.5    0.8\n",
    "                                                             2029   0.5    9.6   0.5    1.4   0.0    0.0   0.5    1.2\n",
    "                                                             2030   1.5    9.2   0.5    0.1   0.5    0.2   1.0    0.5\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   1.0          0.5          0.5          1.0\n",
    "                                                             2023   0.5          1.0          0.0          0.5\n",
    "                                                             2024   0.5          0.5          0.5          0.5\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   1.0          0.5          0.0          1.0\n",
    "                                                             2027   1.0          0.0          0.0          0.5\n",
    "                                                             2028   0.5          0.5          0.5          0.5\n",
    "                                                             2029   0.5          0.5          0.0          0.5\n",
    "                                                             2030   1.5          0.5          0.5          1.0\n",
    "      4                47818.26              104361.94               64084.99               56904.82                                                B    000h01min07.000s\n",
    "      4                44098.12              104361.94               65570.60               56904.82                                                B     (99%)\n",
    "      4                42127.78              104361.94               58394.51               51214.34        7.895                         52969.38  B\n",
    "                                                             2021   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.5   25.1   0.5   20.2   0.0    0.0   0.5    1.1\n",
    "                                                             2024   1.0    5.9   0.5    2.5   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   1.0   10.9   1.0    4.0   0.0    0.0   1.0    0.3\n",
    "                                                             2028   1.0   14.9   1.0    7.5   0.5    0.0   1.0    0.4\n",
    "                                                             2029   0.5   11.6   0.5    2.4   0.0    0.0   0.5    0.2\n",
    "                                                             2030   0.5    1.5   0.5    0.9   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.5          0.5          0.0          0.5\n",
    "                                                             2024   1.0          0.5          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   1.0          1.0          0.0          1.0\n",
    "                                                             2028   1.0          1.0          0.5          1.0\n",
    "                                                             2029   0.5          0.5          0.0          0.5\n",
    "                                                             2030   0.5          0.5          0.0          0.0\n",
    "      5                47818.26              106704.16               64084.99               56904.82                                                B    000h01min14.000s\n",
    "      5                44098.12              106704.16               65570.60               56904.82                                                B     (99%)\n",
    "      5                42127.78              106704.16               58394.51               51214.34        2.244                         51420.58  B\n",
    "                                                             2021   3.0   16.5   2.5   13.1   0.0    0.0   1.5    0.7\n",
    "                                                             2022   0.5    3.6   0.5    2.6   0.0    0.0   0.0    0.0\n",
    "                                                             2023   1.0    5.3   0.0    0.0   0.0    0.0   0.5    0.3\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.5    0.2   0.5    0.7   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.5    3.5   0.5    3.6   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.5    2.5   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   1.0    2.1   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   3.0          2.5          0.0          1.5\n",
    "                                                             2022   0.5          0.5          0.0          0.0\n",
    "                                                             2023   1.0          0.0          0.0          0.5\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.5          0.5          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.5          0.5          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.5          0.0          0.0\n",
    "                                                             2030   0.0          1.0          0.0          0.0\n",
    "      6                47818.26              111272.31               64084.99               56904.82                                                B    000h01min21.000s\n",
    "      6                44098.12              111272.31               65570.60               56904.82                                                B     (99%)\n",
    "      6                42127.78              111272.31               58394.51               51214.34        4.281                         53216.62  B\n",
    "                                                             2021   1.0    1.9   0.5    2.7   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.5    0.8   0.5    1.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   1.0    4.4   1.5    3.4   0.0    0.0   0.5    0.5\n",
    "                                                             2024   0.0    0.0   0.5    2.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   1.0   11.8   1.0    2.7   0.0    0.0   0.5    0.3\n",
    "                                                             2026   0.0    0.0   0.5    1.2   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.5    4.6   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.5    1.7   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.5    1.3   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   1.0          0.5          0.0          0.0\n",
    "                                                             2022   0.5          0.5          0.0          0.0\n",
    "                                                             2023   1.0          1.5          0.0          0.5\n",
    "                                                             2024   0.0          0.5          0.0          0.0\n",
    "                                                             2025   1.0          1.0          0.0          0.5\n",
    "                                                             2026   0.0          0.5          0.0          0.0\n",
    "                                                             2027   0.0          0.5          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.5          0.0          0.0          0.0\n",
    "                                                             2030   0.5          0.0          0.0          0.0\n",
    "      7                49208.00              113529.93               59057.27               54347.17                                                B    000h01min26.000s\n",
    "      7                47200.49              113529.93               60274.84               54347.17                                                B     (99%)\n",
    "      7                43773.28              113529.93               53622.55               48912.45        2.029                         48912.45  B\n",
    "                                                             2021   0.5    0.3   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.5    1.3   0.5    0.6   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.5    0.1   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.5    0.2   0.5    2.1   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.5          0.0          0.0          0.0\n",
    "                                                             2022   0.5          0.5          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.5          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.5          0.5          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "      8                49208.00              118847.06               59057.27               54347.17                                                B    000h01min33.000s\n",
    "      8                47200.49              118847.06               60274.84               54347.17                                                B     (99%)\n",
    "      8                43773.28              118847.06               53622.55               48912.45        4.683                         50923.64  B\n",
    "                                                             2021   0.5    8.5   0.5    2.2   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.5    0.4   0.5    0.6   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.5    0.1   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.5    8.6   0.5    1.1   0.0    0.0   0.5    0.0\n",
    "                                                             2028   0.5    4.7   0.5    0.8   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.5    2.4   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.5    5.9   1.0    3.8   0.5    0.1   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.5          0.5          0.0          0.0\n",
    "                                                             2022   0.5          0.5          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.5          0.0          0.0\n",
    "                                                             2027   0.5          0.5          0.0          0.5\n",
    "                                                             2028   0.5          0.5          0.0          0.0\n",
    "                                                             2029   0.0          0.5          0.0          0.0\n",
    "                                                             2030   0.5          1.0          0.5          0.0\n",
    "      9                49208.00              119412.53               59057.27               54347.17                                                B    000h01min42.000s\n",
    "      9                47200.49              119412.53               60274.84               54347.17                                                B     (99%)\n",
    "      9                43773.28              119412.53               53622.55               48912.45        0.476                         52414.75  B\n",
    "                                                             2021   0.0    0.0   0.5    0.8   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.5   10.6   1.0    7.0   0.0    0.0   0.5    0.8\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.5    8.1   0.0    0.0   0.0    0.0   0.5    1.7\n",
    "                                                             2026   1.0    1.0   0.5    2.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   1.0    4.9   1.0    5.4   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.5    7.5   1.0    4.1   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   1.0    1.4   1.0    1.6   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.5          0.0          0.0\n",
    "                                                             2022   0.5          1.0          0.0          0.5\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.5          0.0          0.0          0.5\n",
    "                                                             2026   1.0          0.5          0.0          0.0\n",
    "                                                             2027   1.0          1.0          0.0          0.0\n",
    "                                                             2028   0.5          1.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   1.0          1.0          0.0          0.0\n",
    "     10                49208.00              121166.95               59057.27               54347.17                                                B    000h01min46.000s\n",
    "     10                47200.49              121166.95               60274.84               54347.17                                                B     (99%)\n",
    "     10                43773.28              121166.95               53622.55               48912.45        1.469                         50931.46  B\n",
    "                                                             2021   2.0   10.7   1.0    3.8   0.0    0.0   0.5    0.5\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.5    4.7   1.0    2.5   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   1.0    2.5   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   1.0    8.3   1.0    4.5   0.0    0.0   0.5    0.3\n",
    "                                                             2029   0.0    0.0   0.5    0.9   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.5    1.0   0.0    0.0   0.0    0.0   0.5    0.1\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   2.0          1.0          0.0          0.5\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.5          1.0          0.0          0.0\n",
    "                                                             2024   0.0          1.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   1.0          1.0          0.0          0.5\n",
    "                                                             2029   0.0          0.5          0.0          0.0\n",
    "                                                             2030   0.5          0.0          0.0          0.5\n",
    "     11                49208.00              122677.98               59057.27               54347.17                                                B    000h01min55.000s\n",
    "     11                47200.49              122677.98               60274.84               54347.17                                                B     (99%)\n",
    "     11                43773.28              122677.98               53622.55               48912.45        1.247                         50070.10  B\n",
    "                                                             2021   2.0   12.5   1.5    6.2   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.5    5.6   0.0    0.0   0.5    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   2.0          1.5          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.5          0.0          0.5          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "     12                48586.36              124285.38               58500.20               54118.26                                                B    000h02min00.000s\n",
    "     12                47060.23              124285.38               59904.66               54118.26                                                B     (99%)\n",
    "     12                43174.54              124285.38               53088.38               48706.44        1.310                         48706.44  B\n",
    "                                                             2021   0.0    0.0   0.5    0.6   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.5    0.3   0.5    3.9   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.5    5.6   0.5    1.6   0.0    0.0   0.5    0.1\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.5    0.2   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   1.0   11.1   0.5    3.9   0.0    0.0   1.0    0.5\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.5          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.5          0.5          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.5          0.5          0.0          0.5\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.5          0.0          0.0          0.0\n",
    "                                                             2030   1.0          0.5          0.0          1.0\n",
    "     13                48272.34              127364.57               57205.75               52929.74                                                B    000h02min08.000s\n",
    "     13                46685.84              127364.57               58291.17               52929.74                                                B     (99%)\n",
    "     13                42979.37              127364.57               51912.78               47636.76        2.478                         47636.76  B\n",
    "                                                             2021   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "     14                48272.34              127543.95               57205.75               52929.74                                                B    000h02min21.000s\n",
    "     14                46685.84              127543.95               58291.17               52929.74                                                B     (99%)\n",
    "     14                42979.37              127543.95               51912.78               47636.76        0.141                         52280.75  B\n",
    "                                                             2021   1.0    3.8   1.0    2.6   0.0    0.0   0.5    0.0\n",
    "                                                             2022   0.5   27.0   1.0   11.3   0.0    0.0   0.5    0.2\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.5    8.2   0.5    3.4   0.0    0.0   0.5    0.7\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.5    5.9   0.5    4.6   0.0    0.0   0.5    0.6\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   1.0          1.0          0.0          0.5\n",
    "                                                             2022   0.5          1.0          0.0          0.5\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.5          0.5          0.0          0.5\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.5          0.5          0.0          0.5\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "     15                48272.34              128150.33               57205.75               52929.74                                                B    000h02min24.000s\n",
    "     15                46685.84              128150.33               58291.17               52929.74                                                B     (99%)\n",
    "     15                42979.37              128150.33               51912.78               47636.76        0.475                         48070.92  B\n",
    "                                                             2021   0.5    0.5   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.5    4.5   0.5    6.4   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.5    1.5   0.5    0.4   0.0    0.0   0.5    0.1\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.5          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.5          0.5          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.5          0.5          0.0          0.5\n",
    "     16                48272.34              129470.12               57205.75               52929.74                                                B    000h02min31.000s\n",
    "     16                46685.84              129470.12               58291.17               52929.74                                                B     (99%)\n",
    "     16                42979.37              129470.12               51912.78               47636.76        1.030                         48684.21  B\n",
    "                                                             2021   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.5    7.8   0.5    1.1   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.5    1.9   0.5    3.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.5    3.5   0.5    2.6   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.5    3.7   0.5    3.4   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.5          0.5          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.5          0.5          0.0          0.0\n",
    "                                                             2025   0.5          0.5          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.5          0.5          0.0          0.0\n",
    "     17                47740.64              130118.11               56641.35               52551.13                                                B    000h02min40.000s\n",
    "     17                46151.63              130118.11               57795.26               52551.13                                                B     (99%)\n",
    "     17                42485.52              130118.11               51386.24               47296.01        0.500                         47296.01  B\n",
    "                                                             2021   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.5    2.1   0.0    0.0   0.0    0.0   0.5    0.2\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.5    4.2   0.5    0.8   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.5          0.0          0.0          0.5\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.5          0.5          0.0          0.0\n",
    "     18                47740.64              132137.44               56641.35               52551.13                                                B    000h02min55.000s\n",
    "     18                46151.63              132137.44               57795.26               52551.13                                                B     (99%)\n",
    "     18                42485.52              132137.44               51386.24               47296.01        1.552                         51013.95  B\n",
    "                                                             2021   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   1.0    5.3   1.0    0.9   0.0    0.0   0.5    0.5\n",
    "                                                             2024   0.0    0.0   0.5    1.4   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.5    2.0   0.5    7.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   1.0          1.0          0.0          0.5\n",
    "                                                             2024   0.0          0.5          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.5          0.5          0.0          0.0\n",
    "     19                47740.64              132621.04               56641.35               52551.13                                                B    000h02min54.000s\n",
    "     19                46151.63              132621.04               57795.26               52551.13                                                B     (99%)\n",
    "     19                42485.52              132621.04               51386.24               47296.01        0.366                         51038.22  B\n",
    "                                                             2021   2.5   10.5   1.0    5.9   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   2.5          1.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "     20                47740.64              135126.30               56641.35               52551.13                                                B    000h02min51.000s\n",
    "     20                46151.63              135126.30               57795.26               52551.13                                                B     (99%)\n",
    "     20                42485.52              135126.30               51386.24               47296.01        1.889                         47827.75  B\n",
    "                                                             2021   0.5    4.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.5    2.9   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.5   12.4   0.5    0.9   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.5          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.5          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.5          0.5          0.0          0.0\n",
    "     21                46079.80              135906.44               54561.00               50741.96                                                B    000h03min09.000s\n",
    "     21                44280.69              135906.44               55908.84               50741.96                                                B     (99%)\n",
    "     21                41005.60              135906.44               49486.80               45667.77        0.577                         45667.77  B\n",
    "                                                             2021   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.5    0.6   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.5    2.6   0.5    1.6   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.5    4.3   0.5    3.2   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.5   10.0   0.5    6.0   0.0    0.0   0.5    0.5\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.5          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.5          0.5          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.5          0.5          0.0          0.0\n",
    "                                                             2030   0.5          0.5          0.0          0.5\n",
    "     22                46079.80              136526.29               54561.00               50741.96                                                B    000h03min18.000s\n",
    "     22                44280.69              136526.29               55908.84               50741.96                                                B     (99%)\n",
    "     22                41005.60              136526.29               49486.80               45667.77        0.456                         50200.50  B\n",
    "                                                             2021   0.5    2.9   0.5    2.8   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.5    2.2   0.5    0.4   0.0    0.0   0.5    0.0\n",
    "                                                             2023   0.5    6.6   0.5    1.5   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   1.5   16.5   1.0    2.0   0.0    0.0   1.0    0.2\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.5    1.0   0.5    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.5          0.5          0.0          0.0\n",
    "                                                             2022   0.5          0.5          0.0          0.5\n",
    "                                                             2023   0.5          0.5          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   1.5          1.0          0.0          1.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.5          0.5          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "     23                46079.80              137220.22               54561.00               50741.96                                                B    000h03min15.000s\n",
    "     23                44280.69              137220.22               55908.84               50741.96                                                B     (99%)\n",
    "     23                41005.60              137220.22               49486.80               45667.77        0.508                         53013.79  B\n",
    "                                                             2021   0.5    0.7   0.5    0.5   0.0    0.0   0.0    0.0\n",
    "                                                             2022   1.0    3.4   0.5    0.6   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.5    1.8   0.5    2.4   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.5   13.7   0.5    4.7   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.5   12.1   0.5    0.2   0.0    0.0   0.5    1.2\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.5    8.4   0.5    1.1   0.0    0.0   0.5    0.2\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.5          0.5          0.0          0.0\n",
    "                                                             2022   1.0          0.5          0.0          0.0\n",
    "                                                             2023   0.5          0.5          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.5          0.5          0.0          0.0\n",
    "                                                             2027   0.5          0.5          0.0          0.5\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.5          0.5          0.0          0.5\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "     24                46079.80              138045.75               54561.00               50741.96                                                B    000h03min41.000s\n",
    "     24                44280.69              138045.75               55908.84               50741.96                                                B     (99%)\n",
    "     24                41005.60              138045.75               49486.80               45667.77        0.602                         50578.82  B\n",
    "                                                             2021   0.5    0.7   1.0    3.7   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.5    0.1   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.5   11.1   0.5    5.7   0.5    0.2   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.5    1.1   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.5          1.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.5          0.0          0.0\n",
    "                                                             2024   0.5          0.5          0.5          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.5          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "     25                44422.67              139323.54               51232.54               48076.24                                                B    000h03min31.000s\n",
    "     25                43379.91              139323.54               52188.96               48076.24                                                B     (99%)\n",
    "     25                39615.05              139323.54               46424.92               43268.62        0.926                         43268.62  B\n",
    "                                                             2021   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.5    8.2   0.0    0.0   0.0    0.0   0.5    0.1\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.5          0.0          0.0          0.5\n",
    "     26                44422.67              139596.54               51232.54               48076.24                                                B    000h03min37.000s\n",
    "     26                43379.91              139596.54               52188.96               48076.24                                                B     (99%)\n",
    "     26                39615.05              139596.54               46424.92               43268.62        0.196                         50055.05  B\n",
    "                                                             2021   0.5    3.0   0.5    0.9   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.5    1.2   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.5    3.3   0.5    0.3   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.5   13.8   0.5    8.6   0.0    0.0   0.5    0.3\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.5          0.5          0.0          0.0\n",
    "                                                             2022   0.5          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.5          0.5          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.5          0.5          0.0          0.5\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "     27                44422.67              140106.58               51232.54               48076.24                                                B    000h03min50.000s\n",
    "     27                43379.91              140106.58               52188.96               48076.24                                                B     (99%)\n",
    "     27                39615.05              140106.58               46424.92               43268.62        0.365                         44371.55  B\n",
    "                                                             2021   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.5    5.5   0.5    2.8   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.5          0.5          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "     28                44422.67              140944.17               51232.54               48076.24                                                B    000h03min59.000s\n",
    "     28                43379.91              140944.17               52188.96               48076.24                                                B     (99%)\n",
    "     28                39615.05              140944.17               46424.92               43268.62        0.598                         49110.97  B\n",
    "                                                             2021   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.5    7.7   0.5    0.1   0.0    0.0   0.5    0.9\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.5          0.5          0.0          0.5\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "     29                44422.67              141609.46               51232.54               48076.24                                                B    000h04min12.000s\n",
    "     29                43379.91              141609.46               52188.96               48076.24                                                B     (99%)\n",
    "     29                39615.05              141609.46               46424.92               43268.62        0.472                         48035.57  B\n",
    "                                                             2021   0.5    6.0   0.0    0.0   0.0    0.0   0.5    0.3\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.5    0.7   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.5    0.6   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.5    6.9   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.5    1.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.5          0.0          0.0          0.5\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.5          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.5          0.0          0.0\n",
    "                                                             2028   0.5          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.5          0.0          0.0\n",
    "     30                44422.67              141993.41               51232.54               48076.24                                                B    000h04min15.000s\n",
    "     30                43379.91              141993.41               52188.96               48076.24                                                B     (99%)\n",
    "     30                39615.05              141993.41               46424.92               43268.62        0.271                         45982.51  B\n",
    "                                                             2021   0.5    3.3   0.5    3.1   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.5    1.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.5    1.6   0.5    0.5   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.5          0.5          0.0          0.0\n",
    "                                                             2022   0.5          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.5          0.5          0.0          0.0\n",
    "     31                44422.67              142574.92               51232.54               48076.24                                                B    000h04min22.000s\n",
    "     31                43379.91              142574.92               52188.96               48076.24                                                B     (99%)\n",
    "     31                39615.05              142574.92               46424.92               43268.62        0.410                         50267.63  B\n",
    "                                                             2021   1.0    5.8   0.5    2.5   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.5    4.3   0.5    0.2   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.5    0.2   0.5    2.4   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.5    3.0   0.5    0.9   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   1.0          0.5          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.5          0.5          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.5          0.5          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.5          0.5          0.0          0.0\n",
    "     32                44422.67              143127.65               51232.54               48076.24                                                B    000h04min30.000s\n",
    "     32                43379.91              143127.65               52188.96               48076.24                                                B     (99%)\n",
    "     32                39615.05              143127.65               46424.92               43268.62        0.388                         48173.65  B\n",
    "                                                             2021   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.5    2.8   0.5    2.7   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.5    4.1   0.5    3.4   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.5    1.3   0.0    0.0   0.0    0.0   0.5    0.3\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.5          0.5          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.5          0.5          0.0          0.0\n",
    "                                                             2029   0.5          0.0          0.0          0.5\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "     33                44422.67              143622.07               51232.54               48076.24                                                B    000h04min38.000s\n",
    "     33                43379.91              143622.07               52188.96               48076.24                                                B     (99%)\n",
    "     33                39615.05              143622.07               46424.92               43268.62        0.345                         48033.69  B\n",
    "                                                             2021   1.0    4.2   0.5    0.6   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.5    0.4   0.5    2.7   0.0    0.0   0.5    0.2\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   1.0          0.5          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.5          0.5          0.0          0.5\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "     34                44422.67              144727.64               51232.54               48076.24                                                B    000h04min40.000s\n",
    "     34                43379.91              144727.64               52188.96               48076.24                                                B     (99%)\n",
    "     34                39615.05              144727.64               46424.92               43268.62        0.770                         48453.74  B\n",
    "                                                             2021   1.0    2.3   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.5    2.6   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   1.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.5          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "     35                44422.67              145164.16               51232.54               48076.24                                                B    000h04min58.000s\n",
    "     35                43379.91              145164.16               52188.96               48076.24                                                B     (99%)\n",
    "     35                39615.05              145164.16               46424.92               43268.62        0.302                         50531.61  B\n",
    "                                                             2021   0.5    2.9   0.5    3.5   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.5    1.4   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.5    0.5   0.5    5.3   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.5    6.1   0.5    0.9   0.0    0.0   0.5    0.4\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.5    1.5   0.5    4.5   0.5    0.1   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.5          0.5          0.0          0.0\n",
    "                                                             2022   0.0          0.5          0.0          0.0\n",
    "                                                             2023   0.5          0.5          0.0          0.0\n",
    "                                                             2024   0.5          0.5          0.0          0.5\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.5          0.5          0.5          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "     36                44422.67              145548.95               51232.54               48076.24                                                B    000h05min07.000s\n",
    "     36                43379.91              145548.95               52188.96               48076.24                                                B     (99%)\n",
    "     36                39615.05              145548.95               46424.92               43268.62        0.265                         48744.46  B\n",
    "                                                             2021   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.5    6.4   0.5    2.8   0.0    0.0   0.5    0.4\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.5    0.6   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.5    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.5          0.5          0.0          0.5\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.5          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.5          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "     37                44422.67              146652.45               51232.54               48076.24                                                B    000h05min28.000s\n",
    "     37                43379.91              146652.45               52188.96               48076.24                                                B     (99%)\n",
    "     37                39615.05              146652.45               46424.92               43268.62        0.758                         52025.08  B\n",
    "                                                             2021   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   1.0    3.0   1.0    4.3   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   1.0   18.9   1.0    6.1   0.0    0.0   0.5    0.5\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.5   13.2   0.5    5.9   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   1.0          1.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   1.0          1.0          0.0          0.5\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.5          0.5          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "     38                44422.67              146840.25               51232.54               48076.24                                                B    000h05min10.000s\n",
    "     38                43379.91              146840.25               52188.96               48076.24                                                B     (99%)\n",
    "     38                39615.05              146840.25               46424.92               43268.62        0.128                         46187.59  B\n",
    "                                                             2021   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.5    1.2   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.5   11.1   0.5    5.7   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.5    4.1   0.5    4.1   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.5          0.0          0.0\n",
    "                                                             2026   0.5          0.5          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.5          0.5          0.0          0.0\n",
    "     39                44422.67              147482.26               51232.54               48076.24                                                B    000h05min35.000s\n",
    "     39                43379.91              147482.26               52188.96               48076.24                                                B     (99%)\n",
    "     39                39615.05              147482.26               46424.92               43268.62        0.437                         49633.80  B\n",
    "                                                             2021   0.0    0.0   0.5    0.2   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.5    0.5   0.5    2.4   0.0    0.0   0.5    0.1\n",
    "                                                             2024   0.5    0.9   0.5    0.3   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.5    5.2   0.5    1.5   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.5    0.7   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.5    1.3   0.5    1.6   0.0    0.0   0.5    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.5          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.5          0.5          0.0          0.5\n",
    "                                                             2024   0.5          0.5          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.5          0.5          0.0          0.0\n",
    "                                                             2027   0.0          0.5          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.5          0.5          0.0          0.5\n",
    "     40                44422.67              147961.43               51232.54               48076.24                                                B    000h05min34.000s\n",
    "     40                43379.91              147961.43               52188.96               48076.24                                                B     (99%)\n",
    "     40                39615.05              147961.43               46424.92               43268.62        0.325                         46081.01  B\n",
    "                                                             2021   1.0    3.3   1.0    1.4   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   1.0          1.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "     41                44422.67              148664.94               51232.54               48076.24                                                B    000h05min43.000s\n",
    "     41                43379.91              148664.94               52188.96               48076.24                                                B     (99%)\n",
    "     41                39615.05              148664.94               46424.92               43268.62        0.475                         47303.74  B\n",
    "                                                             2021   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.5    2.1   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.5    0.9   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.5          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.5          0.0          0.0\n",
    "     42                44422.67              148900.98               51232.54               48076.24                                                B    000h06min02.000s\n",
    "     42                43379.91              148900.98               52188.96               48076.24                                                B     (99%)\n",
    "     42                39615.05              148900.98               46424.92               43268.62        0.159                         47726.93  B\n",
    "                                                             2021   0.5   10.8   1.0    1.7   0.0    0.0   0.5    0.2\n",
    "                                                             2022   1.0    1.2   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.5    0.1   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.5    4.2   0.0    0.0   0.0    0.0   0.5    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.5          1.0          0.0          0.5\n",
    "                                                             2022   1.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.5          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.5          0.0          0.0          0.5\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "     43                44422.67              149205.13               51232.54               48076.24                                                B    000h06min08.000s\n",
    "     43                43379.91              149205.13               52188.96               48076.24                                                B     (99%)\n",
    "     43                39615.05              149205.13               46424.92               43268.62        0.204                         51100.34  B\n",
    "                                                             2021   1.0    0.4   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.5    1.6   0.5    2.5   0.0    0.0   0.5    0.0\n",
    "                                                             2024   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.0    0.0   0.5    0.4   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.5    0.1   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   1.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.5          0.5          0.0          0.5\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.5          0.0          0.0\n",
    "                                                             2030   0.0          0.5          0.0          0.0\n",
    "     44                44422.67              149719.11               51232.54               48076.24                                                B    000h06min08.000s\n",
    "     44                43379.91              149719.11               52188.96               48076.24                                                B     (99%)\n",
    "     44                39615.05              149719.11               46424.92               43268.62        0.344                         47536.97  B\n",
    "                                                             2021   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.5    2.7   0.5    0.9   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.5    2.6   0.5    2.5   0.0    0.0   0.0    0.0\n",
    "                                                             2025   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   1.0   37.6   1.0   11.4   0.0    0.0   1.0    0.2\n",
    "                                                             2028   0.5    0.9   0.5    2.5   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.5    1.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.5          0.5          0.0          0.0\n",
    "                                                             2024   0.5          0.5          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   1.0          1.0          0.0          1.0\n",
    "                                                             2028   0.5          0.5          0.0          0.0\n",
    "                                                             2029   0.5          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "     45                44422.67              150140.18               51232.54               48076.24                                                B    000h06min17.000s\n",
    "     45                43379.91              150140.18               52188.96               48076.24                                                B     (99%)\n",
    "     45                39615.05              150140.18               46424.92               43268.62        0.281                         48050.70  B\n",
    "                                                             2021   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2022   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2023   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2024   0.5    5.0   0.5    2.5   0.0    0.0   0.5    0.1\n",
    "                                                             2025   0.5   19.3   0.5    1.0   0.0    0.0   0.5    0.3\n",
    "                                                             2026   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2027   0.5   16.1   0.5    9.5   0.0    0.0   0.5    0.6\n",
    "                                                             2028   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                             2029   0.5    5.6   0.5    1.7   0.0    0.0   0.5    0.0\n",
    "                                                             2030   0.0    0.0   0.0    0.0   0.0    0.0   0.0    0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE MAQUINA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.0          0.0          0.0          0.0\n",
    "                                                             2025   0.0          0.0          0.0          0.0\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.0          0.0          0.0          0.0\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.0          0.0          0.0          0.0\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "                                                                               RISCO DE DEFICIT POR FALTA DE AGUA (%)\n",
    "                                                             2021   0.0          0.0          0.0          0.0\n",
    "                                                             2022   0.0          0.0          0.0          0.0\n",
    "                                                             2023   0.0          0.0          0.0          0.0\n",
    "                                                             2024   0.5          0.5          0.0          0.5\n",
    "                                                             2025   0.5          0.5          0.0          0.5\n",
    "                                                             2026   0.0          0.0          0.0          0.0\n",
    "                                                             2027   0.5          0.5          0.0          0.5\n",
    "                                                             2028   0.0          0.0          0.0          0.0\n",
    "                                                             2029   0.5          0.5          0.0          0.5\n",
    "                                                             2030   0.0          0.0          0.0          0.0\n",
    "\n",
    "\n",
]

MockBlocoConfiguracoesExpansaoEntradaReservatorioPMO = [
    "        CONFIGURACOES POR ENTRADA DE RESERVATORIO E/OU POR POTENCIA DE BASE\n",
    "\n",
    "    X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----\n",
    "      ANO    1     2     3     4     5     6     7     8     9    10    11    12\n",
    "    X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----\n",
    "\n",
    "      2021   1     2     3     4     5     6     7     8     9    10    11    12\n",
    "      2022  13    14    15    16    17    18    19    20    21    22    23    24\n",
    "      2023  25    26    27    28    29    30    31    32    33    34    35    36\n",
    "      2024  37    38    39    40    41    42    43    44    45    46    47    48\n",
    "      2025  49    50    51    52    53    54    55    56    57    58    59    60\n",
    "      2026  60    60    60    60    60    60    60    60    60    60    60    60\n",
    "      2027  60    60    60    60    60    60    60    60    60    60    60    60\n",
    "      2028  60    60    60    60    60    60    60    60    60    60    60    60\n",
    "      2029  60    60    60    60    60    60    60    60    60    60    60    60\n",
    "      2030  60    60    60    60    60    60    60    60    60    60    60    60\n",
    "\n",
    "                 X----------X----------X----------X--------------X\n",
]

MockBlocoConfiguracoesExpansaoAlteracaoPotenciaPMO = [
    "        CONFIGURACOES POR ALTERACAO DE POTENCIA\n",
    "\n",
    "    X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----\n",
    "      ANO    1     2     3     4     5     6     7     8     9    10    11    12\n",
    "    X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----\n",
    "\n",
    "      2021   1     2     3     4     5     6     7     8     9    10    11    12\n",
    "      2022  13    14    15    16    17    18    19    20    21    22    23    24\n",
    "      2023  25    26    27    28    29    30    31    32    33    34    35    36\n",
    "      2024  37    38    39    40    41    42    43    44    45    46    47    48\n",
    "      2025  49    50    51    52    53    54    55    56    57    58    59    60\n",
    "      2026  60    60    60    60    60    60    60    60    60    60    60    60\n",
    "      2027  60    60    60    60    60    60    60    60    60    60    60    60\n",
    "      2028  60    60    60    60    60    60    60    60    60    60    60    60\n",
    "      2029  60    60    60    60    60    60    60    60    60    60    60    60\n",
    "      2030  60    60    60    60    60    60    60    60    60    60    60    60\n",
    "\n",
    "                 X----------X----------X----------X--------------X\n",
]

MockBlocoConfiguracoesExpansaoQualquerModificacaoPMO = [
    "        CONFIGURACOES POR QUALQUER MODIFICACAO NA EXPANSAO\n",
    "\n",
    "    X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----\n",
    "      ANO    1     2     3     4     5     6     7     8     9    10    11    12\n",
    "    X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----X-----\n",
    "\n",
    "      2021   1     2     3     4     5     6     7     8     9    10    11    12\n",
    "      2022  13    14    15    16    17    18    19    20    21    22    23    24\n",
    "      2023  25    26    27    28    29    30    31    32    33    34    35    36\n",
    "      2024  37    38    39    40    41    42    43    44    45    46    47    48\n",
    "      2025  49    50    51    52    53    54    55    56    57    58    59    60\n",
    "      2026  60    60    60    60    60    60    60    60    60    60    60    60\n",
    "      2027  60    60    60    60    60    60    60    60    60    60    60    60\n",
    "      2028  60    60    60    60    60    60    60    60    60    60    60    60\n",
    "      2029  60    60    60    60    60    60    60    60    60    60    60    60\n",
    "      2030  60    60    60    60    60    60    60    60    60    60    60    60\n",
    "\n",
    "                 X----------X----------X----------X--------------X\n",
]


MockBlocoMARSPMOInicial = [
    " PARAMETROS DAS RETAS DE PERDAS POR ENGOLIMENTO MAXIMO\n",
    "\n",
    " REE: SUDESTE     \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.74069E-01 -0.49159E+02\n",
    "       2       0.34519E+00 -0.40840E+03\n",
    "       3       0.76866E+00 -0.13989E+04\n",
    "\n",
    " REE: MADEIRA     \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.20370E-03 -0.28271E+00\n",
    "       2       0.31330E-01 -0.13221E+03\n",
    "       3       0.98680E+00 -0.72860E+04\n",
    "\n",
    " REE: TPIRES      \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.11072E-04 -0.57625E-02\n",
    "       2       0.81132E-01 -0.15856E+03\n",
    "       3       0.94368E+00 -0.21433E+04\n",
    "\n",
    " REE: ITAIPU      \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.00000E+00  0.00000E+00\n",
    "       2       0.00000E+00  0.00000E+00\n",
    "       3       0.10000E+01 -0.12799E+05\n",
    "\n",
    " REE: PARANA      \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.00000E+00  0.00000E+00\n",
    "       2       0.10278E+00 -0.86478E+02\n",
    "       3       0.10278E+00 -0.86478E+02\n",
    "\n",
    " REE: PRNPANEMA   \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.00000E+00  0.00000E+00\n",
    "       2       0.24274E-01 -0.63761E+01\n",
    "       3       0.43558E+00 -0.22163E+03\n",
    "\n",
    " REE: SUL         \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.16424E+00 -0.78833E+02\n",
    "       2       0.50409E+00 -0.66132E+03\n",
    "       3       0.95055E+00 -0.29173E+04\n",
    "\n",
    " REE: IGUACU      \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.47597E-03 -0.12112E+00\n",
    "       2       0.59085E+00 -0.91800E+03\n",
    "       3       0.90216E+00 -0.14231E+04\n",
    "\n",
    " REE: NORDESTE    \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.40895E-01 -0.34172E+01\n",
    "       2       0.53849E+00 -0.21447E+03\n",
    "       3       0.73587E+00 -0.48139E+03\n",
    "\n",
    " REE: NORTE       \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.00000E+00  0.00000E+00\n",
    "       2       0.00000E+00  0.00000E+00\n",
    "       3       0.10000E+01 -0.10454E+04\n",
    "\n",
    " REE: BMONTE      \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.00000E+00  0.00000E+00\n",
    "       2       0.20996E-01 -0.56927E+02\n",
    "       3       0.97998E+00 -0.10643E+05\n",
    "\n",
    " REE: MAN-AP      \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.31772E-01 -0.47415E+01\n",
    "       2       0.26467E+00 -0.82861E+02\n",
    "       3       0.93654E+00 -0.73238E+03\n",
    "\n",
    ' REE: SUDESTE      ENERGIA FIO D"AGUA LIQUIDA (MWmes)   CONFIGURACAO DO PERIODO: FEV/2021\n',
    "             JAN      FEV      MAR      ABR      MAI      JUN      JUL      AGO      SET      OUT      NOV      DEZ\n",
    "     1931   1602.6   1014.0   1988.2   2187.6   1955.1   1536.5   1264.5   1119.3   1131.8   1502.7   1928.1   1729.0\n",
]

MockBlocoMARSPMOFinal = [
    " PARAMETROS DAS RETAS DE PERDAS POR ENGOLIMENTO MAXIMO\n",
    "\n",
    " REE: SUDESTE     \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.74069E-01 -0.49159E+02\n",
    "       2       0.34519E+00 -0.40840E+03\n",
    "       3       0.76866E+00 -0.13989E+04\n",
    "\n",
    " REE: MADEIRA     \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.25071E-01 -0.64928E+02\n",
    "       2       0.92867E+00 -0.67940E+04\n",
    "       3       0.99848E+00 -0.74155E+04\n",
    "\n",
    " REE: TPIRES      \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.11072E-04 -0.57625E-02\n",
    "       2       0.81132E-01 -0.15856E+03\n",
    "       3       0.94368E+00 -0.21433E+04\n",
    "\n",
    " REE: ITAIPU      \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.00000E+00  0.00000E+00\n",
    "       2       0.00000E+00  0.00000E+00\n",
    "       3       0.10000E+01 -0.12799E+05\n",
    "\n",
    " REE: PARANA      \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.00000E+00  0.00000E+00\n",
    "       2       0.10278E+00 -0.86478E+02\n",
    "       3       0.10278E+00 -0.86478E+02\n",
    "\n",
    " REE: PRNPANEMA   \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.00000E+00  0.00000E+00\n",
    "       2       0.24274E-01 -0.63761E+01\n",
    "       3       0.43558E+00 -0.22163E+03\n",
    "\n",
    " REE: SUL         \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.16424E+00 -0.78833E+02\n",
    "       2       0.50409E+00 -0.66132E+03\n",
    "       3       0.95055E+00 -0.29173E+04\n",
    "\n",
    " REE: IGUACU      \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.47597E-03 -0.12112E+00\n",
    "       2       0.59085E+00 -0.91800E+03\n",
    "       3       0.90216E+00 -0.14231E+04\n",
    "\n",
    " REE: NORDESTE    \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.40895E-01 -0.34172E+01\n",
    "       2       0.53849E+00 -0.21447E+03\n",
    "       3       0.73587E+00 -0.48139E+03\n",
    "\n",
    " REE: NORTE       \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.00000E+00  0.00000E+00\n",
    "       2       0.00000E+00  0.00000E+00\n",
    "       3       0.10000E+01 -0.10454E+04\n",
    "\n",
    " REE: BMONTE      \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.00000E+00  0.00000E+00\n",
    "       2       0.20996E-01 -0.56927E+02\n",
    "       3       0.97998E+00 -0.10643E+05\n",
    "\n",
    " REE: MAN-AP      \n",
    "\n",
    "X------------X------------X------------X\n",
    "     RETA       COEF.ANG       CTE          \n",
    "X------------X------------X------------X\n",
    "       1       0.31772E-01 -0.47415E+01\n",
    "       2       0.26467E+00 -0.82861E+02\n",
    "       3       0.93654E+00 -0.73238E+03\n",
    "\x0c\n",
    " CEPEL                         MODELO ESTRATEGICO DE GERACAO HIDROTERMICA A SUBSISTEMAS              VERSAO  27.5.1_CPAMP_L                          \n",
    "                                                                                                         PAG.  18\n",
]

MockBlocoRiscoDeficitENSPMO = [
    "                        RISCO ANUAL DE DEFICIT E E(ENS) (%)\n",
    "                                   SUBSISTEMA\n",
    "\n",
    "      SUDESTE       SUL           NORDESTE      NORTE     \n",
    " ANO  RISCO   EENS  RISCO   EENS  RISCO   EENS  RISCO   EENS  \n",
    "        %    MWMES    %    MWMES    %    MWMES    %    MWMES    \n",
    "X----X-----X-------X-----X-------X-----X-------X-----X-------X\n",
    " 2021   0.00     0.0  0.00     0.0  0.00     0.0  0.00     0.0\n",
    " 2022   0.00     0.0  0.00     0.0  0.00     0.0  0.00     0.0\n",
    " 2023   0.00     0.0  0.00     0.0  0.00     0.0  0.00     0.0\n",
    " 2024   0.00     0.0  0.00     0.0  0.00     0.0  0.00     0.0\n",
    " 2025   0.00     0.0  0.00     0.0  0.00     0.0  0.00     0.0\n",
    "\n",
    "     MEDIA DOS RISCOS ANUAIS DE DEFICIT (%) E E(ENS) - PERIODO DE PLANEJAMENTO\n",
    "        0.00     0.0  0.00     0.0  0.00     0.0  0.00     0.0\n",
]

MockBlocoCustoOperacaoPMO = [
    "                PARCELA           V.ESPERADO  D.P. DO V.E.     %\n",
    "            X------------------X-------------X-------------X-------X\n",
    "             GERACAO TERMICA        21887.91         89.62   98.05\n",
    "             DEFICIT                    0.00          0.00    0.00\n",
    "             VERTIMENTO                 0.87          0.01    0.00\n",
    "             EXCESSO ENERGIA            0.00          0.00    0.00\n",
    "             VIOLACAO CAR             201.30         11.02    0.90\n",
    "             VIOLACAO SAR               0.00          0.00    0.00\n",
    "             VIOL. OUTROS USOS         19.90          1.87    0.09\n",
    "             VIOLACAO EVMIN            90.00          6.47    0.40\n",
    "             VIOLACAO VZMIN             0.00          0.00    0.00\n",
    "             INTERCAMBIO                1.65          0.01    0.01\n",
    "             VIOL. INTERC. MIN.         0.00          0.00    0.00\n",
    "             VERT. FIO N. TURB.         1.20          0.01    0.01\n",
    "             VIOLACAO GHMIN           120.34         31.96    0.54\n",
    "             VIOLACAO GHMINU            0.00          0.00    0.00\n",
    "             VIOLACAO RETIRADA          0.00          0.00    0.00\n",
    "             VIOLACAO EMIS. GEE         0.00          0.00    0.00\n",
    "             CORTE GER. EOLICA          0.00          0.00    0.00\n",
    "            X------------------X-------------X-------------X-------X\n",
    "\n",
    "\n",
]

MockBlocoCustoOperacaoTotalPMO = [
    "                            VALOR ESPERADO TOTAL:                 22323.17\n",
    "                 DESVIO PADRAO DO VALOR ESPERADO:                   107.00\n",
    "\n",
    "\n",
]

MockPMO = (
    MockBlocoEafPastTendenciaHidrolPMO
    + MockBlocoEafPastCfugaMedioPMO
    + MockBlocoConvergenciaPMO
    + MockBlocoConfiguracoesExpansaoEntradaReservatorioPMO
    + MockBlocoConfiguracoesExpansaoAlteracaoPotenciaPMO
    + MockBlocoConfiguracoesExpansaoQualquerModificacaoPMO
    + MockBlocoMARSPMOInicial
    + MockBlocoMARSPMOFinal
    + MockBlocoRiscoDeficitENSPMO
    + MockBlocoCustoOperacaoPMO
    + MockBlocoCustoOperacaoPMO
    + MockBlocoCustoOperacaoPMO
    + MockBlocoCustoOperacaoTotalPMO
)
