from .ApiMethod import ApiMethod


class Likes(ApiMethod):
    def __init__(self, access_token, v, session, calls_per_second):
        super(Likes, self).__init__(access_token, v, session, calls_per_second)
        self._base_method = 'likes.'

    def add(self, type: str = None, owner_id: str = None, item_id: str = None, access_key: str = None) -> dict:
        """
        Добавляет указанный объект в список Мне нравится текущего пользователя.

        :param type: тип объекта.  Возможные типы: post — запись на стене пользователя или группы; comment —
            комментарий к записи на стене; photo — фотография; audio — аудиозапись; video — видеозапись; note —
            заметка; market — товар; photo_comment — комментарий к фотографии; video_comment — комментарий к
            видеозаписи; topic_comment — комментарий в обсуждении; market_comment — комментарий к товару;
        :param owner_id: идентификатор владельца объекта.
        :param item_id: идентификатор объекта.
        :param access_key: ключ доступа в случае работы с приватными объектами.

        :return: В случае успеха возвращает объект с полем likes, в котором находится текущее количество
            пользователей, которые добавили данный объект в свой список Мне нравится
        """

        params = locals()
        method_name = self._base_method + 'add'
        return self._call(method_name, params)

    def delete(self, type: str = None, owner_id: str = None, item_id: str = None, access_key: str = None) -> dict:
        """
        Удаляет указанный объект из списка Мне нравится текущего пользователя

        :param type: тип объекта.  Возможные типы: post — запись на стене пользователя или группы; comment —
            комментарий к записи на стене; photo — фотография; audio — аудиозапись; video — видеозапись; note —
            заметка; photo_comment — комментарий к фотографии; video_comment — комментарий к видеозаписи;
            topic_comment — комментарий в обсуждении; sitepage — страница сайта, на котором установлен виджет «Мне
            нравится».
        :param owner_id: идентификатор владельца объекта.
        :param item_id: идентификатор объекта.
        :param access_key:

        :return: В случае успеха возвращает объект с полем likes, в котором находится текущее количество
            пользователей, которые добавили данный объект в свой список Мне нравится
        """

        params = locals()
        method_name = self._base_method + 'delete'
        return self._call(method_name, params)

    def getList(self, type: str = None, owner_id: str = None, item_id: str = None, page_url: str = None,
                filter: str = None, friends_only: str = None, extended: str = None, offset: str = None,
                count: str = None, skip_own: str = None) -> dict:
        """
        Получает список идентификаторов пользователей, которые добавили заданный объект в свой список Мне нравится.

        :param type: тип объекта.  Возможные типы: post — запись на стене пользователя или группы; comment —
            комментарий к записи на стене; photo — фотография; audio — аудиозапись; video — видеозапись; note —
            заметка; market — товар; photo_comment — комментарий к фотографии; video_comment — комментарий к
            видеозаписи; topic_comment — комментарий в обсуждении; market_comment — комментарий к товару; sitepage —
            страница сайта, на котором установлен виджет «Мне нравится».
        :param owner_id: идентификатор владельца Like-объекта: id пользователя, id сообщества (со знаком «минус»)
            или id приложения. Если параметр type равен sitepage, то в качестве owner_id необходимо передавать id
            приложения. Если параметр не задан, то считается, что он равен либо идентификатору текущего пользователя,
            либо идентификатору текущего приложения (если type равен sitepage).
        :param item_id: идентификатор Like-объекта. Если type равен sitepage, то параметр item_id может содержать
            значение параметра page_id, используемый при инициализации виджета «Мне нравится».
        :param page_url: url страницы, на которой установлен виджет «Мне нравится». Используется вместо параметра
            item_id, если при размещении виджета не был указан page_id.
        :param filter: указывает, следует ли вернуть всех пользователей, добавивших объект в список "Мне
            нравится" или только тех, которые рассказали о нем друзьям. Параметр может принимать следующие значения:
            likes — возвращать информацию обо всех пользователях;  copies — возвращать информацию только о
            пользователях, рассказавших об объекте друзьям. По умолчанию возвращается информация обо всех
            пользователях.
        :param friends_only: указывает, необходимо ли возвращать только пользователей, которые являются друзьями
            текущего пользователя. Параметр может принимать следующие значения:   0 — возвращать всех пользователей в
            порядке убывания времени добавления объекта;  1 — возвращать только друзей текущего пользователя в
            порядке убывания времени добавления объекта; Если метод был вызван без авторизации или параметр не был
            задан, то считается, что он равен 0.
        :param extended: 1 — возвращать расширенную информацию о пользователях и сообществах из списка
            поставивших отметку «Мне нравится» или сделавших репост. По умолчанию — 0.
        :param offset: смещение, относительно начала списка, для выборки определенного подмножества. Если
            параметр не задан, то считается, что он равен 0.
        :param count: количество возвращаемых идентификаторов пользователей. Если параметр не задан, то
            считается, что он равен 100, если не задан параметр friends_only, в противном случае 10. Максимальное
            значение параметра 1000, если не задан параметр friends_only, в противном случае 100.
        :param skip_own: не возвращать самого пользователя.

        :return: После успешного выполнения возвращает список идентификаторов пользователей с учетом параметров
            offset и count, которые добавили заданный объект в свой список Мне нравится.  Если параметр type равен
            sitepage, то будет возвращён список пользователей, воспользовавшихся виджетом «Мне нравится» на внешнем
            сайте. Адрес страницы задаётся при помощи параметра page_url или item_id.  Если extended=1, дополнительно
            возвращается массив items, содержащий расширенную информацию о пользователях или сообществах
        """

        params = locals()
        method_name = self._base_method + 'getList'
        return self._call(method_name, params)

    def isLiked(self, user_id: str = None, type: str = None, owner_id: str = None, item_id: str = None) -> dict:
        """
        Проверяет, находится ли объект в списке Мне нравится заданного пользователя.

        :param user_id: идентификатор пользователя, у которого необходимо проверить наличие объекта в списке «Мне
            нравится». Если параметр не задан, то считается, что он равен идентификатору текущего пользователя.
        :param type: тип объекта.  Возможные типы: post — запись на стене пользователя или группы; comment —
            комментарий к записи на стене; photo — фотография; audio — аудиозапись; video — видеозапись; note —
            заметка; photo_comment — комментарий к фотографии; video_comment — комментарий к видеозаписи;
            topic_comment — комментарий в обсуждении;
        :param owner_id: идентификатор владельца Like-объекта. Если параметр не задан, то считается, что он равен
            идентификатору текущего пользователя.  Обратите внимание, идентификатор сообщества в параметре owner_id
            необходимо указывать со знаком "-" — например, owner_id=-1 соответствует идентификатору сообщества
            ВКонтакте API (club1)
        :param item_id: идентификатор объекта.

        :return: В случае успеха возвращает объект с полями:   liked — есть ли отметка «Мне нравится» от текущего
            пользователя (0 — отметки нет, 1 — отметка есть);  copied — сделан ли репост текущим пользователем (0 —
            не сделан, 1 — сделан)
        """

        params = locals()
        method_name = self._base_method + 'isLiked'
        return self._call(method_name, params)
