"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Comprehendmedical = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [comprehendmedical](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehendmedical.html).
 *
 * @experimental
 */
class Comprehendmedical extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [comprehendmedical](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehendmedical.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'comprehendmedical';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Read": [
                "DescribeEntitiesDetectionV2Job",
                "DescribeICD10CMInferenceJob",
                "DescribePHIDetectionJob",
                "DescribeRxNormInferenceJob",
                "DetectEntitiesV2",
                "DetectPHI",
                "InferICD10CM",
                "InferRxNorm",
                "ListEntitiesDetectionV2Jobs",
                "ListICD10CMInferenceJobs",
                "ListPHIDetectionJobs",
                "ListRxNormInferenceJobs"
            ],
            "Write": [
                "StartEntitiesDetectionV2Job",
                "StartICD10CMInferenceJob",
                "StartPHIDetectionJob",
                "StartRxNormInferenceJob",
                "StopEntitiesDetectionV2Job",
                "StopICD10CMInferenceJob",
                "StopPHIDetectionJob",
                "StopRxNormInferenceJob"
            ]
        };
    }
    /**
     * (experimental) Grants permission to describe the properties of a medical entity detection job that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_DescribeEntitiesDetectionV2Job.html
     *
     * @experimental
     */
    toDescribeEntitiesDetectionV2Job() {
        return this.to('DescribeEntitiesDetectionV2Job');
    }
    /**
     * (experimental) Grants permission to describe the properties of an ICD-10-CM linking job that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_DescribeICD10CMInferenceJob.html
     *
     * @experimental
     */
    toDescribeICD10CMInferenceJob() {
        return this.to('DescribeICD10CMInferenceJob');
    }
    /**
     * (experimental) Grants permission to describe the properties of a PHI entity detection job that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_DescribePHIDetectionJob.html
     *
     * @experimental
     */
    toDescribePHIDetectionJob() {
        return this.to('DescribePHIDetectionJob');
    }
    /**
     * (experimental) Grants permission to describe the properties of an RxNorm linking job that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_DescribeRxNormInferenceJob.html
     *
     * @experimental
     */
    toDescribeRxNormInferenceJob() {
        return this.to('DescribeRxNormInferenceJob');
    }
    /**
     * (experimental) Grants permission to detect the named medical entities, and their relationships and traits within the given text document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_DetectEntitiesV2.html
     *
     * @experimental
     */
    toDetectEntitiesV2() {
        return this.to('DetectEntitiesV2');
    }
    /**
     * (experimental) Grants permission to detect the protected health information (PHI) entities within the given text document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_DetectPHI.html
     *
     * @experimental
     */
    toDetectPHI() {
        return this.to('DetectPHI');
    }
    /**
     * (experimental) Grants permission to detect the medical condition entities within the given text document and link them to ICD-10-CM codes.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_InferICD10CM.html
     *
     * @experimental
     */
    toInferICD10CM() {
        return this.to('InferICD10CM');
    }
    /**
     * (experimental) Grants permission to detect the medication entities within the given text document and link them to RxCUI concept identifiers from the National Library of Medicine RxNorm database.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_InferRxNorm.html
     *
     * @experimental
     */
    toInferRxNorm() {
        return this.to('InferRxNorm');
    }
    /**
     * (experimental) Grants permission to list the medical entity detection jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_ListEntitiesDetectionV2Jobs.html
     *
     * @experimental
     */
    toListEntitiesDetectionV2Jobs() {
        return this.to('ListEntitiesDetectionV2Jobs');
    }
    /**
     * (experimental) Grants permission to list the ICD-10-CM linking jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_ListICD10CMInferenceJobs.html
     *
     * @experimental
     */
    toListICD10CMInferenceJobs() {
        return this.to('ListICD10CMInferenceJobs');
    }
    /**
     * (experimental) Grants permission to list the PHI entity detection jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_ListPHIDetectionJobs.html
     *
     * @experimental
     */
    toListPHIDetectionJobs() {
        return this.to('ListPHIDetectionJobs');
    }
    /**
     * (experimental) Grants permission to list the RxNorm linking jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_ListRxNormInferenceJobs.html
     *
     * @experimental
     */
    toListRxNormInferenceJobs() {
        return this.to('ListRxNormInferenceJobs');
    }
    /**
     * (experimental) Grants permission to start an asynchronous medical entity detection job for a collection of documents.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StartEntitiesDetectionV2Job.html
     *
     * @experimental
     */
    toStartEntitiesDetectionV2Job() {
        return this.to('StartEntitiesDetectionV2Job');
    }
    /**
     * (experimental) Grants permission to start an asynchronous ICD-10-CM linking job for a collection of documents.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StartICD10CMInferenceJob.html
     *
     * @experimental
     */
    toStartICD10CMInferenceJob() {
        return this.to('StartICD10CMInferenceJob');
    }
    /**
     * (experimental) Grants permission to start an asynchronous PHI entity detection job for a collection of documents.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StartPHIDetectionJob.html
     *
     * @experimental
     */
    toStartPHIDetectionJob() {
        return this.to('StartPHIDetectionJob');
    }
    /**
     * (experimental) Grants permission to start an asynchronous RxNorm linking job for a collection of documents.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StartRxNormInferenceJob.html
     *
     * @experimental
     */
    toStartRxNormInferenceJob() {
        return this.to('StartRxNormInferenceJob');
    }
    /**
     * (experimental) Grants permission to stop a medical entity detection job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StopEntitiesDetectionV2Job.html
     *
     * @experimental
     */
    toStopEntitiesDetectionV2Job() {
        return this.to('StopEntitiesDetectionV2Job');
    }
    /**
     * (experimental) Grants permission to stop an ICD-10-CM linking job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StopICD10CMInferenceJob.html
     *
     * @experimental
     */
    toStopICD10CMInferenceJob() {
        return this.to('StopICD10CMInferenceJob');
    }
    /**
     * (experimental) Grants permission to stop a PHI entity detection job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StopPHIDetectionJob.html
     *
     * @experimental
     */
    toStopPHIDetectionJob() {
        return this.to('StopPHIDetectionJob');
    }
    /**
     * (experimental) Grants permission to stop an RxNorm linking job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StopRxNormInferenceJob.html
     *
     * @experimental
     */
    toStopRxNormInferenceJob() {
        return this.to('StopRxNormInferenceJob');
    }
}
exports.Comprehendmedical = Comprehendmedical;
_a = JSII_RTTI_SYMBOL_1;
Comprehendmedical[_a] = { fqn: "iam-floyd.Comprehendmedical", version: "0.252.0" };
//# sourceMappingURL=data:application/json;base64,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