"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithResources = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _3_actions_1 = require("./3-actions");
/**
 * (experimental) Adds "resource" functionality to the Policy Statement.
 *
 * @experimental
 */
class PolicyStatementWithResources extends _3_actions_1.PolicyStatementWithActions {
    constructor() {
        super(...arguments);
        this.useNotResources = false;
        /**
         * @experimental
         */
        this.resources = [];
        /**
         * @experimental
         */
        this.skipAutoResource = false;
        this.cdkResourcesApplied = false;
    }
    /**
     * (experimental) Injects resources into the statement.
     *
     * Only relevant for the main package. In CDK mode this only calls super.
     *
     * @experimental
     */
    toJSON() {
        // @ts-ignore only available after swapping 1-base
        if (typeof this.addResources == 'function') {
            this.cdkApplyResources();
            return super.toJSON();
        }
        const mode = this.useNotResources ? 'NotResource' : 'Resource';
        const statement = super.toJSON();
        const self = this;
        this.ensureResource();
        if (this.resources.length) {
            const resources = this.resources.filter((elem, pos) => {
                return self.resources.indexOf(elem) == pos;
            });
            statement[mode] = resources.length > 1 ? resources : resources[0];
        }
        return statement;
    }
    /**
     * @experimental
     */
    toStatementJson() {
        this.ensureResource();
        this.cdkApplyResources();
        // @ts-ignore only available after swapping 1-base
        return super.toStatementJson();
    }
    cdkApplyResources() {
        if (!this.cdkResourcesApplied) {
            const mode = this.useNotResources ? 'addNotResources' : 'addResources';
            const self = this;
            const uniqueResources = this.resources.filter((elem, pos) => {
                return self.resources.indexOf(elem) == pos;
            });
            // @ts-ignore only available after swapping 1-base
            this[mode](...uniqueResources);
            this.cdkResourcesApplied = true;
        }
    }
    /**
     * (experimental) Switches the statement to use [`NotResource`](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notresource.html).
     *
     * @experimental
     */
    notResources() {
        this.useNotResources = true;
        return this;
    }
    /**
     * (experimental) Checks weather any resource was applied to the policy.
     *
     * @experimental
     */
    hasResources() {
        return this.resources.length > 0;
    }
    /**
     * (experimental) Limit statement to specified resources.
     *
     * To allow all resources, pass `*`
     *
     * @experimental
     */
    on(...arns) {
        this.resources.push(...arns);
        return this;
    }
    /**
     * (experimental) Add all resources (`*`) to the statement.
     *
     * This is the default behavior, unless the statement has principals.
     *
     * @experimental
     */
    onAllResources() {
        this.resources.push('*');
        return this;
    }
    ensureResource() {
        if (this.hasResources())
            return;
        // @ts-ignore only available after swapping 1-base
        if (this.hasResource)
            return;
        // @ts-ignore only available after swapping 1-base
        if (this.hasPrincipal)
            return; //assume policies may not have resources
        if (this.skipAutoResource)
            return;
        // a statement requires resources. if none was added, we assume the user wants all resources
        this.onAllResources();
    }
    /**
     * (experimental) Dummy method. Will be overridden by 6-principal.ts.
     *
     * We just need it here so we can reference it in method `ensureResource`
     *
     * @experimental
     */
    hasPrincipals() {
        return false;
    }
}
exports.PolicyStatementWithResources = PolicyStatementWithResources;
_a = JSII_RTTI_SYMBOL_1;
PolicyStatementWithResources[_a] = { fqn: "iam-floyd.PolicyStatementWithResources", version: "0.252.0" };
//# sourceMappingURL=data:application/json;base64,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