"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const iam = require("@aws-cdk/aws-iam");
const core_2 = require("@aws-solutions-constructs/core");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-iot-sqs';
// Definitions
const props = {
    deadLetterQueueProps: {
        queueName: 'max-receive-count-test-dlq-name'
    },
    deployDeadLetterQueue: true,
    maxReceiveCount: 1,
    queueProps: {
        queueName: 'max-receive-count-test-queue-name'
    },
    iotTopicRuleProps: {
        topicRulePayload: {
            ruleDisabled: false,
            description: "Processing messages from IoT devices or factory machines",
            sql: "SELECT * FROM 'test/topic/#'",
            actions: []
        }
    }
};
const iotToSqsStack = new lib_1.IotToSqs(stack, 'test-iot-sqs-stack', props);
// Grant yourself permissions to use the Customer Managed KMS Key
const policyStatement = new iam.PolicyStatement({
    actions: ["kms:Encrypt", "kms:Decrypt"],
    effect: iam.Effect.ALLOW,
    principals: [new iam.AccountRootPrincipal()],
    resources: ["*"]
});
iotToSqsStack.encryptionKey?.addToResourcePolicy(policyStatement);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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