# Contribution Guidelines

## Issues

Issues are very valuable to this project.

* Ideas are a valuable source of contributions others can make
* Problems show where this project is lacking
* With a question you show where contributors can improve the user experience

Thank you for creating them.

## Pull Requests

Pull requests are a great way to get your ideas into this repository.

When deciding if we merge in a pull request we look at the following things:

### Automatic checks

Keep in mind that we have automatic checks configured for this project. We won't merge your PR unless it:
- passes all the unit tests
- passes all the style checks
- doesn't decrease the test coverage

To make development and contribution easier, we've added pre-commit hooks. This mechanisms prevents you from commiting any code that doesn't comply with our style guides.
You can find more details on ["pre-commit" project's website](https://pre-commit.com).

### Description

Please follow a pull request template to include all the necessary information. A detailed description of your contribution will allow us to react to it faster.

### Does it follow the code of conduct.

This repository has a [code of conduct](docs/CODE_OF_CONDUCT.md), we will remove things that do not respect it.

