from .常量 import 常量
from .音韻地位 import 音韻地位

'''
注意！！
此檔案是半成品，僅供臨時使用。
在 `_韻圖.py` 使用了 `韻圖2切韻` 這一函式。
未來寫好後，此檔案將被移除。
'''

def normalize韻(韻):
    '''
    TODO: 1. 檢查韻典網錯誤
    2. 異體字 normalize
    '''
    return {
        '東': '東',
        '冬': '冬',
        '鍾': '鍾',
        '江': '江',
        '支': '支',
        '脂': '脂',
        '之': '之',
        '微': '微',
        '魚': '魚',
        '虞': '虞',
        '模': '模',
        '齊': '齊',
        '佳': '佳',
        '皆': '皆',
        '灰': '灰',
        '咍': '咍',
        '眞': '眞',
        '諄': '眞',
        '臻': '臻',
        '文': '文',
        '欣': '欣',
        '元': '元',
        '魂': '魂',
        '痕': '痕',
        '寒': '寒',
        '桓': '桓',
        '刪': '刪',
        '山': '山',
        '先': '先',
        '仙': '仙',
        '蕭': '蕭',
        '宵': '宵',
        '肴': '肴',
        '豪': '豪',
        '歌': '歌',
        '戈': '歌',
        '麻': '麻',
        '陽': '陽',
        '唐': '唐',
        '庚': '庚',
        '耕': '耕',
        '清': '清',
        '青': '青',
        '蒸': '蒸',
        '登': '登',
        '尤': '尤',
        '侯': '侯',
        '幽': '幽',
        '侵': '侵',
        '覃': '覃',
        '談': '談',
        '鹽': '鹽',
        '添': '添',
        '咸': '咸',
        '銜': '銜',
        '嚴': '嚴',
        '凡': '凡',
        '董': '東',
        '腫': '鍾',
        '湩': '冬',
        '講': '江',
        '紙': '支',
        '旨': '脂',
        '止': '之',
        '尾': '微',
        '語': '魚',
        '麌': '虞',
        '姥': '模',
        '薺': '齊',
        '蟹': '佳',
        '駭': '皆',
        '賄': '灰',
        '海': '咍',
        '軫': '眞',
        '準': '眞',
        '吻': '文',
        '隱': '欣',
        '𧤛': '臻',
        '阮': '元',
        '混': '魂',
        '很': '痕',
        '旱': '寒',
        '緩': '桓',
        '潸': '刪',
        '產': '山',
        '銑': '先',
        '獮': '仙',
        '篠': '蕭',
        '小': '宵',
        '巧': '肴',
        '晧': '豪',
        '哿': '歌',
        '果': '歌',
        '馬': '麻',
        '養': '陽',
        '蕩': '唐',
        '梗': '庚',
        '耿': '耕',
        '靜': '清',
        '迥': '青',
        '拯': '蒸',
        '等': '登',
        '有': '尤',
        '厚': '侯',
        '黝': '幽',
        '寑': '侵',
        '感': '覃',
        '敢': '談',
        '琰': '鹽',
        '忝': '添',
        '儼': '嚴',
        '豏': '咸',
        '檻': '銜',
        '梵': '凡',
        '送': '東',
        '宋': '冬',
        '用': '鍾',
        '絳': '江',
        '寘': '支',
        '至': '脂',
        '志': '之',
        '未': '微',
        '御': '魚',
        '遇': '虞',
        '暮': '模',
        '霽': '齊',
        '祭': '祭',
        '廢': '廢',
        '泰': '泰',
        '卦': '佳',
        '怪': '皆',
        '夬': '夬',
        '隊': '灰',
        '代': '咍',
        '震': '眞',
        '櫬': '臻',
        '稕': '眞',
        '問': '文',
        '焮': '欣',
        '願': '元',
        '慁': '魂',
        '恨': '痕',
        '翰': '寒',
        '換': '桓',
        '諫': '刪',
        '襇': '山',
        '霰': '先',
        '線': '仙',
        '嘯': '蕭',
        '笑': '宵',
        '效': '肴',
        '号': '豪',
        '箇': '歌',
        '過': '歌',
        '禡': '麻',
        '漾': '陽',
        '宕': '唐',
        '映': '庚',
        '諍': '耕',
        '勁': '清',
        '徑': '青',
        '證': '蒸',
        '嶝': '登',
        '宥': '尤',
        '候': '侯',
        '幼': '幽',
        '沁': '侵',
        '勘': '覃',
        '闞': '談',
        '豔': '鹽',
        '㮇': '添',
        '釅': '嚴',
        '范': '凡',
        '陷': '咸',
        '鑑': '銜',
        '屋': '東',
        '沃': '冬',
        '燭': '鍾',
        '覺': '江',
        '質': '眞',
        '櫛': '臻',
        '術': '眞',
        '物': '文',
        '迄': '欣',
        '月': '元',
        '沒': '魂',
        '麧': '痕',
        '曷': '寒',
        '末': '桓',
        '鎋': '山',
        '黠': '刪',
        '屑': '先',
        '薛': '仙',
        '藥': '陽',
        '鐸': '唐',
        '陌': '庚',
        '麥': '耕',
        '昔': '清',
        '錫': '青',
        '職': '蒸',
        '德': '登',
        '緝': '侵',
        '合': '覃',
        '盍': '談',
        '葉': '鹽',
        '怗': '添',
        '洽': '咸',
        '狎': '銜',
        '業': '嚴',
        '乏': '凡',
        '桓': '寒',
        '緩': '寒',
        '換': '寒',
        '末': '寒',
        '霄': '宵',
        '𥬇': '宵',
        '敬': '庚', # 映韻
        '寢': '侵', # 寑韻
        '帖': '添', # 怗韻
        '䰟': '魂',
    }[韻]

'''
TODO:
韻目 = {
    '𠜂': '刪',
    '㒨': '仙',
    '爻': '肴',
    '矦': '侯',
    '𧟹': '覃',
    '沾': '添',
    '蕫': '董',
    '噳': '麌',
    '𤣗': '獮',
    '筱': '篠',
    '抍': '拯',
    '𠪀': '厚',
    '𠭖': '敢',
    '范': '梵',
    '莫': '暮',
    '𡗒': '夬',
    '圂': '慁',
    '隥': '嶝',
    '𠊱': '候',
    '栝': '㮇',
    '驗': '豔',
    '㽉': '釅',
    '凡2': '范',
    '𣵽': '沃',
    '勿': '物',
    '舝': '鎋',
    '㞕': '屑',
    '𧀼': '薛',
    '㫺': '昔',
    '盇': '盍',
    '帖': '怗',
}
'''

l韻圖母號2韻圖母位置 = [
    '舌齒音第二位', '舌齒音第一位', # 舌齒音
    '喉音第四位', '喉音第三位', '喉音第二位', '喉音第一位', # 喉音
    '齒音第五位', '齒音第四位', '齒音第三位', '齒音第二位', '齒音第一位', # 齒音
    '牙音第四位', '牙音第三位', '牙音第二位', '牙音第一位', # 牙音
    '舌音第四位', '舌音第三位', '舌音第二位', '舌音第一位', # 舌音
    '脣音第四位', '脣音第三位', '脣音第二位', '脣音第一位', # 脣音
]

def 韻圖母號_韻圖等_切韻韻2韻圖母(韻圖母號, 韻圖等, 切韻韻):
    return [
        # 舌齒音
        '日',
        '來',
        # 喉音
        '喻',
        '匣',
        '曉',
        '影',
        # 齒音
        '邪' if 韻圖等 in '一四' else '禪',
        '心' if 韻圖等 in '一四' else '審',
        '從' if 韻圖等 in '一四' else '牀',
        '清' if 韻圖等 in '一四' else '穿',
        '精' if 韻圖等 in '一四' else '照',
        # 牙音
        '疑',
        '羣',
        '溪',
        '見',
        # 舌音
        '泥' if 韻圖等 in '一四' else '孃',
        '定' if 韻圖等 in '一四' else '澄',
        '透' if 韻圖等 in '一四' else '徹',
        '端' if 韻圖等 in '一四' else '知',
        # 脣音
        '微' if 韻圖等 == '三' and 切韻韻 in 常量.輕脣韻 else '明',
        '奉' if 韻圖等 == '三' and 切韻韻 in 常量.輕脣韻 else '並',
        '敷' if 韻圖等 == '三' and 切韻韻 in 常量.輕脣韻 else '滂',
        '非' if 韻圖等 == '三' and 切韻韻 in 常量.輕脣韻 else '幫',
    ][韻圖母號]

def 韻圖等_切韻韻2切韻等(韻圖等, 切韻韻):
    if 切韻韻 in 常量.一三等韻:
        return '一' if 韻圖等 == '一' else '三'
    if 切韻韻 in 常量.二三等韻:
        return '二' if 韻圖等 == '二' else '三' # TODO: 麻庚韻莊組
    return ''

def 韻圖母_韻圖等2切韻母(韻圖母, 韻圖等):
    if 韻圖母 == '喻':
        return '云' if 韻圖等 == '三' else '以'

    if 韻圖母 == '照':
        return '章' if 韻圖等 == '三' else '莊'
    if 韻圖母 == '穿':
        return '昌' if 韻圖等 == '三' else '初'
    if 韻圖母 == '牀':
        return '常' if 韻圖等 == '三' else '從'
    if 韻圖母 == '審':
        return '書' if 韻圖等 == '三' else '生'
    if 韻圖母 == '禪':
        return '船' if 韻圖等 == '三' else '俟'

    if 韻圖母 == '非': return '幫'
    if 韻圖母 == '敷': return '滂'
    if 韻圖母 == '奉': return '並'
    if 韻圖母 == '微': return '明'

    return 韻圖母

def 切韻母_切韻韻_韻圖等2重紐(切韻母, 切韻韻, 韻圖等):
    return '' if 切韻母 not in 常量.重紐母 or 切韻韻 not in 常量.重紐韻 else \
            'B' if 韻圖等 == '三' else \
            'A'

def 韻圖2切韻(轉號, 韻圖開合修正後, 韻圖母位置, 韻圖聲, 韻圖韻, 韻圖等):
    切韻韻 = normalize韻(韻圖韻)
    韻圖母號 = l韻圖母號2韻圖母位置.index(韻圖母位置)
    韻圖母 = 韻圖母號_韻圖等_切韻韻2韻圖母(韻圖母號, 韻圖等, 切韻韻)
    切韻等 = 韻圖等_切韻韻2切韻等(韻圖等, 切韻韻)
    切韻母 = 韻圖母_韻圖等2切韻母(韻圖母, 韻圖等)
    if 切韻母 in '幫滂並明':
        韻圖開合修正後 = ''
    重紐 = 切韻母_切韻韻_韻圖等2重紐(切韻母, 切韻韻, 韻圖等)
    音韻描述 = 切韻母 + 韻圖開合修正後 + 切韻等 + 重紐 + 切韻韻 + 韻圖聲
    try:
        當前音韻地位 = 音韻地位.from描述(音韻描述) # will perform check
    except Exception:
        assert False, 音韻描述
    return 韻圖母, 當前音韻地位
