import * as certmgr from '@aws-cdk/aws-certificatemanager';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as rds from '@aws-cdk/aws-rds';
import * as secretsmanager from '@aws-cdk/aws-secretsmanager';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface KeyCloadProps {
    /**
     * VPC for the workload.
     *
     * @stability stable
     */
    readonly vpc?: ec2.IVpc;
    /**
     * ACM certificate ARN to import.
     *
     * @stability stable
     */
    readonly certificateArn: string;
}
/**
 * @stability stable
 */
export declare class KeyCloak extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly db?: Database;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: KeyCloadProps);
    /**
     * @stability stable
     */
    addDatabase(): Database;
    /**
     * @stability stable
     */
    addKeyCloakContainerService(props: ContainerServiceProps): ContainerService;
    private _generateKeycloakSecret;
}
/**
 * @stability stable
 */
export interface DatabaseProps {
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly instanceType?: ec2.InstanceType;
    /**
     * @stability stable
     */
    readonly engine?: rds.IInstanceEngine;
}
/**
 * @stability stable
 */
export declare class Database extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly dbinstance: rds.DatabaseInstance;
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly clusterEndpointHostname: string;
    /**
     * @stability stable
     */
    readonly clusterIdentifier: string;
    /**
     * @stability stable
     */
    readonly secret: secretsmanager.ISecret;
    private readonly _mysqlListenerPort;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: DatabaseProps);
}
/**
 * @stability stable
 */
export interface ContainerServiceProps {
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly database: Database;
    /**
     * @stability stable
     */
    readonly keycloakSecret: secretsmanager.ISecret;
    /**
     * @stability stable
     */
    readonly certificate: certmgr.ICertificate;
}
/**
 * @stability stable
 */
export declare class ContainerService extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly service: ecs.FargateService;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: ContainerServiceProps);
}
