# Generated by Django 3.1.1 on 2020-09-29 23:25
import django.db.models.deletion
import django.utils.timezone
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Condition",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "description",
                    models.TextField(blank=True, max_length=16384, verbose_name="description"),
                ),
                (
                    "expression",
                    models.TextField(blank=True, max_length=16384, verbose_name="expression"),
                ),
                (
                    "on",
                    models.DateTimeField(
                        db_index=True,
                        default=django.utils.timezone.now,
                        verbose_name="created on",
                    ),
                ),
                ("order", models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name="ExternalUser",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(db_index=True, max_length=512, null=True, verbose_name="name"),
                ),
                (
                    "email",
                    models.EmailField(db_index=True, max_length=512, null=True, verbose_name="email"),
                ),
                (
                    "username",
                    models.CharField(
                        db_index=True,
                        max_length=512,
                        null=True,
                        verbose_name="username",
                    ),
                ),
                (
                    "remote_id",
                    models.CharField(db_index=True, max_length=512, null=True, verbose_name="uid"),
                ),
                (
                    "installation",
                    models.CharField(db_index=True, max_length=255, verbose_name="provider"),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Installation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("remote_id", models.CharField(db_index=True, max_length=512)),
                ("target_type", models.CharField(max_length=50)),
                ("target_id", models.CharField(max_length=255)),
                (
                    "on",
                    models.DateTimeField(
                        db_index=True,
                        default=django.utils.timezone.now,
                        verbose_name="created on",
                    ),
                ),
                (
                    "provider",
                    models.CharField(
                        choices=[
                            ("github", "GitHub"),
                            ("gitlab", "GitLab"),
                            ("bitbucket", "Bitbucket"),
                        ],
                        max_length=50,
                    ),
                ),
                ("active", models.BooleanField(default=True)),
            ],
        ),
        migrations.CreateModel(
            name="PullRequest",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    models.TextField(
                        db_index=True,
                        default="",
                        max_length=16384,
                        verbose_name="title",
                    ),
                ),
                (
                    "description",
                    models.TextField(blank=True, max_length=16384, verbose_name="description"),
                ),
                (
                    "on",
                    models.DateTimeField(
                        db_index=True,
                        default=django.utils.timezone.now,
                        verbose_name="created on",
                    ),
                ),
                ("remote_id", models.CharField(db_index=True, max_length=512)),
                (
                    "source_branch_name",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        max_length=1024,
                        null=True,
                        verbose_name="source branch name",
                    ),
                ),
                (
                    "source_sha",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        max_length=1024,
                        null=True,
                        verbose_name="source sha",
                    ),
                ),
                (
                    "base_branch_name",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        max_length=1024,
                        null=True,
                        verbose_name="base branch name",
                    ),
                ),
                (
                    "url",
                    models.URLField(blank=True, max_length=1024, null=True, verbose_name="url"),
                ),
                ("draft", models.BooleanField(default=False)),
                ("merged", models.BooleanField(default=False)),
                (
                    "mergeable",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("unknown", "Unknown"),
                        ],
                        default="unknown",
                        max_length=15,
                    ),
                ),
                (
                    "rebaseable",
                    models.CharField(
                        choices=[
                            ("true", "True"),
                            ("false", "False"),
                            ("unknown", "Unknown"),
                        ],
                        default="unknown",
                        max_length=15,
                    ),
                ),
                (
                    "status",
                    models.CharField(blank=True, max_length=128, null=True, verbose_name="status"),
                ),
                (
                    "author",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="authored_pull_requests",
                        to="sleuthpr.externaluser",
                        verbose_name="author",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Repository",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("full_name", models.CharField(max_length=255)),
                (
                    "remote_id",
                    models.CharField(db_index=True, max_length=512, null=True),
                ),
                (
                    "installation",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="repositories",
                        to="sleuthpr.installation",
                        verbose_name="installation",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Rule",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    models.CharField(db_index=True, default="", max_length=255, verbose_name="title"),
                ),
                (
                    "description",
                    models.TextField(blank=True, max_length=16384, verbose_name="description"),
                ),
                (
                    "on",
                    models.DateTimeField(
                        db_index=True,
                        default=django.utils.timezone.now,
                        verbose_name="created on",
                    ),
                ),
                ("order", models.IntegerField()),
                (
                    "repository",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="rules",
                        to="sleuthpr.repository",
                        verbose_name="repository",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Trigger",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("type", models.CharField(max_length=255)),
                (
                    "rule",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="triggers",
                        to="sleuthpr.rule",
                        verbose_name="installation",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="PullRequestReviewer",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "pull_request",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="reviewers",
                        to="sleuthpr.pullrequest",
                        verbose_name="pull_request",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="reviewer_for_pull_requests",
                        to="sleuthpr.externaluser",
                        verbose_name="user",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="PullRequestLabel",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "value",
                    models.CharField(db_index=True, max_length=255, verbose_name="value"),
                ),
                (
                    "pull_request",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="labels",
                        to="sleuthpr.pullrequest",
                        verbose_name="pull_request",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="PullRequestAssignee",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "pull_request",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="assignees",
                        to="sleuthpr.pullrequest",
                        verbose_name="pull_request",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="assigned_pull_requests",
                        to="sleuthpr.externaluser",
                        verbose_name="user",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="pullrequest",
            name="repository",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="pull_requests",
                to="sleuthpr.repository",
                verbose_name="repository",
            ),
        ),
        migrations.CreateModel(
            name="ConditionCheckRun",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[("success", "Success"), ("failure", "Failure")],
                        db_index=True,
                        max_length=50,
                    ),
                ),
                ("remote_id", models.CharField(db_index=True, max_length=512)),
                (
                    "condition",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="checks",
                        to="sleuthpr.condition",
                        verbose_name="condition",
                    ),
                ),
                (
                    "pull_request",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="checks",
                        to="sleuthpr.pullrequest",
                        verbose_name="pull_request",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="condition",
            name="rule",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="conditions",
                to="sleuthpr.rule",
                verbose_name="rule",
            ),
        ),
        migrations.CreateModel(
            name="Action",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "type",
                    models.CharField(db_index=True, max_length=255, verbose_name="type"),
                ),
                (
                    "description",
                    models.TextField(blank=True, max_length=16384, verbose_name="description"),
                ),
                (
                    "on",
                    models.DateTimeField(
                        db_index=True,
                        default=django.utils.timezone.now,
                        verbose_name="created on",
                    ),
                ),
                ("parameters", models.JSONField()),
                ("order", models.IntegerField()),
                (
                    "rule",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="actions",
                        to="sleuthpr.rule",
                        verbose_name="rule",
                    ),
                ),
            ],
        ),
    ]
