import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeSchemasConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/schemas#database DataSnowflakeSchemas#database}
    */
    readonly database: string;
}
export declare class DataSnowflakeSchemasSchemas extends cdktf.ComplexComputedList {
    get comment(): string;
    get database(): string;
    get name(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/schemas snowflake_schemas}
*/
export declare class DataSnowflakeSchemas extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/schemas snowflake_schemas} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeSchemasConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeSchemasConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    schemas(index: string): DataSnowflakeSchemasSchemas;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
