import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkPolicyAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the identifier for the network policy; must be unique for the account in which the network policy is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/network_policy_attachment#network_policy_name NetworkPolicyAttachment#network_policy_name}
    */
    readonly networkPolicyName: string;
    /**
    * Specifies whether the network policy should be applied globally to your Snowflake account<br><br>**Note:** The Snowflake user running `terraform apply` must be on an IP address allowed by the network policy to set that policy globally on the Snowflake account.<br><br>Additionally, a Snowflake account can only have one network policy set globally at any given time. This resource does not enforce one-policy-per-account, it is the user's responsibility to enforce this. If multiple network policy resources have `set_for_account: true`, the final policy set on the account will be non-deterministic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/network_policy_attachment#set_for_account NetworkPolicyAttachment#set_for_account}
    */
    readonly setForAccount?: boolean | cdktf.IResolvable;
    /**
    * Specifies which users the network policy should be attached to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/network_policy_attachment#users NetworkPolicyAttachment#users}
    */
    readonly users?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/network_policy_attachment snowflake_network_policy_attachment}
*/
export declare class NetworkPolicyAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/network_policy_attachment snowflake_network_policy_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkPolicyAttachmentConfig
    */
    constructor(scope: Construct, id: string, config: NetworkPolicyAttachmentConfig);
    get id(): string;
    private _networkPolicyName?;
    get networkPolicyName(): string;
    set networkPolicyName(value: string);
    get networkPolicyNameInput(): string | undefined;
    private _setForAccount?;
    get setForAccount(): boolean | cdktf.IResolvable;
    set setForAccount(value: boolean | cdktf.IResolvable);
    resetSetForAccount(): void;
    get setForAccountInput(): boolean | cdktf.IResolvable | undefined;
    private _users?;
    get users(): string[];
    set users(value: string[]);
    resetUsers(): void;
    get usersInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
