"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SamlIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration snowflake_saml_integration}
*/
class SamlIntegration extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration snowflake_saml_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SamlIntegrationConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_saml_integration',
            terraformGeneratorMetadata: {
                providerName: 'snowflake'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._enabled = config.enabled;
        this._name = config.name;
        this._saml2EnableSpInitiated = config.saml2EnableSpInitiated;
        this._saml2ForceAuthn = config.saml2ForceAuthn;
        this._saml2Issuer = config.saml2Issuer;
        this._saml2PostLogoutRedirectUrl = config.saml2PostLogoutRedirectUrl;
        this._saml2Provider = config.saml2Provider;
        this._saml2RequestedNameidFormat = config.saml2RequestedNameidFormat;
        this._saml2SignRequest = config.saml2SignRequest;
        this._saml2SnowflakeAcsUrl = config.saml2SnowflakeAcsUrl;
        this._saml2SnowflakeIssuerUrl = config.saml2SnowflakeIssuerUrl;
        this._saml2SnowflakeX509Cert = config.saml2SnowflakeX509Cert;
        this._saml2SpInitiatedLoginPageLabel = config.saml2SpInitiatedLoginPageLabel;
        this._saml2SsoUrl = config.saml2SsoUrl;
        this._saml2X509Cert = config.saml2X509Cert;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // created_on - computed: true, optional: false, required: false
    get createdOn() {
        return this.getStringAttribute('created_on');
    }
    get enabled() {
        return this.getBooleanAttribute('enabled');
    }
    set enabled(value) {
        this._enabled = value;
    }
    resetEnabled() {
        this._enabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enabledInput() {
        return this._enabled;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    // saml2_digest_methods_used - computed: true, optional: false, required: false
    get saml2DigestMethodsUsed() {
        return this.getStringAttribute('saml2_digest_methods_used');
    }
    get saml2EnableSpInitiated() {
        return this.getBooleanAttribute('saml2_enable_sp_initiated');
    }
    set saml2EnableSpInitiated(value) {
        this._saml2EnableSpInitiated = value;
    }
    resetSaml2EnableSpInitiated() {
        this._saml2EnableSpInitiated = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2EnableSpInitiatedInput() {
        return this._saml2EnableSpInitiated;
    }
    get saml2ForceAuthn() {
        return this.getBooleanAttribute('saml2_force_authn');
    }
    set saml2ForceAuthn(value) {
        this._saml2ForceAuthn = value;
    }
    resetSaml2ForceAuthn() {
        this._saml2ForceAuthn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2ForceAuthnInput() {
        return this._saml2ForceAuthn;
    }
    get saml2Issuer() {
        return this.getStringAttribute('saml2_issuer');
    }
    set saml2Issuer(value) {
        this._saml2Issuer = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2IssuerInput() {
        return this._saml2Issuer;
    }
    get saml2PostLogoutRedirectUrl() {
        return this.getStringAttribute('saml2_post_logout_redirect_url');
    }
    set saml2PostLogoutRedirectUrl(value) {
        this._saml2PostLogoutRedirectUrl = value;
    }
    resetSaml2PostLogoutRedirectUrl() {
        this._saml2PostLogoutRedirectUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2PostLogoutRedirectUrlInput() {
        return this._saml2PostLogoutRedirectUrl;
    }
    get saml2Provider() {
        return this.getStringAttribute('saml2_provider');
    }
    set saml2Provider(value) {
        this._saml2Provider = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2ProviderInput() {
        return this._saml2Provider;
    }
    get saml2RequestedNameidFormat() {
        return this.getStringAttribute('saml2_requested_nameid_format');
    }
    set saml2RequestedNameidFormat(value) {
        this._saml2RequestedNameidFormat = value;
    }
    resetSaml2RequestedNameidFormat() {
        this._saml2RequestedNameidFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2RequestedNameidFormatInput() {
        return this._saml2RequestedNameidFormat;
    }
    get saml2SignRequest() {
        return this.getBooleanAttribute('saml2_sign_request');
    }
    set saml2SignRequest(value) {
        this._saml2SignRequest = value;
    }
    resetSaml2SignRequest() {
        this._saml2SignRequest = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SignRequestInput() {
        return this._saml2SignRequest;
    }
    // saml2_signature_methods_used - computed: true, optional: false, required: false
    get saml2SignatureMethodsUsed() {
        return this.getStringAttribute('saml2_signature_methods_used');
    }
    get saml2SnowflakeAcsUrl() {
        return this.getStringAttribute('saml2_snowflake_acs_url');
    }
    set saml2SnowflakeAcsUrl(value) {
        this._saml2SnowflakeAcsUrl = value;
    }
    resetSaml2SnowflakeAcsUrl() {
        this._saml2SnowflakeAcsUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SnowflakeAcsUrlInput() {
        return this._saml2SnowflakeAcsUrl;
    }
    get saml2SnowflakeIssuerUrl() {
        return this.getStringAttribute('saml2_snowflake_issuer_url');
    }
    set saml2SnowflakeIssuerUrl(value) {
        this._saml2SnowflakeIssuerUrl = value;
    }
    resetSaml2SnowflakeIssuerUrl() {
        this._saml2SnowflakeIssuerUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SnowflakeIssuerUrlInput() {
        return this._saml2SnowflakeIssuerUrl;
    }
    // saml2_snowflake_metadata - computed: true, optional: false, required: false
    get saml2SnowflakeMetadata() {
        return this.getStringAttribute('saml2_snowflake_metadata');
    }
    get saml2SnowflakeX509Cert() {
        return this.getStringAttribute('saml2_snowflake_x509_cert');
    }
    set saml2SnowflakeX509Cert(value) {
        this._saml2SnowflakeX509Cert = value;
    }
    resetSaml2SnowflakeX509Cert() {
        this._saml2SnowflakeX509Cert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SnowflakeX509CertInput() {
        return this._saml2SnowflakeX509Cert;
    }
    get saml2SpInitiatedLoginPageLabel() {
        return this.getStringAttribute('saml2_sp_initiated_login_page_label');
    }
    set saml2SpInitiatedLoginPageLabel(value) {
        this._saml2SpInitiatedLoginPageLabel = value;
    }
    resetSaml2SpInitiatedLoginPageLabel() {
        this._saml2SpInitiatedLoginPageLabel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SpInitiatedLoginPageLabelInput() {
        return this._saml2SpInitiatedLoginPageLabel;
    }
    get saml2SsoUrl() {
        return this.getStringAttribute('saml2_sso_url');
    }
    set saml2SsoUrl(value) {
        this._saml2SsoUrl = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SsoUrlInput() {
        return this._saml2SsoUrl;
    }
    get saml2X509Cert() {
        return this.getStringAttribute('saml2_x509_cert');
    }
    set saml2X509Cert(value) {
        this._saml2X509Cert = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2X509CertInput() {
        return this._saml2X509Cert;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            enabled: cdktf.booleanToTerraform(this._enabled),
            name: cdktf.stringToTerraform(this._name),
            saml2_enable_sp_initiated: cdktf.booleanToTerraform(this._saml2EnableSpInitiated),
            saml2_force_authn: cdktf.booleanToTerraform(this._saml2ForceAuthn),
            saml2_issuer: cdktf.stringToTerraform(this._saml2Issuer),
            saml2_post_logout_redirect_url: cdktf.stringToTerraform(this._saml2PostLogoutRedirectUrl),
            saml2_provider: cdktf.stringToTerraform(this._saml2Provider),
            saml2_requested_nameid_format: cdktf.stringToTerraform(this._saml2RequestedNameidFormat),
            saml2_sign_request: cdktf.booleanToTerraform(this._saml2SignRequest),
            saml2_snowflake_acs_url: cdktf.stringToTerraform(this._saml2SnowflakeAcsUrl),
            saml2_snowflake_issuer_url: cdktf.stringToTerraform(this._saml2SnowflakeIssuerUrl),
            saml2_snowflake_x509_cert: cdktf.stringToTerraform(this._saml2SnowflakeX509Cert),
            saml2_sp_initiated_login_page_label: cdktf.stringToTerraform(this._saml2SpInitiatedLoginPageLabel),
            saml2_sso_url: cdktf.stringToTerraform(this._saml2SsoUrl),
            saml2_x509_cert: cdktf.stringToTerraform(this._saml2X509Cert),
        };
    }
}
exports.SamlIntegration = SamlIntegration;
_a = JSII_RTTI_SYMBOL_1;
SamlIntegration[_a] = { fqn: "@cdktf/provider-snowflake.SamlIntegration", version: "0.0.21" };
// =================
// STATIC PROPERTIES
// =================
SamlIntegration.tfResourceType = "snowflake_saml_integration";
//# sourceMappingURL=data:application/json;base64,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