import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IListenerCertificate } from '../shared/listener-certificate';
import { IApplicationListener } from './application-listener';
/**
 * Properties for adding a set of certificates to a listener.
 *
 * @stability stable
 */
export interface ApplicationListenerCertificateProps {
    /**
     * The listener to attach the rule to.
     *
     * @stability stable
     */
    readonly listener: IApplicationListener;
    /**
     * (deprecated) ARNs of certificates to attach.
     *
     * Duplicates are not allowed.
     *
     * @default - One of 'certificates' and 'certificateArns' is required.
     * @deprecated Use `certificates` instead.
     */
    readonly certificateArns?: string[];
    /**
     * Certificates to attach.
     *
     * Duplicates are not allowed.
     *
     * @default - One of 'certificates' and 'certificateArns' is required.
     * @stability stable
     */
    readonly certificates?: IListenerCertificate[];
}
/**
 * Add certificates to a listener.
 *
 * @stability stable
 */
export declare class ApplicationListenerCertificate extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: ApplicationListenerCertificateProps);
}
