"use strict";
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkELBMetrics = exports.ApplicationELBMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class ApplicationELBMetrics {
    static requestCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'RequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static httpCodeElb5XxCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'HTTPCode_ELB_5XX_Count',
            dimensions,
            statistic: 'Sum',
        };
    }
    static activeConnectionCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'ActiveConnectionCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static clientTlsNegotiationErrorCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'ClientTLSNegotiationErrorCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static consumedLcUsAverage(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'ConsumedLCUs',
            dimensions,
            statistic: 'Average',
        };
    }
    static httpFixedResponseCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'HTTP_Fixed_Response_Count',
            dimensions,
            statistic: 'Sum',
        };
    }
    static httpRedirectCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'HTTP_Redirect_Count',
            dimensions,
            statistic: 'Sum',
        };
    }
    static httpRedirectUrlLimitExceededCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'HTTP_Redirect_Url_Limit_Exceeded_Count',
            dimensions,
            statistic: 'Sum',
        };
    }
    static httpCodeElb3XxCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'HTTPCode_ELB_3XX_Count',
            dimensions,
            statistic: 'Sum',
        };
    }
    static httpCodeElb4XxCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'HTTPCode_ELB_4XX_Count',
            dimensions,
            statistic: 'Sum',
        };
    }
    static iPv6ProcessedBytesSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'IPv6ProcessedBytes',
            dimensions,
            statistic: 'Sum',
        };
    }
    static iPv6RequestCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'IPv6RequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static newConnectionCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'NewConnectionCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static processedBytesSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'ProcessedBytes',
            dimensions,
            statistic: 'Sum',
        };
    }
    static rejectedConnectionCountSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'RejectedConnectionCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static ruleEvaluationsSum(dimensions) {
        return {
            namespace: 'AWS/ApplicationELB',
            metricName: 'RuleEvaluations',
            dimensions,
            statistic: 'Sum',
        };
    }
}
exports.ApplicationELBMetrics = ApplicationELBMetrics;
class NetworkELBMetrics {
    static healthyHostCountAverage(dimensions) {
        return {
            namespace: 'AWS/NetworkELB',
            metricName: 'HealthyHostCount',
            dimensions,
            statistic: 'Average',
        };
    }
    static unHealthyHostCountAverage(dimensions) {
        return {
            namespace: 'AWS/NetworkELB',
            metricName: 'UnHealthyHostCount',
            dimensions,
            statistic: 'Average',
        };
    }
    static activeFlowCountSum(dimensions) {
        return {
            namespace: 'AWS/NetworkELB',
            metricName: 'ActiveFlowCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static consumedLcUsAverage(dimensions) {
        return {
            namespace: 'AWS/NetworkELB',
            metricName: 'ConsumedLCUs',
            dimensions,
            statistic: 'Average',
        };
    }
    static newFlowCountSum(dimensions) {
        return {
            namespace: 'AWS/NetworkELB',
            metricName: 'NewFlowCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static processedBytesSum(dimensions) {
        return {
            namespace: 'AWS/NetworkELB',
            metricName: 'ProcessedBytes',
            dimensions,
            statistic: 'Sum',
        };
    }
    static tcpClientResetCountSum(dimensions) {
        return {
            namespace: 'AWS/NetworkELB',
            metricName: 'TCP_Client_Reset_Count',
            dimensions,
            statistic: 'Sum',
        };
    }
    static tcpElbResetCountSum(dimensions) {
        return {
            namespace: 'AWS/NetworkELB',
            metricName: 'TCP_ELB_Reset_Count',
            dimensions,
            statistic: 'Sum',
        };
    }
    static tcpTargetResetCountSum(dimensions) {
        return {
            namespace: 'AWS/NetworkELB',
            metricName: 'TCP_Target_Reset_Count',
            dimensions,
            statistic: 'Sum',
        };
    }
}
exports.NetworkELBMetrics = NetworkELBMetrics;
//# sourceMappingURL=data:application/json;base64,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