#!/usr/bin/env python3
#
# GlobalChem - Drugs from Snake Venom
#
# ------------------------------------

class DrugsFromSnakeVenom(object):

    def __init__(self):

        self.name = 'drugs_from_snake_venom'

    @staticmethod
    def get_smiles():

        smiles = {
            'ziconotide': 'CC1C(=O)NC(C(=O)NC2CSSCC3C(=O)NC(C(=O)NC(C(=O)NCC(=O)NC(C(=O)NC(CSSCC(C(=O)NC(CSSCC(C(=O)NC(C(=O)NCC(=O)NC(C(=O)NCC(=O)N1)CCCCN)CCCCN)N)C(=O)NC(C(=O)NCC(=O)NC(C(=O)N3)CO)C(C)O)NC(=O)C(NC(=O)C(NC(=O)C(NC(=O)C(NC(=O)C(NC(=O)C(NC2=O)CO)CCCNC(=N)N)CC(C)C)CCSC)CC4=CC=C(C=C4)O)CC(=O)O)C(=O)N)CCCCN)CO)CCCNC(=N)N)CCCCN',
            'captopril': 'CC(CS)C(=O)N1CCCC1C(=O)O',
            'tirofiban': 'CCCCS(=O)(=O)NC(CC1=CC=C(C=C1)OCCCCC2CCNCC2)C(=O)O',
            'eptifibatide': 'C1CC2C(=O)NC(CSSCCC(=O)NC(C(=O)NCC(=O)NC(C(=O)NC(C(=O)N2C1)CC3=CNC4=CC=CC=C43)CC(=O)O)CCCCN=C(N)N)C(=O)N',
            'batroxobin': 'NC(CCSC)C(NC(C(C)C)C(NC(CC(C)C)C(NC(C(CC)([H])C)C(NC(CCCCNC(N)=N)C(NC(C(C)C)C(NC(C(CC)([H])C)C(NC(C)C(NC(CC(N)=O)C(NC(CC(C)C)C(NC(CC(C)C)C(NC(C(CC)([H])C)C(NC(CC(C)C)C(NC(CCC(N)=O)C(NC(C(C)C)C(NC(CO)C(NC(CC1=CC=C(O)C=C1)C(NC(C)C(NC(CCC(N)=O)C(NC(CCCCN)C(NC(CO)C(NC(CO)C(NC(CCC(O)=O)C(NC(CC(C)C)C(NC(C(C)C)C(NC(C(CC)([H])C)C(NC([H])C(NC([H])C(NC(CC(O)=O)C(NC(CCC(O)=O)C(NC(CS)C(NC(CC(O)=O)C(NC(C(CC)([H])C)C(NC(CC(N)=O)C(NC(CCC(O)=O)C(NC(CC1=CNC=N1)C(NC(C2CCCN2)C(NC(CC1=CC=CC=C1)C(NC(CC(C)C)C(NC(C)C(NC(CC1=CC=CC=C1)C(NC(CCSC)C(NC(CC1=CC=C(O)C=C1)C(NC(CC1=CC=C(O)C=C1)C(NC(CO)C(NC(C2CCCN2)C(NC(CCCCNC(N)=N)C(NC(CC1=CC=C(O)C=C1)C(NC(CC1=CC=CC=C1)C(NC(CS)C(NC([H])C(NC(CCSC)C(NC(C(C)([H])O)C(NC(CC(C)C)C(NC(C(CC)([H])C)C(NC(CC(N)=O)C(NC(CCC(N)=O)C(NC(CCC(O)=O)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(C(C)C)C(NC(CC(C)C)C(NC(C(C)([H])O)C(NC(C)C(NC(C)C(NC(CC1=CNC=N1)C(NC(CS)C(NC(CC(N)=O)C(NC(CCCCNC(N)=N)C(NC(CCCCNC(N)=N)C(NC(CC1=CC=CC=C1)C(NC(CCSC)C(NC(CCCCNC(N)=N)C(NC(C(CC)([H])C)C(NC(CC1=CNC=N1)C(NC(CC(C)C)C(NC([H])C(NC(CCCCN)C(NC(CC1=CNC=N1)C(NC(C)C(NC([H])C(NC(CO)C(NC(C(C)C)C(NC(C)C(NC(CC(N)=O)C(NC(CC1=CC=C(O)C=C1)C(NC(CC(O)=O)C(NC(CCC(O)=O)C(NC(C(C)C)C(NC(C(C)C)C(NC(CCCCNC(N)=N)C(NC(CC1=CC=C(O)C=C1)C(NC(C2CCCN2)C(NC(CCCCN)C(NC(CCC(O)=O)C(NC(CCCCN)C(NC(CC1=CC=CC=C1)C(NC(C(CC)([H])C)C(NC(CS)C(NC(C2CCCN2)C(NC(CC(N)=O)C(NC(CCCCN)C(NC(CCCCN)C(NC(CCCCN)C(NC(CC(N)=O)C(NC(C(C)C)C(NC(C(CC)([H])C)C(NC(C(C)([H])O)C(NC(CC(O)=O)C(NC(CCCCN)C(NC(CC(O)=O)C(NC(C(CC)([H])C)C(NC(CCSC)C(NC(CC(C)C)C(NC(C(CC)([H])C)C(NC(CCCCNC(N)=N)C(NC(CC(C)C)C(NC(CC(O)=O)C(NC(CCCCNC(N)=N)C(NC(C2CCCN2)C(NC(C(C)C)C(NC(CCCCN)C(NC(CC(N)=O)C(NC(CO)C(NC(CCC(O)=O)C(NC(CC1=CNC=N1)C(NC(C(CC)([H])C)C(NC(C)C(NC(C2CCCN2)C(NC(CC(C)C)C(NC(CO)C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(CO)C(NC(CC(N)=O)C(NC(C2CCCN2)C(NC(C2CCCN2)C(NC(CO)C(NC(C(C)C)C(NC([H])C(NC(CO)C(NC(C(C)C)C(NC(CS)C(NC(CCCCNC(N)=N)C(NC(C(CC)([H])C)C(NC(CCSC)C(NC([H])C(NC(CCC1=CNC2=C1C=CC=C2)C(NC([H])C(NC(C)C(NC(C(CC)([H])C)C(NC(C(C)([H])O)C(NC(C(C)([H])O)C(NC(CO)C(NC(CCC(O)=O)C(NC(CC(O)=O)C(NC(C(C)([H])O)C(NC(CC1=CC=C(O)C=C1)C(NC(C2CCCN2)C(NC(CC(O)=O)C(NC(C(C)C)C(NC(C2CCCN2)C(NC(CC1=CNC=N1)C(NC(CS)C(NC(C)C(NC(CC(N)=O)C(NC(C(CC)([H])C)C(NC(CC(N)=O)C(NC(CC(C)C)C(NC(CC1=CC=CC=C1)C(NC(CC(N)=O)C(NC(CC(N)=O)C(NC(C(C)([H])O)C(NC(C(C)C)C(NC(CS)C(NC(CCCCNC(N)=N)C(NC(CCC(O)=O)C(NC(C)C(NC(CC1=CC=C(O)C=C1)C(NC(CC(N)=O)C(NC([H])C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(C)C(NC(CCCCN)C(NC(C(C)([H])O)C(NC(CC(C)C)C(NC(CS)C(NC(C)C(NC([H])C(NC(C(C)C)C(NC(CC(C)C)C(NC(CCC(N)=O)C(NC([H])C(NC([H])C(NC(C(CC)([H])C)C(NC(CC(O)=O)C(NC(C(C)([H])O)C(NC(CS)C(NC([H])C(NC([H])C(NC(CC(O)=O)C(NC(CO)C(NC([H])C(NC([H])C(NC(C2CCCN2)C(NC(CC(C)C)C(NC(C(CC)([H])C)C(NC(CS)C(NC(CC(N)=O)C(NC([H])C(NC(CCC(N)=O)C(NC(CC1=CC=CC=C1)C(NC(CCC(N)=O)C(NC([H])C(NC(C(CC)([H])C)C(NC(CC(C)C)C(NC(CO)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC([H])C(NC(CO)C(NC(CC(O)=O)C(NC(C2CCCN2)C(NC(CS)C(NC(C)C(NC(CCC(O)=O)C(NC(C2CCCN2)C(NC(CCCCNC(N)=N)C(NC(CCCCN)C(NC(C2CCCN2)C(NC(C)C(NC(CC1=CC=CC=C1)C(NC(CC1=CC=C(O)C=C1)C(NC(C(C)([H])O)C(NC(CCCCN)C(NC(C(C)C)C(NC(CC1=CC=CC=C1)C(NC(CC(O)=O)C(NC(CC1=CC=C(O)C=C1)C(NC(CC(C)C)C(NC(C2CCCN2)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(C(CC)([H])C)C(NC(CCC(N)=O)C(NC(CO)C(NC(C(CC)([H])C)C(NC(C(CC)([H])C)C(NC(C)C(NC([H])C(NC(CC(N)=O)C(NC(CCCCN)C(NC(C(C)([H])O)C(NC(C)C(NC(C(C)([H])O)C(NC(CS)C(NC(C2CCCN2)C(NCC(O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O',
            'hemocoagulase': 'NC(CC(O)=O)C(NC(CS)C(NC(CO)C(NC(CO)C(NC([H])C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CO)C(NC(CO)C(NC(CC1=CC=C(O)C=C1)C(NC(CCC(O)=O)C(NC([H])C(NC(CC1=CNC=N1)C(NC(CS)C(NC(CC1=CC=C(O)C=C1)C(NC(CCCCN)C(NC(C(C)C)C(NC(CC1=CC=CC=C1)C(NC(CCCCN)C(NC(CCC(N)=O)C(NC(CO)C(NC(CCCCN)C(NC(C(C)([H])O)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(C)C(NC(CC(O)=O)C(NC(C)C(NC(CCC(O)=O)C(NC(CO)C(NC(CC1=CC=CC=C1)C(NC(CS)C(NC(C(C)([H])O)C(NC(CCCCN)C(NC(CCC(N)=O)C(NC(C(C)C)C(NC(CC(N)=O)C(NC([H])C(NC([H])C(NC(CC1=CNC=N1)C(NC(CC(C)C)C(NC(C(C)C)C(NC(CO)C(NC(CC(C)C)C(NC(CCC(O)=O)C(NC(CO)C(NC(CO)C(NC([H])C(NC(CCC(O)=O)C(NC(C)C(NC(CC(O)=O)C(NC(CC1=CC=CC=C1)C(NC(C(C)C)C(NC([H])C(NC(CCC(N)=O)C(NC(CC(C)C)C(NC(CC(C)C)C(NC(C)C(NC(CCC(N)=O)C(NC(CCCCN)C(NC(CC(C)C)C(NC(CCCCN)C(NC(CO)C(NC(C)C(NC(CCCCN)C(NC(CC(C)C)C(NC(CC1=CNC=N1)C(NC(C(C)C)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CC(C)C)C(NC([H])C(NC(CC(C)C)C(NC(CCCCNC(N)=N)C(NC(C)C(NC(CCC(N)=O)C(NC(CC(N)=O)C(NC(CCCCN)C(NC(CCC(O)=O)C(NC(CCCCN)C(NC(CCC(N)=O)C(NC(CS)C(NC(CO)C(NC(CC(C)C)C(NC(CCC(N)=O)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CO)C(NC(CC(O)=O)C(NC([H])C(NC(CO)C(NC(CO)C(NC(CC(C)C)C(NC(CO)C(NC(CC1=CC=C(O)C=C1)C(NC(CCC(O)=O)C(NC(CC(N)=O)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CC(C)C)C(NC(CCC(O)=O)C(NC(CCC(O)=O)C(NC(CCC(O)=O)C(NC(CO)C(NC(CCCCN)C(NC(CCCCN)C(NC(CS)C(NC(CC(C)C)C(NC([H])C(NC(C(C)C)C(NC(CC1=CNC=N1)C(NC(CC(C)C)C(NC(CCC(O)=O)C(NC(C(C)([H])O)C(NC([H])C(NC(CC1=CC=CC=C1)C(NC(CC1=CNC=N1)C(NC(CCCCN)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CCC(O)=O)C(NC(CC(N)=O)C(NC(CC1=CC=CC=C1)C(NC(CC1=CC=C(O)C=C1)C(NC(CS)C(NC(CCC(O)=O)C(NC(CCC(N)=O)C(NC(CCC(N)=O)C(NC(CC(O)=O)C(NC(C2CCCN2)C(NC(CC1=CC=CC=C1)C(NC(C(C)C)C(NC(CS)C(NC(CCC(O)=O)C(NC(C)C(NC(CC(O)=O)C(NC(CS)C(NC(C2CCCN2)C(NC(CO)C(NC(CC(O)=O)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CO)C(NC(CO)C(NC(CC1=CC=C(O)C=C1)C(NC(CCC(O)=O)C(NC([H])C(NC(CC1=CNC=N1)C(NC(CS)C(NC(CC1=CC=C(O)C=C1)C(NC(CCCCN)C(NC(C2CCCN2)C(NC(CC1=CC=CC=C1)C(NC(CC(N)=O)C(NC(CCC(O)=O)C(NC(C2CCCN2)C(NC(CCCCN)C(NC(CC(N)=O)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(C)C(NC(CC(O)=O)C(NC(C)C(NC(CCC(O)=O)C(NC(CC(N)=O)C(NC(CC1=CC=CC=C1)C(NC(CS)C(NC(C(C)([H])O)C(NC(CCCCN)C(NC(CCC(N)=O)C(NC(CC1=CNC=N1)C(NC(C(C)([H])O)C(NC([H])C(NC([H])C(NC(CC1=CNC=N1)C(NC(CC(C)C)C(NC(C(C)C)C(NC(CO)C(NC(CC1=CC=CC=C1)C(NC(CCC(N)=O)C(NC(CO)C(NC(C(C)([H])O)C(NC(CCC(O)=O)C(NC(CCC(O)=O)C(NC(C)C(NC(CC(O)=O)C(NC(CC1=CC=CC=C1)C(NC(C(C)C)C(NC(C(C)C)C(NC(CCCCN)C(NC(CC(C)C)C(NC(C)C(NC(CC1=CC=CC=C1)C(NC(CCC(N)=O)C(NC(C(C)([H])O)C(NC(CC1=CC=CC=C1)C(NC(CC(O)=O)C(NC(CC1=CC=C(O)C=C1)C(NC([H])C(NC(CC(C)C)C(NC(CC1=CC=CC=C1)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CC1=CC=CC=C1)C(NC([H])C(NC(CC(C)C)C(NC(CO)C(NC(CCCCN)C(NC(CC(C)C)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CC(N)=O)C(NC(CCC(N)=O)C(NC(CS)C(NC(CC(N)=O)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CCC(N)=O)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CO)C(NC(CC(N)=O)C(NC(C)C(NC(C)C(NC(CCSC)C(NC(CC(C)C)C(NC(CCCCN)C(NC(CC1=CC=C(O)C=C1)C(NC(C(C)([H])O)C(NC(CC(O)=O)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(C)C(NC(CCC(O)=O)C(NC(CCC(O)=O)C(NC(CO)C(NC(CC1=CC=C(O)C=C1)C(NC(CS)C(NC(C(C)C)C(NC(CC1=CC=C(O)C=C1)C(NC(CC1=CC=CC=C1)C(NC(CCCCN)C(NC(CO)C(NC(C(C)([H])O)C(NC(CC(N)=O)C(NC(CC(N)=O)C(NC(CCCCN)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CCCCNC(N)=N)C(NC(CO)C(NC(CC(C)C)C(NC(C(C)([H])O)C(NC(CS)C(NC(CCCCNC(N)=N)C(NC(CCSC)C(NC(CC(C)C)C(NC(C)C(NC(CC(N)=O)C(NC(CC1=CC=CC=C1)C(NC(C(C)C)C(NC(CS)C(NC(CCC(O)=O)C(NC(CC1=CC=CC=C1)C(NC(CCC(N)=O)C(NC(C)C(NCC(O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O',
            'alpha cobrotoxin': 'NC(CC(C)C)C(NC(CCC(O)=O)C(NC(CS)C(NC(CC1=CNC=N1)C(NC(CC(N)=O)C(NC(CCC(N)=O)C(NC(CCC(N)=O)C(NC(CO)C(NC(CO)C(NC(CCC(N)=O)C(NC(C(C)([H])O)C(NC(C2CCCN2)C(NC(C(C)([H])O)C(NC(C(C)([H])O)C(NC(C(C)([H])O)C(NC([H])C(NC(CS)C(NC(CO)C(NC([H])C(NC([H])C(NC(CCC(O)=O)C(NC(C(C)([H])O)C(NC(CC(N)=O)C(NC(CS)C(NC(CC1=CC=C(O)C=C1)C(NC(CCCCN)C(NC(CCCCN)C(NC(CCCCNC(N)=N)C(NC(CCC1=CNC2=C1C=CC=C2)C(NC(CCCCNC(N)=N)C(NC(CC(O)=O)C(NC(CC1=CNC=N1)C(NC(CCCCNC(N)=N)C(NC([H])C(NC(CC1=CC=C(O)C=C1)C(NC(CCCCNC(N)=N)C(NC(C(C)([H])O)C(NC(CCC(O)=O)C(NC(CCCCNC(N)=N)C(NC([H])C(NC(CS)C(NC([H])C(NC(CS)C(NC(C2CCCN2)C(NC(CO)C(NC(C(C)C)C(NC(CCCCN)C(NC(CC(N)=O)C(NC([H])C(NC(C(CC)([H])C)C(NC(CCC(O)=O)C(NC(C(CC)([H])C)C(NC(CC(N)=O)C(NC(CS)C(NC(CS)C(NC(C(C)([H])O)C(NC(C(C)([H])O)C(NC(CC(O)=O)C(NC(CCCCNC(N)=N)C(NC(CS)C(NC(CC(N)=O)C(NC(CC(N)=O)C(NCC(O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O)=O',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'ziconotide': '[#6]-[#6]1-[#6](=[#8])-[#7]-[#6](-[#6](=[#8])-[#7]-[#6]2-[#6]-[#16]-[#16]-[#6]-[#6]3-[#6](=[#8])-[#7]-[#6](-[#6](=[#8])-[#7]-[#6](-[#6](=[#8])-[#7]-[#6]-[#6](=[#8])-[#7]-[#6](-[#6](=[#8])-[#7]-[#6](-[#6]-[#16]-[#16]-[#6]-[#6](-[#6](=[#8])-[#7]-[#6](-[#6]-[#16]-[#16]-[#6]-[#6](-[#6](=[#8])-[#7]-[#6](-[#6](=[#8])-[#7]-[#6]-[#6](=[#8])-[#7]-[#6](-[#6](=[#8])-[#7]-[#6]-[#6](=[#8])-[#7]-1)-[#6]-[#6]-[#6]-[#6]-[#7])-[#6]-[#6]-[#6]-[#6]-[#7])-[#7])-[#6](=[#8])-[#7]-[#6](-[#6](=[#8])-[#7]-[#6]-[#6](=[#8])-[#7]-[#6](-[#6](=[#8])-[#7]-3)-[#6]-[#8])-[#6](-[#6])-[#8])-[#7]-[#6](=[#8])-[#6](-[#7]-[#6](=[#8])-[#6](-[#7]-[#6](=[#8])-[#6](-[#7]-[#6](=[#8])-[#6](-[#7]-[#6](=[#8])-[#6](-[#7]-[#6](=[#8])-[#6](-[#7]-[#6]-2=[#8])-[#6]-[#8])-[#6]-[#6]-[#6]-[#7]-[#6](=[#7])-[#7])-[#6]-[#6](-[#6])-[#6])-[#6]-[#6]-[#16]-[#6])-[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8])-[#6]-[#6](=[#8])-[#8])-[#6](=[#8])-[#7])-[#6]-[#6]-[#6]-[#6]-[#7])-[#6]-[#8])-[#6]-[#6]-[#6]-[#7]-[#6](=[#7])-[#7])-[#6]-[#6]-[#6]-[#6]-[#7]',
            'captopril': '[#6]-[#6](-[#6]-[#16])-[#6](=[#8])-[#7]1-[#6]-[#6]-[#6]-[#6]-1-[#6](=[#8])-[#8]',
            'tirofiban': '[#6]-[#6]-[#6]-[#6]-[#16](=[#8])(=[#8])-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8]-[#6]-[#6]-[#6]-[#6]-[#6]1-[#6]-[#6]-[#7]-[#6]-[#6]-1)-[#6](=[#8])-[#8]',
            'eptifibatide': '[#6]1-[#6]-[#6]2-[#6](=[#8])-[#7]-[#6](-[#6]-[#16]-[#16]-[#6]-[#6]-[#6](=[#8])-[#7]-[#6](-[#6](=[#8])-[#7]-[#6]-[#6](=[#8])-[#7]-[#6](-[#6](=[#8])-[#7]-[#6](-[#6](=[#8])-[#7]-2-[#6]-1)-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2)-[#6]-[#6](=[#8])-[#8])-[#6]-[#6]-[#6]-[#6]-[#7]=[#6](-[#7])-[#7])-[#6](=[#8])-[#7]',
            'batroxobin': '[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6]-[#6](-[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8]',
            'hemocoagulase': '[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#16]-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6])-[#6](-[#7]-[#6]-[#6](-[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8]',
            'alpha cobrotoxin': '[#7]-[#6](-[#6]-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]1:[#6]:[#7H]:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#7H]:[#6]:[#7]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]):[#6]:[#6]:1)-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]1-[#6]-[#6]-[#6]-[#7]-1)-[#6](-[#7]-[#6](-[#6]-[#8])-[#6](-[#7]-[#6](-[#6](-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6H]-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6H](-[#6]-[#6])-[#6])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6H](-[#6])-[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#8])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#7])=[#7])-[#6](-[#7]-[#6](-[#6]-[#16])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6](-[#6]-[#6](-[#7])=[#8])-[#6](-[#7]-[#6]-[#6](-[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8])=[#8]',
        }

        return smarts

    @staticmethod
    def get_bit_vector():

        bit_vector = {
            'ziconotide': '01000000001100000000000001000100010000010010000100000100001000000010000000010000100000001010000000000100000000010101100000000000100000000010100000010000010100100001000000001001000000100100000000100100010100000010001000100010000100000100000000100010001000000000000000000000000000000101010001001001100001001000101100101000110000001010001101001000000000000001110000100000000000010000011110010100001000000010001000000010000000000001000010010000101001000000000000100000000001011000001001100010000011100000000100010000',
            'captopril': '01001000000000000001000000000000010000000000000100000000000000000000000010000000100000000000000000000000000010000000000000000000000000001010000000000000010000000000000000000000000000000000000001000000000000000000000000000000100001000000000000100000000000000000000000000000000000000001000000000001000001000000000000000000010000000000000000000000000000000110000000000000000000000000010000000100000000000000000100000010000000010000000000010000000000100000000010000000000000000000000000000000100000000000000000010000',
            'tirofiban': '01000000001001000000000000000100010000000000000000100000000000000000000000000001100000001010000000000010000000000010000000000000100000000010000000000000000100000000000001000000000000010000000000000000100000100000001000100000110000000000000000000000000000000000000000000000000010000010100000000011000001000100101000000000101000000100001001000000010000100000100000000000000000010000010000000100000000000000010000000110000000000000100000000000000000000100100000000000000000100000000001000000000010000000000000010000',
            'eptifibatide': '00001100001000000001000000001000000001010010000000000100000000001000000100000000100000001010000000000000000000000001000100100000000000000010100010010000010000001001000000001001000000000000000000000000011000001010011000000000000000010000000000000011000000000000000000000000000001000000000010001011000101000000000000101000100001001110011001001001000000010001110000101000000000010000010100010110000000000110000000000010000000010000000000010000101000100000000010100000001010000010001000000010000010100000000100010000',
            'batroxobin': '11001000100100000000001000001000010001010111000000000000001011011010000100000001111100111010001001000001000000010100110101100000100000000010100100010001000101100000000010001101000100010000000000010100010000000000101010110010100101100100010000100001010000000001000100100000101000000001000101000111000001001100001101000000010001001000010001011001010000010100100000111000010100011010011000000110001000110100001000000010100100010001100000011000011100000000000000100000000001110000110010111000000001000000000100110100',
            'hemocoagulase': '11001000000100000000001000001000010001010110000000000000001001011010001100000001111100111010001001000001000000010100110101100000100000000010100000010001000101100000000010001101000100000000000000010100010000000000101010110010100101100100010000100001000000000001000100100000101000000001000001000111000001001100001101000000010001001000010001011001010000000100100000111000010100011010011000000110001000110100001000000010100100010001100000011000011100000000000000100000000001110000110010111000000001000000000100110000',
            'alpha cobrotoxin': '01001000100100000000000000001000010001010100000000000000001011011010000100000001111100101010001001000001000000010100010101100000100000000010100000010001000101000000000010000101000100010000000000010100010000000000101010110010100101100100010000100001010000000001000100100000101000000001000101000011000001001100001101000000010001001000010001011001010000000100100000111000010100011010011000000110000000110100000000000010100100010101100000011000011100000000000000000000000001110000100010111000000001000000000100110000',
        }

        return bit_vector